/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.joget.ai.agent.lib.Mem0MemoryTool;
import org.joget.ai.agent.model.AgentBuilderElementAjaxRendering;
import org.joget.ai.agent.model.AgentBuilderPaletteElement;
import org.joget.ai.agent.model.AgentEnhancer;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentLLMRequestProcessor;
import org.joget.ai.agent.model.AgentPrompt;
import org.joget.ai.agent.model.AgentTaskMetadata;
import org.joget.ai.agent.model.AgentTool;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.IMemoryBackend;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.ai.agent.utils.ImageUtils;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.model.CustomBuilder;
import org.joget.apps.app.model.CustomBuilderAbstract;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppResourceUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.commons.util.FileManager;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.Plugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.model.WorkflowAssignment;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.multipart.MultipartFile;

public class AgentBuilder
extends CustomBuilderAbstract
implements PluginWebSupport {
    public static final String OUTPUT = "Output";
    public static final String OUTPUT_EXECUTION = "Execute";
    public static final String OUTPUT_PROPRETY_OPTIONS = "Property Options";

    public String getName() {
        return "agentBuilder";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getIcon() {
        return "fas fa-user-secret";
    }

    public String getColor() {
        return "#5D3FD3";
    }

    public String getObjectName() {
        return "agent";
    }

    public String getObjectLabel() {
        return AppPluginUtil.getMessage((String)"agentBuilder.agent", (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getIdPrefix() {
        return "AI-";
    }

    public String getBuilderConfig() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/agent/agent_builder.json", null, (boolean)false, (String)"messages/agentPlugins");
    }

    public String getResourceBundlePath() {
        return "messages/agentBuilder";
    }

    public void builderPreview(String json, HttpServletRequest request, HttpServletResponse response) {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            response.setContentType("text/html; charset=utf-8");
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("definition", json);
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put(OUTPUT, OUTPUT_PROPRETY_OPTIONS);
            model.put("inputProperites", (String)this.getBuilderResult(json, config));
            String theme = WorkflowUtil.getSystemSetupValue((String)"systemTheme");
            if (theme != null && !theme.isEmpty()) {
                model.put("theme", theme);
            }
            model.put("appId", appDef.getAppId());
            model.put("appVersion", appDef.getVersion().toString());
            model.put("csrfTokenName", SecurityUtil.getCsrfTokenName());
            model.put("csrfTokenValue", SecurityUtil.getCsrfTokenValue((HttpServletRequest)request));
            boolean isDx9 = false;
            try {
                Class<?> dx9Class = Class.forName("org.joget.commons.util.DynamicCacheElement");
                isDx9 = true;
            }
            catch (Exception dx9Class) {
                // empty catch block
            }
            String html = null;
            html = isDx9 ? CustomBuilderUtil.generateHtml((CustomBuilder)this, (String)"templates/preview_DX9.ftl", model, (HttpServletRequest)request) : CustomBuilderUtil.generateHtml((CustomBuilder)this, (String)"templates/preview.ftl", model, (HttpServletRequest)request);
            response.getWriter().write(html);
        }
        catch (Exception ex) {
            LogUtil.error((String)AgentBuilder.class.getName(), (Throwable)ex, (String)"");
        }
    }

    public String getBuilderJS(String contextPath, String buildNumber) {
        String version = this.getVersion() + buildNumber;
        return "<script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/agentTaskSection/agentTaskSection.js?build=" + version + "\"></script><script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/agentSection/agentSection.js?build=" + version + "\"></script><script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/agentbuilder.js?build=" + version + "\"></script>";
    }

    public String getBuilderCSS(String contextPath, String buildNumber) {
        String version = this.getVersion() + buildNumber;
        return "<link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/agentbuilder.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/agentSection/agentSection.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/agentTaskSection/agentTaskSection.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/Prompts/Prompts.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/LLMServices/LLMServices.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/Enhancers/Enhancers.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"" + contextPath + "/plugin/org.joget.ai.agent.AgentBuilder/feature/Tools/Tools.css?build=" + version + "\" rel=\"stylesheet\" type=\"text/css\" />";
    }

    public String getBuilderHTML(BuilderDefinition bd, String string, HttpServletRequest hsr, HttpServletResponse hsr1) {
        return "";
    }

    public String createNewJSON(String id, String name, String description, BuilderDefinition copyDef) {
        String json = "";
        if (copyDef != null) {
            String copyJson = copyDef.getJson();
            try {
                JSONObject obj = new JSONObject(copyJson);
                if (!obj.isNull("properties")) {
                    JSONObject objProperty = obj.getJSONObject("properties");
                    objProperty.put("id", (Object)id);
                    objProperty.put("name", (Object)name);
                    objProperty.put("description", (Object)description);
                }
                json = obj.toString();
            }
            catch (Exception exception) {}
        } else {
            json = AppUtil.readPluginResource((String)this.getClassName(), (String)"/defaultDefinition.json", (Object[])new String[]{id, name, description}, (boolean)true, (String)"messages/agentPlugins");
        }
        return json;
    }

    public Object getBuilderResult(String json, Map<String, Object> config) {
        String output = config.get(OUTPUT).toString();
        if (output != null && json != null && !json.isEmpty()) {
            try {
                JSONObject definition = new JSONObject(json);
                switch (output) {
                    case "Property Options": {
                        return this.generatePropertyOptions(definition);
                    }
                    case "Execute": {
                        return this.runAgent(definition, config);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
        }
        return null;
    }

    public String generatePropertyOptions(JSONObject definition) {
        String result = null;
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        if (definition != null && definition.has("properties")) {
            try {
                JSONArray propertyOptions = new JSONArray();
                JSONObject agentProperties = definition.getJSONObject("properties");
                JSONObject page = new JSONObject();
                propertyOptions.put((Object)page);
                page.put("title", (Object)agentProperties.getString("name"));
                JSONArray pageProperties = new JSONArray();
                page.put("properties", (Object)pageProperties);
                JSONArray inputsArray = agentProperties.getJSONArray("inputs");
                for (int i = 0; i < inputsArray.length(); ++i) {
                    JSONObject inputObj = inputsArray.getJSONObject(i);
                    String type = "textfield";
                    if (inputObj.has("type") && "text".equals(type = inputObj.getString("type"))) {
                        type = "textfield";
                    }
                    JSONObject prop = new JSONObject();
                    prop.put("type", (Object)type);
                    prop.put("required", (Object)"true");
                    prop.put("name", (Object)inputObj.getString("name"));
                    prop.put("label", (Object)inputObj.getString("label"));
                    prop.put("description", (Object)inputObj.getString("description"));
                    if ("file".equals(type)) {
                        prop.put("appPath", (Object)("/" + appDef.getAppId() + "/" + appDef.getVersion()));
                    }
                    pageProperties.put((Object)prop);
                }
                result = propertyOptions.toString(4);
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
        }
        return result;
    }

    public Response runAgent(JSONObject definition, Map<String, Object> config) {
        WorkflowAssignment wfAssignment = (WorkflowAssignment)config.get("workflowAssignment");
        if (config.containsKey("properties")) {
            definition = this.populateInputVariable(definition, (Map)config.get("properties"));
            this.setProperty("agentProperties", definition.getJSONObject("properties").toString());
        }
        LLMConfig llmConfig = new LLMConfig();
        Messages messages = new Messages();
        if (definition.has("agent")) {
            AgentLLM llm;
            JSONObject agent = definition.getJSONObject("agent");
            if (agent.has("llm") && !agent.getJSONArray("llm").isEmpty() && (llm = (AgentLLM)this.getElement(agent.getJSONArray("llm").getJSONObject(0), wfAssignment, AgentLLM.class)) != null) {
                if (config.containsKey("properties")) {
                    Map properties = (Map)config.get("properties");
                    this.addFileMessagesToContext(properties, messages, llm.getLLMType());
                }
                try {
                    if (agent.has("prompt")) {
                        this.processPrompts(agent.getJSONArray("prompt"), llm, llmConfig, messages, wfAssignment);
                    }
                    if (definition.has("tasks") && !definition.getJSONArray("tasks").isEmpty()) {
                        return this.processTasks(definition.getJSONArray("tasks"), llm, llmConfig, messages, wfAssignment);
                    }
                    return new Response("No task was configured.");
                }
                catch (Exception e) {
                    return new Response(e.getMessage());
                }
            }
            return new Response("Agent LLM not available.");
        }
        return new Response("Agent not found.");
    }

    public static Response runAgent(Object agent, WorkflowAssignment wfAssignment) {
        Map agentMap;
        if (agent != null && agent instanceof Map && (agentMap = (Map)agent).containsKey("className") && !agentMap.get("className").toString().isEmpty()) {
            String agentId = agentMap.get("className").toString();
            return AgentBuilder.runAgent(agentId, (Map)agentMap.get("properties"), wfAssignment);
        }
        return null;
    }

    public static Response runAgent(String agentId, Map properties, WorkflowAssignment wfAssignment) {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition builderDefinition = builderDefinitionDao.loadById(agentId, appDef);
        if (builderDefinition != null) {
            String json = builderDefinition.getJson();
            AgentBuilder builder = new AgentBuilder();
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("workflowAssignment", wfAssignment);
            config.put("properties", properties);
            config.put(OUTPUT, OUTPUT_EXECUTION);
            return (Response)builder.getBuilderResult(json, config);
        }
        return null;
    }

    protected JSONObject populateInputVariable(JSONObject definition, Map properties) {
        JSONObject agentProperties = definition.getJSONObject("properties");
        JSONArray inputsArray = agentProperties.getJSONArray("inputs");
        if (!inputsArray.isEmpty()) {
            String tempDef = definition.toString();
            tempDef = tempDef.replaceAll(StringUtil.escapeRegex((String)"\\\\\\\\\\\\\\\""), "__ESC3__").replaceAll(StringUtil.escapeRegex((String)"\\\\\\\""), "__ESC2__").replaceAll(StringUtil.escapeRegex((String)"\\\""), "__ESC1__");
            for (int i = 0; i < inputsArray.length(); ++i) {
                JSONObject inputObj = inputsArray.getJSONObject(i);
                String name = inputObj.getString("name");
                String value = "";
                if (properties.containsKey(name)) {
                    value = properties.get(name).toString();
                    value = value.replace("\\", "\\\\");
                    value = StringUtil.escapeString((String)value, (String)"json");
                }
                if (!value.contains("__ESC")) {
                    if (tempDef.contains("__ESC3__")) {
                        tempDef = tempDef.replaceAll("(__ESC3__.*?)" + StringUtil.escapeRegex((String)("${" + name + "}")) + "(.*?__ESC3__)", "$1" + StringUtil.escapeRegex((String)value.replaceAll(StringUtil.escapeRegex((String)"\\\""), StringUtil.escapeRegex((String)"__ESC4__"))) + "$2");
                    }
                    if (tempDef.contains("__ESC2__")) {
                        tempDef = tempDef.replaceAll("(__ESC2__.*?)" + StringUtil.escapeRegex((String)("${" + name + "}")) + "(.*?__ESC2__)", "$1" + StringUtil.escapeRegex((String)value.replaceAll(StringUtil.escapeRegex((String)"\\\""), StringUtil.escapeRegex((String)"__ESC3__"))) + "$2");
                    }
                    if (tempDef.contains("__ESC1__")) {
                        tempDef = tempDef.replaceAll("(__ESC1__.*?)" + StringUtil.escapeRegex((String)("${" + name + "}")) + "(.*?__ESC1__)", "$1" + StringUtil.escapeRegex((String)value.replaceAll(StringUtil.escapeRegex((String)"\\\""), StringUtil.escapeRegex((String)"__ESC2__"))) + "$2");
                    }
                }
                tempDef = tempDef.replaceAll(StringUtil.escapeRegex((String)("${" + name + "}")), StringUtil.escapeRegex((String)value));
            }
            tempDef = tempDef.replaceAll("__ESC4__", StringUtil.escapeRegex((String)"\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"")).replaceAll("__ESC3__", StringUtil.escapeRegex((String)"\\\\\\\\\\\\\\\"")).replaceAll("__ESC2__", StringUtil.escapeRegex((String)"\\\\\\\"")).replaceAll("__ESC1__", StringUtil.escapeRegex((String)"\\\""));
            definition = new JSONObject(tempDef);
        }
        return definition;
    }

    protected void processPrompts(JSONArray prompts, AgentLLM llm, LLMConfig llmConfig, Messages messages, WorkflowAssignment wfAssignment) {
        for (int i = 0; i < prompts.length(); ++i) {
            AgentPrompt prompt = (AgentPrompt)this.getElement(prompts.getJSONObject(i), wfAssignment, AgentPrompt.class);
            if (prompt == null) continue;
            prompt.generate(llm, llmConfig, messages);
        }
    }

    protected Response processTasks(JSONArray tasks, AgentLLM llm, LLMConfig llmConfig, Messages messages, WorkflowAssignment wfAssignment) {
        Response response = null;
        for (int i = 0; i < tasks.length(); ++i) {
            if (response != null && response.getMessage() != null) {
                JSONObject raw = response.getMessage();
                if (raw instanceof Message) {
                    messages.add((Message)raw);
                } else if (raw instanceof JSONObject) {
                    messages.add(new Message(raw.toString()));
                }
            }
            response = this.processTask(tasks.getJSONObject(i), llm, llmConfig, messages, wfAssignment);
        }
        return response;
    }

    protected void processEnhancers(JSONArray enhancers, AgentLLM llm, LLMConfig llmConfig, Response response, WorkflowAssignment wfAssignment) {
        for (int i = 0; i < enhancers.length(); ++i) {
            AgentEnhancer enhancer = (AgentEnhancer)this.getElement(enhancers.getJSONObject(i), wfAssignment, AgentEnhancer.class);
            if (enhancer == null) continue;
            enhancer.enhance(llm, llmConfig, response);
        }
    }

    protected void processTools(JSONArray tools, Functions functions, Map<String, AgentTool> agentTools, WorkflowAssignment wfAssignment, AgentTaskMetadata metadata) {
        for (int i = 0; i < tools.length(); ++i) {
            AgentTool tool = (AgentTool)this.getElement(tools.getJSONObject(i), wfAssignment, AgentTool.class);
            if (tool == null) continue;
            Functions toolFunctions = tool.getFunctions();
            for (int j = 0; j < toolFunctions.length(); ++j) {
                Function function = toolFunctions.get(j);
                String functionName = function.getName();
                if (agentTools.containsKey(functionName)) continue;
                agentTools.put(functionName, tool);
                if (TaskUtil.isSystemToolFunction(functionName, metadata)) continue;
                functions.add(function);
            }
        }
    }

    protected Response processTask(JSONObject task, AgentLLM llm, LLMConfig llmConfig, Messages messages, WorkflowAssignment wfAssignment) {
        AgentTaskMetadata metadata = (AgentTaskMetadata)new Gson().fromJson(this.getProperty("agentProperties").toString(), AgentTaskMetadata.class);
        Functions functions = new Functions();
        HashMap<String, AgentTool> tools = new HashMap<String, AgentTool>();
        new AgentLLMRequestProcessor(llm, llmConfig, task).process();
        if (task.has("prompt") && !task.getJSONArray("prompt").isEmpty()) {
            this.processPrompts(task.getJSONArray("prompt"), llm, llmConfig, messages, wfAssignment);
        }
        if (task.has("tool") && !task.getJSONArray("tool").isEmpty()) {
            metadata.setUseMemory(TaskUtil.hasMemoryTool(task));
            metadata.setIsMemoryAutoSync(TaskUtil.isMemoryAutoSync(task));
            this.processTools(task.getJSONArray("tool"), functions, tools, wfAssignment, metadata);
        }
        Response response = llm.getResponse(llmConfig, messages, functions);
        response = this.handleToolCalls(response, tools, llm, metadata, llmConfig, messages, functions);
        if (task.has("enhancer") && !task.getJSONArray("enhancer").isEmpty()) {
            this.processEnhancers(task.getJSONArray("enhancer"), llm, llmConfig, response, wfAssignment);
        }
        return response;
    }

    protected Response handleToolCalls(Response response, Map<String, AgentTool> tools, AgentLLM llm, AgentTaskMetadata metadata, LLMConfig llmConfig, Messages messages, Functions functions) {
        if (response == null || response.getMessage() == null) {
            return response;
        }
        messages.add(new Message(response.getMessage().toString()));
        if (!response.getToolExecutions().isEmpty()) {
            for (ToolExecution te : response.getToolExecutions()) {
                if (!tools.containsKey(te.getName())) continue;
                metadata.setMessages(messages);
                te.setMetadata(metadata);
                String result = tools.get(te.getName()).execute(llm, llmConfig, te);
                Message message = Message.createFunctionResponseMessage(llm, te.getName(), te.getId(), result);
                messages.add(message);
                response = llm.getResponse(llmConfig, messages, functions);
            }
        }
        if (metadata.getUseMemory().booleanValue() && metadata.getIsMemoryAutoSync().booleanValue()) {
            try {
                ToolExecution memoryToolExecution = new ToolExecution("store", new JSONObject(), metadata);
                Messages preparedMessages = Messages.deepCopy(messages);
                preparedMessages.add(new Message(Message.Role.ASSISTANT, response.getContent()));
                metadata.setMessages(preparedMessages);
                tools.get(memoryToolExecution.getName()).execute(llm, llmConfig, memoryToolExecution);
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Error executing memory tool");
            }
        }
        if (response != null && !response.getToolExecutions().isEmpty()) {
            response = this.handleToolCalls(response, tools, llm, metadata, llmConfig, messages, functions);
        }
        return response;
    }

    protected Plugin getElement(JSONObject element, WorkflowAssignment wfAssignment, Class clazz) {
        PluginManager pluginManager;
        Plugin plugin;
        if (element.has("className") && (plugin = (pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager")).getPlugin(element.getString("className"))) != null && clazz.isInstance(plugin)) {
            if (plugin instanceof PropertyEditable) {
                Map propertiesMap = AppPluginUtil.getDefaultProperties((Plugin)plugin, (String)element.getJSONObject("properties").toString(), (AppDefinition)AppUtil.getCurrentAppDefinition(), (WorkflowAssignment)wfAssignment);
                if (wfAssignment != null) {
                    propertiesMap.put("workflowAssignment", wfAssignment);
                }
                ((PropertyEditable)plugin).setProperties(propertiesMap);
            }
            return plugin;
        }
        return null;
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/agent/setting.json", null, (boolean)true, (String)"messages/agentPlugins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> processUploadedFiles(Map<String, Object> properties, AppDefinition appDef) {
        HashMap<String, Object> processedProperties = new HashMap<String, Object>(properties);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            File tempFile = null;
            try {
                Messages fileMessages;
                File file = null;
                String fileName = null;
                if (value instanceof String && this.isFile((String)value)) {
                    fileName = (String)value;
                    file = AppResourceUtil.getFile((String)appDef.getAppId(), (String)appDef.getVersion().toString(), (String)fileName);
                } else if (value instanceof MultipartFile) {
                    MultipartFile mpFile = (MultipartFile)value;
                    fileName = mpFile.getOriginalFilename();
                    if (!mpFile.isEmpty() && fileName != null && !fileName.isEmpty()) {
                        String storedPath = FileManager.storeFile((MultipartFile)mpFile, (String)fileName);
                        tempFile = FileManager.getFileByPath((String)storedPath);
                        if (tempFile == null || !tempFile.exists()) continue;
                        Messages fileMessages2 = this.convertFileToMessages(tempFile, fileName, this.guessContentType(fileName));
                        if (!fileMessages2.isEmpty()) {
                            processedProperties.put(key + "_messages", (Object)fileMessages2);
                            processedProperties.put(key + "_processed", true);
                        }
                    }
                } else if (value instanceof File) {
                    file = (File)value;
                    fileName = file.getName();
                }
                if (file == null || !file.exists() || (fileMessages = this.convertFileToMessages(file, fileName, this.guessContentType(fileName))).isEmpty()) continue;
                processedProperties.put(key + "_messages", (Object)fileMessages);
                processedProperties.put(key + "_processed", true);
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Error processing uploaded file for key: " + key));
            }
            finally {
                LogUtil.info((String)this.getClassName(), (String)("Processed uploaded file for key: " + key + ", value: " + value));
            }
        }
        return processedProperties;
    }

    protected Messages convertFileToMessages(File file, String fileName, String contentType) throws IOException {
        Messages messages = new Messages();
        if (fileName.toLowerCase().endsWith(".pdf")) {
            Map<InputStream, String> imageStreams = this.convertPDFToImages(file);
            for (Map.Entry<InputStream, String> entry : imageStreams.entrySet()) {
                Message message = new Message(Message.Role.USER, "Uploaded file: " + fileName, Message.FileType.IMAGE, entry.getKey(), entry.getValue());
                messages.add(message);
            }
        } else if (contentType.startsWith("image/")) {
            BufferedImage original = ImageUtils.readWithoutCache(file);
            if (original != null) {
                BufferedImage processed = ImageUtils.resizeImageIfNeeded(original, 2000);
                String formatName = contentType.substring(contentType.indexOf(47) + 1);
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ImageUtils.writeWithoutCache(processed, formatName, baos);
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    Message message = new Message(Message.Role.USER, "Uploaded file: " + fileName, Message.FileType.IMAGE, bais, contentType);
                    messages.add(message);
                }
            }
        } else {
            try (FileInputStream fis = new FileInputStream(file);
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                Message message = new Message(Message.Role.USER, "Uploaded file: " + fileName, Message.FileType.TEXT, bais, contentType);
                messages.add(message);
            }
        }
        return messages;
    }

    protected Map<InputStream, String> convertPDFToImages(File pdfFile) throws IOException {
        HashMap<InputStream, String> imageStreams = new HashMap<InputStream, String>();
        try (FileInputStream fis = new FileInputStream(pdfFile);
             PDDocument document = PDDocument.load((InputStream)fis, (MemoryUsageSetting)MemoryUsageSetting.setupMainMemoryOnly());){
            ImageIO.setUseCache(false);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            for (int page = 0; page < document.getNumberOfPages(); ++page) {
                BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 300.0f, ImageType.RGB);
                BufferedImage resized = ImageUtils.resizeImageIfNeeded(bim, 2000);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageUtils.writeWithoutCache(resized, "jpeg", baos);
                imageStreams.put(new ByteArrayInputStream(baos.toByteArray()), "image/jpeg");
            }
        }
        return imageStreams;
    }

    public boolean isFile(String fileName) {
        if (fileName == null || fileName.trim().isEmpty()) {
            return false;
        }
        String contentType = this.guessContentType(fileName);
        return !contentType.isEmpty();
    }

    protected String guessContentType(String filename) {
        String contentType = URLConnection.guessContentTypeFromName(filename);
        return contentType != null ? contentType : "";
    }

    protected void addFileMessagesToContext(Map<String, Object> properties, Messages messages, AgentLLM.Type llmType) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!key.endsWith("_messages") || !(value instanceof Messages)) continue;
            Messages fileMessages = (Messages)((Object)value);
            Iterator it = fileMessages.iterator();
            while (it.hasNext()) {
                Message message = (Message)((Object)it.next());
                if (message.getFileInputSteam() == null) continue;
                try {
                    InputStream is = message.getFileInputSteam();
                    try {
                        String type = message.getString("type");
                        if (Message.FileType.IMAGE.toString().equals(type)) {
                            this.processingImageFileMessage(message, is, llmType);
                        } else {
                            this.processingTextFileMessage(message, is);
                        }
                        message.remove("type");
                        message.remove("fileContentType");
                        message.setFileInputStream(null);
                        messages.add(message);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (Exception e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Error processing file message");
                }
            }
        }
    }

    protected void processingImageFileMessage(Message message, InputStream is, AgentLLM.Type llmType) throws IOException {
        JSONArray content = new JSONArray();
        JSONObject text = new JSONObject();
        text.put("type", (Object)"text");
        text.put("text", (Object)message.getString("content"));
        content.put((Object)text);
        if (AgentLLM.Type.OPENAI.equals((Object)llmType)) {
            JSONObject url = new JSONObject();
            url.put("type", (Object)"image_url");
            JSONObject image = new JSONObject();
            image.put("url", (Object)this.convertImageToBase64WithPrefix(is, message.getString("fileContentType")));
            url.put("image_url", (Object)image);
            content.put((Object)url);
        } else if (AgentLLM.Type.ANTHROPIC.equals((Object)llmType)) {
            JSONObject imageContent = new JSONObject();
            imageContent.put("type", (Object)"image");
            JSONObject source = new JSONObject();
            source.put("type", (Object)"base64");
            source.put("media_type", (Object)message.getString("fileContentType"));
            String cleanBase64 = this.convertImageToBase64(is, message.getString("fileContentType"));
            source.put("data", (Object)cleanBase64);
            imageContent.put("source", (Object)source);
            content.put((Object)imageContent);
        } else if (AgentLLM.Type.GEMINI.equals((Object)llmType)) {
            JSONObject imageData = new JSONObject();
            imageData.put("type", (Object)"image_data");
            imageData.put("mime_type", (Object)message.getString("fileContentType"));
            imageData.put("data", (Object)this.convertImageToBase64(is, message.getString("fileContentType")));
            content.put((Object)imageData);
        } else {
            throw new IllegalArgumentException("Unknown or unsupported LLM type: " + llmType);
        }
        message.put("content", content);
        message.put("role", "user");
    }

    protected void processingTextFileMessage(Message message, InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            String fileContent = baos.toString("UTF-8");
            StringBuilder content = new StringBuilder();
            content.append(message.getString("content")).append("\n\n```\n").append(fileContent).append("\n```");
            message.put("content", content.toString());
        }
    }

    protected String convertImageToBase64WithPrefix(InputStream is, String fileContentType) throws IOException {
        BufferedImage original = ImageUtils.readWithoutCache(is);
        if (original == null) {
            return "data:" + fileContentType + ";base64,";
        }
        BufferedImage processed = ImageUtils.resizeImageIfNeeded(original, 2000);
        String formatName = fileContentType.substring(fileContentType.indexOf(47) + 1);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageUtils.writeWithoutCache(processed, formatName, baos);
            String string = "data:" + fileContentType + ";base64," + Base64.getEncoder().encodeToString(baos.toByteArray());
            return string;
        }
    }

    protected String convertImageToBase64(InputStream is, String fileContentType) throws IOException {
        BufferedImage original = ImageUtils.readWithoutCache(is);
        if (original == null) {
            return "";
        }
        BufferedImage processed = ImageUtils.resizeImageIfNeeded(original, 2000);
        String formatName = fileContentType.substring(fileContentType.indexOf(47) + 1);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageUtils.writeWithoutCache(processed, formatName, baos);
            String string = Base64.getEncoder().encodeToString(baos.toByteArray());
            return string;
        }
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
        if (!isAdmin) {
            response.sendError(401);
            return;
        }
        String action = SecurityUtil.validateStringInput((String)request.getParameter("action"));
        if ("config".equals(action)) {
            this.webServiceAgentInputConfig(request, response);
        } else if ("selector".equals(action)) {
            this.webServiceSelectorScript(request, response);
        } else if ("options".equals(action)) {
            this.webServiceSelectorOptions(request, response);
        } else if ("elements".equals(action)) {
            this.webServicePopulateElements(request, response);
        } else if ("runAgent".equals(action)) {
            this.webServiceRunAgent(request, response);
        } else if ("ajaxRendering".equals(action)) {
            this.webServiceAjaxRendering(request, response);
        }
    }

    protected void webServiceAgentInputConfig(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id;
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition builderDefinition = builderDefinitionDao.loadById(id = SecurityUtil.validateStringInput((String)request.getParameter("value")), appDef);
        if (builderDefinition != null) {
            String json = builderDefinition.getJson();
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put(OUTPUT, OUTPUT_PROPRETY_OPTIONS);
            String propertyOptions = (String)this.getBuilderResult(json, config);
            response.getWriter().write(propertyOptions);
        }
    }

    protected void webServiceSelectorScript(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.addDateHeader("Expires", Long.MAX_VALUE);
        response.addHeader("Cache-Control", "private, max-age=9223372036854775807");
        response.getWriter().write(AppUtil.readPluginResource((String)this.getClassName(), (String)"/resources/agentSelector.js", null, (boolean)false, null));
    }

    protected void webServiceSelectorOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        Collection builderDefinitionList = builderDefinitionDao.getBuilderDefinitionList(this.getObjectName(), null, appDef, "name", Boolean.valueOf(false), null, null);
        JSONArray jsonArray = new JSONArray();
        HashMap<String, String> blank = new HashMap<String, String>();
        blank.put("value", "");
        blank.put("label", "");
        jsonArray.put(blank);
        for (BuilderDefinition def : builderDefinitionList) {
            String name = def.getName();
            String description = this.getAttributeValue("description", def.getJson());
            Object logo = this.getAttributeValue("logo", def.getJson());
            Object html = "<block class=\"agent_option\">";
            if (!((String)logo).isEmpty()) {
                logo = "background-image:url('" + (String)logo + "');";
                html = (String)html + "<block class=\"logo\"><block style=\"" + (String)logo + "\"></block></block>";
            } else {
                html = (String)html + "<block class=\"logo no_logo\"><i class=\"far fa-image fa-fw\"></i></block>";
            }
            html = (String)html + "<block class=\"meta\"><span class=\"name\">" + StringUtil.escapeString((String)name, (String)"html") + "</span>";
            html = (String)html + "<span class=\"desc\">" + StringUtil.escapeString((String)description, (String)"html") + "</span>";
            html = (String)html + "</block></block>";
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("value", def.getId());
            data.put("label", html);
            jsonArray.put(data);
        }
        AppUtil.writeJson((Writer)response.getWriter(), (JSONArray)jsonArray, null);
    }

    protected void webServicePopulateElements(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            JSONObject result = new JSONObject();
            this.populateElements(result, "llms", AgentLLM.class);
            this.populateElements(result, "prompts", AgentPrompt.class);
            this.populateElements(result, "tools", AgentTool.class);
            this.populateElements(result, "enhancers", AgentEnhancer.class);
            result.write((Writer)response.getWriter());
        }
        catch (Exception ex) {
            LogUtil.error((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex, (String)"Get available report element plugin error!");
        }
    }

    protected void webServiceRunAgent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        String json = AppUtil.getSubmittedJsonDefinition(null);
        String inputs = request.getParameter("inputs");
        if (json != null && !json.isEmpty()) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            Map<String, Object> properties = PropertyUtil.getPropertiesValueFromJson((String)inputs);
            properties = this.processUploadedFiles(properties, appDef);
            config.put("properties", properties);
            config.put(OUTPUT, OUTPUT_EXECUTION);
            AgentBuilder builder = new AgentBuilder();
            Response r = (Response)builder.getBuilderResult(json, config);
            JSONObject result = new JSONObject();
            if (r != null) {
                result.put("content", (Object)(r.getContent() != null ? r.getContent() : ""));
                result.put("requestPayload", (Object)(r.getRequestPayload() != null ? new JSONObject(r.getRequestPayload()).toString(4) : "{}"));
                result.put("fullResponse", (Object)(r.getFullJsonResponse() != null ? r.getFullJsonResponse().trim() : "{}"));
            }
            result.write((Writer)response.getWriter());
        }
    }

    protected void webServiceAjaxRendering(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        String json = request.getParameter("json");
        AgentBuilderElementAjaxRendering plugin = (AgentBuilderElementAjaxRendering)this.getElement(new JSONObject(json), null, AgentBuilderElementAjaxRendering.class);
        if (plugin != null) {
            response.getWriter().print(plugin.getRenderHtml());
        } else {
            response.getWriter().print("<div></div>");
        }
    }

    protected void populateElements(JSONObject result, String key, Class clazz) {
        Collection<Plugin> plugins = AgentBuilder.getAvailableElements(clazz);
        JSONArray pluginArray = new JSONArray();
        for (Plugin plugin : plugins) {
            if (!(plugin instanceof AgentBuilderPaletteElement) || !clazz.isInstance(plugin)) continue;
            AgentBuilderPaletteElement e = (AgentBuilderPaletteElement)plugin;
            JSONObject o = new JSONObject();
            o.put("className", (Object)e.getClassName());
            o.put("icon", (Object)e.getIcon());
            o.put("label", (Object)e.getLabel());
            o.put("propertyOptions", (Object)e.getPropertyOptions());
            o.put("builderJavaScriptTemplate", (Object)e.getBuilderJavaScriptTemplate());
            o.put("isAjaxRendering", plugin instanceof AgentBuilderElementAjaxRendering);
            if (e.getPropertyOptions() != null && !e.getPropertyOptions().isEmpty()) {
                o.put("defaultProperties", (Object)PropertyUtil.getDefaultPropertyValues((String)o.get("propertyOptions").toString()));
            } else {
                o.put("defaultProperties", (Object)"{}");
            }
            pluginArray.put((Object)o);
        }
        result.put(key, (Object)pluginArray);
    }

    public static Collection<Plugin> getAvailableElements(Class clazz) {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        Collection pluginList = pluginManager.list(clazz);
        return pluginList;
    }

    protected String getAttributeValue(String attribute, String json) {
        int index = json.indexOf("\"" + attribute + "\"");
        if (index != -1) {
            index = index + attribute.length() + 2;
            int firstQuoteIndex = json.indexOf("\"", index);
            String value = json.substring(firstQuoteIndex + 1, json.indexOf("\"", firstQuoteIndex + 1));
            return AppUtil.processHashVariable((String)value, null, null, null);
        }
        return "";
    }

    private static class TaskUtil {
        private static final Set<String> MEMORY_TOOL_CLASSES = Set.of(Mem0MemoryTool.class.getCanonicalName());
        private static final Set<String> SYSTEM_TOOL_FUNCTIONS = Set.of(IMemoryBackend.Func.STORE.toString());

        private TaskUtil() {
        }

        private static boolean isSystemToolFunction(String functionName, AgentTaskMetadata metadata) {
            if (!SYSTEM_TOOL_FUNCTIONS.contains(functionName)) {
                return false;
            }
            if (IMemoryBackend.Func.STORE.toString().equals(functionName)) {
                return metadata.getUseMemory() != false && metadata.getIsMemoryAutoSync() != false;
            }
            return true;
        }

        private static boolean hasMemoryTool(JSONObject task) {
            JSONArray tools = task.optJSONArray("tool");
            if (tools == null) {
                return false;
            }
            for (int j = 0; j < tools.length(); ++j) {
                String className = tools.optJSONObject(j).optString("className", "");
                if (!MEMORY_TOOL_CLASSES.contains(className)) continue;
                return true;
            }
            return false;
        }

        private static boolean isMemoryAutoSync(JSONObject task) {
            JSONArray tools = task.optJSONArray("tool");
            if (tools == null || tools.isEmpty()) {
                return true;
            }
            return IntStream.range(0, tools.length()).mapToObj(arg_0 -> ((JSONArray)tools).optJSONObject(arg_0)).map(tool -> tool != null ? tool.optJSONObject("properties") : null).anyMatch(props -> "true".equalsIgnoreCase(props != null ? props.optString("isAutoSyncMem", "true") : "true"));
        }
    }
}

