/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.HashMap;
import org.joget.ai.agent.model.AgentEnhancerAbstract;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Response;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;

public class BeanShellAgentEnhancer
extends AgentEnhancerAbstract {
    public String getName() {
        return "BeanShellAgentEnhancer";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-code\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"beanshellprompt.purpose", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd>${properties.purpose}</dd></dl></div>";
    }

    @Override
    public void enhance(AgentLLM llm, LLMConfig config, Response response) throws AgentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("plugin", this);
        properties.put("llm", llm);
        properties.put("llmConfig", (Object)config);
        properties.put("response", response);
        try {
            AppPluginUtil.executeScript((String)this.getPropertyString("script"), properties, (boolean)true);
        }
        catch (Exception e) {
            throw new AgentException(e.getLocalizedMessage());
        }
    }
}

