/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.HashMap;
import java.util.Map;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;

public class BeanShellAgentTool
extends AgentToolAbstract {
    public String getName() {
        return "BeanShellAgentTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-code\"></i>";
    }

    @Override
    public Functions getFunctions() {
        Functions functions = new Functions();
        Function func = new Function(this.getPropertyString("name"), this.getPropertyString("description"));
        Object arguments = this.getProperty("arguments");
        if (arguments != null && arguments instanceof Object[]) {
            for (Object argument : (Object[])arguments) {
                Map argumentMap = (Map)argument;
                func.addParameter(argumentMap.get("name").toString(), Function.ParameterType.valueOf(argumentMap.get("type").toString().toUpperCase()), argumentMap.get("description").toString(), "true".equals(argumentMap.get("required").toString()));
            }
        }
        functions.add(func);
        return functions;
    }

    @Override
    public String getInfoTemplate() {
        String namelabel = AppPluginUtil.getMessage((String)"beanshelltool.name", (String)this.getClassName(), (String)"messages/agentPlugins");
        String desclabel = AppPluginUtil.getMessage((String)"beanshelltool.description", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + namelabel + "</dt><dd>${properties.name}</dd><dt>" + desclabel + "</dt><dd>${properties.description}</dd></dl></div>";
    }

    @Override
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("plugin", this);
        properties.put("llm", llm);
        properties.put("llmConfig", (Object)config);
        properties.put("arguments", call.getArguments());
        try {
            return (String)AppPluginUtil.executeScript((String)this.getPropertyString("script"), properties, (boolean)true);
        }
        catch (Exception e) {
            throw new AgentException(e.getLocalizedMessage());
        }
    }
}

