/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.apps.app.lib.EmailTool;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;

public class EmailAgentTool
extends AgentToolAbstract {
    public String getName() {
        return "EmailAgentTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-code\"></i>";
    }

    @Override
    public Functions getFunctions() {
        String desclabel = AppPluginUtil.getMessage((String)"emailTool.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        Functions functions = new Functions();
        Function func = new Function("send_email", desclabel);
        func.addParameter("toEmail", AppPluginUtil.getMessage((String)"emailTool.toEmail", (String)this.getClassName(), (String)"messages/agentPlugins"));
        func.addParameter("subject", AppPluginUtil.getMessage((String)"emailTool.subject", (String)this.getClassName(), (String)"messages/agentPlugins"));
        func.addParameter("message", AppPluginUtil.getMessage((String)"emailTool.message", (String)this.getClassName(), (String)"messages/agentPlugins"));
        functions.add(func);
        return functions;
    }

    @Override
    public String getInfoTemplate() {
        String namelabel = AppPluginUtil.getMessage((String)"beanshelltool.name", (String)this.getClassName(), (String)"messages/agentPlugins");
        String desclabel = AppPluginUtil.getMessage((String)"beanshelltool.description", (String)this.getClassName(), (String)"messages/agentPlugins");
        String descValue = AppPluginUtil.getMessage((String)"emailTool.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + namelabel + "</dt><dd>send_email</dd><dt>" + desclabel + "</dt><dd>" + descValue + "</dd></dl></div>";
    }

    @Override
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        EmailTool emailTool = new EmailTool();
        emailTool.setProperties(this.getProperties());
        emailTool.setProperty("toSpecific", (Object)call.getArguments().getString("toEmail"));
        emailTool.setProperty("subject", (Object)call.getArguments().getString("subject"));
        emailTool.setProperty("message", (Object)call.getArguments().getString("message"));
        emailTool.execute(emailTool.getProperties());
        return "Function executed";
    }
}

