/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentPromptAbstract;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.utils.ImageUtils;
import org.joget.apps.app.dao.AppResourceDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.AppResource;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppResourceUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.service.FileUtil;
import org.joget.apps.form.service.FormUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.StringUtil;
import org.joget.workflow.model.WorkflowAssignment;

public class FileAgentPrompt
extends AgentPromptAbstract {
    public String getName() {
        return "FileAgentPrompt";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-file\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"beanshellprompt.purpose", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd>${properties.purpose}</dd></dl></div>";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(AgentLLM llm, LLMConfig config, Messages messages) throws AgentException {
        String source = this.getPropertyString("source");
        String type = this.getPropertyString("fileType");
        String purpose = this.getPropertyString("purpose");
        Map<InputStream, String> ins = null;
        try {
            void var9_15;
            String string = source;
            int n = -1;
            switch (string.hashCode()) {
                case 96801: {
                    if (!string.equals("app")) break;
                    boolean bl = false;
                    break;
                }
                case 3148996: {
                    if (!string.equals("form")) break;
                    boolean bl = true;
                    break;
                }
                case -887328209: {
                    if (!string.equals("system")) break;
                    int n2 = 2;
                    break;
                }
                case 116079: {
                    if (!string.equals("url")) break;
                    int n3 = 3;
                }
            }
            switch (var9_15) {
                case 0: {
                    ins = this.getAppResource();
                    break;
                }
                case 1: {
                    ins = this.getFormUploadFile();
                    break;
                }
                case 2: {
                    ins = this.getSystemFile();
                    break;
                }
                case 3: {
                    ins = this.getUrlFile();
                }
            }
            if (ins != null && !ins.isEmpty()) {
                if ("PDF".equals(type)) {
                    ins = this.convertPDFToImages(ins);
                    type = Message.FileType.IMAGE.toString();
                }
                if (ins != null && !ins.isEmpty()) {
                    for (Map.Entry entry : ins.entrySet()) {
                        messages.add(new Message(Message.Role.valueOf(this.getPropertyString("msgRole")), purpose, Message.FileType.valueOf(type), (InputStream)entry.getKey(), (String)entry.getValue()));
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            if (ins != null) {
                for (InputStream in : ins.keySet()) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            throw new AgentException(e.getLocalizedMessage());
        }
    }

    protected Map<InputStream, String> getAppResource() throws FileNotFoundException {
        HashMap<InputStream, String> ins = new HashMap<InputStream, String>();
        String fileName = this.getPropertyString("appResorce");
        if (!fileName.isEmpty()) {
            AppResourceDao appResourceDao = (AppResourceDao)AppUtil.getApplicationContext().getBean("appResourceDao");
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            AppResource appResource = (AppResource)appResourceDao.loadById(fileName, appDef);
            File file = AppResourceUtil.getFile((String)appDef.getAppId(), (String)appDef.getVersion().toString(), (String)fileName);
            if (file != null && file.exists()) {
                ins.put(new FileInputStream(file), this.guessContentType(fileName));
            }
        }
        return ins;
    }

    protected Map<InputStream, String> getFormUploadFile() throws IOException {
        HashMap<InputStream, String> ins = new HashMap<InputStream, String>();
        String formDefId = this.getPropertyString("formDefId");
        String fieldId = this.getPropertyString("fieldId");
        if (!formDefId.isEmpty() && !fieldId.isEmpty()) {
            AppService appService;
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            WorkflowAssignment wfAssignment = (WorkflowAssignment)this.getProperty("workflowAssignment");
            String primaryKey = this.getPropertyString("recordId");
            if (primaryKey.isEmpty() && wfAssignment != null) {
                appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                primaryKey = appService.getOriginProcessId(wfAssignment.getProcessId());
            }
            appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            FormData formData = new FormData();
            formData.setPrimaryKeyValue(primaryKey);
            Form loadForm = appService.viewDataForm(appDef.getId(), appDef.getVersion().toString(), formDefId, null, null, null, formData, null, null);
            Element el = FormUtil.findElement((String)fieldId, (Element)loadForm, (FormData)formData);
            String value = FormUtil.getElementPropertyValue((Element)el, (FormData)formData);
            if (value.contains("/web/client/app/") && value.contains("/form/download/")) {
                value = this.retrieveFileNames(value, appDef.getAppId(), formDefId, primaryKey);
            }
            if (value != null && !value.isEmpty()) {
                String[] values;
                for (String v : values = value.split(";")) {
                    File file;
                    if (v.isEmpty() || (file = FileUtil.getFile((String)v, (Element)loadForm, (String)primaryKey)) == null || !file.exists()) continue;
                    ins.put(new FileInputStream(file), this.guessContentType(file.getName()));
                }
            }
        }
        return ins;
    }

    protected Map<InputStream, String> getSystemFile() throws FileNotFoundException {
        File file;
        HashMap<InputStream, String> ins = new HashMap<InputStream, String>();
        String filePath = this.getPropertyString("filePath");
        if (!filePath.isEmpty() && (file = new File(filePath)).exists()) {
            ins.put(new FileInputStream(file), this.guessContentType(file.getName()));
        }
        return ins;
    }

    protected Map<InputStream, String> getUrlFile() throws MalformedURLException, IOException {
        HashMap<InputStream, String> ins = new HashMap<InputStream, String>();
        URL url = new URL(this.getPropertyString("url"));
        ins.put(url.openStream(), this.guessContentType(url.getFile()));
        return ins;
    }

    protected String retrieveFileNames(String content, String appId, String formId, String primaryKey) {
        HashSet<String> values = new HashSet<String>();
        Pattern pattern = Pattern.compile("<img[^>]*src=\"[^\"]*/web/client/app/" + StringUtil.escapeRegex((String)appId) + "/form/download/" + StringUtil.escapeRegex((String)formId) + "/" + StringUtil.escapeRegex((String)primaryKey) + "/([^\"]*)\\.\"[^>]*>");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String fileName = matcher.group(1);
            values.add(fileName);
        }
        return String.join((CharSequence)";", values);
    }

    protected Map<InputStream, String> convertPDFToImages(Map<InputStream, String> ins) throws IOException {
        HashMap<InputStream, String> newIns = new HashMap<InputStream, String>();
        Iterator<InputStream> iterator = ins.keySet().iterator();
        while (iterator.hasNext()) {
            InputStream in;
            InputStream inputStream = in = iterator.next();
            try {
                PDDocument document = PDDocument.load((InputStream)in);
                try {
                    PDFRenderer pdfRenderer = new PDFRenderer(document);
                    for (int page = 0; page < document.getNumberOfPages(); ++page) {
                        BufferedImage bim = pdfRenderer.renderImageWithDPI(page, 300.0f, ImageType.RGB);
                        BufferedImage resized = ImageUtils.resizeImageIfNeeded(bim, 2000);
                        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                            ImageUtils.writeWithoutCache(resized, "jpeg", baos);
                            newIns.put(new ByteArrayInputStream(baos.toByteArray()), "image/jpeg");
                            continue;
                        }
                    }
                }
                finally {
                    if (document == null) continue;
                    document.close();
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return newIns;
    }

    protected String guessContentType(String filename) {
        String contentType = URLConnection.guessContentTypeFromName(filename);
        return contentType != null ? contentType : "";
    }
}

