/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentLLMAbstract;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.ai.agent.model.URLUtility;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeminiAgentLLM
extends AgentLLMAbstract {
    private static final String CLASS_NAME = GeminiAgentLLM.class.getName();
    private final AtomicBoolean isProcessing = new AtomicBoolean(false);
    private static final String ICON = "<svg width=\"52\" height=\"52\" viewBox=\"0 0 52 52\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n<mask id=\"mask0_958_15881\" style=\"mask-type:alpha\" maskUnits=\"userSpaceOnUse\" x=\"0\" y=\"0\" width=\"52\" height=\"52\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M23.554 41.2204C24.92 44.3354 25.603 47.6638 25.603 51.2055C25.603 47.6638 26.264 44.3354 27.587 41.2204C28.952 38.1054 30.787 35.3958 33.091 33.0916C35.396 30.7873 38.105 28.9738 41.22 27.651C44.335 26.2855 47.664 25.6028 51.205 25.6028C47.664 25.6028 44.335 24.9414 41.22 23.6185C38.105 22.2531 35.396 20.4182 33.091 18.114C30.787 15.8097 28.952 13.1001 27.587 9.98507C26.264 6.87007 25.603 3.54171 25.603 0C25.603 3.54171 24.92 6.87007 23.554 9.98507C22.232 13.1001 20.418 15.8097 18.114 18.114C15.81 20.4182 13.1 22.2531 9.98501 23.6185C6.87001 24.9414 3.54171 25.6028 0 25.6028C3.54171 25.6028 6.87001 26.2855 9.98501 27.651C13.1 28.9738 15.81 30.7873 18.114 33.0916C20.418 35.3958 22.232 38.1054 23.554 41.2204Z\" fill=\"white\"/>\n</mask>\n<g mask=\"url(#mask0_958_15881)\">\n<rect x=\"-158.25\" y=\"-455.443\" width=\"832.09\" height=\"685.324\" fill=\"url(#paint0_linear_958_15881)\"/>\n</g>\n<defs>\n<linearGradient id=\"paint0_linear_958_15881\" x1=\"-57.4049\" y1=\"130.441\" x2=\"354.97\" y2=\"30.369\" gradientUnits=\"userSpaceOnUse\">\n<stop stop-color=\"#439DDF\"/>\n<stop offset=\"0.524208\" stop-color=\"#4F87ED\"/>\n<stop offset=\"0.781452\" stop-color=\"#9476C5\"/>\n<stop offset=\"0.888252\" stop-color=\"#BC688E\"/>\n<stop offset=\"1\" stop-color=\"#D6645D\"/>\n</linearGradient>\n</defs>\n</svg>";

    public String getName() {
        return "GeminiAgentLLM";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response getResponse(LLMConfig config, Messages messages, Functions functions) throws AgentException {
        if (!this.isProcessing.compareAndSet(false, true)) {
            LogUtil.warn((String)CLASS_NAME, (String)"Request already being processed, skipping duplicate execution");
            throw new AgentException("Request already in progress");
        }
        try {
            this.presetConfig(config);
            LogUtil.info((String)CLASS_NAME, (String)"Sending request to Gemini API");
            Response response = this.callService(this.getUrl(), config, messages, functions);
            LogUtil.info((String)CLASS_NAME, (String)"Received response from Gemini API");
            Response response2 = response;
            return response2;
        }
        finally {
            this.isProcessing.set(false);
        }
    }

    @Override
    public AgentLLM.Type getLLMType() {
        return AgentLLM.Type.GEMINI;
    }

    protected void presetConfig(LLMConfig config) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        config.put("model", this.getPropertyString("model"));
    }

    protected String getUrl() {
        String configuredUrl = this.getPropertyString("apiUrl");
        String geminiDefaultUrl = AppPluginUtil.getMessage((String)"gemini.defaultapiUrl", (String)this.getClassName(), (String)"messages/agentPlugins");
        String baseUrl = URLUtility.validateApiUrl(configuredUrl, geminiDefaultUrl);
        String model = this.getPropertyString("model");
        if (model == null || model.trim().isEmpty()) {
            model = "gemini-1.5-flash";
        }
        return baseUrl.replace("{model}", model);
    }

    @Override
    protected void prepareRequestHeader(HttpRequestBase request) {
        request.setHeader("Content-Type", "application/json");
        request.setHeader("x-goog-api-key", this.getPropertyString("apiKey"));
    }

    protected String convertInputStreamToBase64(InputStream is) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            String string = Base64.getEncoder().encodeToString(baos.toByteArray());
            return string;
        }
    }

    @Override
    protected void processingFileMessages(Messages messages) {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)((Object)it.next());
            if (message.getFileInputSteam() == null) continue;
            try {
                InputStream is = message.getFileInputSteam();
                try {
                    String fileContentType = message.getString("fileContentType");
                    LogUtil.debug((String)CLASS_NAME, (String)("Processing file message. Content Type: " + fileContentType));
                    if (fileContentType != null && fileContentType.startsWith("image/")) {
                        this.processImageFile(message, is, fileContentType);
                    } else if (fileContentType != null && fileContentType.equals("application/pdf")) {
                        this.processPdfFile(message, is, fileContentType);
                    } else {
                        LogUtil.debug((String)CLASS_NAME, (String)"Processing file as text");
                        super.processingTextFileMessage(message, is);
                    }
                    message.remove("type");
                    message.remove("fileContentType");
                    message.setFileInputStream(null);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (Exception e) {
                LogUtil.error((String)CLASS_NAME, (Throwable)e, (String)"Error processing file message");
                it.remove();
            }
        }
    }

    private void processImageFile(Message message, InputStream is, String fileContentType) throws IOException {
        JSONObject imageData = new JSONObject();
        imageData.put("type", (Object)"image_data");
        imageData.put("mime_type", (Object)fileContentType);
        imageData.put("data", (Object)this.convertInputStreamToBase64(is));
        JSONArray newContent = this.createContentArray(message.getString("content"), imageData);
        message.put("content", newContent);
        message.put("role", "user");
        LogUtil.debug((String)CLASS_NAME, (String)"File processed as image_data");
    }

    private void processPdfFile(Message message, InputStream is, String fileContentType) throws IOException {
        JSONObject pdfData = new JSONObject();
        pdfData.put("type", (Object)"pdf_data");
        pdfData.put("mime_type", (Object)fileContentType);
        pdfData.put("data", (Object)this.convertInputStreamToBase64(is));
        JSONArray newContent = this.createContentArray(message.getString("content"), pdfData);
        message.put("content", newContent);
        message.put("role", "user");
        LogUtil.debug((String)CLASS_NAME, (String)"File processed as pdf_data");
    }

    private JSONArray createContentArray(String existingText, JSONObject fileData) {
        JSONArray newContent = new JSONArray();
        if (existingText != null && !existingText.trim().isEmpty()) {
            newContent.put((Object)new JSONObject().put("type", (Object)"text").put("text", (Object)existingText));
        }
        newContent.put((Object)fileData);
        return newContent;
    }

    @Override
    protected JSONArray convertMessages(Messages messages) {
        JSONArray geminiMessages = new JSONArray();
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            JSONObject geminiMessage;
            block8: {
                Message message = new Message(it.next().toString());
                if (!message.has("content") && !message.has("parts")) {
                    LogUtil.warn((String)CLASS_NAME, (String)"Skipping message without content or parts");
                    continue;
                }
                geminiMessage = new JSONObject();
                String role = message.optString("role", "user");
                geminiMessage.put("role", (Object)("assistant".equals(role) ? "model" : "user"));
                if (message.has("parts")) {
                    JSONArray fallbackParts;
                    try {
                        Object rawParts = message.get("parts");
                        if (rawParts instanceof JSONArray) {
                            geminiMessage.put("parts", rawParts);
                            break block8;
                        }
                        LogUtil.warn((String)CLASS_NAME, (String)"Invalid parts format, expected JSONArray");
                        fallbackParts = new JSONArray();
                        fallbackParts.put((Object)new JSONObject().put("text", (Object)"[Invalid parts]"));
                        geminiMessage.put("parts", (Object)fallbackParts);
                    }
                    catch (Exception e) {
                        LogUtil.error((String)CLASS_NAME, (Throwable)e, (String)"Error parsing 'parts'");
                        fallbackParts = new JSONArray();
                        fallbackParts.put((Object)new JSONObject().put("text", (Object)"[Error in parts]"));
                        geminiMessage.put("parts", (Object)fallbackParts);
                    }
                } else if (message.has("content")) {
                    JSONArray parts = this.convertMessageContent(message.get("content"));
                    geminiMessage.put("parts", (Object)parts);
                }
            }
            geminiMessages.put((Object)geminiMessage);
        }
        return geminiMessages;
    }

    private JSONArray convertMessageContent(Object content) {
        JSONArray parts = new JSONArray();
        if (content instanceof JSONArray) {
            JSONArray contentArray = (JSONArray)content;
            LogUtil.debug((String)CLASS_NAME, (String)("Converting message with " + contentArray.length() + " parts"));
            for (int i = 0; i < contentArray.length(); ++i) {
                JSONObject contentItem = contentArray.getJSONObject(i);
                JSONObject part = this.convertContentItem(contentItem);
                if (part == null) continue;
                parts.put((Object)part);
            }
        } else {
            JSONObject textPart = new JSONObject();
            textPart.put("text", (Object)content.toString());
            parts.put((Object)textPart);
        }
        return parts;
    }

    private JSONObject convertContentItem(JSONObject contentItem) {
        String itemType;
        JSONObject part = new JSONObject();
        switch (itemType = contentItem.getString("type")) {
            case "text": {
                part.put("text", (Object)contentItem.getString("text"));
                break;
            }
            case "image_data": 
            case "pdf_data": {
                JSONObject inlineData = new JSONObject();
                inlineData.put("mime_type", (Object)contentItem.getString("mime_type"));
                inlineData.put("data", (Object)contentItem.getString("data"));
                part.put("inline_data", (Object)inlineData);
                break;
            }
            case "image_url": {
                return this.convertImageUrl(contentItem);
            }
            default: {
                LogUtil.warn((String)CLASS_NAME, (String)("Unknown content type: " + itemType));
                return null;
            }
        }
        return part;
    }

    private JSONObject convertImageUrl(JSONObject contentItem) {
        JSONObject part = new JSONObject();
        String imageUrl = contentItem.getJSONObject("image_url").getString("url");
        if (imageUrl.startsWith("data:")) {
            String[] partsOfDataUrl = imageUrl.split(",", 2);
            if (partsOfDataUrl.length == 2) {
                String meta = partsOfDataUrl[0];
                String base64Data = partsOfDataUrl[1];
                String mimeType = meta.substring(meta.indexOf(":") + 1, meta.indexOf(";"));
                JSONObject inlineData = new JSONObject();
                inlineData.put("mime_type", (Object)mimeType);
                inlineData.put("data", (Object)base64Data);
                part.put("inline_data", (Object)inlineData);
            } else {
                LogUtil.warn((String)CLASS_NAME, (String)"Invalid data URL format");
                part.put("text", (Object)"Error processing image data URL");
            }
        } else {
            LogUtil.warn((String)CLASS_NAME, (String)"Non-data URL image encountered");
            part.put("text", (Object)("Image URL: " + imageUrl));
        }
        return part;
    }

    @Override
    protected JSONArray convertFunctions(Functions functions) {
        JSONArray geminiTools = new JSONArray();
        if (functions.isEmpty()) {
            return geminiTools;
        }
        JSONObject tool = new JSONObject();
        JSONArray declarations = new JSONArray();
        Iterator it = functions.iterator();
        while (it.hasNext()) {
            JSONObject function;
            JSONObject geminiFunction;
            JSONObject functionObj = (JSONObject)it.next();
            if (!functionObj.has("function") || (geminiFunction = this.convertFunction(function = functionObj.getJSONObject("function"))) == null) continue;
            declarations.put((Object)geminiFunction);
        }
        if (declarations.length() > 0) {
            tool.put("function_declarations", (Object)declarations);
            geminiTools.put((Object)tool);
        }
        return geminiTools;
    }

    private JSONObject convertFunction(JSONObject function) {
        if (!function.has("name")) {
            return null;
        }
        JSONObject geminiFunction = new JSONObject();
        geminiFunction.put("name", (Object)function.getString("name"));
        geminiFunction.put("description", (Object)function.optString("description", ""));
        if (function.has("parameters")) {
            JSONObject parameters = function.getJSONObject("parameters");
            JSONObject cleanedParams = new JSONObject();
            cleanedParams.put("type", (Object)"object");
            if (parameters.has("properties")) {
                cleanedParams.put("properties", (Object)parameters.getJSONObject("properties"));
            }
            if (parameters.has("required")) {
                cleanedParams.put("required", (Object)parameters.getJSONArray("required"));
            }
            geminiFunction.put("parameters", (Object)cleanedParams);
        }
        return geminiFunction;
    }

    @Override
    protected String preparePayload(LLMConfig config, Messages messages, Functions functions) {
        this.processingFileMessages(messages);
        JSONObject payload = new JSONObject(config.toString());
        if (payload.has("contents")) {
            payload.put("contents", (Object)this.convertMessages(new Messages(payload.getJSONArray("contents").toString())));
            payload.getJSONArray("contents").putAll(this.convertMessages(messages));
        } else {
            payload.put("contents", (Object)this.convertMessages(messages));
        }
        JSONArray toolsArray = this.convertFunctions(functions);
        if (!toolsArray.isEmpty()) {
            payload.put("tools", (Object)toolsArray);
            LogUtil.debug((String)CLASS_NAME, (String)("Added " + toolsArray.length() + " tools to payload"));
        }
        return payload.toString();
    }

    @Override
    protected void parseResponse(Response result, CloseableHttpResponse response) throws IOException {
        String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        result.setFullJsonResponse(jsonResponse);
        try {
            JSONObject jsonResponseObj = new JSONObject(jsonResponse);
            if (jsonResponseObj.has("error")) {
                this.handleErrorResponse(result, jsonResponseObj);
                return;
            }
            if (!jsonResponseObj.has("candidates") || jsonResponseObj.getJSONArray("candidates").length() == 0) {
                result.setContent("No response candidates available");
                LogUtil.warn((String)CLASS_NAME, (String)"No candidates in Gemini response");
                return;
            }
            this.processResponseCandidate(result, jsonResponseObj.getJSONArray("candidates").getJSONObject(0));
        }
        catch (JSONException e) {
            LogUtil.error((String)CLASS_NAME, (Throwable)e, (String)"Error parsing Gemini response");
            result.setContent("Error parsing response: " + e.getMessage());
        }
    }

    private void handleErrorResponse(Response result, JSONObject jsonResponseObj) {
        String errorMessage = jsonResponseObj.getJSONObject("error").getString("message");
        result.setContent("Error: " + errorMessage);
        LogUtil.error((String)CLASS_NAME, null, (String)("Gemini API error: " + errorMessage));
    }

    private void processResponseCandidate(Response result, JSONObject candidate) {
        if (!candidate.has("content")) {
            result.setContent("No content in response");
            return;
        }
        JSONObject content = candidate.getJSONObject("content");
        JSONObject message = new JSONObject();
        message.put("role", (Object)"assistant");
        if (content.has("parts")) {
            JSONArray parts = content.getJSONArray("parts");
            StringBuilder textContent = new StringBuilder();
            boolean hasFunctionCalls = false;
            for (int i = 0; i < parts.length(); ++i) {
                JSONObject part = parts.getJSONObject(i);
                if (part.has("functionCall")) {
                    hasFunctionCalls = true;
                    this.processFunctionCall(result, part.getJSONObject("functionCall"), i);
                    continue;
                }
                if (!part.has("text")) continue;
                textContent.append(part.getString("text"));
            }
            String finalContent = hasFunctionCalls ? this.buildFunctionAcknowledgment(result) : textContent.toString();
            message.put("content", (Object)finalContent);
            result.setContent(finalContent);
        }
        result.setMessage(message);
    }

    private void processFunctionCall(Response result, JSONObject functionCall, int index) {
        String functionName = functionCall.getString("name");
        JSONObject args = functionCall.optJSONObject("args", new JSONObject());
        LogUtil.debug((String)CLASS_NAME, (String)("Processing function call: " + functionName));
        ToolExecution te = new ToolExecution(functionName, args);
        te.setId("call_" + index);
        result.addToolExecution(te);
    }

    private String buildFunctionAcknowledgment(Response result) {
        StringBuilder ackBuilder = new StringBuilder();
        for (ToolExecution exec : result.getToolExecutions()) {
            ackBuilder.append("Function ").append(exec.getName()).append(" executed successfully.\n");
        }
        return ackBuilder.toString().trim();
    }
}

