/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.io.IOException;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentLLMAbstract;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class GoogleWebSearchAgentTool
extends AgentToolAbstract {
    public String getName() {
        return "GoogleWebSearchAgentTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fab fa-google\"></i>";
    }

    @Override
    public Functions getFunctions() {
        Functions functions = new Functions();
        String desclabel = AppPluginUtil.getMessage((String)"googlewebsearch.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        String arglabel = AppPluginUtil.getMessage((String)"googlewebsearch.arg.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        Function func = new Function("google_web_search", desclabel);
        func.addParameter("query", arglabel);
        functions.add(func);
        return functions;
    }

    @Override
    public String getInfoTemplate() {
        String namelabel = AppPluginUtil.getMessage((String)"beanshelltool.name", (String)this.getClassName(), (String)"messages/agentPlugins");
        String desclabel = AppPluginUtil.getMessage((String)"beanshelltool.description", (String)this.getClassName(), (String)"messages/agentPlugins");
        String descValue = AppPluginUtil.getMessage((String)"googlewebsearch.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + namelabel + "</dt><dd>google_web_search</dd><dt>" + desclabel + "</dt><dd>" + descValue + "</dd></dl></div>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        block29: {
            String query = call.getArguments().getString("query");
            CloseableHttpClient client = null;
            HttpGet request = null;
            Response result = new Response();
            try {
                String string;
                block28: {
                    client = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
                    String url = "https://www.googleapis.com/customsearch/v1?q=" + URLEncoder.encode(query, "UTF-8") + "&key=" + URLEncoder.encode(this.getPropertyString("apiKey"), "UTF-8") + "&cx=" + URLEncoder.encode(this.getPropertyString("searchEngineId"), "UTF-8");
                    URL urlObj = new URL(url);
                    request = new HttpGet(urlObj.toURI());
                    CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                    try {
                        string = this.parseResponse(response);
                        if (response == null) break block28;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable ex) {
                                    throwable.addSuppressed(ex);
                                }
                            }
                            throw throwable;
                        }
                        catch (NoResultsFoundException e) {
                            LogUtil.warn((String)this.getClass().getName(), (String)("No search results found for query: " + query));
                            String string2 = GoogleWebSearchAgentTool.createResultItem("No results found for the query: " + query).toString(2);
                            try {
                                if (request != null) {
                                    request.releaseConnection();
                                }
                                if (client != null) {
                                    client.close();
                                }
                            }
                            catch (IOException ex) {
                                LogUtil.error((String)AgentLLMAbstract.class.getName(), (Throwable)ex, (String)"");
                            }
                            return string2;
                        }
                        catch (IOException e) {
                            try {
                                throw new AgentException("Error executing search request: " + e.getMessage());
                            }
                            catch (Exception e2) {
                                LogUtil.error((String)AgentLLMAbstract.class.getName(), (Throwable)e2, (String)"");
                                break block29;
                            }
                        }
                    }
                    response.close();
                }
                return string;
            }
            finally {
                try {
                    if (request != null) {
                        request.releaseConnection();
                    }
                    if (client != null) {
                        client.close();
                    }
                }
                catch (IOException ex) {
                    LogUtil.error((String)AgentLLMAbstract.class.getName(), (Throwable)ex, (String)"");
                }
            }
        }
        return "No result available";
    }

    protected String parseResponse(CloseableHttpResponse response) throws IOException {
        JSONObject finalResponse = new JSONObject();
        JSONArray llmResults = new JSONArray();
        finalResponse.put("search_results", (Object)llmResults);
        String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        if (jsonResponse != null && !jsonResponse.isEmpty()) {
            JSONObject jsonResponseObj = new JSONObject(jsonResponse);
            JSONArray items = jsonResponseObj.optJSONArray("items");
            if (items == null || items.isEmpty()) {
                throw new NoResultsFoundException();
            }
            for (int i = 0; i < items.length(); ++i) {
                JSONObject item = items.getJSONObject(i);
                llmResults.put((Object)GoogleWebSearchAgentTool.createResultItem(item.optString("title", "Untitled"), item.optString("snippet", ""), item.optString("link", "")));
            }
        }
        return finalResponse.toString(2);
    }

    private static JSONObject createResultItem(String title, String description, String url) {
        JSONObject result = new JSONObject();
        result.put("title", (Object)title);
        result.put("description", (Object)description);
        result.put("url", (Object)url);
        return result;
    }

    private static JSONObject createResultItem(String message) {
        JSONObject result = new JSONObject();
        result.put("search_results", (Object)message);
        return result;
    }

    private static class NoResultsFoundException
    extends RuntimeException {
        private NoResultsFoundException() {
            super("No results found for the query.");
        }
    }
}

