/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.Map;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentPromptAbstract;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.JsonApiUtil;
import org.joget.commons.util.LogUtil;
import org.json.JSONObject;

public class JsonApiAgentPrompt
extends AgentPromptAbstract {
    public String getName() {
        return "JsonApiAgentPrompt";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i><span style=\"font-size: 55%;top: -9px;font-weight: bold;\">JSON</span></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"app.jsontool.jsonUrl", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd>${properties.jsonUrl}</dd></dl></div>";
    }

    @Override
    public void generate(AgentLLM llm, LLMConfig config, Messages messages) throws AgentException {
        try {
            Map results = JsonApiUtil.callApi((Map)this.getProperties(), null);
            if (results != null) {
                messages.add(new Message(Message.Role.SYSTEM, new JSONObject(results).toString()));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            throw new AgentException(e.getLocalizedMessage());
        }
    }
}

