/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.agent.mcp.McpClient;
import org.joget.ai.agent.mcp.McpClientBuilder;
import org.joget.ai.agent.mcp.McpException;
import org.joget.ai.agent.mcp.ToolSpecification;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONObject;

public class McpClientAgentTool
extends AgentToolAbstract
implements PluginWebSupport {
    public String getName() {
        return "McpClientAgentTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)"mcp.label", (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)"mcp.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/agent/McpClientAgentTool.json", null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i><span style=\"font-size: 55%;top: -9px;font-weight: bold;\">MCP</span></i>";
    }

    @Override
    public Functions getFunctions() {
        this.debug(this.properties, this.getClassName(), "McpClientAgentTool.getFunctions");
        Functions functions = new Functions();
        try {
            String mcpServerUrl = this.getPropertyString("sseUrl");
            String serverTimeout = this.getPropertyString("serverTimeout");
            try (McpClient mcpClient = new McpClientBuilder().sseUrl(mcpServerUrl).timeout(Integer.valueOf(serverTimeout != null && !serverTimeout.trim().isEmpty() ? Integer.parseInt(serverTimeout) : 60)).build();){
                List tools = mcpClient.listTools();
                this.debug(this.properties, this.getClassName(), tools.size() + " tool(s) found");
                for (ToolSpecification tool : tools) {
                    this.debug(this.properties, this.getClassName(), "tool.name: " + tool.getName());
                    Function func = new Function(tool.getName(), tool.getDescription(), false);
                    for (Map.Entry entry : tool.getParameters().entrySet()) {
                        ToolSpecification.ParameterSpec param = (ToolSpecification.ParameterSpec)entry.getValue();
                        func.addParameter((String)entry.getKey(), Function.ParameterType.STRING, param.getDescription(), tool.getRequired().contains(entry.getKey()));
                    }
                    functions.add(func);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"error listing functions");
        }
        return functions;
    }

    @Override
    public String getInfoTemplate() {
        String namelabel = AppPluginUtil.getMessage((String)"mcp.server.name", (String)this.getClassName(), (String)"messages/agentPlugins");
        String desclabel = AppPluginUtil.getMessage((String)"mcp.server.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + namelabel + "</dt><dd>${properties.name}</dd><dt>" + desclabel + "</dt><dd>${properties.description}</dd></dl></div>";
    }

    @Override
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        String string;
        block10: {
            this.debug(this.properties, this.getClassName(), "McpClientAgentTool.execute");
            this.debug(this.properties, this.getClassName(), "call.name: " + call.getName());
            this.debug(this.properties, this.getClassName(), "call.arguments: " + call.getArguments());
            String mcpServerUrl = this.getPropertyString("sseUrl");
            String serverTimeout = this.getPropertyString("serverTimeout");
            McpClient mcpClient = new McpClientBuilder().sseUrl(mcpServerUrl).timeout(Integer.valueOf(serverTimeout != null && !serverTimeout.trim().isEmpty() ? Integer.parseInt(serverTimeout) : 60)).build();
            try {
                HashMap<String, Object> arguments = new HashMap<String, Object>();
                JSONObject argsJson = call.getArguments();
                for (String key : argsJson.keySet()) {
                    arguments.put(key, argsJson.get(key));
                }
                String response = mcpClient.executeTool(call.getName(), arguments);
                String string2 = string = response != null ? response : "No result";
                if (mcpClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (mcpClient != null) {
                        try {
                            mcpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (McpException e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"MCP error executing tool");
                    return "Error: " + e.getMessage();
                }
                catch (Exception e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"error executing tool");
                    return "Error: " + e.getMessage();
                }
            }
            mcpClient.close();
        }
        return string;
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
        if (!isAdmin) {
            response.sendError(401);
            return;
        }
        String action = request.getParameter("action");
        if ("testConnection".equals(action)) {
            Object message = "";
            try {
                String mcpServerUrl = request.getParameter("sseUrl");
                try (McpClient mcpClient = new McpClientBuilder().sseUrl(mcpServerUrl).timeout(Integer.valueOf(60)).build();){
                    List tools = mcpClient.listTools();
                    StringBuilder msg = new StringBuilder();
                    msg.append(tools.size()).append(" tool(s) found");
                    for (ToolSpecification tool : tools) {
                        msg.append("\n - ").append(tool.getName());
                    }
                    message = msg.toString();
                }
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"error testing connection");
                message = "failed to connect to MCP server: " + e.getMessage();
            }
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.accumulate("message", message);
                jsonObject.write((Writer)response.getWriter());
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"error writing JSON response");
                response.sendError(500, "Error writing response");
            }
        } else {
            response.setStatus(204);
        }
    }

    private void debug(Map properties, String className, String message) {
        if (properties.get("debugMode") != null && "yes".equals(properties.get("debugMode").toString())) {
            LogUtil.info((String)className, (String)message);
        }
    }
}

