/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentTaskMetadata;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.IMemoryBackend;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class Mem0MemoryTool
extends AgentToolAbstract
implements IMemoryBackend<String> {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private static final String MSG_ROLE_KEY = "role";
    private static final String MSG_CONTENT_KEY = "content";
    private static final Set<String> MSG_ALLOWED_ROLES = Set.of("user", "assistant");

    public String getName() {
        return "Mem0MemoryTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    @Override
    public String getInfoTemplate() {
        String nameLabel = AppPluginUtil.getMessage((String)"beanshelltool.name", (String)this.getClassName(), (String)"messages/agentPlugins");
        String descLabel = AppPluginUtil.getMessage((String)"beanshelltool.description", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + nameLabel + "</dt><dd>Mem0 Agent Memory Tool</dd><dt>" + descLabel + "</dt><dd>Store and recall conversation messages using Mem0.</dd></dl></div>";
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/agent/Mem0MemoryTool.json", null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-brain\"></i>";
    }

    @Override
    public Functions getFunctions() {
        Functions functions = new Functions();
        Function store = new Function("store", this.getPropertyString("storeDescription"));
        Function recall = new Function("recall", this.getPropertyString("recallDescription"));
        Function query = new Function("query", this.getPropertyString("queryDescription"));
        query.addParameter("query", Function.ParameterType.STRING, "The search query to match against stored messages.");
        Function clear = new Function("clear", this.getPropertyString("clearDescription"));
        Function deleteById = new Function("deleteById", this.getPropertyString("deleteByIdDescription"));
        deleteById.addParameter("memory_id", Function.ParameterType.STRING, "The ID of the memory to delete.", false, true);
        Function batchDelete = new Function("batchDelete", this.getPropertyString("batchDeleteDescription"));
        batchDelete.addParameter("memory_ids", Function.ParameterType.STRING, "Array of memory IDs to delete. Max 1000 IDs per call.", true, true);
        functions.add(store);
        functions.add(recall);
        functions.add(query);
        functions.add(clear);
        functions.add(deleteById);
        functions.add(batchDelete);
        return functions;
    }

    @Override
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        AgentTaskMetadata metadata = call.getMetadata();
        JSONObject args = call.getArguments();
        String function = call.getName();
        String agentId = metadata.getAgentId() != null ? metadata.getAgentId() : "default";
        String userId = WorkflowUtil.getCurrentUsername();
        try {
            switch (function) {
                case "store": {
                    return this.store(agentId, userId, metadata.getMessages());
                }
                case "recall": {
                    return this.recall(agentId, userId);
                }
                case "query": {
                    String query = args.getString("query");
                    return this.query(agentId, userId, query);
                }
                case "clear": {
                    return this.clear(agentId, userId);
                }
                case "deleteById": {
                    String memoryId = args.getString("memory_id");
                    return this.deleteById(memoryId);
                }
                case "batchDelete": {
                    List memoryIds = args.getJSONArray("memory_ids").toList().stream().map(Object::toString).collect(Collectors.toList());
                    return this.batchDelete(memoryIds);
                }
            }
            return "{\"error\": \"Unknown function: " + function + "\"}";
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)String.format("Exception in [%s], agent=%s, user=%s: %s", function, agentId, userId, e.getMessage()));
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    @Override
    public String store(String agentId, String userId, Messages messages) throws Exception {
        String apiKey = this.getPropertyString("apiKey");
        JSONObject body = new JSONObject();
        body.put("messages", (Object)this.transformMessages(messages));
        body.put("user_id", (Object)userId);
        body.put("agent_id", (Object)agentId);
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).uri(URI.create(this.getBaseUrl() + "/v1/memories/")).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json; charset=UTF-8").header("Authorization", "Token " + apiKey).build();
        HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        this.logHttp("store", "POST", "/v1/memories/", agentId, userId, response.statusCode());
        if (response.statusCode() != 200) {
            this.logHttpError("store", "POST", "/v1/memories/", agentId, userId, response.statusCode());
            throw new IOException("Mem0 POST failed, HTTP " + response.statusCode() + ": " + response.body());
        }
        return response.body();
    }

    @Override
    public String recall(String agentId, String userId) throws Exception {
        String apiKey = this.getPropertyString("apiKey");
        String uri = this.getBaseUrl() + "/v1/memories/?user_id=" + this.encode(userId) + "&sort=asc";
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(uri)).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json; charset=UTF-8").header("Authorization", "Token " + apiKey).build();
        HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        this.logHttp("recall", "GET", "/v1/memories/", agentId, userId, response.statusCode());
        if (response.statusCode() != 200) {
            this.logHttpError("recall", "GET", "/v1/memories/", agentId, userId, response.statusCode());
            throw new IOException("Mem0 GET failed, HTTP " + response.statusCode() + ": " + response.body());
        }
        return response.body();
    }

    @Override
    public String query(String agentId, String userId, String query) throws Exception {
        String apiKey = this.getPropertyString("apiKey");
        JsonObject body = new JsonObject();
        JsonObject filters = new JsonObject();
        JsonArray orConditions = new JsonArray();
        JsonObject userFilter = new JsonObject();
        JsonObject agentFilter = new JsonObject();
        JsonObject inClause = new JsonObject();
        userFilter.addProperty("user_id", userId);
        orConditions.add((JsonElement)userFilter);
        inClause.add("in", new Gson().toJsonTree((Object)new String[]{agentId}));
        agentFilter.add("agent_id", (JsonElement)inClause);
        orConditions.add((JsonElement)agentFilter);
        filters.add("OR", (JsonElement)orConditions);
        body.addProperty("query", query);
        body.add("filters", (JsonElement)filters);
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).uri(URI.create(this.getBaseUrl() + "/v2/memories/search/")).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json; charset=UTF-8").header("Authorization", "Token " + apiKey).build();
        HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        this.logHttp("query", "POST", "/v2/memories/search/", agentId, userId, response.statusCode());
        if (response.statusCode() != 200) {
            this.logHttpError("query", "POST", "/v2/memories/search/", agentId, userId, response.statusCode());
            throw new IOException("Mem0 POST failed, HTTP " + response.statusCode() + ": " + response.body());
        }
        return response.body();
    }

    @Override
    public String clear(String agentId, String userId) throws Exception {
        String apiKey = this.getPropertyString("apiKey");
        String endpoint = this.getBaseUrl() + "/v1/memories/";
        Map<String, String> idTypeMap = Map.of("user_id", userId, "agent_id", agentId);
        for (Map.Entry<String, String> entry : idTypeMap.entrySet()) {
            String idType = entry.getKey();
            String idValue = entry.getValue();
            String queryParam = idType + "=" + this.encode(idValue);
            HttpRequest request = HttpRequest.newBuilder().DELETE().uri(URI.create(endpoint + "?" + queryParam)).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json; charset=UTF-8").header("Authorization", "Token " + apiKey).build();
            HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            this.logHttp("clear", "DELETE", "/v1/memories/", idType.equals("agent_id") ? idValue : "-", idType.equals("user_id") ? idValue : "-", response.statusCode());
            int status = response.statusCode();
            if (status == 204 || status == 200) continue;
            this.logHttpError("clear", "DELETE", "/v1/memories/", idType.equals("agent_id") ? agentId : "-", idType.equals("user_id") ? userId : "-", status);
            throw new IOException("Mem0 DELETE failed, HTTP " + status + ": " + response.body());
        }
        return "{\"result\": \"cleared\"}";
    }

    @Override
    public String batchDelete(List<String> memoryIds) throws Exception {
        String apiKey = this.getPropertyString("apiKey");
        if (memoryIds == null || memoryIds.isEmpty()) {
            return "{\"error\": \"No memory IDs provided for batch deletion.\"}";
        }
        JsonArray memoriesArray = new JsonArray();
        for (String memoryId : memoryIds) {
            JsonObject memObj = new JsonObject();
            memObj.addProperty("memory_id", memoryId);
            memoriesArray.add((JsonElement)memObj);
        }
        JsonObject body = new JsonObject();
        body.add("memories", (JsonElement)memoriesArray);
        HttpRequest request = HttpRequest.newBuilder().DELETE().uri(URI.create(this.getBaseUrl() + "/v1/batch/")).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json; charset=UTF-8").header("Authorization", "Token " + apiKey).method("DELETE", HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).build();
        HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        this.logHttp("batchDelete", "DELETE", "/v1/batch/", "-", "-", response.statusCode());
        if (response.statusCode() != 200 && response.statusCode() != 204) {
            this.logHttpError("batchDelete", "DELETE", "/v1/batch/", "-", "-", response.statusCode());
            throw new IOException("Mem0 batch delete failed, HTTP " + response.statusCode() + ": " + response.body());
        }
        return response.body() != null ? response.body() : "{\"result\": \"batch deleted\"}";
    }

    @Override
    public String deleteById(String id) throws Exception {
        String apiKey = this.getPropertyString("apiKey");
        if (id == null || id.isEmpty()) {
            return "{\"error\": \"Memory ID is required for deletion.\"}";
        }
        HttpRequest request = HttpRequest.newBuilder().DELETE().uri(URI.create(this.getBaseUrl() + "/v1/memories/" + this.encode(id) + "/")).timeout(Duration.ofSeconds(20L)).header("Content-Type", "application/json; charset=UTF-8").header("Authorization", "Token " + apiKey).build();
        HttpResponse<String> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
        this.logHttp("deleteById", "DELETE", "/v1/memories/" + this.encode(id), "-", "-", response.statusCode());
        if (response.statusCode() != 204 && response.statusCode() != 200) {
            this.logHttpError("deleteById", "DELETE", "/v1/memories/" + this.encode(id), "-", "-", response.statusCode());
            throw new IOException("Mem0 DELETE failed, HTTP " + response.statusCode() + ": " + response.body());
        }
        return "{\"result\": \"deleted\"}";
    }

    private String getBaseUrl() {
        String url = this.getPropertyString("baseUrl");
        if (url == null || url.isEmpty()) {
            url = "https://api.mem0.ai";
        }
        url = url.replaceAll("/+$", "");
        return url;
    }

    private String encode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    private void logHttp(String method, String httpMethod, String path, String agentId, String userId, int status) {
        LogUtil.info((String)this.getClassName(), (String)String.format("[%s] %s %s | agent=%s user=%s status=%d", method, httpMethod, path, agentId, userId, status));
    }

    private void logHttpError(String method, String httpMethod, String path, String agentId, String userId, int status) {
        LogUtil.error((String)this.getClassName(), null, (String)String.format("[%s] HTTP %s %s failed | agent=%s user=%s status=%d", method, httpMethod, path, agentId, userId, status));
    }

    private JSONArray transformMessages(JSONArray messages) {
        JSONArray filtered = new JSONArray();
        for (int i = 0; i < messages.length(); ++i) {
            String content;
            String role;
            JSONObject msg = messages.optJSONObject(i);
            if (msg == null || !MSG_ALLOWED_ROLES.contains(role = msg.optString(MSG_ROLE_KEY, "").trim().toLowerCase()) || (content = this.extractTextContent(msg.opt(MSG_CONTENT_KEY))).isEmpty()) continue;
            filtered.put((Object)new JSONObject().put(MSG_ROLE_KEY, (Object)role).put(MSG_CONTENT_KEY, (Object)content));
        }
        return filtered;
    }

    private String extractTextContent(Object contentObj) {
        if (contentObj instanceof String) {
            return (String)contentObj;
        }
        if (contentObj instanceof JSONArray) {
            JSONArray arr = (JSONArray)contentObj;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length(); ++i) {
                String text;
                JSONObject part = arr.optJSONObject(i);
                if (part == null || (text = part.optString("text", "").trim()).isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(text);
            }
            return sb.toString().trim();
        }
        return "";
    }
}

