/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentLLMAbstract;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.HyperParameters;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.URLUtility;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.workflow.model.service.WorkflowUserManager;

public class OpenRouterAgentLLM
extends AgentLLMAbstract {
    public String getName() {
        return "OpenRouterAgentLLM";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<svg width=\"512\" height=\"512\" viewBox=\"0 0 512 512\" xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" stroke=\"currentColor\"><g clip-path=\"url(#clip0_205_3)\"><path d=\"M3 248.945C18 248.945 76 236 106 219C136 202 136 202 198 158C276.497 102.293 332 120.945 423 120.945\" stroke-width=\"90\" /><path d=\"M511 121.5L357.25 210.268L357.25 32.7324L511 121.5Z\" /><path d=\"M0 249C15 249 73 261.945 103 278.945C133 295.945 133 295.945 195 339.945C273.497 395.652 329 377 420 377\" stroke-width=\"90\" /><path d=\"M508 376.445L354.25 287.678L354.25 465.213L508 376.445Z\" /></g></svg>";
    }

    protected String getUrl() {
        String configuredUrl = this.getPropertyString("apiUrl");
        String genericAIDefaultUrl = AppPluginUtil.getMessage((String)"openRouter.apiUrl.default", (String)this.getClassName(), (String)"messages/agentPlugins");
        return URLUtility.validateApiUrl(configuredUrl, genericAIDefaultUrl);
    }

    protected void presetConfig(LLMConfig config) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        config.put("user", wum.getCurrentUsername());
        HyperParameters hyperparameters = this.getHyperParameters();
        hyperparameters.populateConfig(config);
    }

    protected HyperParameters getHyperParameters() {
        String p = "messages/agentPlugins";
        String c = this.getClassName();
        HyperParameters.Builder b = new HyperParameters.Builder();
        b.model(this.getOrDefault("model", String.class, AppPluginUtil.getMessage((String)"llm.default.model", (String)c, (String)"messages/agentPlugins"))).temperature(this.getOrDefault("temperature", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.temperature", (String)c, (String)"messages/agentPlugins")))).topP(this.getOrDefault("topP", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.top_p", (String)c, (String)"messages/agentPlugins")))).topK(this.getOrDefault("topK", Integer.class, Integer.valueOf(AppPluginUtil.getMessage((String)"llm.default.top_k", (String)c, (String)"messages/agentPlugins")))).frequencyPenalty(this.getOrDefault("frequencyPenalty", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.frequency_penalty", (String)c, (String)"messages/agentPlugins")))).presencePenalty(this.getOrDefault("presencePenalty", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.presence_penalty", (String)c, (String)"messages/agentPlugins")))).repetitionPenalty(this.getOrDefault("repetitionPenalty", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.repetition_penalty", (String)c, (String)"messages/agentPlugins")))).minP(this.getOrDefault("minP", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.min_p", (String)c, (String)"messages/agentPlugins")))).topA(this.getOrDefault("topA", Double.class, Double.valueOf(AppPluginUtil.getMessage((String)"llm.default.top_a", (String)c, (String)"messages/agentPlugins")))).maxTokens(this.getOrDefault("maxTokens", Integer.class, Integer.valueOf(AppPluginUtil.getMessage((String)"llm.default.max_tokens", (String)c, (String)"messages/agentPlugins"))));
        return b.build();
    }

    @Override
    public Response getResponse(LLMConfig config, Messages messages, Functions functions) throws AgentException {
        this.presetConfig(config);
        return this.callService(this.getUrl(), config, messages, functions);
    }

    @Override
    public AgentLLM.Type getLLMType() {
        return AgentLLM.Type.DEFAULT;
    }
}

