/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.Enhancer;
import org.joget.ai.agent.model.IRequestHandler;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.StoreToFormRequestHandler;
import org.json.JSONObject;

public class AgentLLMRequestProcessor {
    private final AgentLLM.Type llmType;
    private final LLMConfig llmConfig;
    private final JSONObject task;
    private final List<IRequestHandler> requestHandlers = List.of(new StoreToFormRequestHandler());

    public AgentLLMRequestProcessor(AgentLLM agentLLM, LLMConfig llmConfig, JSONObject task) {
        this.llmType = agentLLM.getLLMType();
        this.llmConfig = llmConfig;
        this.task = task;
    }

    public void process() {
        if (!this.task.has("enhancer")) {
            return;
        }
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<Enhancer>>(){}.getType();
        List enhancers = (List)gson.fromJson(this.task.getJSONArray("enhancer").toString(), listType);
        for (Enhancer enhancer : enhancers) {
            this.requestHandlers.stream().filter(handler -> handler.supports(enhancer.getClassName())).findFirst().ifPresent(handler -> handler.handle(enhancer, this.llmConfig, this.llmType));
        }
    }
}

