/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static final int MAX_SIZE = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage resizeImageIfNeeded(BufferedImage source, int maxDimension) {
        int width = source.getWidth();
        int height = source.getHeight();
        if (width <= maxDimension && height <= maxDimension) {
            return source;
        }
        double scale = Math.min((double)maxDimension / (double)width, (double)maxDimension / (double)height);
        int targetW = Math.max(1, (int)Math.round((double)width * scale));
        int targetH = Math.max(1, (int)Math.round((double)height * scale));
        int type = source.getType() == 0 ? 2 : source.getType();
        BufferedImage resized = new BufferedImage(targetW, targetH, type);
        Graphics2D g2d = resized.createGraphics();
        try {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.drawImage(source, 0, 0, targetW, targetH, null);
        }
        finally {
            g2d.dispose();
        }
        return resized;
    }

    public static BufferedImage readWithoutCache(File file) throws IOException {
        try {
            ImageIO.setUseCache(false);
            BufferedImage bufferedImage = ImageIO.read(file);
            return bufferedImage;
        }
        finally {
            ImageIO.setUseCache(true);
        }
    }

    public static BufferedImage readWithoutCache(InputStream inputStream) throws IOException {
        try {
            ImageIO.setUseCache(false);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        finally {
            ImageIO.setUseCache(true);
        }
    }

    public static void writeWithoutCache(BufferedImage processed, String formatName, ByteArrayOutputStream baos) throws IOException {
        try {
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)processed, formatName, baos);
        }
        finally {
            ImageIO.setUseCache(true);
        }
    }
}

