AgentBuilderPreview = {
    
    /**
     * Prepare the preview page elements and events
     * 
     * @param {type} jsonDef
     * @param {type} options
     * @param {type} inputsPropertiesOptions
     * @returns {undefined}
     */
    init : function(jsonDef, options, inputsPropertiesOptions) {
        AgentBuilderPreview.renderInputs(jsonDef, options, inputsPropertiesOptions);
        
        $("#runAgent").off('click')
                .on("click", function(){
                    $(this).addClass("loading");
                    $(this).prepend('<i class="las la-spinner la-spin" style="padding:0 3px;"></i>');
                    $(this).prop("disabled", true);
                    $(this).css("opacity", "0.8");
                    $(".agent-result").hide();
                    var editor = $($('.agent-inputs-container')).data("editor");
                    editor.save();
                });
    },
    
    /**
     * Render the inputs section with properties editor
     * 
     * @param {type} jsonDef
     * @param {type} options
     * @param {type} inputsPropertiesOptions
     * @returns {undefined}
     */
    renderInputs : function(jsonDef, options, inputsPropertiesOptions) {
        // render properties
        var poptions = {
            appPath: options.appPath, // use directly from AgentBuilderPreview.init
            contextPath: options.contextPath,
            propertiesDefinition : inputsPropertiesOptions,
            changeCheckIgnoreUndefined: true,
            saveCallback: function(container, properties) {
                var inputJson = JSON.encode(properties);
                
                //run the agent if the save is from button clicked
                if ($("#runAgent").hasClass("loading")) {
                    AgentBuilderPreview.runAgent(jsonDef, options, inputJson);
                }
            },
            validationFailedCallback: function() {
                $("#runAgent").removeClass("loading");
                $("#runAgent").find("i").remove();
                $("#runAgent").prop("disabled", false);
                $("#runAgent").css("opacity", "1");
            }
        };
        PropertyEditor.SimpleMode.render($('.agent-inputs-container'), poptions);
        console.log("appPath used:", poptions.appPath);

        // Get value rows from jsonDef (not from poptions)
        let inputRows = [];
        try {
            const defObj = typeof jsonDef === 'string' ? JSON.parse(jsonDef) : jsonDef;
            inputRows = defObj.properties?.inputs || [];
        } catch (e) {
            console.error("Invalid jsonDef format", e);
        }

        // Fix file input dialog height issue
        $('.agent-inputs-container [name]').each(function() {
            const inputName = $(this).attr('name');
            const inputWrapper = $(this).closest('.property-editor-property');

            for (const row of inputRows) {
                if (row.name === inputName && row.type === 'file') {
                    const fileInputId = inputName + '_file';                    
                }
            }
        });
    },
    
    /**
     * Make an AJAX call to retrive agent response
     * 
     * @param {type} jsonDef
     * @param {type} options
     * @param {type} inputs
     * @returns {undefined}
     */
    runAgent : function(jsonDef, options, inputs) {
        var jsonFile = new Blob([jsonDef], {type : 'text/plain'});
        var params = new FormData();
        params.append("jsonFile", jsonFile);
        params.append("inputs", inputs);

        $.ajax({ 
            type: "POST", 
            url: options.url,
            data: params,
            cache: false,
            processData: false,
            contentType: false,
            dataType: "json",
            timeout: options.timeout,
            beforeSend: function (request) {
               request.setRequestHeader(ConnectionManager.tokenName, ConnectionManager.tokenValue);
            },
            success:function(data) {
                //rendering the response
                AgentBuilderPreview.populate("agent-result-content", data?.content || "", "text");
                AgentBuilderPreview.populate("agent-result-request-payload", data?.requestPayload || "{}");
                AgentBuilderPreview.populate("agent-result-full-result", data?.fullResponse || "{}");
            },
            error:function(data) {
                AgentBuilderPreview.populate("agent-result-content", options?.err, "text");
                AgentBuilderPreview.populate("agent-result-request-payload", "");
                AgentBuilderPreview.populate("agent-result-full-result", "");
            },
            complete: function() {
                //show the result section and enable back the button
                $(".agent-result").show();
                $("#runAgent").removeClass("loading");
                $("#runAgent").find("i").remove();
                $("#runAgent").prop("disabled", false);
                $("#runAgent").css("opacity", 1);
            }
        });
    },
    
    /**
     * Populate the result to preview page using a code editor
     * 
     * @param {type} id
     * @param {type} result
     * @param {type} mode
     * @returns {undefined}
     */
    populate: function(id, result, mode) {
        $("."+id).find(".code-editor").remove();
        $("."+id).append('<div id="code_'+id+'" class="code-editor"></div>');

        // Defensive defaulting
        if (result == undefined || result == null) result = "";

        if (mode === undefined) {
            mode = "application/json";
        }
        
        var codeMirror = CodeMirror(document.getElementById("code_"+id), {
            lineNumbers: true,
            mode: mode,
            matchBrackets: true,
            theme: "default",
            autoRefresh:true,
            gutters: ["CodeMirror-lint-markers", "CodeMirror-linenumbers", "CodeMirror-foldgutter"],
            lint: true,
            historyEventDelay: 100,
            autoCloseTags: true,
            autoCloseBrackets: true,
            foldGutter: true,
            lint: true,
            lineWrapping: true,
            readOnly: true,
            highlightSelectionMatches: {annotateScrollbar: true, minChars: 1}
        });
        
        codeMirror.setValue(result);
    }
};
