AgentSection = {
    init: function() {
        var agentMeta = {
            builderTemplate: {
                render: AgentSection.renderAgent,
                draggable: false,
                movable: false,
                deletable: false,
                copyable: false,
                navigable: false,
                uneditable: true,
                supportProperties: false,
                supportStyle: false,
                childsContainerAttr: 'prompt'
            }
        };
        CustomBuilder.initPaletteElement("", "agent", "", null, null, null, false, "", agentMeta);
    },
    
    /**
     * Render an agent section to canvas
     * 
     * @param {type} element
     * @param {type} elementObj
     * @param {type} component
     * @param {type} callback
     * @returns {undefined}
     */
    renderAgent: function(element, elementObj, component, callback) {
        element.html(''); //empty it
        element.addClass("agent-section");
        element.append('<h5 class="agent-llm-label">'+get_cbuilder_msg('agentbuilder.configAgent')+'</h5>');
        element.append('<div class="agent-llm-section"><div data-cbuilder-llm data-cbuilder-single data-cbuilder-iscontainer data-cbuilder-droparea-msg="'+get_cbuilder_msg('agentbuilder.llmArea')+'"></div>');
        element.append('<div class="agent-llm-prompt-section"><div data-cbuilder-prompt data-cbuilder-iscontainer data-cbuilder-droparea-msg="'+get_cbuilder_msg('agentbuilder.promptArea')+'"></div></div>');
        
        //render LLM
        if (elementObj.llm) {
            AgentBuilder.renderElements(element.find('> .agent-llm-section > div'), elementObj.llm);
        }

        //render prompts
        if (elementObj.prompt) {
            AgentBuilder.renderElements(element.find('> .agent-llm-prompt-section > div'), elementObj.prompt);
        }
        callback(element);
    }
};