/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import com.hazelcast.topic.ITopic;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.agent.model.AgentTraceEvent;
import org.joget.ai.agent.utils.DbHelper;
import org.joget.ai.agent.utils.HazelcastManager;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.base.PluginWebSupport;

public class AgentExecutionTrace
extends ExtDefaultPlugin
implements PluginWebSupport {
    private static final String EVENT_NAME = "agent-trace-event";

    public String getName() {
        return "AgentExecutionTrace";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getDescription() {
        return "AgentExecutionTraceAgentExecutionTrace";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void webService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String runId = SecurityUtil.validateStringInput((String)request.getParameter("runId"));
        if (runId == null || runId.isEmpty()) {
            response.sendError(400, "Missing runId");
            return;
        }
        response.setStatus(200);
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        ITopic<String> topic = HazelcastManager.getTopic(runId);
        PrintWriter pw = response.getWriter();
        pw.write(":ok\n\n");
        pw.flush();
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicReference<UUID> listenerIdRef = new AtomicReference<UUID>();
        UUID listenerId = topic.addMessageListener(message -> {
            try {
                String payload = (String)message.getMessageObject();
                pw.write("event: agent-trace-event\n");
                pw.write("data: " + payload + "\n\n");
                pw.flush();
                if (payload.contains("\"status\":\"END\"")) {
                    pw.write("event: end\n");
                    pw.write("data: Stream completed\n\n");
                    pw.flush();
                    running.set(false);
                    topic.removeMessageListener((UUID)listenerIdRef.get());
                }
            }
            catch (Exception e) {
                running.set(false);
            }
        });
        listenerIdRef.set(listenerId);
        try {
            while (running.get()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return;
                }
            }
        }
        finally {
            topic.removeMessageListener((UUID)listenerIdRef.get());
            pw.close();
        }
    }

    public static void publishTraceEvent(AgentTraceEvent event, boolean persist, boolean debug) {
        try {
            String jsonEvent = event.toString();
            if (debug) {
                LogUtil.info((String)AgentExecutionTrace.class.getName(), (String)String.format("%s - %s is %s%nRequest=%s%nResponse=%s%n", new Object[]{event.getType(), event.getLabel(), event.getStatus(), event.getRequest(), event.getResponse()}));
            }
            if (event.getRunId() != null && !event.getRunId().isEmpty()) {
                HazelcastManager.publish(event.getRunId(), jsonEvent);
                if (persist) {
                    DbHelper.agentTraceEventDao.save(event);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)AgentExecutionTrace.class.getName(), (Throwable)e, (String)e.getMessage());
        }
    }
}

