/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentLLMAbstract;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.ai.agent.model.Traceable;
import org.joget.ai.agent.model.URLUtility;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class AnthropicAgentLLM
extends AgentLLMAbstract {
    public String getName() {
        return "AnthropicAgentLLM";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-user-secret\"></i>";
    }

    @Override
    public AgentLLM.Type getLLMType() {
        return AgentLLM.Type.ANTHROPIC;
    }

    protected String getUrl() {
        String configuredUrl = this.getPropertyString("apiUrl");
        String anthropicDefaultUrl = AppPluginUtil.getMessage((String)"anthropic.defaultapiUrl", (String)this.getClassName(), (String)"messages/agentPlugins");
        return URLUtility.validateApiUrl(configuredUrl, anthropicDefaultUrl);
    }

    @Override
    protected void prepareRequestHeader(HttpRequestBase request) {
        request.setHeader("Content-Type", "application/json");
        request.setHeader("x-api-key", this.getPropertyString("apiKey"));
        request.setHeader("anthropic-version", this.getPropertyString("anthropicVersion"));
    }

    @Override
    protected void processingImageFileMessage(Message message, InputStream is) throws IOException {
        JSONArray content = new JSONArray();
        JSONObject text = new JSONObject();
        text.put("type", (Object)"text");
        text.put("text", (Object)message.getString("content"));
        content.put((Object)text);
        JSONObject imageObj = new JSONObject();
        imageObj.put("type", (Object)"image");
        String base64Data = this.convertImageToBase64(is, message.getString("fileContentType"));
        String contentType = message.getString("fileContentType");
        String base64Only = base64Data.substring(base64Data.indexOf(",") + 1);
        JSONObject source = new JSONObject();
        source.put("type", (Object)"base64");
        source.put("media_type", (Object)contentType);
        source.put("data", (Object)base64Only);
        imageObj.put("source", (Object)source);
        content.put((Object)imageObj);
        message.put("content", content);
        message.put("role", "user");
    }

    protected void presetConfig(LLMConfig config) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        config.put("model", this.getPropertyString("model"));
        config.put("max_tokens", Integer.parseInt(this.getPropertyString("maxTokens")));
    }

    private String combineSystemMessages(Messages messages) {
        StringBuilder sb = new StringBuilder();
        int systemCount = 0;
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)((Object)it.next());
            if (!"system".equals(message.getString("role")) || ++systemCount <= 1) continue;
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(message.getString("content"));
        }
        return sb.toString();
    }

    private String extractSystemMessage(Messages messages) {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)((Object)it.next());
            if (!"system".equals(message.getString("role"))) continue;
            return message.getString("content");
        }
        return null;
    }

    private JSONArray convertMessagesForAnthropic(Messages messages) {
        JSONArray convertedMessages = new JSONArray();
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)((Object)it.next());
            String role = message.getString("role");
            if ("system".equals(role)) continue;
            if ("tool".equals(role)) {
                JSONObject anthropicMessage = new JSONObject();
                anthropicMessage.put("role", (Object)"user");
                JSONArray content = new JSONArray();
                JSONObject toolResult = new JSONObject();
                toolResult.put("type", (Object)"tool_result");
                toolResult.put("tool_use_id", (Object)message.getString("tool_call_id"));
                toolResult.put("content", (Object)message.getString("content"));
                content.put((Object)toolResult);
                anthropicMessage.put("content", (Object)content);
                convertedMessages.put((Object)anthropicMessage);
                continue;
            }
            convertedMessages.put((Object)message);
        }
        return convertedMessages;
    }

    private JSONArray convertFunctionsForAnthropic(Functions functions) {
        JSONArray tools = new JSONArray();
        Iterator it = functions.iterator();
        while (it.hasNext()) {
            JSONObject function = (JSONObject)it.next();
            if (function.has("function") && function.has("type")) {
                function = function.getJSONObject("function");
            }
            JSONObject tool = new JSONObject();
            tool.put("name", (Object)function.getString("name"));
            tool.put("description", (Object)function.getString("description"));
            if (function.has("parameters")) {
                tool.put("input_schema", (Object)function.getJSONObject("parameters"));
            }
            tools.put((Object)tool);
        }
        return tools;
    }

    @Override
    protected String preparePayload(LLMConfig config, Messages messages, Functions functions) {
        JSONArray convertedMessages;
        this.processingFileMessages(messages);
        JSONObject payload = new JSONObject(config.toString());
        Object combinedSystem = this.extractSystemMessage(messages);
        String additionalSystem = this.combineSystemMessages(messages);
        if (additionalSystem != null && !additionalSystem.isEmpty()) {
            combinedSystem = combinedSystem != null && !((String)combinedSystem).isEmpty() ? (String)combinedSystem + "\n\n" + additionalSystem : additionalSystem;
        }
        if (combinedSystem != null && !((String)combinedSystem).isEmpty()) {
            payload.put("system", combinedSystem);
        }
        if ((convertedMessages = this.convertMessagesForAnthropic(messages)).isEmpty()) {
            JSONObject fallbackMessage = new JSONObject();
            fallbackMessage.put("role", (Object)"user");
            String fallbackContent = combinedSystem != null && !((String)combinedSystem).isEmpty() ? combinedSystem : "Hello";
            fallbackMessage.put("content", (Object)fallbackContent);
            convertedMessages.put((Object)fallbackMessage);
        }
        if (payload.has("messages")) {
            payload.getJSONArray("messages").putAll(convertedMessages);
        } else {
            payload.put("messages", (Object)convertedMessages);
        }
        if (!functions.isEmpty()) {
            if (payload.has("tools")) {
                payload.getJSONArray("tools").putAll(this.convertFunctionsForAnthropic(functions));
            } else {
                payload.put("tools", (Object)this.convertFunctionsForAnthropic(functions));
            }
        }
        return payload.toString();
    }

    @Override
    protected void parseResponse(Response result, CloseableHttpResponse response) throws IOException {
        String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        result.setFullJsonResponse(jsonResponse);
        if (jsonResponse != null && !jsonResponse.isEmpty()) {
            try {
                JSONObject jsonResponseObj = new JSONObject(jsonResponse);
                if (jsonResponseObj.has("content")) {
                    JSONArray content = jsonResponseObj.getJSONArray("content");
                    StringBuilder textContent = new StringBuilder();
                    for (int i = 0; i < content.length(); ++i) {
                        JSONObject contentItem = content.getJSONObject(i);
                        String type = contentItem.getString("type");
                        if ("text".equals(type)) {
                            if (textContent.length() > 0) {
                                textContent.append("\n");
                            }
                            textContent.append(contentItem.getString("text"));
                            continue;
                        }
                        if (!"tool_use".equals(type)) continue;
                        String name = contentItem.getString("name");
                        JSONObject input = contentItem.getJSONObject("input");
                        String id = contentItem.getString("id");
                        ToolExecution te = new ToolExecution(name, input);
                        te.setId(id);
                        result.addToolExecution(te);
                    }
                    if (textContent.length() > 0) {
                        result.setContent(textContent.toString());
                    }
                    JSONObject message = new JSONObject();
                    message.put("role", (Object)"assistant");
                    message.put("content", (Object)content);
                    result.setMessage(message);
                } else if (jsonResponseObj.has("error")) {
                    JSONObject error = jsonResponseObj.getJSONObject("error");
                    String errorMessage = error.optString("message", "Unknown error occurred");
                    result.setContent(errorMessage);
                    LogUtil.error((String)this.getClass().getName(), null, (String)("Anthropic API error: " + errorMessage));
                }
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClass().getName(), (Throwable)e, (String)("Error parsing Anthropic response: " + jsonResponse));
                result.setContent("Error parsing response: " + e.getMessage());
            }
        }
    }

    @Override
    @Traceable
    public Response getResponse(LLMConfig config, Messages messages, Functions functions) throws AgentException {
        this.presetConfig(config);
        return this.callService(this.getUrl(), config, messages, functions);
    }
}

