/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.ai.agent.model.Traceable;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;

public class DatabaseQueryAgentTool
extends AgentToolAbstract {
    public String getName() {
        return "DatabaseQueryAgentTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-database\"></i>";
    }

    @Override
    public Functions getFunctions() {
        Functions functions = new Functions();
        String arglabel = AppPluginUtil.getMessage((String)"databaseQuery.arg.desc", (String)this.getClassName(), (String)"messages/agentPlugins");
        Function func = new Function(this.getPropertyString("name"), this.getPropertyString("description"));
        func.addParameter("query", arglabel);
        functions.add(func);
        return functions;
    }

    @Override
    public String getInfoTemplate() {
        String namelabel = AppPluginUtil.getMessage((String)"beanshelltool.name", (String)this.getClassName(), (String)"messages/agentPlugins");
        String desclabel = AppPluginUtil.getMessage((String)"beanshelltool.description", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + namelabel + "</dt><dd>${properties.name}</dd><dt>" + desclabel + "</dt><dd>${properties.description}</dd></dl></div>";
    }

    @Override
    @Traceable
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        String sql = call.getArguments().getString("query");
        DataSource ds = null;
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            ds = this.createDataSource();
            con = ds.getConnection();
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            String string = this.parseResults(rs);
            return string;
        }
        catch (Exception e) {
            throw new AgentException("Database error: " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
                if (con != null) {
                    con.close();
                }
                if (ds != null && ds instanceof BasicDataSource) {
                    ((BasicDataSource)ds).close();
                }
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
        }
    }

    protected String parseResults(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        StringBuilder markdown = new StringBuilder();
        markdown.append("| ");
        for (i = 1; i <= columnCount; ++i) {
            markdown.append(metaData.getColumnName(i).trim()).append(" | ");
        }
        markdown.append("\n");
        markdown.append("|");
        for (i = 0; i < columnCount; ++i) {
            markdown.append(" --- |");
        }
        markdown.append("\n");
        boolean hasRows = false;
        while (rs.next()) {
            hasRows = true;
            markdown.append("| ");
            for (int i2 = 1; i2 <= columnCount; ++i2) {
                markdown.append(rs.getString(i2) != null ? rs.getString(i2) : "").append(" | ");
            }
            markdown.append("\n");
        }
        if (!hasRows) {
            return "No data found";
        }
        return markdown.toString();
    }

    protected DataSource createDataSource() throws Exception {
        DataSource ds = null;
        String datasource = this.getPropertyString("jdbcDatasource");
        if ("default".equals(datasource)) {
            ds = (DataSource)AppUtil.getApplicationContext().getBean("setupDataSource");
        } else {
            Properties dsProps = new Properties();
            dsProps.put("driverClassName", this.getPropertyString("jdbcDriver"));
            dsProps.put("url", this.getPropertyString("jdbcUrl"));
            dsProps.put("username", this.getPropertyString("jdbcUser"));
            dsProps.put("password", this.getPropertyString("jdbcPassword"));
            ds = BasicDataSourceFactory.createDataSource((Properties)dsProps);
        }
        return ds;
    }
}

