/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.Map;
import org.joget.ai.agent.AgentBuilder;
import org.joget.ai.agent.model.AgentBuilderElementAjaxRendering;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentToolAbstract;
import org.joget.ai.agent.model.Function;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.ToolExecution;
import org.joget.ai.agent.model.Traceable;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.model.WorkflowAssignment;
import org.json.JSONArray;
import org.json.JSONObject;

public class RunAgentAgentTool
extends AgentToolAbstract
implements AgentBuilderElementAjaxRendering {
    public String getName() {
        return "RunAgentAgentTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-user-secret\"></i>";
    }

    @Override
    public Functions getFunctions() {
        String agentId = this.getPropertyString("agentId");
        JSONObject props = this.getAgentProperties(agentId);
        Functions functions = new Functions();
        Function func = new Function(this.getPropertyString("functionName"), props.getString("description"));
        JSONArray inputsArray = props.getJSONArray("inputs");
        for (int i = 0; i < inputsArray.length(); ++i) {
            JSONObject inputObj = inputsArray.getJSONObject(i);
            func.addParameter(inputObj.getString("name"), inputObj.getString("description"));
        }
        functions.add(func);
        return functions;
    }

    @Override
    public String getInfoTemplate() {
        return "<div></div>";
    }

    @Override
    public String getRenderHtml() {
        String agentId = this.getPropertyString("agentId");
        JSONObject props = this.getAgentProperties(agentId);
        if (props != null) {
            String namelabel = AppPluginUtil.getMessage((String)"beanshelltool.name", (String)this.getClassName(), (String)"messages/agentPlugins");
            String desclabel = AppPluginUtil.getMessage((String)"beanshelltool.description", (String)this.getClassName(), (String)"messages/agentPlugins");
            String desc = props.getString("description");
            return "<div><dl><dt>" + namelabel + "</dt><dd>" + this.getPropertyString("functionName") + "</dd><dt>" + desclabel + "</dt><dd>" + desc + "</dd></dl></div>";
        }
        String error = AppPluginUtil.getMessage((String)"runAgent.pleaseChoose", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><div class=\"text-error\">" + error + "</div></div>";
    }

    @Override
    @Traceable
    public String execute(AgentLLM llm, LLMConfig config, ToolExecution call) throws AgentException {
        WorkflowAssignment wfAssignment = (WorkflowAssignment)this.getProperty("workflowAssignment");
        try {
            String agentId = this.getPropertyString("agentId");
            Map Properties2 = PropertyUtil.getProperties((JSONObject)call.getArguments());
            Response r = AgentBuilder.runAgent(agentId, Properties2, wfAssignment);
            return r.getContent();
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            throw new AgentException(e.getLocalizedMessage());
        }
    }

    protected JSONObject getAgentProperties(String agentId) {
        JSONObject definition;
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition builderDefinition = builderDefinitionDao.loadById(agentId, appDef);
        if (builderDefinition != null && (definition = new JSONObject(builderDefinition.getJson())).has("properties")) {
            return definition.getJSONObject("properties");
        }
        return null;
    }
}

