<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>@@ubuilder.preview@@</title>
        <link rel="shortcut icon" href="${request.contextPath}/images/favicon.ico"/>    
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/wro/common.css?build=@@build.number@@" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/css/v7.css?build=@@build.number@@" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/js/dropzone/dropzone.css" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/js/tooltipster/css/tooltipster.bundle.min.css" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/css/jquery.propertyeditor.css?build=@@build.number@@" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/universal/lib/material-design-iconic-font/css/material-design-iconic-font.min.css" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/js/line-awesome-1.3.0/css/line-awesome.min.css" />
        <link rel="stylesheet" href="${request.contextPath}/plugin/org.joget.ai.agent.AgentBuilder/codeMirror.min.css" />
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/css/builderTheme.css?build=@@build.number@@" />
        <link rel="stylesheet" href="${request.contextPath}/plugin/org.joget.ai.agent.AgentBuilder/lib/driver.css" />

        <link rel="stylesheet" type="text/css" href="${request.contextPath}/plugin/org.joget.ai.agent.AgentBuilder/agentbuilder_preview.css?build=@@build.number@@" >
    </head>

    <body <#if theme?? >builder-theme="${theme!}"</#if>>
        <h1>@@agentbuilder.testRun@@</h1>
        <div class="agent-preview-tabs">
            <div class="agent-tab-container">
                <button class="agent-tab-btn active" data-tab="execution" type="button">@@agentbuilder.tab.execution@@</button>
                <button class="agent-tab-btn" data-tab="response" type="button">@@agentbuilder.tab.result@@</button>
            </div>
        </div>

        <div id="agent-tab-execution" class="agent-tab-content" style="display:block;">
            <div class="agent-inputs">
                <h2>@@agentbuilder.configureAgentInputs@@</h2>
                <div class="agent-inputs-container"></div>
                <div class="agent-inputs-action"><button id="runAgent" class="btn btn-primary">@@agentbuilder.runAgent@@</button></div>
            </div>

            <div class="agent-node-viewer">
                <h2>@@agentbuilder.nodeViewer.title@@</h2>
                <div id="node-viewer-container" class="node-viewer-container">
                    <div id="node-viewer-preview" class="node-viewer-preview">
                        <div id="canvas"></div>
                        <svg id="connection-layer"></svg>
                    </div>
                </div>
                <div class="node-viewer-result-container">
                    <div class="node-result-request-payload">
                        <h3>@@agentbuilder.nodeViewer.req@@</h3>
                    </div>
                    <div class="node-result-full-result">
                        <h3>@@agentbuilder.nodeViewer.res@@</h3>
                    </div>
                </div>
            </div>
        </div>

        <div id="agent-tab-response" class="agent-tab-content" style="display:none;">
            <div class="agent-result">
                <h2>@@agentbuilder.result@@</h2>
                <div class="agent-result-sub agent-result-content">
                    <h3>@@agentbuilder.content@@</h3>
                    <label class="prettyJsonToggle">
                        <input type="checkbox">
                        @@agentbuilder.content.prettyPrintJson.label@@
                    </label>
                </div>
                <div class="agent-result-sub agent-result-request-payload">
                    <h3>@@agentbuilder.requestPayload@@</h3>
                </div>
                <div class="agent-result-sub agent-result-full-result">
                    <h3>@@agentbuilder.response@@</h3>
                </div>
            </div>
        </div>

        <script type="text/javascript" src="${request.contextPath}/wro/common.preload.js?build=@@build.number@@"> </script>
        <script type="text/javascript" src="${request.contextPath}/wro/common.js?build=@@build.number@@"> </script>

        <script type="text/javascript" src="${request.contextPath}/js/JSON.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/JSONError.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/storage/jquery.html5storage.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/tiny_mce/js/tinymce/tinymce.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/ace/ace.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/dropzone/dropzone.js"></script>
        <script>
            // Initialize ConnectionManager FIRST
            ConnectionManager = ConnectionManager || {};
            ConnectionManager.tokenName = "${csrfTokenName!?js_string}";
            ConnectionManager.tokenValue = "${csrfTokenValue!?js_string}";
        </script>
        <script type="text/javascript">
            // Configure Dropzone AFTER ConnectionManager is set
            Dropzone.autoDiscover = false;
            
            // Add global CSRF configuration
            if (typeof ConnectionManager !== 'undefined' && ConnectionManager.tokenName) {
                // Configure future Dropzones
                Dropzone.prototype.defaultOptions.headers = {
                    ...Dropzone.prototype.defaultOptions.headers,
                    [ConnectionManager.tokenName]: ConnectionManager.tokenValue
                };
                
                Dropzone.prototype.defaultOptions.sending = function(file, xhr, formData) {
                    formData.append(ConnectionManager.tokenName, ConnectionManager.tokenValue);
                };
                            }
        </script>
        <script type="text/javascript" src="${request.contextPath}/js/tinyColorPicker/jqColorPicker.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/tooltipster/js/tooltipster.bundle.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/speakingurl/speakingurl.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/web/console/i18n/peditor?build=@@build.number@@"></script>
        <script type="text/javascript" src="${request.contextPath}/js/jquery/scrollTo/jquery.scrollTo.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/js/jquery/jquery.propertyeditor.js?build=@@build.number@@"></script>
        <script type="text/javascript">// Immediately after the js include
            Dropzone.autoDiscover = false;
        </script>
        <script type="text/javascript" src="${request.contextPath}/plugin/org.joget.ai.agent.AgentBuilder/codeMirror.min.js"></script>
        <script type="text/javascript" src="${request.contextPath}/plugin/org.joget.ai.agent.AgentBuilder/lib/driver.js.iife.js"></script>

        <script type="text/javascript" src="${request.contextPath}/plugin/org.joget.ai.agent.AgentBuilder/agentbuilder_preview.js?build=@@build.number@@"> </script>
        <script>
            // Initialize Dropzone instances after page loads
            document.addEventListener('DOMContentLoaded', function() {
                // Configure existing Dropzones
                document.querySelectorAll('.dropzone').forEach(dropzoneElement => {
                    const dropzone = dropzoneElement.dropzone;
                    if (dropzone) {
                        // Add CSRF header
                        dropzone.options.headers = {
                            ...dropzone.options.headers,
                            [ConnectionManager.tokenName]: ConnectionManager.tokenValue
                        };
                        
                        // Add CSRF token to form data
                        dropzone.on('sending', (file, xhr, formData) => {
                            formData.append(ConnectionManager.tokenName, ConnectionManager.tokenValue);
                        });
                        
                    }
                });
            });

            // Initialize the preview
            AgentBuilderPreview.init("${definition!?js_string}", 
                {
                    "appId" : "${appId!?js_string}",
                    "appVersion" : "${appVersion!?js_string}",
                    "appPath": "/${appId}/${appVersion}",
                    "contextPath" : "${request.contextPath}",
                    "url" : "${request.contextPath}/web/json/app/${appId!?js_string}/${appVersion!?js_string}/plugin/org.joget.ai.agent.AgentBuilder/service?action=runAgent",
                    "err" : "@@agentbuilder.errorRunningAgent@@",
                    "timeout" : @@agentbuilder.requestTimeoutMS@@,
                    "urlTrace" : "${request.contextPath}/web/json/app/${appId!?js_string}/${appVersion!?js_string}/plugin/org.joget.ai.agent.lib.AgentExecutionTrace/service",
                },
            ${inputProperites});
        </script>
    </body>
</html>

