/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.feature;

import io.vavr.control.Try;
import java.util.List;
import javax.websocket.Session;
import org.joget.ai.designer.dto.AgentJogetResponse;
import org.joget.ai.designer.dto.AgentProposalResponse;
import org.joget.ai.designer.dto.AgentStructureResponse;
import org.joget.ai.designer.feature.BaseInjectorPopUp;
import org.joget.ai.designer.model.ApiServiceConfig;
import org.joget.ai.designer.service.AgentApiService;
import org.joget.ai.designer.utils.ValidatorUtil;
import org.joget.ai.designer.validation.Validators;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SetupManager;
import org.joget.plugin.base.PluginWebSocket;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class AgentInjectorPopUp
extends BaseInjectorPopUp<ConversationState>
implements PluginWebSocket {
    private static final String[] STEPS = new String[]{"step_1_proposal", "step_2_structure", "step_3_joget_agent"};
    private static final Integer MIN_QUERY_LENGTH = 50;

    @Override
    public String getName() {
        return "AI Designer - Agent Injector";
    }

    @Override
    public String getVersion() {
        return "8.2-SNAPSHOT";
    }

    @Override
    public String getDescription() {
        return "Chat pop up window for AI Designer - Agent Injector";
    }

    @Override
    public String[] getInjectUrlPatterns() {
        return new String[]{"/web/console/app/*/*/cbuilder/agent/design/*"};
    }

    @Override
    protected String getTemplatePath() {
        return "/resources/feature/AgentInjectorPopUp/AgentInjectorPopUp.ftl";
    }

    @Override
    protected String[] getSteps() {
        return STEPS;
    }

    @Override
    protected JSONArray getActions() {
        return new JSONArray(){
            {
                this.put("continue");
            }
        };
    }

    @Override
    protected ConversationState createState() {
        return new ConversationState();
    }

    @Override
    public void onMessage(String message, Session session) {
        try {
            JSONObject incoming = new JSONObject(message);
            String type = incoming.optString("type", "chat_message");
            ConversationState state = (ConversationState)session.getUserProperties().get("conversationState");
            if (state == null) {
                state = this.createState();
                session.getUserProperties().put("conversationState", state);
            }
            switch (type) {
                case "init": {
                    this.handleInitMessage(session, incoming);
                    break;
                }
                case "continue_step": {
                    this.handlePipelineStep(session, state.step + 1, state);
                    break;
                }
                default: {
                    String query = incoming.optString("message");
                    String error = ValidatorUtil.validateAll(query, Validators.notEmptyString("Please provide a message."), Validators.minLength(MIN_QUERY_LENGTH, "Message must be at least " + MIN_QUERY_LENGTH + " characters long"));
                    if (error != null && !error.isEmpty()) {
                        BaseInjectorPopUp.Helper.sendErrorMessage(session, error);
                        return;
                    }
                    state.query = query;
                    this.handlePipelineStep(session, 1, state);
                    break;
                }
            }
        }
        catch (Exception e) {
            BaseInjectorPopUp.Helper.sendErrorMessage(session, e.getMessage());
        }
    }

    @Override
    protected void handleInitMessage(Session session, JSONObject message) {
        try {
            String userId = WorkflowUtil.getCurrentUsername();
            String sessionId = message.optString("sessionId");
            LogUtil.info((String)this.getClassName(), (String)("Initializing chat for user: " + userId + ", session: " + sessionId));
            session.getUserProperties().put("userId", userId);
            session.getUserProperties().put("sessionId", sessionId);
            JSONObject response = new JSONObject();
            response.put("type", (Object)"status");
            response.put("message", (Object)"Chat initialized successfully");
            BaseInjectorPopUp.Helper.sendMessage(session, response.toString());
            JSONObject welcomeResponse = new JSONObject();
            welcomeResponse.put("type", (Object)"chat_response");
            welcomeResponse.put("content", (Object)"Welcome to the AI Agent Builder! <br> Describe the agent you'd like to create. <br> Please configure Joget Inteligence settings and register the LLM service of your choice if not done already. <br><br> Note: This is a PREVIEW feature only and might fail. Use with caution.");
            BaseInjectorPopUp.Helper.sendMessage(session, welcomeResponse.toString());
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Error handling init message");
            BaseInjectorPopUp.Helper.sendErrorMessage(session, "Initialization failed");
        }
    }

    @Override
    protected void handlePipelineStep(Session session, int step, ConversationState state) {
        this.executor.submit(() -> {
            try {
                ApiServiceConfig config = ApiServiceConfig.fromSetupManager((SetupManager)AppUtil.getApplicationContext().getBean("setupManager"));
                AgentApiService agentApiService = new AgentApiService(config.apiServerUrl, config.apiServerKey);
                String query = state.query;
                if (step == 1) {
                    Try<AgentProposalResponse> proposalTry = agentApiService.callAgentProposal(query, config);
                    if (proposalTry.isFailure()) {
                        BaseInjectorPopUp.Helper.sendErrorMessage(session, "Proposal failed: " + proposalTry.getCause());
                        return;
                    }
                    AgentProposalResponse proposalResp = (AgentProposalResponse)proposalTry.get();
                    List<String> workflowDoc = null;
                    if (proposalResp.data != null) {
                        workflowDoc = proposalResp.data.workflow_document;
                    }
                    state.proposal = proposalResp;
                    state.step = 1;
                    BaseInjectorPopUp.Helper.sendMessage(session, BaseInjectorPopUp.Helper.stepMessage("step_1_proposal", workflowDoc, 1, this.getSteps().length, this.getActions(), null));
                } else if (step == 2) {
                    AgentStructureResponse structureResp;
                    AgentProposalResponse agentProposal = state.proposal;
                    List<String> proposalList = null;
                    if (agentProposal != null && agentProposal.data != null) {
                        proposalList = agentProposal.data.workflow_document;
                    }
                    if (proposalList == null || proposalList.isEmpty()) {
                        BaseInjectorPopUp.Helper.sendErrorMessage(session, "Proposal/workflow document missing or invalid in previous step.");
                        return;
                    }
                    Try<AgentStructureResponse> structureTry = agentApiService.callAgentStructure(query, config, proposalList);
                    if (structureTry.isFailure()) {
                        BaseInjectorPopUp.Helper.sendErrorMessage(session, "Structure failed: " + structureTry.getCause());
                        return;
                    }
                    state.structure = structureResp = (AgentStructureResponse)structureTry.get();
                    state.step = 2;
                    BaseInjectorPopUp.Helper.sendMessage(session, BaseInjectorPopUp.Helper.stepMessage("step_2_structure", structureResp.getDataJson(), 2, this.getSteps().length, this.getActions(), null));
                } else if (step == this.getSteps().length) {
                    AgentStructureResponse.AgentStructureData structureData = state.structure != null ? state.structure.data : null;
                    AgentStructureResponse.ProposedWorkflowParsed agentStructure = null;
                    if (structureData != null) {
                        agentStructure = structureData.proposed_workflow_parsed;
                    }
                    if (agentStructure == null) {
                        BaseInjectorPopUp.Helper.sendErrorMessage(session, "No agent structure found for final step.");
                        return;
                    }
                    Try<AgentJogetResponse> jogetTry = agentApiService.callStructureToJogetAgent(query, config, state.structure.getDataJson().getJSONObject("proposed_workflow_parsed"));
                    if (jogetTry.isFailure()) {
                        BaseInjectorPopUp.Helper.sendErrorMessage(session, "Joget Agent failed: " + jogetTry.getCause());
                        return;
                    }
                    AgentJogetResponse jogetResp = (AgentJogetResponse)jogetTry.get();
                    state.step = this.getSteps().length;
                    JSONObject out = new JSONObject();
                    out.put("successMessage", (Object)"Agent has been created and loaded successfully.");
                    out.put("agentJson", (Object)jogetResp.getDataJson());
                    BaseInjectorPopUp.Helper.sendMessage(session, BaseInjectorPopUp.Helper.stepMessage(STEPS[this.getSteps().length - 1], out, this.getSteps().length, this.getSteps().length, this.getActions(), null));
                }
            }
            catch (Exception ex) {
                BaseInjectorPopUp.Helper.sendErrorMessage(session, ex.getMessage());
            }
        });
    }

    protected static class ConversationState
    extends BaseInjectorPopUp.BaseConversationState {
        AgentProposalResponse proposal;
        AgentStructureResponse structure;

        protected ConversationState() {
        }
    }
}

