/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.feature;

import io.vavr.control.Try;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.Session;
import org.joget.ai.designer.dto.FormDesignResponse;
import org.joget.ai.designer.model.ApiServiceConfig;
import org.joget.ai.designer.service.FormApiService;
import org.joget.apps.app.model.UiHtmlInjectorPluginAbstract;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SetupManager;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSocket;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class FormInjectorPopUp
extends UiHtmlInjectorPluginAbstract
implements PluginWebSocket {
    private ExecutorService executor;
    private static final Set<Session> sessions = new CopyOnWriteArraySet<Session>();
    private static final int MAX_BUFFER_SIZE = 0x200000;

    public String getName() {
        return "AI Designer - Form Injector";
    }

    public String getVersion() {
        return "8.2-SNAPSHOT";
    }

    public String getDescription() {
        return "Chat pop up window for AI Designer - Form injector";
    }

    public String[] getInjectUrlPatterns() {
        return new String[]{"/web/console/app/*/*/form/builder/*"};
    }

    public boolean isIncludeForAjaxThemePageSwitching() {
        return false;
    }

    public String getHtml(HttpServletRequest request) {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("contextPath", request.getContextPath());
        data.put("debug", "true".equalsIgnoreCase(System.getenv("debug")));
        return pluginManager.getPluginFreeMarkerTemplate(data, this.getClassName(), "/resources/feature/FormInjectorPopUp/FormInjectorPopUp.ftl", null);
    }

    public void onOpen(Session session) {
        try {
            session.setMaxTextMessageBufferSize(0x200000);
            session.setMaxBinaryMessageBufferSize(0x200000);
            if (this.executor == null || this.executor.isShutdown()) {
                this.executor = Executors.newCachedThreadPool();
                LogUtil.info((String)this.getClassName(), (String)"Executor service initialized for WebSocket handling.");
            }
            sessions.add(session);
            LogUtil.info((String)this.getClassName(), (String)("WebSocket connected. Session ID: " + session.getId()));
            JSONObject welcomeMsg = new JSONObject();
            welcomeMsg.put("type", (Object)"status");
            welcomeMsg.put("message", (Object)"Connected to form design service");
            Helper.sendMessage(session, welcomeMsg.toString());
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"onOpen Error");
        }
    }

    public void onMessage(String message, Session session) {
        try {
            JSONObject incoming = new JSONObject(message);
            String type = incoming.optString("type", "chat_message");
            ConversationState state = (ConversationState)session.getUserProperties().get("conversationState");
            if (state == null) {
                state = new ConversationState();
                session.getUserProperties().put("conversationState", state);
            }
            switch (type) {
                case "init": {
                    this.handleInitMessage(session, incoming);
                    break;
                }
                case "continue_step": {
                    this.handlePipelineStep(session, state.step + 1, state);
                    break;
                }
                case "refine_form": {
                    String refineInstructions = incoming.optString("message");
                    if (refineInstructions == null || refineInstructions.isBlank()) {
                        Helper.sendErrorMessage(session, "Please provide refinement instructions.");
                        return;
                    }
                    state.refineQuery = refineInstructions;
                    this.handlePipelineStep(session, 3, state);
                    break;
                }
                default: {
                    this.handleChatMessage(session, incoming, state);
                    break;
                }
            }
        }
        catch (Exception e) {
            Helper.sendErrorMessage(session, e.getMessage());
        }
    }

    public void onClose(Session session) {
        try {
            sessions.remove(session);
            if (sessions.isEmpty() && this.executor != null) {
                this.executor.shutdown();
                this.executor = null;
                LogUtil.info((String)this.getClassName(), (String)"All WebSocket sessions closed, shutting down executor.");
            }
            LogUtil.info((String)this.getClassName(), (String)("WebSocket disconnected. Session ID: " + session.getId()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"onClose Error");
        }
    }

    public void onError(Session session, Throwable throwable) {
        LogUtil.error((String)this.getClassName(), (Throwable)throwable, (String)("WebSocket Error for session: " + session.getId()));
        try {
            Helper.sendErrorMessage(session, "Connection error occurred. Please try again.");
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Failed to send error message after WebSocket error");
        }
    }

    private void handleChatMessage(Session session, JSONObject incoming, ConversationState state) {
        String query = incoming.optString("message");
        boolean hasImage = incoming.optBoolean("hasImage", false);
        if (!hasImage && (query == null || query.isBlank())) {
            Helper.sendErrorMessage(session, "Please provide a form description or upload an image.");
            return;
        }
        if (hasImage) {
            String imageBase64 = incoming.optString("imageBase64", "");
            if (imageBase64.length() > 0x200000) {
                Helper.sendErrorMessage(session, "Image too large. Please compress the image or reduce quality.");
                return;
            }
            state.imageBase64 = imageBase64;
            state.imageFileName = incoming.optString("imageFileName", "uploaded_image");
        }
        state.query = query;
        state.hasImage = hasImage;
        this.handlePipelineStep(session, 1, state);
    }

    private void handleInitMessage(Session session, JSONObject message) {
        try {
            String userId = WorkflowUtil.getCurrentUsername();
            String sessionId = message.optString("sessionId");
            LogUtil.info((String)this.getClassName(), (String)("Initializing form designer chat for user: " + userId + ", session: " + sessionId));
            session.getUserProperties().put("userId", userId);
            session.getUserProperties().put("sessionId", sessionId);
            JSONObject response = new JSONObject();
            response.put("type", (Object)"status");
            response.put("message", (Object)"Form designer initialized successfully");
            Helper.sendMessage(session, response.toString());
            JSONObject welcomeResponse = new JSONObject();
            welcomeResponse.put("type", (Object)"chat_response");
            welcomeResponse.put("content", (Object)"Welcome to the AI Designer - Form Injector! \nDescribe the form you'd like to create.");
            Helper.sendMessage(session, welcomeResponse.toString());
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Error handling init message");
            Helper.sendErrorMessage(session, "Initialization failed");
        }
    }

    private void handlePipelineStep(Session session, int step, ConversationState state) {
        this.executor.submit(() -> {
            try {
                ApiServiceConfig config = ApiServiceConfig.fromSetupManager((SetupManager)AppUtil.getApplicationContext().getBean("setupManager"));
                FormApiService formApiService = new FormApiService(config.apiServerUrl, config.apiServerKey);
                String query = state.query != null ? state.query : "";
                ArrayList<String> imageBase64List = new ArrayList<String>();
                if (state.hasImage && state.imageBase64 != null && !state.imageBase64.isEmpty()) {
                    imageBase64List.add(state.imageBase64);
                } else {
                    LogUtil.info((String)this.getClassName(), (String)"No image data for request");
                }
                if (step == 1) {
                    Try<FormDesignResponse> formDesignTry = formApiService.callFormDesign(query, config, imageBase64List, true);
                    if (formDesignTry.isFailure()) {
                        Helper.sendErrorMessage(session, "Form design failed: " + formDesignTry.getCause().getMessage());
                        return;
                    }
                    FormDesignResponse formResp = (FormDesignResponse)formDesignTry.get();
                    if (!formResp.isStatus()) {
                        Helper.sendErrorMessage(session, "Form design failed: " + formResp.getMessage());
                        return;
                    }
                    JSONObject designedForms = null;
                    if (formResp.data != null) {
                        designedForms = formResp.data.designed_forms;
                    }
                    state.formResponse = formResp;
                    state.currentDesignedForms = designedForms;
                    state.step = 1;
                    Helper.sendMessage(session, Helper.stepMessage("step_1_form_design", designedForms, 1, null));
                } else if (step == 2) {
                    FormDesignResponse formResponse = state.formResponse;
                    if (formResponse == null || formResponse.data == null || formResponse.data.joget_designed_forms == null) {
                        Helper.sendErrorMessage(session, "No form data available for injection.");
                        return;
                    }
                    JSONObject jogetForms = formResponse.data.joget_designed_forms;
                    String firstFormKey = (String)jogetForms.keys().next();
                    JSONObject formContainer = jogetForms.optJSONObject(firstFormKey);
                    if (formContainer == null) {
                        Helper.sendErrorMessage(session, "No form container found.");
                        return;
                    }
                    JSONObject formJson = formContainer.optJSONObject("form");
                    if (formJson == null) {
                        Helper.sendErrorMessage(session, "No form JSON found in container.");
                        return;
                    }
                    state.step = 2;
                    JSONObject out = new JSONObject();
                    out.put("successMessage", (Object)"Form has been created and loaded successfully.");
                    out.put("formJson", (Object)formJson);
                    Helper.sendMessage(session, Helper.stepMessage("step_2_form_inject", out, 2, null));
                } else if (step == 3) {
                    String refineQuery = state.refineQuery;
                    JSONObject designedForms = state.currentDesignedForms;
                    if (refineQuery == null || refineQuery.isBlank()) {
                        Helper.sendErrorMessage(session, "Please provide refinement instructions.");
                        return;
                    }
                    if (designedForms == null) {
                        Helper.sendErrorMessage(session, "No previous form design found to refine.");
                        return;
                    }
                    Try<FormDesignResponse> refineTry = formApiService.callProcessCorrection(refineQuery, config, designedForms, imageBase64List);
                    if (refineTry.isFailure()) {
                        Helper.sendErrorMessage(session, "Form refinement failed: " + refineTry.getCause().getMessage());
                        return;
                    }
                    FormDesignResponse refineResp = (FormDesignResponse)refineTry.get();
                    if (!refineResp.isStatus()) {
                        Helper.sendErrorMessage(session, "Form refinement failed: " + refineResp.getMessage());
                        return;
                    }
                    JSONObject refinedDesignedForms = null;
                    if (refineResp.data != null) {
                        refinedDesignedForms = refineResp.data.designed_forms;
                    }
                    state.formResponse = refineResp;
                    state.currentDesignedForms = refinedDesignedForms;
                    state.step = 1;
                    Helper.sendMessage(session, Helper.stepMessage("step_1_form_design_refined", refinedDesignedForms, 1, null));
                }
            }
            catch (Exception ex) {
                LogUtil.error((String)this.getClassName(), (Throwable)ex, (String)("Error in pipeline step " + step));
                Helper.sendErrorMessage(session, "Error: " + ex.getMessage());
            }
        });
    }

    private static class Helper {
        private Helper() {
        }

        private static void sendMessage(Session session, String message) {
            try {
                if (session.isOpen()) {
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (IOException e) {
                LogUtil.error((String)FormInjectorPopUp.class.getCanonicalName(), (Throwable)e, (String)("Error sending message to session: " + session.getId()));
            }
        }

        private static void sendErrorMessage(Session session, String errorMessage) {
            try {
                JSONObject error = new JSONObject();
                error.put("type", (Object)"error");
                error.put("message", (Object)errorMessage);
                Helper.sendMessage(session, error.toString());
            }
            catch (Exception e) {
                LogUtil.error((String)FormInjectorPopUp.class.getCanonicalName(), (Throwable)e, (String)"Error sending error message");
            }
        }

        private static JSONArray actionsForStep(int step) {
            JSONArray actions = new JSONArray();
            if (step == 1) {
                actions.put((Object)"continue");
                actions.put((Object)"refine");
            }
            actions.put((Object)"restart");
            return actions;
        }

        private static String stepMessage(String type, Object content, int step, Object extra) {
            JSONObject o = new JSONObject();
            o.put("type", (Object)type);
            o.put("content", content);
            o.put("step", step);
            o.put("actions", (Object)Helper.actionsForStep(step));
            if (extra != null) {
                o.put("extra", extra);
            }
            return o.toString();
        }
    }

    private static class ConversationState {
        int step = 0;
        String query;
        String refineQuery;
        boolean hasImage = false;
        String imageBase64 = null;
        String imageFileName = "";
        FormDesignResponse formResponse;
        JSONObject currentDesignedForms;

        private ConversationState() {
        }
    }
}

