/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.feature;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.designer.AiDesigner;
import org.joget.ai.designer.utils.ApiHelper;
import org.joget.ai.designer.utils.DbHelper;
import org.joget.apps.app.service.AppUtil;
import org.joget.plugin.base.PluginManager;
import org.json.JSONObject;

public abstract class UiFeatureAbstract {
    public static final AiDesigner AiDesigner = new AiDesigner();
    private static final String BASE_RESOURCE_PATH = "resources/feature/";
    protected static final String className = ((Object)((Object)AiDesigner)).getClass().getName();

    protected String[] getSupportedResourceTypes() {
        return new String[]{"css", "js"};
    }

    public JSONObject driver(HttpServletRequest request, HttpServletResponse response, JSONObject workflowDocument) throws Exception {
        JSONObject responseBodyData = ApiHelper.callAiDesignerApi(request, response, workflowDocument);
        workflowDocument = this.postProcessWorkflowDocument(workflowDocument, responseBodyData);
        String stage = request.getParameter("_a");
        String stage_name = request.getParameter("stage_name");
        if (responseBodyData.getBoolean("status")) {
            if ("query_enhancer".equals(stage) || "pii_analyser".equals(stage)) {
                workflowDocument.put("query", (Object)responseBodyData.getString("response"));
            }
            if ("process_proposal".equals(stage_name)) {
                workflowDocument.put("proposed_process", (Object)responseBodyData.getString("proposed_process"));
            }
            if ("forms_and_participants".equals(stage_name)) {
                workflowDocument.put("forms", (Object)responseBodyData.getString("forms"));
                workflowDocument.put("participants", (Object)responseBodyData.getString("participants"));
            }
            if ("transitions_and_business_activities".equals(stage_name)) {
                workflowDocument.put("process_xpdl", responseBodyData.get("process_xpdl"));
                workflowDocument.put("proposed_workflow", responseBodyData.get("transitions"));
                workflowDocument.put("proposed_workflow_parsed", (Object)responseBodyData.getString("transitions_parsed"));
            }
            if ("forms_design".equals(stage_name) || "remove_form_design".equals(stage_name) || "add_forms_design".equals(stage_name) || "replace_form_design".equals(stage_name)) {
                workflowDocument.put("forms", responseBodyData.get("forms"));
                workflowDocument.put("designed_form_joget_format", responseBodyData.get("joget_designed_forms"));
                workflowDocument.put("designed_form", responseBodyData.get("designed_forms"));
            }
            if ("replace_form_design".equals(stage_name)) {
                workflowDocument.put("proposed_workflow", responseBodyData.get("transitions"));
                workflowDocument.put("proposed_workflow_parsed", responseBodyData.get("transitions_parsed"));
            }
            if ("process_correction".equals(stage_name)) {
                workflowDocument.put("forms", responseBodyData.get("forms"));
                workflowDocument.put("participants", responseBodyData.get("participants"));
                workflowDocument.put("proposed_process", responseBodyData.get("proposed_process"));
                workflowDocument.put("designed_form_joget_format", responseBodyData.get("joget_designed_forms"));
                workflowDocument.put("designed_form", responseBodyData.get("designed_forms"));
                workflowDocument.put("proposed_workflow", responseBodyData.get("transitions"));
            }
        }
        workflowDocument.put("responseBodyData", (Object)responseBodyData);
        DbHelper.saveWorkflowCollection(workflowDocument);
        return workflowDocument;
    }

    public JSONObject getResources(PluginManager pluginManager, String resourceName) {
        String[] resourceTypes;
        JSONObject resources = new JSONObject();
        String ftlFilePath = BASE_RESOURCE_PATH + resourceName + "/" + resourceName + ".ftl";
        resources.put("ftl", (Object)pluginManager.getPluginFreeMarkerTemplate(new HashMap(), className, ftlFilePath, null));
        for (String resource : resourceTypes = this.getSupportedResourceTypes()) {
            resources.put(resource, (Object)AppUtil.readPluginResource((String)className, (String)(BASE_RESOURCE_PATH + resourceName + "/" + resourceName + "." + resource)));
        }
        return resources;
    }

    public JSONObject postProcessWorkflowDocument(JSONObject workflowDocument, JSONObject responseBodyData) {
        workflowDocument.put("llmModelClass", responseBodyData.get("llmModelClass"));
        workflowDocument.put("llmModelName", responseBodyData.get("llmModelName"));
        workflowDocument.put("status", responseBodyData.get("status"));
        if (responseBodyData.keySet().contains("query")) {
            workflowDocument.put("query", (Object)responseBodyData.getString("query"));
        }
        return workflowDocument;
    }
}

