/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.model;

import org.joget.commons.util.SetupManager;
import org.joget.commons.util.StringUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiServiceConfig {
    public final String apiServerUrl;
    public final String apiServerKey;
    public final String modelClass;
    public final String modelName;
    public final String customLlmUrl;
    public final String apiKey;

    public ApiServiceConfig(String apiServerUrl, String apiServerKey, String modelClass, String modelName, String customLlmUrl, String apiKey) {
        this.apiServerUrl = apiServerUrl;
        this.apiServerKey = apiServerKey;
        this.modelClass = modelClass;
        this.modelName = modelName;
        this.customLlmUrl = customLlmUrl;
        this.apiKey = apiKey;
    }

    public static ApiServiceConfig fromSetupManager(SetupManager setupManager) {
        JSONObject apiServerProps = ApiServiceConfig.extractProperties(setupManager, "API_SERVER_CONFIG");
        String apiServerUrl = apiServerProps.optString("apiServerUrl");
        String apiServerKey = apiServerProps.optString("apiServerKey");
        JSONObject aiServicesProps = ApiServiceConfig.extractProperties(setupManager, "MY_AI_SERVICES");
        JSONArray servicesArray = aiServicesProps.optJSONArray("myAiServices");
        String modelClass = "";
        String modelName = "";
        String customLlmUrl = "";
        String apiKey = "";
        if (servicesArray != null) {
            for (int i = 0; i < servicesArray.length(); ++i) {
                JSONObject apiEntry = servicesArray.optJSONObject(i);
                if (apiEntry == null || !apiEntry.optBoolean("using")) continue;
                modelClass = apiEntry.optString("modelClass");
                if ("Custom".equals(modelClass)) {
                    modelClass = "OpenAI";
                    modelName = apiEntry.optString("customModelName");
                    customLlmUrl = apiEntry.optString("customLlmUrl");
                } else {
                    customLlmUrl = "";
                    modelName = apiEntry.optString("modelName");
                }
                apiKey = apiEntry.optString("apiKey");
                break;
            }
        }
        return new ApiServiceConfig(apiServerUrl, apiServerKey, modelClass, modelName, customLlmUrl, apiKey);
    }

    private static JSONObject extractProperties(SetupManager setupManager, String settingKey) {
        String encrypted = setupManager.getSettingValue(settingKey);
        String decrypted = StringUtil.decryptContent((String)encrypted);
        JSONObject setting = new JSONObject(decrypted);
        return setting.optJSONObject("properties");
    }
}

