/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.ai.designer.utils.Constants;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SetupManager;
import org.joget.commons.util.StringUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiHelper {
    public static String getClassName() {
        return "ApIHelper";
    }

    public static String findKeyByModelName(JSONObject awsModels, String modelName) {
        for (String key : awsModels.keySet()) {
            JSONArray modelsArray = awsModels.getJSONArray(key);
            for (int i = 0; i < modelsArray.length(); ++i) {
                if (!modelsArray.getString(i).equals(modelName)) continue;
                return key;
            }
        }
        return null;
    }

    private static JSONObject returnProperties(String settingType) {
        SetupManager setupManager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        String settingValue = setupManager.getSettingValue(settingType);
        JSONObject settingValueDecrypted = new JSONObject(StringUtil.decryptContent((String)settingValue));
        JSONObject properties = settingValueDecrypted.getJSONObject("properties");
        return properties;
    }

    public static JSONObject getConfigurations(JSONObject awsModels) throws Exception {
        JSONObject properties = new JSONObject();
        properties = ApiHelper.returnProperties("MY_AI_SERVICES");
        JSONArray myAiServicesArray = properties.getJSONArray("myAiServices");
        properties = ApiHelper.returnProperties("API_SERVER_CONFIG");
        String apiServerUrl = properties.getString("apiServerUrl");
        String apiServerKey = properties.getString("apiServerKey");
        Object apiKey = null;
        String modelName = null;
        String customLlmUrl = null;
        String modelClass = null;
        String customModelName = null;
        for (int i = 0; i < myAiServicesArray.length(); ++i) {
            JSONObject apiEntry = myAiServicesArray.getJSONObject(i);
            if (!apiEntry.getBoolean("using")) continue;
            modelClass = apiEntry.getString("modelClass");
            if (modelClass.equals("Custom")) {
                modelClass = "OpenAI";
                modelName = customModelName = apiEntry.getString("customModelName");
                customLlmUrl = apiEntry.getString("customLlmUrl");
            } else {
                customLlmUrl = "";
                modelName = apiEntry.getString("modelName");
            }
            if (modelClass.equals("AWS Bedrock")) {
                String key;
                modelClass = key = ApiHelper.findKeyByModelName(awsModels, modelName);
                apiKey = apiEntry.getJSONObject("apiKey");
                break;
            }
            apiKey = apiEntry.getString("apiKey");
            break;
        }
        if (apiKey == null) {
            throw new Exception("apiKey for LLM needs to be provided");
        }
        JSONObject configuration = new JSONObject();
        configuration.put("modelClass", modelClass);
        configuration.put("modelName", modelName);
        configuration.put("apiKey", (Object)apiKey.toString());
        configuration.put("customLlmUrl", (Object)customLlmUrl);
        configuration.put("apiServerUrl", (Object)apiServerUrl);
        configuration.put("apiServerKey", (Object)apiServerKey);
        return configuration;
    }

    public static JSONObject callAiDesignerApi(HttpServletRequest request, HttpServletResponse response, JSONObject workflowDocument) throws Exception {
        String stage = request.getParameter("_a");
        String stage_name = request.getParameter("stage_name");
        JSONObject awsModels = request.getParameter("_awsModels") == null ? new JSONObject() : new JSONObject(request.getParameter("_awsModels"));
        JSONObject configuration = ApiHelper.getConfigurations(awsModels);
        HttpClient client = HttpClient.newBuilder().build();
        JSONObject requestBodyJson = new JSONObject();
        requestBodyJson.put("analysis_stage", (Object)stage_name);
        if (stage_name.equals("replace_form_design")) {
            requestBodyJson.put("form_to_replace", (Object)request.getParameter("form_to_replace"));
            requestBodyJson.put("transitions", workflowDocument.get("proposed_workflow"));
            if (workflowDocument.has("proposed_workflow_parsed") && workflowDocument.getString("proposed_workflow_parsed") != null && !workflowDocument.getString("proposed_workflow_parsed").trim().isEmpty()) {
                requestBodyJson.put("transitions_parsed", (Object)new JSONObject(workflowDocument.getString("proposed_workflow_parsed")));
            }
            requestBodyJson.put("designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form")));
            requestBodyJson.put("joget_designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form_joget_format")));
        }
        if (stage_name.equals("add_forms_design")) {
            requestBodyJson.put("designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form")));
            requestBodyJson.put("joget_designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form_joget_format")));
        }
        if (stage_name.equals("getAppData")) {
            requestBodyJson.put("json_string", (Object)workflowDocument.getString("designed_form_joget_format"));
        }
        if (stage_name.equals("remove_form_design")) {
            JSONArray removeFormDesignNamesArray = new JSONArray(request.getParameter("forms_to_remove"));
            ArrayList<String> removeFormDesignNamesList = new ArrayList<String>();
            for (int i = 0; i < removeFormDesignNamesArray.length(); ++i) {
                String removeFormDesignName = removeFormDesignNamesArray.getString(i);
                removeFormDesignNamesList.add(removeFormDesignName);
            }
            requestBodyJson.put("forms_to_remove", removeFormDesignNamesList);
            requestBodyJson.put("designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form")));
            requestBodyJson.put("joget_designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form_joget_format")));
        }
        if (Constants.inputRequiredStages.contains(stage_name)) {
            requestBodyJson.put("query", (Object)request.getParameter("query"));
            String imageBase64ListString = request.getParameter("image_base_64_list");
            if (imageBase64ListString != null) {
                JSONArray imageBase64List = new JSONArray(imageBase64ListString);
                requestBodyJson.put("image_base_64_list", (Object)imageBase64List);
                requestBodyJson.put("image_url_list", (Object)new JSONArray());
            }
        }
        if (Constants.llmRequiredStages.contains(stage_name)) {
            requestBodyJson.put("llm_model_class", (Object)configuration.getString("modelClass"));
            requestBodyJson.put("llm_model_name", (Object)configuration.getString("modelName"));
            requestBodyJson.put("api_key", (Object)configuration.getString("apiKey"));
            requestBodyJson.put("custom_llm_url", (Object)configuration.getString("customLlmUrl"));
        }
        if (stage_name.equals("query_pii_masking")) {
            JSONArray denyList = new JSONArray(request.getParameter("deny_list"));
            requestBodyJson.put("deny_list", (Object)denyList);
        }
        if (stage_name.equals("forms_and_participants") || stage_name.equals("transitions_and_business_activities") || stage_name.equals("forms_design")) {
            requestBodyJson.put("process_proposal", workflowDocument.get("proposed_process"));
        }
        if (stage_name.equals("transitions_and_business_activities") || stage_name.equals("forms_design")) {
            requestBodyJson.put("forms", workflowDocument.get("forms"));
            requestBodyJson.put("participants", workflowDocument.get("participants"));
        }
        if (stage_name.equals("forms_design")) {
            requestBodyJson.put("transitions", workflowDocument.get("proposed_workflow"));
        }
        if (stage_name.equals("process_correction")) {
            requestBodyJson.put("process_proposal", workflowDocument.get("proposed_process"));
            requestBodyJson.put("forms", workflowDocument.get("forms"));
            requestBodyJson.put("participants", workflowDocument.get("participants"));
            requestBodyJson.put("transitions", workflowDocument.get("proposed_workflow"));
            requestBodyJson.put("requested_changes", (Object)new String[]{request.getParameter("requested_changes")});
            if (!workflowDocument.getString("designed_form").isEmpty()) {
                requestBodyJson.put("designed_forms", (Object)new JSONObject(workflowDocument.getString("designed_form")));
            } else {
                requestBodyJson.put("designed_forms", (Object)new JSONObject());
            }
        }
        String endpoint = Constants.STAGE_TO_URL_MAPPING.get(stage);
        HttpRequest httpRequest = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestBodyJson.toString())).uri(URI.create(configuration.getString("apiServerUrl") + endpoint)).header("accept", "application/json").header("Content-Type", "application/json").header("Authorization", configuration.getString("apiServerKey")).build();
        HttpResponse<String> httpResponse = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject httpResponseBody = new JSONObject(httpResponse.body());
        JSONObject httpResponseBodyData = new JSONObject();
        if (httpResponse.statusCode() != 200) {
            httpResponseBodyData.put("message", (Object)httpResponseBody.optString("message"));
        } else {
            httpResponseBodyData = httpResponseBody.optJSONObject("data");
        }
        httpResponseBodyData.put("status", httpResponse.statusCode() == 200);
        httpResponseBodyData.put("llmModelClass", (Object)configuration.getString("modelClass"));
        httpResponseBodyData.put("llmModelName", (Object)configuration.getString("modelName"));
        if (Constants.inputRequiredStages.contains(stage_name)) {
            httpResponseBodyData.put("query", (Object)request.getParameter("query"));
        }
        if (httpResponse.statusCode() != 200) {
            LogUtil.debug((String)ApiHelper.getClassName(), (String)("AI Designer API Returned a non 200 status code response --> " + httpResponseBodyData + "\nStatus Code: " + httpResponse.statusCode()));
        }
        return httpResponseBodyData;
    }
}

