/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.joget.ai.designer.AiAppContext;
import org.joget.ai.designer.dao.ProposedWorkflowDaoImpl;
import org.joget.ai.designer.model.ProposedWorkflow;
import org.joget.apps.app.dao.DatalistDefinitionDao;
import org.joget.apps.app.model.AbstractAppVersionedObject;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.DatalistDefinition;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class DbHelper {
    public static ProposedWorkflowDaoImpl proposedWorkflowDao = (ProposedWorkflowDaoImpl)AiAppContext.getInstance().getAppContext().getBean("proposedWorkflowDao");
    public static DatalistDefinitionDao datalistDefinitionDao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");

    public static JSONArray findAllWorkflows(String sort, Boolean desc, Integer start, Integer rows) {
        Collection<ProposedWorkflow> workflowDocuments = proposedWorkflowDao.find("", null, sort, desc, start, rows);
        JSONArray workflowDocumentsJSON = new JSONArray();
        if (workflowDocuments == null) {
            return workflowDocumentsJSON;
        }
        for (ProposedWorkflow workflowDocument : workflowDocuments) {
            workflowDocumentsJSON.put((Object)workflowDocument.toJson());
        }
        return workflowDocumentsJSON;
    }

    public static JSONObject findWorkflowCollection(String userId, String sessionId) {
        ProposedWorkflow workflowDocument = proposedWorkflowDao.get(userId, sessionId);
        if (workflowDocument != null) {
            return workflowDocument.toJson();
        }
        return new ProposedWorkflow(userId, sessionId).toJson();
    }

    public static void saveWorkflowCollection(JSONObject workflowDocument) {
        if (workflowDocument == null) {
            throw new IllegalStateException("Workflow document cannot be empty!");
        }
        if (!(workflowDocument.get("proposed_workflow_parsed") instanceof String)) {
            workflowDocument.put("proposed_workflow_parsed", (Object)workflowDocument.get("proposed_workflow_parsed").toString());
        }
        if (!(workflowDocument.get("designed_form") instanceof String)) {
            workflowDocument.put("designed_form", (Object)workflowDocument.get("designed_form").toString());
        }
        if (!(workflowDocument.get("designed_form_joget_format") instanceof String)) {
            workflowDocument.put("designed_form_joget_format", (Object)workflowDocument.get("designed_form_joget_format").toString());
        }
        ProposedWorkflow workflowDocumentToProposedWorkflow = new ProposedWorkflow();
        workflowDocumentToProposedWorkflow.setAppId(workflowDocument.optString("app_id", null));
        workflowDocumentToProposedWorkflow.setAppName(workflowDocument.optString("app_name", null));
        workflowDocumentToProposedWorkflow.setId(workflowDocument.get("id").toString());
        workflowDocumentToProposedWorkflow.setUserId(workflowDocument.get("user_id").toString());
        workflowDocumentToProposedWorkflow.setSessionId(workflowDocument.get("session_id").toString());
        workflowDocumentToProposedWorkflow.setLlmModelClass(workflowDocument.optString("llmModelClass", null));
        workflowDocumentToProposedWorkflow.setLlmModelName(workflowDocument.optString("llmModelName", null));
        workflowDocumentToProposedWorkflow.setQuery(workflowDocument.optString("query", null));
        JSONArray proposedProcessJSONArray = new JSONArray(workflowDocument.get("proposed_process").toString());
        List<String> proposedProcessList = proposedProcessJSONArray.toList().stream().map(Object::toString).collect(Collectors.toList());
        workflowDocumentToProposedWorkflow.setProposedProcess(proposedProcessList);
        JSONArray formsJSONArray = new JSONArray(workflowDocument.get("forms").toString());
        List<String> formsList = formsJSONArray.toList().stream().map(Object::toString).collect(Collectors.toList());
        workflowDocumentToProposedWorkflow.setForms(formsList);
        JSONArray participantsJSONArray = new JSONArray(workflowDocument.get("participants").toString());
        List<String> participantsList = participantsJSONArray.toList().stream().map(Object::toString).collect(Collectors.toList());
        workflowDocumentToProposedWorkflow.setParticipants(participantsList);
        workflowDocumentToProposedWorkflow.setProposedWorkflow(workflowDocument.get("proposed_workflow").toString());
        workflowDocumentToProposedWorkflow.setProposedWorkflowParsed(workflowDocument.get("proposed_workflow_parsed").toString());
        workflowDocumentToProposedWorkflow.setDesignedForm(workflowDocument.get("designed_form").toString());
        JSONArray transitionProblemsJSONArray = new JSONArray(workflowDocument.get("transition_problems").toString());
        List<String> transitionProblemsList = transitionProblemsJSONArray.toList().stream().map(Object::toString).collect(Collectors.toList());
        workflowDocumentToProposedWorkflow.setTransitionProblems(transitionProblemsList);
        workflowDocumentToProposedWorkflow.setAnalysisStage(workflowDocument.get("analysis_stage").toString());
        workflowDocumentToProposedWorkflow.setProcessXpdl(workflowDocument.get("process_xpdl").toString());
        workflowDocumentToProposedWorkflow.setDesignedFormJogetFormat(workflowDocument.get("designed_form_joget_format").toString());
        workflowDocumentToProposedWorkflow.setCreatedAt(new Date());
        proposedWorkflowDao.save(workflowDocumentToProposedWorkflow);
    }

    public static void datafixDatalists(String listId, AppDefinition appDef) {
        try {
            DatalistDefinition datalist = (DatalistDefinition)datalistDefinitionDao.loadById(listId, appDef);
            if (datalist == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject(datalist.getJson());
            JSONArray columns = jsonObject.getJSONArray("columns");
            for (int i = 0; i < columns.length(); ++i) {
                JSONObject col = columns.getJSONObject(i);
                col.remove("format");
            }
            datalist.setJson(jsonObject.toString());
            datalistDefinitionDao.update((AbstractAppVersionedObject)datalist);
        }
        catch (Exception e) {
            LogUtil.error((String)DbHelper.class.getName(), (Throwable)e, (String)("Error while fixing datalist: " + listId));
        }
    }
}

