/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils.GenerationUtils;

import java.util.Collection;
import java.util.Map;
import org.joget.ai.designer.utils.StringUtils;
import org.joget.ai.designer.utils.WorkflowUtils;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.service.AppUtil;

public class FormGenerationUtils {
    public static String getFormNameByActivity(String activityName, Map<String, Collection<String>> formActivityNamesMap) {
        for (Map.Entry<String, Collection<String>> entry : formActivityNamesMap.entrySet()) {
            if (!entry.getValue().contains(activityName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map<String, Map<String, String>> generateForm(String name, String formId, String tableName, String json, Map<String, Map<String, String>> generated, AppDefinition appDef) {
        FormDefinitionDao dao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
        FormDefinition formDef = new FormDefinition();
        formDef.setAppDefinition(appDef);
        formDef.setId(formId);
        formDef.setName(name);
        formDef.setTableName(tableName);
        formDef.setJson(json);
        dao.add(formDef);
        generated = WorkflowUtils.addGenerated("Form", name, formDef.getId(), generated);
        return generated;
    }

    public static String findFormId(String name, Map<String, Map<String, String>> generated) {
        String entityFormId = StringUtils.nameToId(name);
        Map<String, String> generatedForms = generated.get("Form");
        if (generatedForms != null && !generatedForms.isEmpty() && generatedForms.containsKey(name)) {
            entityFormId = generatedForms.get(name);
        }
        return entityFormId;
    }
}

