/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils.GenerationUtils;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.joget.ai.designer.AiDesigner;
import org.joget.ai.designer.utils.GenerationUtils.FormGenerationUtils;
import org.joget.ai.designer.utils.GenerationUtils.ListGenerationUtils;
import org.joget.ai.designer.utils.GenericUtils;
import org.joget.apps.app.dao.UserviewDefinitionDao;
import org.joget.apps.app.model.AbstractAppVersionedObject;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.UserviewDefinition;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.generator.service.GeneratorUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.property.model.PropertyEditable;
import org.json.JSONArray;
import org.json.JSONObject;

public class UiGenerationUtils {
    public static GenericUtils genericUtils = new GenericUtils(false, "UiGenerationUtils");

    public static void generateUI(AiDesigner plugin, Collection<String> entities, Map<String, Map<String, String>> generated, AppDefinition appDef) {
        String uid = GeneratorUtil.getFirstAvailableUserviewId((AppDefinition)appDef);
        if (uid == null || uid.isEmpty()) {
            uid = "v";
        }
        String name = appDef.getName();
        String desc = "";
        String json = null;
        try {
            Method method = GeneratorUtil.class.getMethod("createNewUserviewJson", String.class, String.class, String.class, AppDefinition.class);
            json = (String)method.invoke(null, uid, name, desc, appDef);
        }
        catch (NoSuchMethodException e) {
            json = GeneratorUtil.createNewUserviewJson((String)uid, (String)name, (String)desc);
        }
        catch (Exception e) {
            // empty catch block
        }
        genericUtils.debug("Create UI Definition: " + name, null);
        try {
            JSONObject userviewObject = new JSONObject(json);
            JSONArray categories = userviewObject.getJSONArray("categories");
            HashSet<String> skip = new HashSet<String>();
            Map<String, String> processes = generated.get("Process");
            if (processes != null && !processes.isEmpty()) {
                for (String entity : processes.keySet()) {
                    if (entity == null) continue;
                    skip.add(entity);
                    String runProcess = generated.get("RunProcess").get(entity);
                    HashMap<String, String> variables = new HashMap<String, String>();
                    variables.put("label", entity);
                    variables.put("formId", FormGenerationUtils.findFormId(runProcess, generated));
                    variables.put("datalistId", ListGenerationUtils.findListId(runProcess, generated));
                    variables.put("processId", processes.get(entity));
                    String cJson = GeneratorUtil.processResourceFile((PropertyEditable)plugin, (String)"/resources/generator/ai/userview_process.json", null, (String)"message/ai/AiDesigner", variables, (String)"javascript");
                    if (cJson.isEmpty()) continue;
                    genericUtils.debug(">>> Adding process menus : " + entity, cJson);
                    JSONObject categoryObject = new JSONObject(cJson);
                    categories.put((Object)categoryObject);
                }
            }
            for (String entity : entities) {
                if (skip.contains(entity)) continue;
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("label", entity);
                variables.put("formId", FormGenerationUtils.findFormId(entity, generated));
                variables.put("datalistId", ListGenerationUtils.findListId(entity, generated));
                String cJson = GeneratorUtil.processResourceFile((PropertyEditable)plugin, (String)"/resources/generator/ai/userview_crud.json", null, (String)"message/ai/AiDesigner", variables, (String)"javascript");
                if (cJson.isEmpty()) continue;
                genericUtils.debug(">>> Adding CRUD menus : " + entity, cJson);
                JSONObject categoryObject = new JSONObject(cJson);
                categories.put((Object)categoryObject);
            }
            json = userviewObject.toString();
        }
        catch (Exception e) {
            LogUtil.error((String)GeneratorUtil.class.getName(), (Throwable)e, (String)"addCategoryJsonToUserviewJson error");
        }
        UserviewDefinitionDao userviewDefinitionDao = (UserviewDefinitionDao)AppUtil.getApplicationContext().getBean("userviewDefinitionDao");
        UserviewDefinition userviewDef = new UserviewDefinition();
        userviewDef.setJson(json);
        userviewDef.setId(uid);
        userviewDef.setName(name);
        userviewDef.setAppDefinition(appDef);
        userviewDefinitionDao.add((AbstractAppVersionedObject)userviewDef);
    }
}

