/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.designer.utils.GenerationUtils;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.joget.ai.designer.utils.Constants;
import org.joget.ai.designer.utils.GenericUtils;
import org.joget.ai.designer.utils.WorkflowUtils;
import org.joget.ai.designer.utils.XpdlHelper;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.PackageDefinition;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.service.CustomFormDataTableUtil;
import org.joget.apps.generator.service.GeneratorUtil;
import org.joget.commons.util.LogUtil;
import org.joget.workflow.model.service.WorkflowManager;
import org.w3c.dom.NodeList;

public class XpdlGenerationUtils {
    private String xml = null;
    private AppDefinition appDef = null;
    private String xpdl = null;
    public static GenericUtils genericUtils = new GenericUtils(false, "XpdlGenerationUtils");

    public XpdlGenerationUtils(String xml, AppDefinition appDef) {
        this.xml = xml;
        this.appDef = appDef;
    }

    public String getClassName() {
        return "XpdlGenerationUtils";
    }

    public void deployProcesses(Map<String, Map<String, String>> generated) throws Exception {
        Map<String, String> map;
        Map<String, String> pe;
        if (this.xpdl == null || this.xpdl.isEmpty()) {
            return;
        }
        genericUtils.debug("Deploy Processes: ", this.xpdl);
        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
        PackageDefinition packageDef = appService.deployWorkflowPackage(this.appDef.getId(), this.appDef.getVersion().toString(), this.xpdl.getBytes(StandardCharsets.UTF_8), false);
        Map<String, String> routes = generated.get("Route");
        if (routes != null && !routes.isEmpty()) {
            for (String string : routes.keySet()) {
                String[] temp = string.split("::");
                genericUtils.debug(">>> Add route mapping for " + temp[0] + " - " + temp[1] + " to RulesDecisionPlugin. ", routes.get(string));
                GeneratorUtil.addToolMapping((AppDefinition)this.appDef, (PackageDefinition)packageDef, (String)temp[0], (String)temp[1], (String)"org.joget.apps.app.lib.RulesDecisionPlugin", (String)routes.get(string));
            }
        }
        if ((pe = generated.get("Process Enhancement")) != null && !pe.isEmpty()) {
            for (String key : pe.keySet()) {
                String[] temp = key.split("::");
                genericUtils.debug(">>> Add process enhancement mapping for " + temp[0] + " - " + temp[1] + " to AssignmentFormActions. ", pe.get(key));
                GeneratorUtil.addToolMapping((AppDefinition)this.appDef, (PackageDefinition)packageDef, (String)temp[0], (String)temp[1], (String)"org.joget.process.AssignmentFormActions", (String)pe.get(key));
            }
        }
        if ((map = generated.get("Process Form")) != null && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String[] temp = key.split("::");
                genericUtils.debug(">>> Add form mapping for " + temp[0] + " - " + temp[1] + " to " + map.get(key), null);
                GeneratorUtil.addFormMapping((AppDefinition)this.appDef, (PackageDefinition)packageDef, (String)temp[0], (String)temp[1], (String)map.get(key));
            }
        }
        genericUtils.debug(">>> Create table for process enhancement data : " + this.appDef.getAppId() + "_pd", null);
        CustomFormDataTableUtil.createTable((AppDefinition)this.appDef, (String)(this.appDef.getAppId() + "_pd"), (String[])Constants.PROCESS_DATA_COLUMN);
    }

    public Map<String, Map<String, String>> generateProcess(String runProcessFormName, String processId, Map<String, Map<String, String>> generated, NodeList transitionList, NodeList activityList, Map<String, Collection<String>> formActivityNamesMap) {
        generated = XpdlHelper.prepareMappings(processId, runProcessFormName, generated, transitionList, activityList, formActivityNamesMap);
        String xmlWorkflowProcess = this.xml.replaceAll(".*(<WorkflowProcess[\\s\\S]*?</WorkflowProcess>).*", "$1");
        String xmlParticipants = this.xml.replaceAll(".*(<Participants[\\s\\S]*?</Participants>).*", "$1");
        try {
            if (this.xpdl == null) {
                PackageDefinition packageDef = this.appDef.getPackageDefinition();
                if (packageDef != null) {
                    WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
                    byte[] content = workflowManager.getPackageContent(packageDef.getId(), packageDef.getVersion().toString());
                    this.xpdl = new String(content, StandardCharsets.UTF_8);
                }
                if (this.xpdl == null || this.xpdl.isEmpty()) {
                    this.xpdl = GeneratorUtil.createProcessPackageXpdl((AppDefinition)this.appDef);
                }
            }
            this.xpdl = GeneratorUtil.addParticipantsAndProcessXmlToXpdl((String)xmlParticipants, (String)xmlWorkflowProcess, (String)this.xpdl);
            generated = WorkflowUtils.addGenerated("Process", runProcessFormName, processId, generated);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return generated;
    }
}

