var addFormDesignQuery = "";
var lastAddFormDesignIsFile = false;

// Calls /add_form_design API
async function addFormDesign() {
    if(lastAddFormDesignIsFile){
        isFileUploaded = true;
    }

    var imageBase64ListRaw = imageBase64List.map(imageBase64 => imageBase64.split("base64,")[1]);

    const formData = new FormData();
    formData.append('_a', 'add_forms_design');
    formData.append('stage_name', "add_forms_design");
    formData.append('user_id', userId);
    formData.append('session_id', sessionId);
    formData.append('query', isFileUploaded ? "" : addFormDesignQuery);
    formData.append('image_base_64_list', isFileUploaded ? JSON.stringify(imageBase64ListRaw) : JSON.stringify([]));
    formData.append('_awsModels', JSON.stringify(awsModels));

    try {
        if(!formData.get("query") && formData.get("image_base_64_list") !== "[]"){
            lastAddFormDesignIsFile = true;
        }else{
            lastAddFormDesignIsFile = false;
        }
        const request = $.ajax({
            type: "POST",
            data: formData,
            processData: false, // Prevent jQuery from converting FormData to string
            contentType: false, // Let browser set appropriate headers for FormData
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            dataType: "json"
        });
        ajaxRequestObjectList.push(request);
        const response = await request;
        if(discontinueApiCalls){
            return;
        }
        // If API call involved file upload, reset the flag
        if(isFileUploaded){
            isFileUploaded = false;
        }
        if (response.status) {
            const designed_form_joget_format = response.joget_designed_forms;
            // Helper to check empty responses
            const isEmptyResponse = (condition) => {
                if (condition) {
                    return true;
                }
            };
            let formattedResult = isEmptyResponse(Object.keys(designed_form_joget_format).length == 0) ? "" : designed_form_joget_format;
            return new Map([
                ['result', formattedResult],
                ['status', true]
            ]);
        } else {
            return new Map([
                ['result', response.message],
                ['status', false]
            ]);
        }
    } catch (error) {
        console.error("AJAX request failed:", error);
        return new Map([
            ['result', error.responseJSON?.message || "@@aiag.error@@"],
            ['status', false]
        ]);
    }
}

// Click event for the send button after the user describes the app's process
$(document).on('click', '.gen-ai-section:not(.template) .action-button.input.add-form-design.send', function () {
    // If not an empty value
    if($(".gen-ai-section:not(.template) .input-box").val().trim() != "" || isFileUploaded){
        lastAddFormDesignIsFile = false;
        hidePreviewSection();
        $(".chat-output").find(".box").removeClass("selected");
        scrollChatScrollViewDown()
        setInputBoxHalfHeight();
        currentStage = "add_forms_design";
        addFormDesignQuery = $(".gen-ai-section:not(.template) .input-box").val();
        $(".gen-ai-section:not(.template) .input-box").val("");
        discontinueApiCalls = false;
        createChat(false);
    }
});

// Click event for the "Add Form" button
$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.add-form-design', function () {
    scrollChatScrollViewDown();
    $(".gen-ai-section:not(.template) .conversation-section .help-section").addClass("hide");
    $(".gen-ai-section:not(.template) .conversation-section .help-section").css("opacity", "0");
    $(".gen-ai-section:not(.template) .input-section .uploaded-file-box").html("").addClass("hide");
    $(".gen-ai-section:not(.template) .action-button.input.file-upload").removeClass("hide"); // Hides the file upload action button while correction
    $(".gen-ai-section:not(.template) .action-button.input").each(function() {
        if (!$(this).hasClass("cancel") && !$(this).hasClass("add-form-design")) {
            $(this)
                .removeClass("query correction replace-form-design")
                .addClass("add-form-design");
        }
    });
    $(".gen-ai-section:not(.template) .input-box").attr("placeholder", "@@aiag.addFormDesignPlaceholder@@").removeClass("query correction replace-form-design").addClass("add-form-design"); // Changes the placeholder message and text color to purple
    setInputBoxFullHeight();
    $(".gen-ai-section:not(.template) .input-section .action-buttons-container .dropdown-enhancement").addClass("hide");
    $(".gen-ai-section:not(.template) .input-section .action-buttons-container .action-button.input.send").addClass("add-form-design").removeClass("correction query");
});