
var newAiServiceFormFields = {};
    
var awsModels = {};

var availableModels = {};

var configurationSection = $(".template.config-section").clone();
$(configurationSection).removeClass("template hide");

$(".template.joget-ai-designer").append(configurationSection);


// Click event for the "Configure" button in the Current AI Service section
$(document).on('click', '.configure.button', function () {
    clearNewAiServiceSectionFormFields();
    // Hides the Current AI Service section
    $(".config-section:not(.template) .current-ai-service-config-section").addClass("hide");
    // Shows the section that contains New AI Service and My AI Services sections
    $(".config-section:not(.template) .more-ai-service-config-section").removeClass("hide");
    $(".config-section:not(.template) .switch-container .switch.new-ai-service").click();
});

// Click event for the back button.
$(document).on('click', '.config-section:not(.template) .back-button', function () {
    // If it's for going back to the Current AI Service section
    if($(this).hasClass("go-to-current-ai-service-section")){
        // Shows the Current AI Service section
        $(".config-section:not(.template) .current-ai-service-config-section").removeClass("hide");
        // Hides the section that contains New AI Service and My AI Services sections
        $(".config-section:not(.template) .more-ai-service-config-section").addClass("hide");
    }
    // If it's for going back to My AI Services section
    else if($(this).hasClass("go-to-my-ai-services-list")){
        // Shows the My AI Services section
        $(".config-section:not(.template) .my-ai-services-list").removeClass("hide");
        // Hides the Edit AI Service section
        $(".config-section:not(.template) .edit-my-ai-service-section").addClass("hide");
    }
});

// Click event for the "Save" button in the Current AI Service section
$(document).on('click', '.config-section:not(.template) .current-ai-service-config-section .config-submit-button', function () {
    var currentAiService = $(".config-section:not(.template) #current-ai-service option:selected").text();
    // If no AI Service is selected
    if(!currentAiService){
        showMessageInConfigStatus("@@aiag.service.notSelected@@", true);
    }else{
        saveCurrentAiService(true);
    }
});

// Click event for the "Save" button in the API Server configuration section
$(document).on('click', '.config-section:not(.template) .api-server-config-section .config-submit-button', async function () {
    var apiServerUrl = $(".config-section:not(.template) #api-server-url").val().trim();
    var apiServerKey = $(".config-section:not(.template) #api-server-key").val().trim();
    // If the API Server URL or API Server Key is an empty value
    if(!apiServerUrl || !apiServerKey){
        showMessageInConfigStatus("@@aiag.empty@@", true);
    }else{
        // Validate and correct the URL
        showLoadingInConfigStatus();
        var correctedApiServerUrl = await validateApiServerUrl(apiServerUrl);
        if(correctedApiServerUrl){
            if (apiServerKey !== apiServerConfigString.properties.apiServerKey) {
                var correctedApiServerKey = await validateApiServerKey(correctedApiServerUrl, apiServerKey);
                if(correctedApiServerKey){
                    $(".config-section:not(.template) .api-server-config-section #api-server-url").val(correctedApiServerUrl);
                    $(".config-section:not(.template) .api-server-config-section #api-server-key").val(correctedApiServerKey);
                    saveApiServerConfig(correctedApiServerUrl, correctedApiServerKey);
                }else{
                    // Sets input value to previous correct Server Url after error message is displayed
                    setTimeout(function(){
                        $(".config-section:not(.template) .api-server-config-section #api-server-key").val(apiServerConfigString.properties.apiServerKey);
                    },1000);
                    showMessageInConfigStatus("@@aiag.invalidKey@@", true);
                }
            } else {
                $(".config-section:not(.template) .api-server-config-section #api-server-url").val(correctedApiServerUrl);
                $(".config-section:not(.template) .api-server-config-section #api-server-key").val(apiServerKey);
                saveApiServerConfig(correctedApiServerUrl, apiServerKey);
            }
        }else{
            // Sets input value to previous correct Server Url after error message is displayed
            setTimeout(function(){
                $(".config-section:not(.template) .api-server-config-section #api-server-url").val(apiServerConfigString.properties.apiServerUrl);
            },1000);
            showMessageInConfigStatus("@@aiag.invalidUrl@@", true);
        }
    }
});


// Click event for the "Create" button in the New AI Service section
$(document).on('click', '.config-section:not(.template) .new-ai-service-section .config-submit-button', function () {
    var validationErrors = []; // Stores a list of validation error messages raised by form fields
    // Scans the form fields in the New AI Service section, stores each field name along with its value
    var createNewAiServiceData = {};
    $('.config-section:not(.template) .new-ai-service-section').find('input[type="text"], input[type="password"], select').each(function() {
        var inputName = $(this).attr('name');
        var inputValue = $(this).val();
        createNewAiServiceData[inputName] = inputValue;
    });
    // Filters and stores all the form fields that is returned by the /new_ai_service_form_fields API
    var allFields = [];
    newAiServiceFormFields.fields.forEach(field => {
        // If the form field type is "text", "password" or "select" then it will store it normally
        if(!field.hasOwnProperty("children")){
            allFields.push(field);
        }
        // If the form field type is "container" then it will go through its children and store each of them
        else{
            field.children.forEach(child => {
                allFields.push(child);
            });
        }
    });
    // Loops through user entered data (form field name and its value)
    $.each(createNewAiServiceData, function(key, value) {
        // Loops through the each form field
        allFields.forEach(field => {
            // When the key from the user entered data matches with the form field name
            if(key == field.name){
                // If the form field can handle validation and it's not empty
                if(field.hasOwnProperty("validation") && field.validation != ""){
                    // Gets the Regex
                    var regex = new RegExp(field.validation);
                    // Validates the value
                    if(regex.test(value)){
                        var atleastOneScenarioIsTrue = false;
                        // In the JSON, "activateValidationScenarios" attribute means one or more scenarios of when the validation will work
                        field.activateValidationScenarios.forEach(scenario => {
                            var shownList = []
                            // Checks the scenario on what are the form fields that needs be shown
                            scenario.shown.forEach(shownDiv => {
                                if ($(`#${shownDiv}`).is("div")) {
                                    shownList.push(!$(`#${shownDiv}`).hasClass("hide"));
                                } else {
                                    shownList.push(!$(`#${shownDiv}`).closest(".field-row").hasClass("hide"));
                                }
                            });
                            var hiddenList = []
                            // Checks the scenario on what are the form fields that needs be hidden
                            scenario.hidden.forEach(hiddenDiv => {
                                if ($(`#${hiddenDiv}`).is("div")) {
                                    hiddenList.push($(`#${hiddenDiv}`).hasClass("hide"));
                                } else {
                                    hiddenList.push($(`#${hiddenDiv}`).closest(".field-row").hasClass("hide"));
                                }
                            });
                            // If the shownList and hiddenList contains all "true", that means the scenario is real
                            if (shownList.every(value => value == true) && hiddenList.every(value => value == true)) {
                                atleastOneScenarioIsTrue = true;
                            }
                        });
                        if(atleastOneScenarioIsTrue){
                            validationErrors.push(field.validationMessage);
                        }
                    }
                }
            }
        });
    });
    // If there is not validation errors then proceeds with creating the new AI Service
    if(validationErrors.length == 0){
        createNewAiService(createNewAiServiceData);
    }
    // Else shows the first validation error message from the list
    else{
        showMessageInConfigStatus(validationErrors[0], true);
    }
});


// Changes the current AI Service used by the user to be the selected option in the <select>
function setCurrentAiService(){
    $(".config-section:not(.template) #current-ai-service").val(currentAiServiceString.properties.aiService).trigger("change");
    $(".genaiview-ai-service").val(currentAiServiceString.properties.aiService);
}

// Saves the currently selected AI Service
function saveCurrentAiService(showMessage){
    var currentAiService = $(".config-section:not(.template) #current-ai-service option:selected").text();
    var modelName = "";
    var modelClass = "";
    for(var i=0; i<myAiServicesString.properties.myAiServices.length;i++){
        var myAiService = myAiServicesString.properties.myAiServices[i];
        if(myAiService.aiServiceName === currentAiService){
            modelClass = myAiService.modelClass;
            modelName = modelClass === "@@aiag.optionCustom@@" ? myAiService.customModelName : myAiService.modelName; 
            break;
        }
    }
    if(showMessage){
        showLoadingInConfigStatus();
    }
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'saveCurrentAiService',
            '_currentAiService' : currentAiService,
            '_modelClass' : modelClass,
            '_modelName' : modelName
        },
        dataType: "json",
        success: function (response) {
            currentAiServiceString = response.currentAiService;
            // Dynamically update the placeholder with the new modelName
            $(".gen-ai-section:not(.template) .input-box.query").attr("placeholder", `@@aiag.processProposalPlaceholder@@`);               
            setCurrentAiService();
            // $(".genaiview-ai-service").val(currentAiService);
            $(".action-button.gen-ai").removeClass("disable"); // Makes the button that shows the GenAI view to become clickable
            if(showMessage){
                showMessageInConfigStatus("@@aiag.saved@@", false);
            }
        }
    });
}



// Saves the API Server configuration
function saveApiServerConfig(apiServerUrl, apiServerKey){
    showLoadingInConfigStatus();
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'saveApiServerConfig',
            '_apiServerUrl' : apiServerUrl,
            '_apiServerKey' : apiServerKey,
        },
        dataType: "json",
        success: function (response) {
            showMessageInConfigStatus("@@aiag.saved@@", false);
            // After saving, make the tab button that leads to AI Service configuration to be clickable
            $(".config-section:not(.template) .tab-button.ai-service-config").removeClass("disable");
            retrieveNewAiServiceFormFields();
            apiServerConfigString = response.apiServerConfig;
            apiServerConfigString.properties.apiServerKey = apiServerConfigString.properties.apiServerKey;
            // If user already selected an AI Service to be used
            if($('.config-section:not(.template) #current-ai-service').val() != null){
                $(".action-button.gen-ai").removeClass("disable"); // Makes the button that shows the GenAI view to become clickable
            }
        }
    });
}

// Creates an AI Service
function createNewAiService(createNewAiServiceData){
    showLoadingInConfigStatus();
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'createNewAiService',
            '_createNewAiServiceData': JSON.stringify(createNewAiServiceData)
        },
        dataType: "json",
        success: function (response) {
            if(response.success){
                myAiServicesString = response.myAiServices;
                refreshMyAiServices();
                showMessageInConfigStatus("@@aiag.service.created@@", false);
            }
            // If success is false then it means an AI Service with the same name already exists
            else{
                showMessageInConfigStatus("@@aiag.service.exist@@", true);
            }
        }
    });
}

// Revokes an AI Service
function revokeMyAiService(myAiServiceName){
    showLoadingInConfigStatus(); 
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'revokeMyAiService',
            '_myAiServiceName': myAiServiceName
        },
        dataType: "json",
        success: function (response) {
            myAiServicesString = response.myAiServices;
            refreshMyAiServices();
            showMessageInConfigStatus(`"${myAiServiceName}" @@aiag.service.revoked@@`, false);
            // After the user revokes all of their created AI Services
            if(myAiServicesString.properties.myAiServices.length == 0 || currentAiServiceString.properties.aiService == myAiServiceName){
                currentAiServiceString.properties.aiService = ""; // Sets current AI Service as none
                $('.config-section:not(.template) #current-ai-service').val("") // Clears the <select> for choosing an AI Service
                $(".action-button.gen-ai").addClass("disable"); // Makes the button that shows the GenAI view to become unclickable
            }
        }
    });
}

// Shows loading after user makes changes like create, save, edit or revoke in a configuration 
function showLoadingInConfigStatus(){
    var configStatus = $(".config-section:not(.template) > .config-status");
    // Clears and hides the status message
    configStatus.find(".text").text("");
    configStatus.find(".text").addClass("hide");
    configStatus.find(".loader").removeClass("hide"); // Shows the loading
}

// Shows message after user makes changes like create, save, edit or revoke in a configuration 
function showMessageInConfigStatus(message, isError){
    var configStatus = $(".config-section:not(.template) > .config-status");
    configStatus.find(".loader").addClass("hide"); // Hides the loading 
    // Sets the message
    configStatus.find(".text").removeClass("hide");
    configStatus.find(".text").text(message);
    // If message is supposed to be an error then the text will be in red color
    if(isError){
        configStatus.find(".text").addClass("error");
    }
    // After 2 seconds, hides the message
    setTimeout(() => {
        configStatus.find(".text").text("");
        configStatus.find(".text").removeClass("error");
        configStatus.find(".text").addClass("hide");
    }, 1000);
}

//
//
//

function refreshMyPiiMaskingRules() {
    $(".config-section:not(.template) .pii-masking-rules-config-section .my-pii-masking-rules-section .my-pii-masking-rules-list").empty();
    myPiiMaskingRulesConfigString.properties.myPiiMaskingRules.forEach(myPiiMaskingRule => {
        var item = $(".template.my-pii-masking-rules-list-item").clone();
        $(item).removeClass("template hide");
        $(item).find(".name").prepend(myPiiMaskingRule);
        $(item).find(".revoke").attr("my-pii-masking-rule", myPiiMaskingRule);
        $(".config-section:not(.template) .pii-masking-rules-config-section .my-pii-masking-rules-list").append(item);
    });
}

$(document).on('click', '.add-pii-masking-rule.button', function () {
    var newPiiToken = $(".config-section:not(.template) .pii-masking-rules-config-section #pii-masking-rule").val().trim();
    if(newPiiToken){
        if(myPiiMaskingRulesConfigString.properties.myPiiMaskingRules.includes(newPiiToken)){
            showMessageInConfigStatus("@@aiag.myPiiMaskingRules.ruleAlreadyExists@@", true);
        }else{
            myPiiMaskingRulesConfigString.properties.myPiiMaskingRules.push(newPiiToken);
            updateMyPiiMaskingRules(false, "");
            refreshMyPiiMaskingRules();
            $(".config-section:not(.template) .pii-masking-rules-config-section #pii-masking-rule").val("");
        }
    }
});

$(document).on('click', '.my-pii-masking-rules-list-item .revoke', function() {
    var piiToken = $(this).attr("my-pii-masking-rule");
    revokemyPiiMaskingRule(piiToken);
});

function revokemyPiiMaskingRule(piiToken) {
    showLoadingInConfigStatus();
    myPiiMaskingRulesConfigString.properties.myPiiMaskingRules = myPiiMaskingRulesConfigString.properties.myPiiMaskingRules.filter(token => token !== piiToken);
    updateMyPiiMaskingRules(true, piiToken);
    refreshMyPiiMaskingRules();
}

// Saves the API Server configuration
function updateMyPiiMaskingRules(isRevoke, piiToken){
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'updateMyPiiMaskingRules',
            'newMyPiiMaskingRulesConfig' : JSON.stringify(myPiiMaskingRulesConfigString),
        },
        dataType: "json",
        success: function (response) {
            if(isRevoke){
                showMessageInConfigStatus(`"${piiToken}" @@aiag.service.revoked@@`, false);
            }
        }
    });
}

//
//
//
    
// Gets all AI Services created by the user, displays it as list, updates the <select> for choosing an AI Service 
function refreshMyAiServices() {
    $(".config-section:not(.template) #current-ai-service, .genaiview-ai-service").empty(); // Clears the <select> for choosing an AI Service
    $(".config-section:not(.template) .more-ai-service-config-section .my-ai-services-section .my-ai-services-list").empty(); // Clears the list
    myAiServicesString.properties.myAiServices.forEach(myAiService => {
        // For each AI Service, appends the option in the <select>
        var option = $("<option></option>").text(myAiService.aiServiceName).val(myAiService.aiServiceName);
        $(".config-section:not(.template) #current-ai-service, .genaiview-ai-service").append(option);
        // Clones the template list item
        var myAiServiceListItem = $(".template.my-ai-service-list-item").clone();
        $(myAiServiceListItem).removeClass("template hide");
        // Plugs the necessary information about the AI Service
        $(myAiServiceListItem).find(".model-class").html(`<span style='font-weight:bold'>@@aiag.fieldModelClass@@:</span> ${myAiService.modelClass}`);
        $(myAiServiceListItem).find(".model-name").html(`<span style='font-weight:bold'>@@aiag.fieldModelName@@:</span> ${myAiService.modelClass == "@@aiag.optionCustom@@" ? myAiService.customModelName : myAiService.modelName}`);
        $(myAiServiceListItem).find(".name").prepend(myAiService.aiServiceName);
        $(myAiServiceListItem).find(".revoke").attr("my-ai-service-name", myAiService.aiServiceName);
        $(myAiServiceListItem).find(".edit").attr("my-ai-service-name", myAiService.aiServiceName);
        // Appends the list item to the list
        $(".config-section:not(.template) .my-ai-services-section .my-ai-services-list").append(myAiServiceListItem);
    });
}

// Sets the current API Server configuration
function setCurrentApiServerConfig() {
    apiServerConfigString.properties.apiServerKey = apiServerConfigString.properties.apiServerKey;
    $(".config-section:not(.template) .api-server-config-section #api-server-url").val(apiServerConfigString.properties.apiServerUrl);
    $(".config-section:not(.template) .api-server-config-section #api-server-key").val(apiServerConfigString.properties.apiServerKey);
}

// Clears the value of form fields inside New AI Service section, but does nothing for <select> elements
function clearNewAiServiceSectionFormFields(){
    $('.config-section:not(.template) .new-ai-service-section').find('input[type="text"], input[type="password"]').each(function() {
        var inputId = $(this).attr('id');
        $(`#${inputId}`).val("");   
    });
}


// Calls an API that will return the form fields to be put inside New AI Service section. Available models information are also included in it.
// Then, it will parse the response JSON and create each form field inside New AI Service section
function retrieveNewAiServiceFormFields() {
    // Empty the New AI Service section
    $(".config-section:not(.template) .new-ai-service-section").empty();
    // Gets the response JSON
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'retrieveNewAiServiceFormFields',
        },
        dataType: "json",
        success: function (response) {
            newAiServiceFormFields = response.data;
            // Stores AWS Models
            awsModels = newAiServiceFormFields.awsModels;
            // Stores the available models information
            newAiServiceFormFields.fields.forEach(field => {
                if(field.id == "model-name"){
                    availableModels = field.options;
                }
            });
            // Loops through each form field
            newAiServiceFormFields.fields.forEach(field => {
                // If form field type is "text" or "password"
                if(field.type == "text" || field.type == "password"){
                    // Clones the template form field
                    var fieldRow = $(".template.field-row").clone();
                    fieldRow.removeClass("template hide");
                    // Creates a <input> element and plugs necessary attributes to it
                    var input = $('<input>').attr({
                        autocomplete: 
                            field.type === "number" 
                                ? "new-number" 
                                : field.type === "password" 
                                    ? "new-password" 
                                    : field.type === "text" 
                                        ? "new-text" 
                                        : "",
                        id: field.id,
                        name: field.name,
                        type: field.type,
                        placeholder: field.placeholder,
                        class: "input",
                    });
                    // Puts the label for the form field
                    $(fieldRow).find(".name").text(field.label);
                    // Puts the <input> inside the appropriate container
                    $(fieldRow).find(".input-with-button-container").append(input);
                    // If the default visibility of the form field is to be hidden than hides the form field
                    if(field.hidden == true){
                        $(fieldRow).addClass("hide");
                    }
                    // Appends the form field inside New AI Service section
                    $(".config-section:not(.template) .new-ai-service-section").append(fieldRow);
                }
                // If form field type is a "select"
                else if(field.type == "select"){
                    // Clones the template form field
                    var fieldRow = $(".template.field-row").clone();
                    fieldRow.removeClass("template hide");
                    // Creates a <select> element and plugs necessary attributes to it
                    var select = $('<select>').attr({
                        id: field.id,
                        name: field.name,
                        class: "input",
                    }); 
                    // Loops through the options for the <select> and appends inside it
                    if(Array.isArray(field.options)) {
                        field.options.forEach(option => {
                            select.append($('<option>').attr('value', option).text(option));
                        });
                    }
                    // If the form field contains triggers such as change, click, mousehover etc., then creates event for each of the trigger
                    if(field.triggers.length > 0){
                        // Loops through the each trigger
                        field.triggers.forEach(trigger => {
                            // If the trigger is "change", this is usually for <select>
                            if(trigger == "change"){
                                // Creates an event
                                $(document).on('change', `#${field.id}`, function() {
                                    // << START >> Handling cascading options for <select>
                                    // Gets the selected option of the <select>. For now, this is the Model Class form field. It is only one that has "change" trigger currently
                                    var selectedOption = $(`#${field.id}`).val();
                                    // If the <select> is a parent that controls the options that is shown in another <select>, a child
                                    if(field.cascadesTo != ""){
                                        var childSelectBoxOptions;
                                        // Loops through the form fields to find the child <select>
                                        newAiServiceFormFields.fields.forEach(field2 => {
                                            if(field2.id == field.cascadesTo){
                                                childSelectBoxOptions = field2.options; // Gets all the possible options list
                                            }
                                        });
                                        // Loops through the possible options list
                                        $.each(childSelectBoxOptions, function(key, value) {
                                            // If the key (e.g. OpenAI, Meta) matches the selected option in the parent <select> which is Model Class
                                            if(key == selectedOption){
                                                // Empty the options inside the child <select>
                                                $(`#${field.cascadesTo}`).empty();
                                                // Appends new options (e.g. gpt-4o, gpt-3.5-turbo) based on the selected option in the parent <select> 
                                                value.forEach(option => {
                                                    $(`#${field.cascadesTo}`).append($('<option>').attr('value', option).text(option));
                                                });
                                            }
                                        });
                                    }
                                    // << END >> Handling cascading options for <select>
                                    // << START >> Handling visibility of other form fields or container according to the selected option
                                    var ifValues = []; // Stores each <select> option that is also inside the "If" array in the JSON
                                    field.visibilityDecisions.if.forEach(decision => {
                                        ifValues.push(decision.value);
                                        // If the selected option is inside the "If" array in the JSON
                                        if(decision.value == selectedOption){
                                            // Go through the fields or containers that needs to be hidden and hide them
                                            decision.hide.forEach(toHide => {
                                                // If it is a <div>, then it's a container 
                                                if($(`#${toHide}`).is("div")){
                                                    $(`#${toHide}`).addClass("hide");
                                                }
                                                else if($(`#${toHide}`).is("input[type='text'], input[type='password'], select")){
                                                    $(`#${toHide}`).closest(".field-row").addClass("hide");
                                                }
                                            }); 
                                            // Go through the fields or containers that needs to be shown and show them
                                            decision.show.forEach(toShow => {
                                                // If it is a <div>, then it's a container 
                                                if($(`#${toShow}`).is("div")){
                                                    $(`#${toShow}`).removeClass("hide");
                                                }else if($(`#${toShow}`).is("input[type='text'], input[type='password'], select")){
                                                    $(`#${toShow}`).closest(".field-row").removeClass("hide");
                                                }
                                            });
                                        }
                                    });
                                    // If the selected option is not inside the "If" array in the JSON
                                    if(!ifValues.includes(selectedOption)){
                                        // Go through the fields or containers that needs to be hidden and hide them
                                        field.visibilityDecisions.else.hide.forEach(toHide => {
                                            // If it is a <div>, then it's a container 
                                            if($(`#${toHide}`).is("div")){
                                                $(`#${toHide}`).addClass("hide");
                                            }else if($(`#${toHide}`).is("input[type='text'], input[type='password'], select")){
                                                $(`#${toHide}`).closest(".field-row").addClass("hide");
                                            }
                                        });
                                        // Go through the fields or containers that needs to be shown and show them
                                        field.visibilityDecisions.else.show.forEach(toShow => {
                                            // If it is a <div>, then it's a container 
                                            if($(`#${toShow}`).is("div")){
                                                $(`#${toShow}`).removeClass("hide");
                                            }else if($(`#${toShow}`).is("input[type='text'], input[type='password'], select")){
                                                $(`#${toShow}`).closest(".field-row").removeClass("hide");
                                            }
                                        });
                                    }
                                    // << END >> Handling visibility of other form fields or container according to the selected option
                                });
                            }
                        });
                    }
                    // Puts the label for the form field
                    $(fieldRow).find(".name").text(field.label);
                    // Puts the <select> inside the appropriate container
                    $(fieldRow).find(".input-with-button-container").append(select);
                    // If the default visibility of the form field is to be hidden than hides the form field
                    if(field.hidden == true){
                        $(fieldRow).addClass("hide");
                    }
                    // Appends the form field inside New AI Service section
                    $(".config-section:not(.template) .new-ai-service-section").append(fieldRow);
                }
                // If form field type is a "container", meaning it's a group of form fields put together
                else if(field.type == "container"){
                    // Creates a <div> and plugs the necessary attributes to it
                    var containerField = $("<div>").attr({
                        id: field.id,
                        class: "container-field",
                    });
                    // Loops through each form fields inside the container
                    field.children.forEach(child => {
                        // Clones the template form field
                        var fieldRow = $(".template.field-row").clone();
                        fieldRow.removeClass("template hide");
                        // If form field type is "text" or "password"
                        if(child.type == "text" || child.type == "password"){
                            // Creates a <input> element and plugs necessary attributes to it
                            var input = $('<input>').attr({
                                autocomplete: 
                                    field.type === "number" 
                                        ? "new-number" 
                                        : field.type === "password" 
                                            ? "new-password" 
                                            : field.type === "text" 
                                                ? "new-text" 
                                                : "",
                                id: child.id,
                                name: child.name,
                                type: child.type,
                                placeholder: child.placeholder,
                                class: "input",
                            });
                            // Puts the label for the form field
                            $(fieldRow).find(".name").text(child.label);
                            // Puts the <input> inside the appropriate container
                            $(fieldRow).find(".input-with-button-container").append(input);
                            // Appends the form field inside the <div> that was created earlier
                            $(containerField).append(fieldRow);
                        }
                    });
                    // If the default visibility of the Container is to be hidden than hides the form field
                    if(field.hidden == true){
                        $(containerField).addClass("hide");
                    }
                    // Appends the Container to the form section for creating new AI service
                    $(".config-section:not(.template) .new-ai-service-section").append(containerField);
                }
            });
            // Clones the template configuration submit section
            var configSubmitSection = $(".template.config-submit-section").clone();
            configSubmitSection.removeClass("template hide");
            // Gives a name for the submit button
            $(configSubmitSection).find(".config-submit-button").text("@@aiag.create@@");
            // Appends the configuration submit section inside New AI Service section
            $(".config-section:not(.template) .new-ai-service-section").append(configSubmitSection);
            // Programmatically selects the first option in Model Class
            $(".config-section:not(.template) .new-ai-service-section #model-class").val(Object.keys(availableModels)[0]).trigger("change");
        }
    });
}


function editMyAiService(modelClass, myAiServiceName, editMyAiServiceData){
    showLoadingInConfigStatus(); 
    $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'editMyAiService',
            '_modelClass' : modelClass,
            '_myAiServiceName' : myAiServiceName,
            '_editMyAiServiceData': JSON.stringify(editMyAiServiceData)
        },
        dataType: "json",
        success: function (response) {
            myAiServicesString = response.myAiServices;
            refreshMyAiServices();
            showMessageInConfigStatus(`"${myAiServiceName}" @@aiag.service.updated@@`, false);
        }
    });
}

async function validateApiServerUrl(apiServerUrl) {
    apiServerUrl = apiServerUrl.replace(/\/+$/, '').replace(/^(?!https?:\/\/)/, 'http://');
    const request = $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'validateApiServerUrl',
            '_apiServerUrl' : apiServerUrl,
        },
        dataType: "json",
    });
    const response = await request;
    if(response){
        return apiServerUrl;
    }else{
        return "";
    }
}

async function validateApiServerKey(apiServerUrl, apiServerKey) {
    const request = $.ajax({
        type: "POST",
        url: UI.base + `/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
        data: {
            '_a' : 'validateApiServerKey',
            '_apiServerUrl' : apiServerUrl,
            '_apiServerKey' : apiServerKey,
        },
        dataType: "json",
    });
    const response = await request;
    if(response){
        return apiServerKey;
    }else{
        return "";
    }
}

// Click event for the tab buttons in Configuration view. Currently, there are two tabs (API Server and AI Service)
$(document).on('click', '.tab-button', function() {
    // If the tab button is not made to be unclickable
    if(!$(this).hasClass("disable")){
        $(".tab-button").removeClass("selected"); // Removes the "selected" class from all the tab buttons because the UI for the selected tab button will be different from the unselected
        // If the tab button is for the API Server configuration
        if($(this).hasClass("api-server-config")){
            $(this).addClass("selected");
            $(".config-section:not(.template) .pii-masking-rules-config-section").addClass("hide");
            // Hides the AI Service configuration section
            $(".config-section:not(.template) .current-ai-service-config-section").addClass("hide");
            $(".config-section:not(.template) .more-ai-service-config-section").addClass("hide");
            // Shows the API Server configuration section
            $(".config-section:not(.template) .api-server-config-section").removeClass("hide");
        }
        // If the tab button is for the AI Service configuration
        else if($(this).hasClass("ai-service-config")){
            setCurrentAiService();
            clearNewAiServiceSectionFormFields();
            $(this).addClass("selected");
            $(".config-section:not(.template) .pii-masking-rules-config-section").addClass("hide");
            // Hides the API Server configuration section
            $(".config-section:not(.template) .api-server-config-section").addClass("hide");
            // Shows the Current AI Service section
            $(".config-section:not(.template) .current-ai-service-config-section").removeClass("hide");
            // Hides the New AI Service and My AI Services sections because it's only shown after the user clicks on "Configure" button
            $(".config-section:not(.template) .more-ai-service-config-section").addClass("hide");
        }        // If the tab button is for the AI Service configuration
        else if($(this).hasClass("pii-masking-rules-config")){
            $(this).addClass("selected");
            $(".config-section:not(.template) .pii-masking-rules-config-section").removeClass("hide");
            // Hides the API Server configuration section
            $(".config-section:not(.template) .api-server-config-section").addClass("hide");
            // Shows the Current AI Service section
            $(".config-section:not(.template) .current-ai-service-config-section").addClass("hide");
            // Hides the New AI Service and My AI Services sections because it's only shown after the user clicks on "Configure" button
            $(".config-section:not(.template) .more-ai-service-config-section").addClass("hide");
        }
    }
});

// Click event for the revoke button in a list item in the list inside My AI Services section
$(document).on('click', '.my-ai-service-list-item .revoke', function() {
    revokeMyAiService($(this).attr("my-ai-service-name")); // Passes the name of the AI Service
});

// Click event for the "Save" button in the Edit My AI Service section
$(document).on('click', '.config-section:not(.template) .edit-my-ai-service-section .config-submit-button', function () {
    var modelClass;
    var myAiServiceName = $(".config-section:not(.template) .edit-my-ai-service-section .selected-my-ai-service").text(); 
    myAiServicesString.properties.myAiServices.forEach(myAiService => {
        if(myAiService.aiServiceName == myAiServiceName){
            modelClass = myAiService.modelClass;
        }
    });
    var editMyAiServiceData = {};
    $('.config-section:not(.template) .edit-fields-container').find('input[type="text"], input[type="password"], select').each(function() {
        var inputName = $(this).attr('name');
        var inputValue = $(this).val();
        editMyAiServiceData[inputName] = inputValue;
    });
    editMyAiService(modelClass, myAiServiceName, editMyAiServiceData);
});

// Click event for the edit button in a list item in the list inside My AI Services section
$(document).on('click', '.my-ai-service-list-item .edit', function() {
    $(".config-section:not(.template) .my-ai-services-list").addClass("hide"); // Hides the My AI Services list
    $(".config-section:not(.template) .edit-my-ai-service-section").removeClass("hide"); // Shows the Edit My AI Service section
    // Sets the label to show which My AI Service is currently being edited
    $(".config-section:not(.template) .edit-my-ai-service-section .selected-my-ai-service").text($(this).attr("my-ai-service-name")); 
    // Clears the fields
    $(".config-section:not(.template) .edit-fields-container").empty();
    // Filters and stores all the form fields that is returned by the /new_ai_service_form_fields API
    var allFields = [];
    newAiServiceFormFields.fields.forEach(field => {
        // If the form field type is "text", "password" or "select" then it will store it normally
        if(!field.hasOwnProperty("children")){
            allFields.push(field);
        }
        // If the form field type is "container" then it will go through its children and store each of them
        else{
            field.children.forEach(child => {
            allFields.push(child);
            });
        }
    });
    const createFieldRow = (field, value) => {
        // Clones the template form field
        var fieldRow = $(".template.field-row").clone().removeClass("template hide");
        // Creates a <input> element and plugs necessary attributes to it
        var input = $('<input>').attr({
            autocomplete: 
                field.type === "number" 
                    ? "new-number" 
                    : field.type === "password" 
                        ? "new-password" 
                        : field.type === "text" 
                            ? "new-text" 
                            : "",
            id: field.id,
            name: field.name,
            type: field.type,
            placeholder: field.placeholder,
            class: "input",
        }).val(value);
        // Puts the label for the form field
        $(fieldRow).find(".name").text(field.label);
        // Puts the <input> inside the appropriate container
        $(fieldRow).find(".input-with-button-container").append(input);
        // Appends the form field inside New AI Service section
        $(".config-section:not(.template) .edit-fields-container").append(fieldRow);
    };
    myAiServicesString.properties.myAiServices.forEach(myAiService => {
        if(myAiService.aiServiceName == $(this).attr("my-ai-service-name")){
            if(myAiService.modelClass == "@@aiag.optionCustom@@"){
                // Loops through the each form field
                allFields.forEach(field => {
                    if(field.id == "custom-llm-url" || field.id == "custom-model-name" || field.id == "api-key"){
                        if(field.id == "api-key"){
                            createFieldRow(field, myAiService[field.name]);
                        }else{
                            createFieldRow(field, myAiService[field.name]);
                        }
                    }
                });
            }else if(myAiService.modelClass == "@@aiag.optionAwsBedrock@@"){
                // Loops through the each form field
                allFields.forEach(field => {
                    if(field.id == "aws-access-key-id" || field.id == "aws-secret-access-key" || field.id == "aws-session-token"){
                        if(field.id == "aws-session-token"){
                            createFieldRow(field, myAiService.apiKey[field.name]);
                        }else{
                            createFieldRow(field, myAiService.apiKey[field.name]);
                        }
                    }
                });
            }else{
                // Loops through the each form field
                allFields.forEach(field => {
                    if(field.id == "api-key"){
                        createFieldRow(field, myAiService[field.name]);
                    }
                });
            }
        }
    });
});

// Click on event for the tab buttons in the AI Service configuration section. Two tabs; New AI Service and My AI Services sections
$(document).on('click', '.config-section:not(.template) .switch-container .switch', function() {
    $(".config-section:not(.template) .switch-container .switch").removeClass("selected");  // Removes the "selected" class from all the tab buttons because the UI for the selected tab button will be different from the unselected
    // If the tab is for New AI Service section
    if($(this).hasClass("new-ai-service")){
        $(this).addClass("selected");
        $(".config-section:not(.template) .new-ai-service-section").removeClass("hide"); // Shows the New AI Service section
        $(".config-section:not(.template) .my-ai-services-section").addClass("hide"); // Hides the My AI Services section
    }
    // If the tab is for My AI Services section
    else if($(this).hasClass("my-ai-services")){
        clearNewAiServiceSectionFormFields();
        $(this).addClass("selected");
        $(".config-section:not(.template) .new-ai-service-section").addClass("hide");
        $(".config-section:not(.template) .my-ai-services-section").removeClass("hide");
        $(".config-section:not(.template) .my-ai-services-section .my-ai-services-list").removeClass("hide");
        $(".config-section:not(.template) .my-ai-services-section .edit-my-ai-service-section").addClass("hide");
    }
});

// Click event for the button leads to the Configuration view
$(document).on('click', '.action-button.config', function () {
    showConfigurationView();
});

// Switches to Configuration view
function showConfigurationView(){
    $(".action-button.reset:not(.template)").addClass("hide");
    $(".service-selector-container:not(.template)").addClass("hide");
    $(".action-button.config").addClass("hide");
    $(".action-button.gen-ai").removeClass("hide").closest(".parent").removeClass("hide");
    $(".gen-ai-section:not(.template)").addClass("hide"); // Hides the GenAI view
    $(".config-section:not(.template)").removeClass("hide"); // Shows the Configuration view
    $(".tab-button.api-server-config").click();
}

refreshMyPiiMaskingRules();
refreshMyAiServices();
setCurrentApiServerConfig();
retrieveNewAiServiceFormFields();
setCurrentAiService();