var chatOutputMap = new Map();
var xmlString = "";
var jsonString = "";
var userId = "";
var sessionId = "";
var upcomingStage = "";
var processProposalQuery = "";
var processCorrectionQuery = "";
var requestedChanges = "";
var previousStage = "";
var currentStage = "app_creation_mode";
var previewSizeFull = false;
var currentChatSectionId = "";
var isFileUploaded = false;
var imageBase64List = [];
var processProposalQueryIsFile = false;
var processCorrectionQueryIsFile = false;
var processProposalQueryImageBase64 = "";
var processCorrectionQueryImageBase64 = "";
var discontinueApiCalls = false;
var ajaxRequestObjectList = [];
var isVisualizationLoadedInterval = 0;
var passedFormDesign = false;
var lastProcessProposalIsFile = false;
var lastProcessCorrectionIsFile = false;
var typeWriterQueue = {};
var stopCycle = false;
var appData = {};
var modifyAppId = "";
var modifyAppVersion = "";
var isModifyAppMode = false;
var fileName = "";
let currentSessionToken = null;
// Enhanced spotlight system with step-by-step functionality
let spotlightActive = false;
let currentTooltip = null;
let spotlightQueue = [];
let currentSpotlightIndex = 0;

var slides = [
    {
        stage: "query_type",
        help_message: "@@aiag.conversation.helpMessage1@@",
        caption: "@@aiag.conversation.caption1@@",
        carousel: [
            { icon: "fa-align-justify", text: "@@aiag.conversation.text1@@" },
            { icon: "fa-file-text", text: "@@aiag.conversation.text2@@" }
        ]
    },
    {
        stage: "text_query",
        help_message: "@@aiag.conversation.helpMessage2@@",
        caption: "@@aiag.conversation.caption2@@",
        carousel: []
    },
    {
        stage: "file_query",
        help_message: "@@aiag.conversation.helpMessage3@@",
        caption: "@@aiag.conversation.caption3@@",
        carousel: []
    },
    {
        stage: "query_preprocess",
        help_message: "@@aiag.conversation.helpMessage4@@",
        caption: "@@aiag.conversation.caption4@@",
        carousel: [
            {icon: "fa-lightbulb", text: "@@aiag.conversation.text3@@"},
            {icon: "fa-user-secret", text: "@@aiag.conversation.text4@@"}
        ]
    },
    {
        stage: "before_process_proposal",
        help_message: "@@aiag.conversation.helpMessage5@@",
        caption: "@@aiag.conversation.caption5@@",
        carousel: [
            { text: "@@aiag.conversation.text5@@" },
            { text: "@@aiag.conversation.text6@@" },
            { text: "@@aiag.conversation.text7@@" },
            { text: "@@aiag.conversation.text8@@" }
        ]
    },
    {
        stage: ["process_proposal", "forms_and_participants", "transitions_and_business_activities", "forms_design", "process_correction", "add_forms_design", "replace_form_design", "remove_form_design"],
        help_message: "@@aiag.conversation.helpMessage6@@",
        caption: "@@aiag.conversation.caption6@@",
        carousel: [
            { icon: "fa-arrow-right", text: "@@aiag.conversation.text9@@" },
            { icon: "fa-sync", text: "@@aiag.conversation.text10@@" },
            { icon: "fa-edit", text: "@@aiag.conversation.text11@@" },
            { icon: "fa-plus", text: "@@aiag.conversation.text12@@" }
        ]
    },
    {
        stage: "output_error",
        help_message: "@@aiag.conversation.helpMessage7@@",
        caption: "@@aiag.conversation.caption7@@",
        carousel: [
            { icon: "fa-sync", text: "@@aiag.conversation.text13@@" },
            { icon: "fa-edit", text: "@@aiag.conversation.text14@@" },
            { icon: "fa-undo", text: "@@aiag.conversation.text15@@" }
        ]
    },
    {
        stage: "query_adjustments",
        help_message: "@@aiag.conversation.helpMessage6@@",
        caption: "@@aiag.conversation.caption6@@",
        carousel: [
            { icon: "fa-arrow-right", text: "@@aiag.conversation.text9@@" },
            { icon: "fa-sync", text: "@@aiag.conversation.text10@@" },
            { icon: "fa-arrow-left", text: "@@aiag.conversation.text18@@" }
        ]
    },
    {
        stage: "query_adjustments_error",
        help_message: "@@aiag.conversation.helpMessage7@@",
        caption: "@@aiag.conversation.caption7@@",
        carousel: [
            { icon: "fa-sync", text: "@@aiag.conversation.text13@@" },
            { icon: "fa-arrow-left", text: "@@aiag.conversation.text18@@" }
        ]
    },
    {
        stage: "app_creation_mode",
        help_message: "@@aiag.appCreationMode.helpGuide.title@@",
        caption: "@@aiag.appCreationMode.helpGuide.caption@@",
        carousel: [
            { icon: "fa-plus", text: "@@aiag.appCreationMode.helpGuide.createApp@@" },
            { icon: "fa-level-up", text: "@@aiag.appCreationMode.helpGuide.modifyApp@@" }
            //{ icon: "fa-list-ul", text: "Form Only: Craft only forms. Focus on creating efficient, user-friendly forms to collect and manage data seamlessly." }
        ]
    },
    {
        stage: "fetch_app",
        help_message: "@@aiag.conversation.helpMessage6@@",
        caption: "@@aiag.conversation.caption6@@",
        carousel: [
            { icon: "fa-arrow-right", text: "@@aiag.conversation.text9@@" },
            { icon: "fa-sync", text: "@@aiag.appCreationMode.modifyApp.fetchApp.regenerate@@" },
            { icon: "fa-plus", text: "@@aiag.conversation.text12@@" }
        ]
    }
];

var querySample = [
    "@@aiag.sample1@@",
    "@@aiag.sample2@@",
    "@@aiag.sample3@@",
    "@@aiag.sample4@@"
];

var passedEnhancedQuery = false;
var previousStage = "";

// Enhanced function to create friendly AI error styling for any error message
function createFriendlyAIError(errorMessage) {
    return `
        <div class="ai-feedback-container">
            <div class="ai-feedback-inner">
                <div class="friendly-header">
                    <i class='fa fa-search' style='color:grey'></i> 
                    <strong> Something to Look At:</strong>
                </div>
                <div class="ai-message">
                    ${errorMessage}
                </div>
                <div class="encouragement">
                    <em><i class='fas fa-lightbulb' style='color:yellow'></i> You can follow our step-by-step guide to help resolve your issue.</em>
                </div>
            </div>
        </div>`;
}

// Modified appendChatOutput function with enhanced friendly error handling
function appendChatOutput(chatSection, data, label, color, icon, isFailed) {
    // Clones the template Chat Output
    var type;
    var chatOutput;
    if (data.type == "html") {
        type = "text-box";
    } else {
        type = "file-box";
    }
    chatOutput = $(".template.chat-output." + type).clone();
    if (data.type == "xpdl") {
        $(chatOutput).find(".indicator, .operations-container").remove();
    }
    $(chatOutput).removeClass("template hide");
    
    // Generates a unique ID for Chat Output
    var chatOutputId = generateUniqueId();
    $(chatOutput).attr("chat-output-id", chatOutputId);
    $(chatOutput).attr("output-title", label);

    // Enhanced error handling
    if (isFailed) {
        // Extract the error message
        let errorMessage = data.content;

        // Replace content with friendly version
        data.content = createFriendlyAIError(errorMessage);

        // Apply friendly styling class instead of error styling
        $(chatOutput).find(".box").addClass("friendly-ai-container");
        
        // Common error styling (remove indicators, etc.)
        $(chatOutput).find(".indicator, .operations-container").remove();
        $(chatOutput).find(".box").find(".logo").remove();
        $(chatOutput).find(".box").find(".text").css("white-space", "normal");
        $(chatOutput).find(".box").css({
            "max-width": "none",
            "padding-right": "0",
            "padding": "20px"
        });

    $(chatOutput).find(".box").replaceWith(data.content);    
    }

    chatOutputMap.set(chatOutputId, { ...data });

    // Handles putting content for different types of Chat Output
    if (data.type == "html") {
        $(chatOutput).find(".box").html(data.content);
    } else {
        $(chatOutput).find(".box").find(".logo").css("background-color", color).find("i").addClass(icon).css("font-size", "18px");
        $(chatOutput).find(".box").find(".text").html(label);
        if (data.type == "json") {
            if (isFailed) {
                $(chatOutput).find(".box").find(".text").html(label);
            } else {
                $(chatOutput).find(".box").find(".text").html(label);
                $(chatOutput).attr("form-design-name", data.form_meta.key);
                $(chatOutput).attr("form-design-id", data.form_meta.id);
            }
        }
    }
    
    var chatOutputList = $(chatSection).find(`.chat-output-list[attempt='${$(chatSection).find(".chat-output-list").length}']`);
    // Appends the Chat Output to the Chat Output List
    $(chatOutputList).append(chatOutput);
    $(chatOutputList).removeClass("hide");

    $(chatSection).find(".chat-output-details").removeClass("hide");

    changeChatModelInfoColor(chatSection);

    $(chatSection).find(".attempts-controller .attempts-counter .current-attempt").text($(chatSection).find(".chat-output-list").length);
    $(chatSection).find(".attempts-controller .attempts-counter .total-attempts").text($(chatSection).find(".chat-output-list").length);

    showChatOutputList(chatSection, $(chatSection).find(".chat-output-list").length, false);

    // Shows the Chat Output
    setTimeout(() => {
        $(chatOutput).find(".box").addClass("fade-in");
    }, 100);
}

function changeChatModelInfoColor(chatSection) {
    if (currentStage == "process_correction") {
        $(chatSection).find(".chat-output-details .chat-model-info i").addClass("correction").removeClass("query add-form-design replace-form-design remove-form-design");
    } else if (currentStage == "add_forms_design") {
        $(chatSection).find(".chat-output-details .chat-model-info i").addClass("add-form-design").removeClass("query correction replace-form-design remove-form-design");
    } else if (currentStage == "remove_form_design") {
        $(chatSection).find(".chat-output-details .chat-model-info i").addClass("remove-form-design").removeClass("query correction replace-form-design add-form-design");
    } else if (currentStage == "replace_form_design") {
        $(chatSection).find(".chat-output-details .chat-model-info i").addClass("replace-form-design").removeClass("query correction remove-form-design add-form-design");
    } else {
        $(chatSection).find(".chat-output-details .chat-model-info i").addClass("query").removeClass("replace-form-design correction remove-form-design add-form-design");
    }
}

function showChatOutputList(chatSection, attempt, farEnd) {
    $(chatSection).find(".chat-output-list").each(function () {
        var chatOutputList = this;
        if (attempt == $(chatOutputList).attr("attempt")) {
            $(chatOutputList).find(".chat-output").each(function () {
                if($(this).find(".box").hasClass("failed")){
                    hidePreviewContainer();
                }
            }); 
            $(chatSection).find(".attempts-controller .attempts-counter .current-attempt").text(attempt);
            $(chatSection).find(".chat-output-details .chat-model-info .name").text($(chatOutputList).attr("model-name"));
            $(chatOutputList).removeClass("hide");
            var lastFileBox = $(chatOutputList).find(".file-box").last();
            if(lastFileBox.length){
                if(!farEnd){
                    $(lastFileBox).find(".box").click();
                }
            }
        } else {
            $(chatOutputList).addClass("hide");
        }
    });
}

// Called when Chat Output for Process Design or Form Design is clicked. Sets up Visualize and Code view
function previewData(output) {

    $('.preview-section-container').css("width", "60%");
    $('.preview-section').removeClass("hide");

    /*
    * ===============================
    * Haze effect for visualization preview
    * 
    * Purpose:
    * - When switching views quickly (from Visual to Code),
    *   the layout may appear broken or misaligned due to incomplete rendering.
    * 
    * Behavior:
    * - A "haze" overlay is shown to prevent users from interacting
    *   with the preview until it finishes calculating dimensions.
    * - The haze remains active until the Java backend sets the `isVisualizationLoaded`
    *   cookie, signaling that the visual is ready.
    */
    $('.gen-ai-section:not(.template) .preview-box .visualize').addClass("haze");
    setCookie("isVisualizationLoaded", false);
    isVisualizationLoadedInterval = setInterval(function () {
        if (getCookie("isVisualizationLoaded")) {
            $('.gen-ai-section:not(.template) .preview-box .visualize').removeClass("haze");
        }
    }, 1000);
    // ===============================

    // Removes grey background color from a Chat Output that is currently selected to avoid confusion since the user has clicked on this Chat Output
    $(".chat-output").find(".box").removeClass("selected");
    // Adds the grey background color for this Chat Output
    $(output).addClass("selected");
    // Gets the ID of this Chat Output
    var chatOutputId = $(output).closest(".chat-output").attr("chat-output-id");
    var title = $(output).closest(".chat-output").attr("output-title");
    // Temporarily make the iFrame invisible and gives an empty source for it
    $('.gen-ai-section:not(.template) .preview-box .visualize').css("visibility", "hidden");
    $(".gen-ai-section:not(.template) .preview-box .visualize").attr("src", "");
    // Basically shows everything inside the Preview section
    $(".gen-ai-section:not(.template) .preview-options-section").removeClass("not-visible");
    $(".gen-ai-section:not(.template) .preview-box").removeClass("hide");
    $(".gen-ai-section:not(.template) .preview-resize-section").removeClass("hide");
    // Hides the Code view first
    $('.gen-ai-section:not(.template) .preview-box .code').addClass("hide");
    // Adds "selected" class for the the Visualize button because the UI for the selected button will be different
    $(".gen-ai-section:not(.template) .action-button.preview-option.visualize").addClass("selected");
    $(".gen-ai-section:not(.template) .action-button.preview-option.code").removeClass("selected");
    // Gets the content of the Process Design or Form Design by using the ID
    var data = chatOutputMap.get(chatOutputId);
    // Creates a temporary form. This form will be programmatically submitted so that the Iframe will load the visual
    var form = $('<form style="display:none;" action="' + UI.base + '/web/json/plugin/org.joget.ai.designer.AiDesigner/service?_a=' + encodeURIComponent(data.action) + '" method="post" target="visualize-iframe"></form>');
    // Sets the necessary attributes and data to the form and submits it
    $(form).append('<input type="hidden" name="' + data.type + '" />');
    $(form).find('[name="' + data.type + '"]').val(data.content);
    $('.gen-ai-section:not(.template) .preview-box').append($(form));
    $(form).submit();
    // Removes the form
    $(form).remove();
    // BlockUI is a jQuery plugin that will basically block user interaction like inputting values in a form field
    // For some reason, when this form is submitted, it's calling the $.blockUI(); function
    // So, that's why $.unblockUI(); is called here
    $.unblockUI();
    // Updates the content of Code view
    $('.gen-ai-section:not(.template) .preview-box .code').val(data.content);
    $('.gen-ai-section:not(.template) .preview-box .title').text(title)
    // Makes the iFrame visible again
    setTimeout(() => {
        $(".gen-ai-section:not(.template) .preview-box .visualize").removeClass("hide");
        $('.gen-ai-section:not(.template) .preview-box .visualize').css("visibility", "visible");
    }, 1000);
}

// Finds the key by "name" of the form
function findFormKeyByFormName(object, name) {
    for (const key in object) {
        if (object[key].form.properties.name === name) {
            return key;
        }
    }
    return null;
}

function changeHelpSectionCarousel(helpSection, targetCount) {
    $(helpSection).attr("currentCount", parseInt(targetCount));
    $(helpSection).find(".content").each(function () {
        let count = $(this).attr("count");
        $(this).addClass("hide");
        if (parseInt(count) == targetCount) {
            $(this).removeClass("hide");
        }
    });
    $(helpSection).find(".carousel-indicator i").each(function () {
        let count = $(this).attr("count");
        $(this).removeClass("fas fa-circle").addClass("far fa-circle");
        if (parseInt(count) == targetCount) {
            $(this).removeClass("far fa-circle").addClass("fas fa-circle");
        }
    });
}

$(document).on('click', '.gen-ai-section:not(.template) .help-box .carousel .next', function () {
    var helpSection = $(this).closest(".help-section");
    var currentCount = parseInt($(helpSection).attr("currentCount"));
    var maxCount = parseInt($(helpSection).attr("maxCount"));
    currentCount = currentCount + 1;
    if (currentCount > maxCount) {
        currentCount = 0;
    }
    changeHelpSectionCarousel(helpSection, currentCount);
});

$(document).on('click', '.gen-ai-section:not(.template) .help-box .carousel .prev', function () {
    var helpSection = $(this).closest(".help-section");
    var currentCount = parseInt($(helpSection).attr("currentCount"));
    var maxCount = parseInt($(helpSection).attr("maxCount"));
    currentCount = currentCount - 1;
    if (currentCount < 0) {
        currentCount = maxCount;
    }
    changeHelpSectionCarousel(helpSection, currentCount);
});









var mouseEnterHelpButton = false;
var timeout = setTimeout(() => { }, 1000);
var timeout2 = setTimeout(() => { }, 1000);

function adjustTooltipPosition() {
    const firstDiv = document.querySelector('.help-section');
    const firstDivRect = firstDiv.getBoundingClientRect();
    $('.help-box').css("left", `${firstDivRect.left}px`);
    $('.help-box').css("top", `${firstDivRect.bottom + 10}px`);
}

$(document).on('mouseenter', '.help-button', function () {
    timeout2 = setTimeout(() => {
        clearTimeout(timeout);
        mouseEnterHelpButton = true;
        var helpSection = $(this).closest(".help-section")
        const firstDiv = $(helpSection).find(".help-button")[0];
        const firstDivRect = firstDiv.getBoundingClientRect();
        $(helpSection).find(".help-box").css("visibility", "visible");
        $(helpSection).find(".help-box").css("opacity", "1");
        $(helpSection).find(".help-box").css("z-index", "9999");
        var parent = $(helpSection).parent()
        if ($(parent).hasClass("chat-section")) {
            $(helpSection).find(".help-box").css("left", `${firstDivRect.left}px`);
            $(helpSection).find(".help-box").css("top", `${firstDivRect.bottom + 11}px`);
        } else {
            if ($(helpSection).hasClass("plain-text")) {
                $(helpSection).find(".help-box").css("left", `${firstDivRect.left}px`);
                $(helpSection).find(".help-box").css("top", `${firstDivRect.bottom - 90}px`);
            } else if ($(helpSection).hasClass("plain-text-with-button")) {
                $(helpSection).find(".help-box").css("left", `${firstDivRect.left}px`);
                $(helpSection).find(".help-box").css("top", `${firstDivRect.bottom - 155}px`);
            } else {
                $(helpSection).find(".help-box").css("left", `${firstDivRect.left}px`);
                $(helpSection).find(".help-box").css("top", `${firstDivRect.bottom - 185}px`);
            }
        }
    }, 500);
});

$(document).on('mouseenter', '.help-box', function () {
    clearTimeout(timeout);
    if (mouseEnterHelpButton) {
        var helpSection = $(this).closest(".help-section")
        $(helpSection).find(".help-box").css("opacity", "1");
        $(helpSection).find(".help-box").css("z-index", "9999");
    }
});

$(document).on('mouseleave', '.help-section', function () {
    clearTimeout(timeout2);
    timeout = setTimeout(() => {
        var helpSection = $(this).closest(".help-section")
        $(helpSection).find(".help-box").css("opacity", "0");
        setTimeout(() => {
            $(helpSection).find(".help-box").css("visibility", "hidden");
        }, 100);
        $(helpSection).find(".help-box").css("z-index", "");
        mouseEnterHelpButton = false;
    }, 500);
});

window.addEventListener('resize', adjustTooltipPosition);


$(document).on('click', '.gen-ai-section:not(.template) .help-box .text-button', async function () {
    $(".gen-ai-section:not(.template) .input-section .input-box").val("");
    $(".gen-ai-section:not(.template) .input-section .input-box").attr("placeholder", "@@aiag.conversation.text16@@");
    setTimeout(() => {
        var randomIndex = Math.floor(Math.random() * querySample.length);
        var suggestedQuery = querySample[randomIndex];
        $(".gen-ai-section:not(.template) .input-section .input-box.query").attr("placeholder", `@@aiag.processProposalPlaceholder@@`);
        $(".gen-ai-section:not(.template) .input-section .input-box").val(suggestedQuery);
    }, 2000);
});


function getFormDesignName(chatOutputId) {
    let formName = null;
    $('.chat-output.file-box').each(function () {
        var chatOutput = $(this);
        if ($(chatOutput).attr("chat-output-id") == chatOutputId) {
            formName = $(chatOutput).attr("form-design-name");
            return false;
        }
    });
    return formName;
}

function getFormDesignId(chatOutputId) {
    let formId = null;
    $('.chat-output.file-box').each(function () {
        var chatOutput = $(this);
        if ($(chatOutput).attr("chat-output-id") == chatOutputId) {
            formId = $(chatOutput).attr("form-design-id");
            return false;
        }
    });
    return formId;
}

$(document).on('click', '.spotlight-next-btn', function (event) {
    event.stopPropagation();
    nextSpotlightStep();
});

$(document).on('click', '.spotlight-skip-btn', function (event) {
    event.stopPropagation();
    skipSpotlightTour();
});

$(document).on('mouseenter', '#dynamicTooltip', function () {
    var parent = $('#dynamicTooltip').closest('.top-button-tooltip');
    const tooltipText = $(parent).attr('data-tooltip');
    if (tooltipText) {
        $(parent).data('original-tooltip', tooltipText);
        $(parent).removeAttr('data-tooltip');
    }
});

$(document).on('mouseleave', '#dynamicTooltip', function () {
    restoreDataTooltipInUserGuideParent();
});

// Simplified showSpotlight function with basic positioning
function showSpotlight(targetElement, message = "Action required", options = {}) {
    const overlay = document.getElementById('spotlightOverlay');
    const circle = document.getElementById('spotlightCircle');

    if (!overlay || !circle || !targetElement) {
        console.error('Spotlight elements not found');
        return;
    }
    
    if (spotlightActive) {
        hideSpotlight(false);
        setTimeout(() => {
            continueShowingSpotlight();
        }, 350);
        return;
    }
    
    continueShowingSpotlight();
    
    function continueShowingSpotlight() {
        removeUserGuide();
        tooltip = document.createElement('div');
        tooltip.id = 'dynamicTooltip';
        tooltip.className = 'spotlight-tooltip hide';
        $(targetElement).append(tooltip);
        
        targetElement.classList.remove('hide');
        const parent = targetElement.closest('.parent, .template');
        if (parent && !parent.classList.contains('template')) {
            parent.classList.remove('hide');
        }
        
        const rect = targetElement.getBoundingClientRect();
        const centerX = rect.left + rect.width / 2;
        const centerY = rect.top + rect.height / 2;
        const circleSize = Math.max(rect.width, rect.height) + (options.padding || 80);
        
        circle.style.width = circleSize + 'px';
        circle.style.height = circleSize + 'px';
        circle.style.left = (centerX - circleSize / 2) + 'px';
        circle.style.top = (centerY - circleSize / 2) + 'px';
        
        const stepIndicator = options.stepInfo ? 
            `<div class="step-indicator">Step ${options.stepInfo.current} of ${options.stepInfo.total}</div>` : '';
        const nextButton = options.hasNext ? 
            `<button class="spotlight-next-btn">Next</button>` : '';
        const skipButton = options.canSkip ? 
            `<button class="spotlight-skip-btn">${options.hasNext ? "Skip Tour" : "End Tour"}</button>` : '';
        
        tooltip.innerHTML = `
            ${stepIndicator}
            <div class="tooltip-message">${message}</div>
            <div class="tooltip-buttons">
                ${nextButton}
                ${skipButton}
            </div>
        `;

        // positioning - just basic top/bottom with boundary check
        const tooltipPosition = calculateSimpleTooltipPosition(rect, tooltip, options);
        tooltip.style.transform = options.transform;
        tooltip.className = `spotlight-tooltip hide ${tooltipPosition.position}`;

        if(options.arrow_position){
            if (options.arrow_position === 'right') {
                tooltip.classList.add('arrow-right');
            }
        }
        
        tooltip.classList.remove('hide');
        targetElement.classList.add('spotlight-highlight');
        overlay.classList.add('active');

        setTimeout(() => {
            tooltip.classList.add('show');
        }, 200);
        
        spotlightActive = true;
        currentTooltip = tooltip;

        if (options.autoHide) {
            setTimeout(() => {
                if (spotlightActive) hideSpotlight();
            }, options.autoHide);
        }
    }
}

// Click outside to close
const closeOnOutsideClick = function (e) {
    const tooltip = document.getElementById('dynamicTooltip');
    const circle = document.getElementById('spotlightCircle');
    // If either exists and the click is outside both (or the existing one)
    const clickedOutsideTooltip = !tooltip || !tooltip.contains(e.target);
    const clickedOutsideCircle = !circle || !circle.contains(e.target);
    if (clickedOutsideTooltip && clickedOutsideCircle) {
        hideSpotlight();
    }
};

document.addEventListener('click', closeOnOutsideClick);

function hideSpotlight(resetQueue = true) {
    const overlay = document.getElementById('spotlightOverlay');
    const circle = document.getElementById('spotlightCircle');

    if (!overlay || !spotlightActive) return;

    // Remove highlight
    document.querySelectorAll('.spotlight-highlight').forEach(el => el.classList.remove('spotlight-highlight'));

    // Hide tooltip
    if (currentTooltip) {
        currentTooltip.classList.remove('show');
        currentTooltip.classList.add('hide');

        // Reset tooltip style
        currentTooltip.style.left = '';
        currentTooltip.style.top = '';
        currentTooltip.style.transform = '';
        currentTooltip.innerHTML = '';
    }

    // Remove overlay state
    overlay.classList.remove('active');
    overlay.style.pointerEvents = 'none';

    spotlightActive = false;
    currentTooltip = null;

    // Clear spotlight queue if needed
    if (resetQueue) {
        spotlightQueue = [];
        currentSpotlightIndex = 0;
    }

    restoreDataTooltipInUserGuideParent();
    removeUserGuide();
}

function removeUserGuide(){
    let tooltip = document.getElementById('dynamicTooltip');
    if (tooltip) {
        $(tooltip).remove();
    }
}

function restoreDataTooltipInUserGuideParent(){
    var parent = $('#dynamicTooltip').closest('.top-button-tooltip');
    const original = $(parent).data('original-tooltip');
    if (original) {
        setTimeout(() => {
            $(parent).attr('data-tooltip', original);
        }, 100);
        $(parent).removeData('original-tooltip');
    }
}

// Much simpler positioning logic
function calculateSimpleTooltipPosition(targetRect, tooltip, options = {}) {
    const viewportHeight = window.innerHeight;
    const spacing = 20;
    
    // Get tooltip dimensions
    tooltip.style.visibility = 'hidden';
    tooltip.style.display = 'block';
    const tooltipRect = tooltip.getBoundingClientRect();
    const tooltipHeight = tooltipRect.height || 100;
    tooltip.style.display = '';
    tooltip.style.visibility = '';
    
    const centerX = targetRect.left + targetRect.width / 2;
    const spaceAbove = targetRect.top;
    const spaceBelow = viewportHeight - targetRect.bottom;
    
    let position, top, left, transform;
    
    // Simple rule: If more space above, show above. Otherwise, show below.
    if (spaceAbove > spaceBelow && spaceAbove > tooltipHeight + spacing) {
        // Show above
        position = 'top';
        top = targetRect.top - tooltipHeight - spacing;
        left = centerX;
        transform = 'translateX(-50%)';
    } else {
        // Show below (default)
        position = 'bottom';
        top = targetRect.bottom + spacing;
        left = centerX;
        transform = 'translateX(-50%)';
    }
    
    // Simple boundary check - keep tooltip in viewport horizontally
    const margin = 20;
    const tooltipWidth = tooltipRect.width || 250;
    const minLeft = margin + tooltipWidth/2;
    const maxLeft = window.innerWidth - margin - tooltipWidth/2;
    
    if (left < minLeft) {
        left = minLeft;
    } else if (left > maxLeft) {
        left = maxLeft;
    }
    
    return { position, left, top, transform };
}

// Step-by-step spotlight system
function startSpotlightTour(steps) {
    spotlightQueue = steps;
    currentSpotlightIndex = 0;
    showCurrentSpotlightStep();
}

function showCurrentSpotlightStep() {
    if (currentSpotlightIndex >= spotlightQueue.length) {
        hideSpotlight();
        return;
    }
    
    const step = spotlightQueue[currentSpotlightIndex];
    const options = {
        ...step.options,
        stepInfo: {
            current: currentSpotlightIndex + 1,
            total: spotlightQueue.length
        },
        hasNext: currentSpotlightIndex < spotlightQueue.length - 1,
        canSkip: true
    };
    
    // Add a delay when transitioning between steps to ensure smooth transition
    const delay = currentSpotlightIndex === 0 ? 0 : 350;
    
    setTimeout(() => {
        showSpotlightFor(step.selector, step.message, options);
    }, delay);
}

function nextSpotlightStep() {
    currentSpotlightIndex++;
    showCurrentSpotlightStep();
}

function skipSpotlightTour() {
    hideSpotlight();
}

// Convenience function to spotlight by selector
function showSpotlightFor(selector, message, options = {}) {
    let targetElement;

    // Handle different selector types
    if (typeof selector === 'string') {
        // Could be a data attribute, class, or ID
        if (selector.startsWith('#') || selector.startsWith('.')) {
            targetElement = document.querySelector(selector);
        } else {
            // Try data-spotlight-id first, then class
            targetElement = document.querySelector(`[data-spotlight-id="${selector}"]`) ||
                           document.querySelector(`.${selector}:not(.template)`);
        }
    } else {
        // Direct element reference
        targetElement = selector;
    }
    
    if (targetElement) {
        showSpotlight(targetElement, message, options);
    } else {
        console.error('Target element not found:', selector);
    }
}

function triggerSmartErrorRecoverySpotlight() {
    const config = [
        {
            selector: '.gen-ai-section:not(.template) .suggestion-button.regeneration',
            message: '@@aiag.tooltip.regenerate@@',
            padding: 60,
            transform: 'translateX(-36%) translateY(-78%)',
            arrow_position: ''
        },
        {
            selector: '.gen-ai-section:not(.template) .suggestion-button.correction',
            message: '@@aiag.tooltip.refine@@',
            padding: 60,
            transform: 'translateX(-40%) translateY(-78%)',
            arrow_position: ''
        },
        {
            selector: '.close-section .service-selector-container',
            message: '@@aiag.tooltip.switchService@@',
            padding: 80,
            transform: 'translateX(-23%) translateY(10%)',
            arrow_position: ''
        },
        {
            selector: '.close-section .action-button.reset',
            message: '@@aiag.tooltip.reset@@',
            padding: 70,
            transform: 'translateX(-30%) translateY(70%)',
            arrow_position: 'right'
        }
    ];

    const steps = [];

    config.forEach(({ selector, message, padding, transform, arrow_position}) => {
        document.querySelectorAll(selector).forEach((el) => {
            if (!el.closest('.template') && el.offsetParent !== null) {
                $(el).removeClass("hide");
                steps.push({
                    selector: el,
                    message: message,
                    options: { padding: padding , transform: transform , arrow_position: arrow_position}
                });
            }
        });
    });

    if (steps.length > 0) {
        startSpotlightTour(steps);
    }
}

// Adds Chat in the Conversation section
async function createChat(isRegeneration) {
    var chatSection;
    if (isRegeneration) {
        chatSection = $(".chat-section").filter(function () {
            return $(this).attr("chat-section-id") == currentChatSectionId;
        });
        beginStep(chatSection);
    } else {
        // Clones the template Chat Section
        chatSection = $(".template.chat-section").clone();
        chatSection.removeClass("template hide");
        var chatSectionId = generateUniqueId();
        // Sets the "stage" attribute
        chatSection.attr("chat-section-id", chatSectionId);
        currentChatSectionId = chatSectionId;

        chatSection.find(".chat-input").html(beginStep(chatSection));
        chatSection.find(".chat-input").addClass(isFileUploaded ? "file" : "text");
        chatSection.find(".chat-input").attr("previous-stage", previousStage);
        chatSection.find(".chat-input").attr("current-stage", currentStage);

        if (currentStage == "app_creation_mode") {
            chatSection.find(".chat-input-container").remove();
        }

        if (currentStage == "query_preprocess" && previousStage == "text_query") {
            // chatSection.find(".chat-input-container .edit-prompt-button").removeClass("hide");
        }

        if (currentStage == "before_process_proposal" && previousStage == "file_query") {
            // chatSection.find(".chat-input-container .edit-prompt-button").removeClass("hide");
        }

        // Makes the Chat Input background color as purple if the Chat is a Correction
        if (currentStage == "process_correction") {
            chatSection.find(".chat-input").addClass("correction");
        }

        if (currentStage == "add_forms_design") {
            chatSection.find(".chat-input").addClass("add-form-design");
        }

        if (currentStage == "replace_form_design") {
            chatSection.find(".chat-input").addClass("replace-form-design");
        }

        if (currentStage == "remove_form_design") {
            chatSection.find(".chat-input").addClass("remove-form-design");
        }

        // Appends and shows the Chat in the Conversation
        $(".gen-ai-section:not(.template) .chat-sections-container").append(chatSection);
        setTimeout(() => {
            chatSection.find(".chat-input").addClass("fade-in");
        }, 100);
    }

    $(".edit-prompt-button").addClass("disable");

    // Clones the template Chat Output List
    var chatOutputList = $(".template.chat-output-list").clone();
    chatOutputList.removeClass("template hide");
    $(chatOutputList).attr("attempt", $(chatSection).find(".chat-output-list").length + 1);
    $(chatOutputList).attr("model-name", currentAiServiceString.properties.modelName);
    $(chatOutputList).addClass("hide");
    $(chatSection).find(".chat-sandwich").append(chatOutputList);

    // If the Chat is a Correction
    if (currentStage == "process_correction") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").addClass("hide"); // Temporarily hides the suggestion buttons to prevent user from pressing them while output is being generated
        var emptyResponse = []
        // Calls the /process_correction API. The map contains the corrected Process Proposal and may contain Forms & Participants (depends if the user is on the second step which is Forms & Participants or not)
        var processCorrectionResponse = await workflowDesign("process_correction");
        if (discontinueApiCalls) {
            return;
        }
        var currentStageTemp;
        if (processCorrectionResponse.get('status')) {
            currentStageTemp = currentStage;
            var processCorrection = processCorrectionResponse.get('result').get('processCorrection');

            if(!isModifyAppMode){
                if (processCorrection.processProposalResult) {
                    // Passes the content and appends the Chat Output
                    appendChatOutput(chatSection, { type: 'html', content: processCorrection.processProposalResult }, "", "", "", false);
                } else {
                    currentStageTemp = "output_error";
                    hidePreviewContainer();
                    // Passes the content and appends the Chat Output
                    appendChatOutput(chatSection, { type: 'html', content: `@@aiag.failed.processProposal@@ - ${processCorrectionResponse.get('result')}` }, "", "", "", true);
                }
                emptyResponse.push(!!processCorrection.processProposalResult);
            }

            // If the user does correction after going through the second step, which is Forms & Participants
            if (upcomingStage != "forms_and_participants") {

                if(!isModifyAppMode){
                    if (processCorrection.formsAndParticipantsResult) {
                        // Passes the content and appends the Chat Output
                        setTimeout(() => {
                            appendChatOutput(chatSection, { type: 'html', content: processCorrection.formsAndParticipantsResult }, "", "", "", false);
                        }, 100);
                    } else {
                        currentStageTemp = "output_error";
                        hidePreviewContainer();
                        // Passes the content and appends the Chat Output
                        appendChatOutput(chatSection, { type: 'html', content: `@@aiag.failed.formParticipants@@ - ${processCorrectionResponse.get('result')}` }, "", "", "", true);
                    }
                    emptyResponse.push(!!processCorrection.formsAndParticipantsResult);
                }

                // If the user does correction after going through the third step, which is Process Design
                if (upcomingStage != "transitions_and_business_activities") {
                    var xpdlResponse = await workflowDesign("transitions_and_business_activities");
                    if (discontinueApiCalls) {
                        return;
                    }
                    if (xpdlResponse.get('status')) {
                        setTimeout(() => {
                            // Passes the content and appends the Chat Output
                            putProcessDesign(chatSection, xpdlResponse.get('result'), false);
                        }, 100);
                        emptyResponse.push(true);
                    } else {
                        currentStageTemp = "output_error";
                        hidePreviewContainer();
                        // Passes the content and appends the Chat Output
                        setTimeout(() => {
                            putProcessDesign(chatSection, xpdlResponse.get('result'), true);
                        }, 100);
                        emptyResponse.push(false);
                    }
                    // If the user does correction after going through the fourth step, which is Form Design
                    if (upcomingStage != "forms_design") {
                        var jsonResponse = await workflowDesign("forms_design");
                        if (discontinueApiCalls) {
                            return;
                        }
                        if (jsonResponse.get('status')) {
                            setTimeout(() => {
                                putFormDesign(chatSection, jsonResponse.get('result'), false);
                            }, 100);
                            emptyResponse.push(true);
                        } else {
                            currentStageTemp = "output_error";
                            hidePreviewContainer();
                            // Passes the content and appends the Chat Output
                            setTimeout(() => {
                                putFormDesign(chatSection, jsonResponse.get('result'), true);
                            }, 100);
                            emptyResponse.push(false);
                        }
                    }
                }
            }
            //
        } else {
            currentStageTemp = "output_error";
            hidePreviewContainer();
            appendChatOutput(chatSection, { type: 'html', content: `@@aiag.failed.error.correction@@ - ${processCorrectionResponse.get('result')}` }, "", "", "", true);
            emptyResponse.push(false);
            setTimeout(()=>{
                triggerSmartErrorRecoverySpotlight()
            },1000);
        }
        
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            if(!passedFormDesign && item.icon == "fa-plus"){
                //
            }else{
                slidesLength++;
                var content = carouselContent.clone();
                $(content).attr("count", slidesLength);
                $(content).find(".icon i").addClass(`fa ${item.icon}`);
                $(content).find(".text").text(item.text)
                $(helpSection).find(".help-box .carousel .next").before(content);
                //
                var i = $("<i>");
                $(i).attr("count", slidesLength).addClass("far fa-circle");
                $(helpSection).find(".help-box .carousel-indicator").append(i);
            }
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
  
        changeHelpSectionCarousel(helpSection, 0);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        //
        // Shows back the suggestion buttons
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").removeClass("hide");
        var statusMessage;
        if (emptyResponse.every(value => value == true)) {
            statusMessage = "@@aiag.success.changed@@";
            $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.next-step").removeClass("hide"); // Passes the status message. Passes an empty array for "nextSteps" and false for "showCorrection" because it's the Correction step so no need to create new suggestion buttons
        } else {
            statusMessage = "@@aiag.failed.correction@@";
            $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.next-step").addClass("hide");
        }
        concludeStep(statusMessage, [], false, false, false, upcomingStage, chatSection, false);
    }
    // If the Chat is for adding Form(s)
    else if (currentStage == "add_forms_design") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").addClass("hide"); // Temporarily hides the suggestion buttons to prevent user from pressing them while output is being generated

        var response = await addFormDesign();
        if (discontinueApiCalls) {
            return;
        }
        var statusMessage;
        var currentStageTemp;
        if (response.get('status')) {
            currentStageTemp = currentStage;
            // Since the Chat Output of Form Design is a button, addition attributes are added and appended to the Chat Output. Looped appending might be done to create multiple Chat Output because Form Design can be more than one
            putFormDesign(chatSection, response.get('result'), false);
            statusMessage = "@@aiag.success.form@@";
        } else {
            currentStageTemp = "output_error";
            hidePreviewContainer();
            statusMessage = "@@aiag.failed.addFormDesign@@"
            $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.create-app").addClass("hide");
            putFormDesign(chatSection, response.get('result'), true);
            setTimeout(()=>{
                triggerSmartErrorRecoverySpotlight()
            },1000);
        }
        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            slidesLength++;
            var content = carouselContent.clone();
            $(content).attr("count", slidesLength);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", slidesLength).addClass("far fa-circle");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);

        changeHelpSectionCarousel(helpSection, 0);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        //
        // Shows back the suggestion buttons
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").removeClass("hide");
        concludeStep(statusMessage, [], false, true, false, "", chatSection, true);
    }
    // If the Chat is for replacing
    else if (currentStage == "replace_form_design") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").addClass("hide"); // Temporarily hides the suggestion buttons to prevent user from pressing them while output is being generated

        var response = await replaceFormDesign();
        var statusMessage;
        var currentStageTemp;
        if (response.get('status')) {
            currentStageTemp = currentStage;
            putFormDesign(chatSection, response.get('result'), false);
            statusMessage = "@@aiag.success.replaceFormDesign@@";

        } else {
            currentStageTemp = "output_error";
            hidePreviewContainer();
            statusMessage = "@@aiag.failed.replaceFormDesign@@"
            $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.create-app").addClass("hide");
            putFormDesign(chatSection, response.get('result'), true);
            setTimeout(()=>{
                triggerSmartErrorRecoverySpotlight()
            },1000);
        }
        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            slidesLength++;
            var content = carouselContent.clone();
            $(content).attr("count", slidesLength);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", slidesLength).addClass("far fa-circle");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);

        changeHelpSectionCarousel(helpSection, 0);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        //
        // Shows back the suggestion buttons
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").removeClass("hide");
        concludeStep(statusMessage, [], false, false, false, "", chatSection, false);
    }
    // If the Chat is for removing
    else if (currentStage == "remove_form_design") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").addClass("hide"); // Temporarily hides the suggestion buttons to prevent user from pressing them while output is being generated

        var response = await removeFormDesign();
        var statusMessage;
        var currentStageTemp;
        if (response.get('status')) {
            currentStageTemp = currentStage;
            putFormDesign(chatSection, response.get('result'), false);
            statusMessage = "@@aiag.success.removeFormDesign@@";

        } else {
            currentStageTemp = "output_error";
            hidePreviewContainer();
            statusMessage = "@@aiag.failed.removeFormDesign@@"
            $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.create-app").addClass("hide");
            putFormDesign(chatSection, response.get('result'), true);
            setTimeout(()=>{
                triggerSmartErrorRecoverySpotlight()
            },1000);
        }
        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            slidesLength++;
            var content = carouselContent.clone();
            $(content).attr("count", slidesLength);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", slidesLength).addClass("far fa-circle");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
     
        changeHelpSectionCarousel(helpSection, 0);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        //
        // Shows back the suggestion buttons
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").removeClass("hide");
        concludeStep(statusMessage, [], false, false, false, "", chatSection, false);
    }
    else if (currentStage == "query_type") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();

        var cardButtonsData = [{ icon: "fa fa-align-justify", title: "@@aiag.chatInputTitle.textQuery@@", slug: "text_query" }, { icon: "fa fa-file-text", title: "@@aiag.chatInputTitle.fileQuery@@", slug: "file_query" }];
        var chatOutput = $(".template.chat-output." + "text-box").clone();
        $(chatOutput).removeClass("template hide");
        $(chatOutput).addClass("row-direction")
        var box = $(chatOutput).find(".box").addClass("clickable").clone();
        $(chatOutput).find(".box").remove();
        cardButtonsData.forEach(cardButtonData => {
            var output = box.clone();
            var cardButton = $(".template.card-button").clone();
            $(cardButton).removeClass("template hide");
            $(cardButton).find(".icon i").addClass(cardButtonData.icon);
            $(cardButton).find(".title").text(cardButtonData.title);
            $(output).html(cardButton);
            $(output).attr("button-id", cardButtonData.slug)
            $(chatOutput).append(output);
        });
        $(chatSection).find(".chat-output-list").append(chatOutput);
        $(chatSection).find(".chat-output-list").removeClass("hide");
        $(chatSection).find(".chat-output-details").remove();

        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStage);
        var slide = slides.find(slide => slide.stage == currentStage);
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        slide.carousel.forEach((item, index) => {
            var content = carouselContent.clone();
            $(content).attr("count", index);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", index).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slide.carousel.length - 1);
        $(helpSection).find(".help-button").css("opacity", "0");
        $(chatSection).append(helpSection);
        changeHelpSectionCarousel(helpSection, 0);
        //

        setTimeout(() => {
            $(chatOutput).find(".box").addClass("fade-in");
        }, 100);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        
    }
    else if (currentStage == "app_creation_mode") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        var cardButtonsData = [{ icon: "fa fa-plus", title: "@@aiag.appCreationMode.createApp@@", slug: "query_type" }, { icon: "fa fa-level-up", title: "@@aiag.appCreationMode.modifyApp@@", slug: "modify_app" }];
        //var cardButtonsData = [{ icon: "fa fa-plus", title: "Create App", slug: "query_type" }, { icon: "fa fa-level-up", title: "Enhance App", slug: "enhance_app" }, { icon: "fa fa-list-ul", title: "Form Only", slug: "form_only" }];
        
        var chatOutput = $(".template.chat-output." + "text-box").clone();
        $(chatOutput).removeClass("template hide");
        $(chatOutput).addClass("row-direction")
        var box = $(chatOutput).find(".box").addClass("clickable").clone();
        $(chatOutput).find(".box").remove();
        cardButtonsData.forEach(cardButtonData => {
            var output = box.clone();
            var cardButton = $(".template.card-button").clone();
            $(cardButton).removeClass("template hide");
            $(cardButton).find(".icon i").addClass(cardButtonData.icon);
            $(cardButton).find(".title").text(cardButtonData.title);
            $(output).html(cardButton);
            $(output).attr("button-id", cardButtonData.slug)
            $(chatOutput).append(output);
        });
        $(chatSection).find(".chat-output-list").append(chatOutput);
        $(chatSection).find(".chat-output-list").removeClass("hide");
        $(chatSection).find(".chat-output-details").remove();

        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStage);
        var slide = slides.find(slide => slide.stage == currentStage);
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        slide.carousel.forEach((item, index) => {
            var content = carouselContent.clone();
            $(content).attr("count", index);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", index).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slide.carousel.length - 1);
        $(helpSection).find(".help-button").css("opacity", "0");
        $(chatSection).append(helpSection);
        changeHelpSectionCarousel(helpSection, 0);
        //

        setTimeout(() => {
            $(chatOutput).find(".box").addClass("fade-in");
        }, 100);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);

    }
    else if (currentStage == "modify_app") {
        currentSessionToken = Date.now(); // Start new session
        const mySession = currentSessionToken;

        isModifyAppMode = true;

        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();

        var fetchAppMenu = $(".template.fetch-app-menu").clone();
        $(fetchAppMenu).removeClass("template hide");

        var appIds = await getAppIds();
        if (mySession !== currentSessionToken) return;
        
        for (var appId of appIds) {
            var versions = await getAppVersions(appId);
            appData[appId] = versions;
        }

        $(fetchAppMenu).find(".app-id-selector").empty();
        for (var key in appData) {
            var option = $("<option></option>").text(key).val(key);
            $(fetchAppMenu).find(".app-id-selector").append(option);
            appData[key].forEach(value => {
                var option = $("<option></option>").text(value).val(value);
                $(fetchAppMenu).find(".app-version-selector").append(option);
            });
        }
        
        if (mySession !== currentSessionToken) return;

        var chatOutput = $(".template.chat-output." + "text-box").clone();
        $(chatOutput).removeClass("template hide");
        $(chatOutput).addClass("row-direction")
        $(chatOutput).find(".box").append(fetchAppMenu);
        $(chatSection).find(".chat-output-list").append(chatOutput);
        $(chatSection).find(".chat-output-list").removeClass("hide");
        $(chatSection).find(".chat-output-details").remove();
        
        var firstOption = Object.keys(appData)[0];
        $(".gen-ai-section:not(.template) .app-id-selector").val(firstOption).trigger("change");

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove();
        concludeStep("@@aiag.appCreationMode.modifyApp.fetchApp.beforeLoad@@", [{ label: "@@aiag.suggestionFetchApp@@", cssClass: "fetch-app" }], false, false, false, "fetch_app", chatSection, false);

        setTimeout(() => {
            $(chatOutput).find(".box").addClass("fade-in");
        }, 100);
        
        $(".gen-ai-section:not(.template) .input-section").removeClass("hide");
        setInputBoxHalfHeight();

        setTimeout(() => {
            // If something failed, call a friendly error spotlight
            if (appIds.length == 0 || Object.keys(appData).length == 0) {
                triggerSmartErrorRecoverySpotlight();
            } else {
                // Success guide: nudge user to start the tour
                const steps = [
                    {
                        selector: document.querySelector(".gen-ai-section:not(.template) .app-id-selector").closest(".menu"),
                        message: "@@aiag.appCreationMode.modifyApp.selectApp@@",
                        options: { canSkip: true , transform: 'translateX(0%) translateY(65%)', arrow_position: ''}
                    },
                    {
                        selector: document.querySelector(".gen-ai-section:not(.template) .app-version-selector").closest(".menu"),
                        message: "@@aiag.appCreationMode.modifyApp.selectVersion@@",
                        options: { canSkip: true , transform: 'translateX(-10%) translateY(-103%)', arrow_position: ''}
                    },
                    {
                        selector: ".gen-ai-section:not(.template) .suggestion-button.fetch-app",
                        message: "@@aiag.appCreationMode.modifyApp.fetchApp.clickFetch@@",
                        options: { canSkip: true , transform: 'translateX(-37%) translateY(-78%)', arrow_position: ''}
                    }
                ];
                startSpotlightTour(steps);
            }

        }, 300);

    }
    else if (currentStage == "fetch_app") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").addClass("hide"); // Temporarily hides the suggestion buttons to prevent user from pressing them while output is being generated

        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();

        var fetchedApp = await getAppData(modifyAppId, modifyAppVersion);
        
        $(chatSection).find(".chat-output-details").remove();

        if(fetchedApp.xpdl){
            xmlString = fetchedApp.xpdl;
            // await xpdlToYaml(fetchedApp.xpdl);
            // putProcessDesign(chatSection, fetchedApp.xpdl, false);
        }
        if(fetchedApp.json){
            await jogetFormToForms(fetchedApp.json);
            putFormDesign(chatSection, fetchedApp.json, false);
        }
      
        passedFormDesign = true;
        
        $(".gen-ai-section:not(.template) .suggestion-section").removeClass("hide");
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove();
        concludeStep("@@aiag.appCreationMode.modifyApp.fetchApp.afterLoad@@", [{ label: "@@aiag.suggestionCreateApp@@", cssClass: "create-app" }], false, true, false, "", chatSection, true);
        
        $(".gen-ai-section:not(.template) .input-section").removeClass("hide");


        var currentStageTemp = currentStage;

        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            slidesLength++;
            var content = carouselContent.clone();
            $(content).attr("count", slidesLength);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
     
        changeHelpSectionCarousel(helpSection, 0);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        //
        // Shows back the suggestion buttons
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").removeClass("hide");

        setInputBoxHalfHeight();

        setTimeout(() => {
            $(".input-section").css("opacity", "1");
        }, 100);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);

        setTimeout(() => {
            // If something failed, call a friendly error spotlight
            if (!(fetchedApp.xpdl || fetchedApp.json)) {
                triggerSmartErrorRecoverySpotlight();
            } else {
                // Success guide: nudge user to create/continue
                showSpotlightFor('.suggestion-button.create-app',
                    "@@aiag.success.fetchApp@@",
                    { canSkip: true, autoHide: 8000 }
                );
            }
        }, 100);

    }
    else if (currentStage == "text_query") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".gen-ai-section:not(.template) .drop-zone").addClass("hide");

        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();
        $(".input-section").css("opacity", "0");
        $(".input-section").removeClass("hide");
        $(".input-section .uploaded-file-box").html("").addClass("hide");
        $(".input-section .action-buttons-container .action-button.input.file-upload").addClass("hide");
        $(".input-section").css("transition", "0.1s");
        $(".input-section").css("gap", "1em");

        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).addClass("plain-text-with-button");
        $(helpSection).attr("stage", currentStage);
        var slide = slides.find(slide => slide.stage == currentStage);
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel").remove();
        $(helpSection).find(".help-box .carousel-indicator").remove();
        $(helpSection).find(".help-box .text-button-container").removeClass("hide");
        $(helpSection).find(".help-box .text-button-container .text-button").text("@@aiag.conversation.text17@@");
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
        //

        setTimeout(() => {
            $(".input-section").css("opacity", "1");
        }, 100);
        $(".suggestion-section .suggestion-button").addClass("hide");
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);

        previousStage = "text_query";
        currentStage = "query_preprocess";
    }
    else if (currentStage == "file_query") {
        
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();

        $(".input-section").css("opacity", "0");
        $(".input-section").removeClass("hide");
        $(".input-section .drop-zone").removeClass("hide");
        $(".input-section .uploaded-file-box").html("").addClass("hide");
        $(".input-section .action-buttons-container .action-button.input.file-upload").addClass("hide");
        $(".gen-ai-section:not(.template) .action-button.input.cancel").addClass("hide");
        $(".input-section .input-box").addClass("hide");
        $(".input-section").css("transition", "0.1s");
        $(".input-section").css("gap", "1em");

        $(".suggestion-section .suggestion-button").addClass("hide"); // Temporarily hides the suggestion buttons to prevent user from pressing them while output is being generated

        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).addClass("plain-text");
        $(helpSection).attr("stage", currentStage);
        var slide = slides.find(slide => slide.stage == currentStage);
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel").remove();
        $(helpSection).find(".help-box .carousel-indicator").remove();
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
        setTimeout(() => {
            $(".input-section").css("opacity", "1");
        }, 100);
        $(".suggestion-section .suggestion-button").addClass("hide");
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);

        currentStage = "before_process_proposal";
    }
    else if (currentStage == "query_preprocess") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");
        
        if (previousStage == "text_query") {
            $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        }
        typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.conversation.c5@@", false);
        var cardButtonsData = [{ icon: "fa fa-lightbulb", title: "@@aiag.chatInputTitle.enhanceQuery@@", slug: "enhance_query" }, { icon: "fa fa-user-secret", title: "@@aiag.chatInputTitle.piiMasking@@", slug: "pii_masking" }];
        var chatOutput = $(".template.chat-output." + "text-box").clone();
        $(chatOutput).removeClass("template hide");
        $(chatOutput).addClass("row-direction")
        var box = $(chatOutput).find(".box").addClass("clickable").clone();
        $(chatOutput).find(".box").remove();
        cardButtonsData.forEach(cardButtonData => {
            var output = box.clone();
            var cardButton = $(".template.card-button").clone();
            $(cardButton).removeClass("template hide");
            $(cardButton).find(".icon i").addClass(cardButtonData.icon);
            $(cardButton).find(".title").text(cardButtonData.title);
            $(output).html(cardButton);
            $(output).attr("button-id", cardButtonData.slug);
            
            // Add tooltip for enhance query if query was too short
            if (cardButtonData.slug === "enhance_query" && window.isQueryTooShort) {
                $(output).attr("data-tooltip", window.shortQueryMessage);
                $(output).addClass("show-tooltip");
            }
            
            $(chatOutput).append(output);
        });
        $(chatSection).find(".chat-output-details").remove();
        $(chatSection).find(".chat-output-list").append(chatOutput);
        $(chatSection).find(".chat-output-list").removeClass("hide");

        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStage);
        var slide = slides.find(slide => slide.stage == currentStage);
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        slide.carousel.forEach((item, index) => {
            var content = carouselContent.clone();
            $(content).attr("count", index);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", index).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slide.carousel.length - 1);
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(chatSection).append(helpSection);
        changeHelpSectionCarousel(helpSection, 0);
        //

        setTimeout(() => {
            $(chatOutput).find(".box").addClass("fade-in");
            
            // Show tooltip animation for enhance query button if needed
            if (window.isQueryTooShort) {
                setTimeout(() => {
                    $(chatOutput).find("[button-id='enhance_query']").addClass("pulse-highlight");
                }, 500);
            }
        }, 100);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        $(".gen-ai-section:not(.template) .suggestion-section").removeClass("hide");
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove();
        concludeStep("", [{ label: "@@aiag.skip@@", cssClass: "skip-query-preprocess" }], false, false, false, "process_proposal", chatSection, false);
    }
    else if (currentStage == "enhance_query") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();
        typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading11@@", true);
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove();
        var response = await enhanceFunction(processProposalQuery);
        var currentStageTemp;
        if (response.status && response.processProposalQueryEnhanced) {
            currentStageTemp = "query_adjustments";
            processProposalQueryEnhanced = response.processProposalQueryEnhanced;
            appendChatOutput(chatSection, { type: 'html', content: escapePiiTags(processProposalQueryEnhanced) }, "", "", "", false);
            
             // Remove tooltip and pulse highlight after successful enhancement
            $("[button-id='enhance_query']").removeClass("pulse-highlight show-tooltip");
            $("[button-id='enhance_query']").removeAttr("data-tooltip");
            
            // Reset the global flag
            window.isQueryTooShort = false;
            
            concludeStep("@@aiag.success.enhanceQuery@@", [{ label: "@@aiag.continue@@", cssClass: "continue-query-preprocess" }], false, true, true, "query_preprocess", chatSection, false);
        } else {
            currentStageTemp = "query_adjustments_error";
            appendChatOutput(chatSection, { type: 'html', content: "@@aiag.failed.enhanceQuery@@" }, "", "", "", true);
            concludeStep("@@aiag.failed.generateEnhanceQuery@@", [], false, true, true, "query_preprocess", chatSection, false);
            setTimeout(()=>{
                triggerSmartErrorRecoverySpotlight()
            },1000);
        }
        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            slidesLength++;
            var content = carouselContent.clone();
            $(content).attr("count", slidesLength);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        changeHelpSectionCarousel(helpSection, 0);
    }
    else if (currentStage == "pii_masking") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");
        
        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();
        typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading10@@", true);
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove();
        var response = await piiFunction(processProposalQuery);
        var currentStageTemp;
        if (response.status && response.processProposalQueryMasked) {
            currentStageTemp = "query_adjustments";
            processProposalQueryMasked = response.processProposalQueryMasked;
            appendChatOutput(chatSection, { type: 'html', content: escapePiiTags(processProposalQueryMasked) }, "", "", "", false);
            concludeStep("@@aiag.success.piiMasking@@", [{ label: "@@aiag.continue@@", cssClass: "continue-query-preprocess" }], false, true, true, "query_preprocess", chatSection, false);
        } else {
            currentStageTemp = "query_adjustments_error";
            appendChatOutput(chatSection, { type: 'html', content: "@@aiag.failed.piiMasking@@" }, "", "", "", true);
            concludeStep("@@aiag.failed.generatePiiMasking@@", [], false, true, true, "query_preprocess", chatSection, false);
            setTimeout(()=>{
                triggerSmartErrorRecoverySpotlight()
            },1000);
        }
        $(chatSection).find(".chat-output-details").remove();
        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStageTemp);
        var slide = slides.find(slide =>
            Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
        )
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        var slidesLength = -1;
        slide.carousel.forEach((item, index) => {
            slidesLength++;
            var content = carouselContent.clone();
            $(content).attr("count", slidesLength);
            $(content).find(".icon i").addClass(`fa ${item.icon}`);
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slidesLength);
        $(helpSection).css("width", "auto");
        $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
        $(helpSection).css("margin-left", "");
        $(helpSection).css("align-items", "end");
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
        $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);
        changeHelpSectionCarousel(helpSection, 0);
    }
    else if (currentStage == "before_process_proposal") {

        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
        $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");
        
        $(".input-section .drop-zone").addClass("hide");
        typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.conversation.c4@@", false);
        $(".chat-section").eq(-1).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".chat-sandwich").remove();
        $(".chat-section").eq(-2).find(".help-section").remove();

        //
        var helpSection = $(".template.help-section").clone();
        $(helpSection).removeClass("template hide");
        $(helpSection).attr("stage", currentStage);
        var slide = slides.find(slide => slide.stage == currentStage);
        $(helpSection).find(".help-button .text").text(slide.help_message);
        $(helpSection).find(".help-box .caption").text(slide.caption);
        var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
        $(helpSection).find(".help-box .carousel .content").remove();
        slide.carousel.forEach((item, index) => {
            var content = carouselContent.clone();
            $(content).attr("count", index);
            $(content).find(".icon").addClass("hide");
            $(content).find(".text").text(item.text)
            $(helpSection).find(".help-box .carousel .next").before(content);
            //
            var i = $("<i>");
            $(i).attr("count", index).addClass("fa fa-circle-o");
            $(helpSection).find(".help-box .carousel-indicator").append(i);
        });
        $(helpSection).attr("currentCount", 0);
        $(helpSection).attr("maxCount", slide.carousel.length - 1);
        $(helpSection).find(".help-button").css("opacity", "0");
        //
        $(chatSection).append(helpSection);
        changeHelpSectionCarousel(helpSection, 0);
        //

        setTimeout(() => {
            $(helpSection).find(".help-button").css("opacity", "");
        }, 100);

        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove();
        concludeStep("", [{ label: "@@aiag.stage.processProposal@@", cssClass: "next-step" }], false, false, false, "process_proposal", chatSection, false);
    }
    // If the Chat is whether a when the user starts the conversation by describing the app's process or proceeds to the next step in app generation
    else {
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button").remove(); // Removes all suggestion buttons as new ones will be created afterwards

        // Handles the 4 steps that the user goes through during app generation
        if (currentStage == "process_proposal") {

            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

            $(".chat-section").eq(-2).find(".chat-sandwich").remove();
            $(".chat-section").eq(-2).find(".help-section").remove();
            // Gets the Process Proposal
            var processProposal = await workflowDesign("process_proposal");
            if (discontinueApiCalls) {
                return;
            }
            var statusMessage;
            var currentStageTemp;
            if (processProposal.get('status')) {
                currentStageTemp = currentStage;
                statusMessage = "@@aiag.success.processProposal@@";
                // Passes the content and appends the Chat Output
                appendChatOutput(chatSection, { type: 'html', content: processProposal.get('result') }, "", "", "", false);

                //
            } else {
                currentStageTemp = "output_error";
                hidePreviewContainer();
                statusMessage = "@@aiag.failed.generateProcesspropsal@@";
                // Passes the content and appends the Chat Output
                appendChatOutput(chatSection, { type: 'html', content: `@@aiag.failed.processProposal@@ - ${processProposal.get('result')}` }, "", "", "", true);
            }
            //
            var helpSection = $(".template.help-section").clone();
            $(helpSection).removeClass("template hide");
            $(helpSection).attr("stage", currentStageTemp);
            var slide = slides.find(slide =>
                Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
            )
            $(helpSection).find(".help-button .text").text(slide.help_message);
            $(helpSection).find(".help-box .caption").text(slide.caption);
            var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
            $(helpSection).find(".help-box .carousel .content").remove();
            var slidesLength = -1;
            slide.carousel.forEach((item, index) => {
                if (currentStageTemp == "output_error" && item.icon == "fa-edit") {
                    //
                } else if(!passedFormDesign && item.icon == "fa-plus"){
                    //
                } else {
                    slidesLength++;
                    var content = carouselContent.clone();
                    $(content).attr("count", slidesLength);
                    $(content).find(".icon i").addClass(`fa ${item.icon}`);
                    $(content).find(".text").text(item.text)
                    $(helpSection).find(".help-box .carousel .next").before(content);
                    //
                    var i = $("<i>");
                    $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
                    $(helpSection).find(".help-box .carousel-indicator").append(i);
                }
            });
            $(helpSection).attr("currentCount", 0);
            $(helpSection).attr("maxCount", slidesLength);
            $(helpSection).css("width", "auto");
            $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
            $(helpSection).css("margin-left", "");
            $(helpSection).css("align-items", "end");
            $(helpSection).find(".help-button").css("opacity", "0");
            $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
            $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
            changeHelpSectionCarousel(helpSection, 0);
            setTimeout(() => {
                $(helpSection).find(".help-button").css("opacity", "");
            }, 100);
            //
            // Sets things up after this step is done (e.g. status message, next step, "currentStage", and "upcomingStage")
            concludeStep(statusMessage, [{ label: "@@aiag.formParticipants@@", cssClass: "next-step" }], true, true, false, "forms_and_participants", chatSection, false);
            if (!processProposal.get('status')) {
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.next-step").addClass("hide");
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.correction").addClass("hide");
                // For your regeneration button (will prefer top positioning)
                setTimeout(()=>{
                    triggerSmartErrorRecoverySpotlight()
                },1000);               
            }
            $(".gen-ai-section:not(.template) .action-button.input").removeClass("query");
            $(".gen-ai-section:not(.template) .input-box").removeClass("query");
            $(".gen-ai-section:not(.template) .input-section .action-buttons-container .dropdown-enhancement").addClass("hide");
        } else if (currentStage == "forms_and_participants") {

            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");
            
            // Gets the Forms & Participants
            var formsAndParticipants = await workflowDesign("forms_and_participants");
            if (discontinueApiCalls) {
                return;
            }
            var statusMessage;
            var currentStageTemp;
            if (formsAndParticipants.get('status')) {
                currentStageTemp = currentStage;
                statusMessage = "@@aiag.success.formParticipant@@"
                // Passes the content and appends the Chat Output
                appendChatOutput(chatSection, { type: 'html', content: formsAndParticipants.get('result') }, "", "", "", false);

            } else {
                currentStageTemp = "output_error";
                hidePreviewContainer();
                statusMessage = "@@aiag.failed.generateFormParticipants@@"
                // Passes the content and appends the Chat Output
                appendChatOutput(chatSection, { type: 'html', content: `@@aiag.failed.formParticipants@@ - ${formsAndParticipants.get('result')}` }, "", "", "", true);
            }
            //
            var helpSection = $(".template.help-section").clone();
            $(helpSection).removeClass("template hide");
            $(helpSection).attr("stage", currentStageTemp);
            var slide = slides.find(slide =>
                Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
            )
            $(helpSection).find(".help-button .text").text(slide.help_message);
            $(helpSection).find(".help-box .caption").text(slide.caption);
            var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
            $(helpSection).find(".help-box .carousel .content").remove();
            var slidesLength = -1;
            slide.carousel.forEach((item, index) => {
                if (currentStageTemp == "output_error" && item.icon == "fa-edit") {
                    //
                } else if(!passedFormDesign && item.icon == "fa-plus"){
                    //
                } else {
                    slidesLength++;
                    var content = carouselContent.clone();
                    $(content).attr("count", slidesLength);
                    $(content).find(".icon i").addClass(`fa ${item.icon}`);
                    $(content).find(".text").text(item.text)
                    $(helpSection).find(".help-box .carousel .next").before(content);
                    //
                    var i = $("<i>");
                    $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
                    $(helpSection).find(".help-box .carousel-indicator").append(i);
                }
            });
            $(helpSection).attr("currentCount", 0);
            $(helpSection).attr("maxCount", slidesLength);
            $(helpSection).css("width", "auto");
            $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
            $(helpSection).css("margin-left", "");
            $(helpSection).css("align-items", "end");
            $(helpSection).find(".help-button").css("opacity", "0");
            //
            $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
            $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
            changeHelpSectionCarousel(helpSection, 0);
            setTimeout(() => {
                $(helpSection).find(".help-button").css("opacity", "");
            }, 100);
            //
            // Sets things up after this step is done (e.g. status message, next step, "currentStage", and "upcomingStage")
            concludeStep(statusMessage, [{ label: "@@aiag.processDesign@@", cssClass: "next-step" }], true, true, false, "transitions_and_business_activities", chatSection, false);
            if (!formsAndParticipants.get('status')) {
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.next-step").addClass("hide");
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.correction").addClass("hide");
                setTimeout(()=>{
                    triggerSmartErrorRecoverySpotlight()
                },1000);
            }
        } else if (currentStage == "transitions_and_business_activities") {

            //
            
            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

            if (discontinueApiCalls) {
                return;
            }
        
            var transitionsAndBusinessActivities = await workflowDesign("transitions_and_business_activities");
            if (discontinueApiCalls) {
                return;
            }

            var statusMessage;
            var currentStageTemp;
            if (transitionsAndBusinessActivities.get('status')) {
                currentStageTemp = currentStage;
                // Since the Chat Output of Process Design is a button, addition attributes are added and appended to the Chat Output
                putProcessDesign(chatSection, transitionsAndBusinessActivities.get('result'), false);
                statusMessage = "@@aiag.success.processDesign@@"

            } else {
                currentStageTemp = "output_error";
                hidePreviewContainer();
                statusMessage = "@@aiag.failed.generateProcessDesign@@"
                putProcessDesign(chatSection, transitionsAndBusinessActivities.get('result'), true);
            }
            //
            var helpSection = $(".template.help-section").clone();
            $(helpSection).removeClass("template hide");
            $(helpSection).attr("stage", currentStageTemp);
            var slide = slides.find(slide =>
                Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
            )
            $(helpSection).find(".help-button .text").text(slide.help_message);
            $(helpSection).find(".help-box .caption").text(slide.caption);
            var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
            $(helpSection).find(".help-box .carousel .content").remove();
            var slidesLength = -1;
            slide.carousel.forEach((item, index) => {
                if (currentStageTemp == "output_error" && item.icon == "fa-edit") {
                    //
                } else if(!passedFormDesign && item.icon == "fa-plus"){
                    //
                } else {
                    slidesLength++;
                    var content = carouselContent.clone();
                    $(content).attr("count", slidesLength);
                    $(content).find(".icon i").addClass(`fa ${item.icon}`);
                    $(content).find(".text").text(item.text)
                    $(helpSection).find(".help-box .carousel .next").before(content);
                    //
                    var i = $("<i>");
                    $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
                    $(helpSection).find(".help-box .carousel-indicator").append(i);
                }
            });
            $(helpSection).attr("currentCount", 0);
            $(helpSection).attr("maxCount", slidesLength);
            $(helpSection).css("width", "auto");
            $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
            $(helpSection).css("margin-left", "");
            $(helpSection).css("align-items", "end");
            $(helpSection).find(".help-button").css("opacity", "0");
            //
            $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
            $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
           
            changeHelpSectionCarousel(helpSection, 0);
            setTimeout(() => {
                $(helpSection).find(".help-button").css("opacity", "");
            }, 100);
            //
            // Sets things up after this step is done (e.g. status message, next step, "currentStage", and "upcomingStage")
            concludeStep(statusMessage, [{ label: "@@aiag.formDesign@@", cssClass: "next-step" }], true, true, false, "forms_design", chatSection, true);
            if (!transitionsAndBusinessActivities.get('status')) {
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.next-step").addClass("hide");
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.correction").addClass("hide");
                setTimeout(()=>{
                    triggerSmartErrorRecoverySpotlight()
                },1000);
            }
        } else if (currentStage == "forms_design") {

            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("opacity", "0");
            $(".gen-ai-section:not(.template) .help-section-container .help-section").css("visibility", "hidden");

            var formsDesign = await workflowDesign("forms_design");
            if (discontinueApiCalls) {
                return;
            }
            var statusMessage;
            var currentStageTemp;
            if (formsDesign.get('status')) {
                currentStageTemp = currentStage;
                // Since the Chat Output of Form Design is a button, addition attributes are added and appended to the Chat Output. Looped appending might be done to create multiple Chat Output because Form Design can be more than one
                putFormDesign(chatSection, formsDesign.get('result'), false);
                statusMessage = "@@aiag.success.formDesign@@"
                passedFormDesign = true;

            } else {
                currentStageTemp = "output_error";
                hidePreviewContainer();
                statusMessage = "@@aiag.failed.generateFormDesign@@"
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.create-app").addClass("hide");
                putFormDesign(chatSection, formsDesign.get('result'), true);
            }
            //
            var helpSection = $(".template.help-section").clone();
            $(helpSection).removeClass("template hide");
            $(helpSection).attr("stage", currentStageTemp);
            var slide = slides.find(slide =>
                Array.isArray(slide.stage) ? slide.stage.includes(currentStageTemp) : slide.stage === currentStageTemp
            )
            $(helpSection).find(".help-button .text").text(slide.help_message);
            $(helpSection).find(".help-box .caption").text(slide.caption);
            var carouselContent = $(helpSection).find(".help-box .carousel .content").clone();
            $(helpSection).find(".help-box .carousel .content").remove();
            var slidesLength = -1;
            slide.carousel.forEach((item, index) => {
                if (currentStageTemp == "output_error" && item.icon == "fa-edit") {
                    //
                } else if(!passedFormDesign && item.icon == "fa-plus"){
                    //
                } else {
                    slidesLength++;
                    var content = carouselContent.clone();
                    $(content).attr("count", slidesLength);
                    $(content).find(".icon i").addClass(`fa ${item.icon}`);
                    $(content).find(".text").text(item.text)
                    $(helpSection).find(".help-box .carousel .next").before(content);
                    //
                    var i = $("<i>");
                    $(i).attr("count", slidesLength).addClass("fa fa-circle-o");
                    $(helpSection).find(".help-box .carousel-indicator").append(i);
                }
            });
            $(helpSection).attr("currentCount", 0);
            $(helpSection).attr("maxCount", slidesLength);
            $(helpSection).css("width", "auto");
            $(helpSection).find(".help-button").css("flex-directon", "row-reverse");
            $(helpSection).css("margin-left", "");
            $(helpSection).css("align-items", "end");
            $(helpSection).find(".help-button").css("opacity", "0");
            //
            $(".gen-ai-section:not(.template) .help-section-container .help-section").remove();
            $(".gen-ai-section:not(.template) .help-section-container").append(helpSection);
         
            changeHelpSectionCarousel(helpSection, 0);
            setTimeout(() => {
                $(helpSection).find(".help-button").css("opacity", "");
            }, 100);
            //
            // Sets things up after this step is done (e.g. AI Status message, Suggestion buttons, currentStage, and upcomingStage)
            concludeStep(statusMessage, [{ label: "@@aiag.suggestionCreateApp@@", cssClass: "create-app" }], true, true, false, "", chatSection, true);
            if (!formsDesign.get('status')) {
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.create-app").addClass("hide");
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.add-form-design").addClass("hide");
                $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.correction").addClass("hide");
                setTimeout(()=>{
                    triggerSmartErrorRecoverySpotlight()
                },1000);
            }

        }
    }

    $(".edit-prompt-button").removeClass("disable");

    setTimeout(() => {
        scrollChatScrollViewDown();
    }, 100);
}

function beginStep(chatSection) {

    if (currentStage == "app_creation_mode" || currentStage == "query_type" || currentStage == "text_query" || currentStage == "file_query" || currentStage == "query_preprocess" || currentStage == "before_process_proposal") {
        $(chatSection).find(".ai-status .logo").removeClass("loading").addClass("stop-loading");
    } else {
        // Get the current computed transform and opacity values
        const $logo = $(chatSection).find(".ai-status .logo");
        const computedStyle = window.getComputedStyle($logo[0]);
        const transform = computedStyle.transform;
        const opacity = computedStyle.opacity;
        // Apply these values as inline styles
        $logo.css({
            transform: transform,
            opacity: opacity,
        });
        $(chatSection).find(".ai-status .logo").removeClass("stop-loading").addClass("loading");
    }

    var chatInputContent;
    const generateUnorderedList = (list = []) => {
        const listItems = list.map(item => `<li>&#8226; ${item}</li>`).join('');
        return `<ul>${listItems}</ul>`;
    };
    if (isFileUploaded) {
        hideUploadedFileContainer();
        $(".gen-ai-section:not(.template) .drop-zone").addClass("hide");
    }
    switch (currentStage) {
        case "before_process_proposal":
            if (isFileUploaded) {
                if(imageBase64List.length > 0){
                    processProposalQueryIsFile = true;
                    chatInputContent = `<div style="position:relative"><img class="uploaded-file" src="${imageBase64List[0]}"><p class="overlay-text">${fileName}</p></img></div>`;
                }
            } else {
                chatInputContent = "@@aiag.skip@@";
            }
            break;
        case "process_proposal":
            chatInputContent = "@@aiag.stage.processProposal@@"
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading1@@", true);
            break;
        case "forms_and_participants":
            chatInputContent = "@@aiag.stage.formParticipant@@";
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading2@@", true);
            break;
        case "transitions_and_business_activities":
            chatInputContent = "@@aiag.stage.processDesign@@";
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading3@@", true);
            break;
        case "forms_design":
            chatInputContent = "@@aiag.stage.formDesign@@";
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading4@@", true);
            break;
        case "process_correction":
            if (isFileUploaded) {
                if(imageBase64List.length > 0){
                    processCorrectionQueryIsFile = true;
                    chatInputContent = `<div style="position:relative"><img class="uploaded-file" src="${imageBase64List[0]}"><p class="overlay-text">${fileName}</p></img></div>`;
                }
            } else {
                chatInputContent = processCorrectionQuery;
            }
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading5@@", true);
            break;
        case "add_forms_design":
            chatInputContent = "<div style='font-weight:bold; text-align: center; border-radius: 1em; padding: 0.8em; background-color: var(--theme-header-color-1); color: var(--theme-label-color-1);'>@@aiag.chatInputTitle.addFormDesign@@</div>";
            var queryHolder_addFormDesign = $("<div></div>");
            if (isFileUploaded) {
                if(imageBase64List.length > 0){
                    queryHolder_addFormDesign.css("position", "relative");
                    queryHolder_addFormDesign.html(`<img class="uploaded-file" src="${imageBase64List[0]}"><p class="overlay-text">${fileName}</p></img>`);
                }
            } else {
                queryHolder_addFormDesign.html(addFormDesignQuery);
            }
            chatInputContent += queryHolder_addFormDesign[0].outerHTML;
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading6@@", true);
            break;
        case "replace_form_design":
            chatInputContent = "<div style='font-weight:bold; text-align: center; border-radius: 1em; padding: 0.8em; background-color: var(--theme-header-color-1); color: var(--theme-label-color-1);'>@@aiag.chatInputTitle.replaceFormDesign@@</div>";
            formId = getFormDesignId(replaceFormDesignChatOutputId);
            chatInputContent += `<div style='width:fit-content; font-size:smaller; border-radius:0.8em; padding: 0.5em 0.8em; color: var(--theme-label-color-1); background-color: var(--theme-header-color-1);'>@@aiag.chatInputTitle.replaceFormDesign.sub1@@</div><div>&#8226; ${formId}</div>`;
            chatInputContent += `<div style='width:fit-content; font-size:smaller; border-radius:0.8em; padding: 0.5em 0.8em; color: var(--theme-label-color-1); background-color: var(--theme-header-color-1);'>@@aiag.chatInputTitle.replaceFormDesign.sub2@@</div>`
            var queryHolder_replaceFormDesign = $("<div></div>");
            if (isFileUploaded) {
                if(imageBase64List.length > 0){
                    queryHolder_replaceFormDesign.css("position", "relative");
                    queryHolder_replaceFormDesign.html(`<img class="uploaded-file" src="${imageBase64List[0]}"><p class="overlay-text">${fileName}</p></img>`);
                }
            } else {
                queryHolder_replaceFormDesign.html(replaceFormDesignQuery);
            }
            chatInputContent += queryHolder_replaceFormDesign[0].outerHTML;
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading8@@", true);
            break;
        case "remove_form_design":
            chatInputContent = "<div style='font-weight:bold; text-align: center; border-radius: 1em; padding: 0.8em; background-color: var(--theme-header-color-1); color: var(--theme-label-color-1);'>@@aiag.chatInputTitle.removeFormDesign@@</div>";
            
            var removeFormDesignIdsList = [];
            removeFormDesignNamesList.forEach(formName => {
                var jsonObject = JSON.parse(jsonString);
                var formData = jsonObject[formName];
                var formId = formData["form"]["properties"]["id"];
                removeFormDesignIdsList.push(formId);
            });
            
            chatInputContent += generateUnorderedList(removeFormDesignIdsList);
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.loading9@@", true);
            break;
        case "app_creation_mode":
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.appCreationMode.initialMessage@@", false);
            break;
        case "modify_app":
            chatInputContent = "<div style='font-weight:bold; text-align: center; border-radius: 1em; padding: 0.8em; background-color: var(--theme-header-color-1); color: var(--theme-label-color-1);'>@@aiag.appCreationMode.modifyApp@@</div>";
            chatInputContent += `<div style='width:fit-content; font-size:smaller; border-radius:0.8em; padding: 0.5em 0.8em; color: var(--theme-label-color-1); background-color: var(--theme-header-color-1);'>@@aiag.disclaimer@@</div><div style="font-size:smaller;">@@aiag.appCreationMode.modifyApp.disclaimer@@</div>`;
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.appCreationMode.modifyApp.duringLoad@@", true);
            break;
        case "query_type":
            chatInputContent = "@@aiag.appCreationMode.createApp@@";
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.conversation.c1@@", false);
            break;
        case "fetch_app":
            chatInputContent = "<div style='font-weight:bold; text-align: center; border-radius: 1em; padding: 0.8em; background-color: var(--theme-header-color-1); color: var(--theme-label-color-1);'>@@aiag.appCreationMode.modifyApp.fetchApp@@</div>";
            chatInputContent += `<div style='width:fit-content; font-size:smaller; border-radius:0.8em; padding: 0.5em 0.8em; color: var(--theme-label-color-1); background-color: var(--theme-header-color-1);'>@@aiag.appCreationMode.modifyApp.fetchApp.appId@@</div><div>&#8226; ${modifyAppId}</div>`;
            chatInputContent += `<div style='width:fit-content; font-size:smaller; border-radius:0.8em; padding: 0.5em 0.8em; color: var(--theme-label-color-1); background-color: var(--theme-header-color-1);'>@@aiag.appCreationMode.modifyApp.fetchApp.appVersion@@</div><div>&#8226; ${modifyAppVersion}</div>`
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.appCreationMode.modifyApp.fetchApp.duringLoad@@", true);
            break;
        case "text_query":
            chatInputContent = "@@aiag.chatInputTitle.textQuery@@";
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.conversation.c2@@", false);
            break;
        case "file_query":
            chatInputContent = "@@aiag.chatInputTitle.fileQuery@@";
            typeWriter($(chatSection).find(".ai-status .text"), "@@aiag.conversation.c3@@", false);
            break;
        case "query_preprocess":
            processProposalQueryIsFile = false;
            if (previousStage == "enhance_query" || previousStage == "pii_masking") {
                chatInputContent = "@@aiag.continue@@";
            } else {
                chatInputContent = processProposalQuery;
            }
            break;
        case "enhance_query":
            chatInputContent = "@@aiag.chatInputTitle.enhanceQuery@@";
            break;
        case "pii_masking":
            chatInputContent = "@@aiag.chatInputTitle.piiMasking@@";
            break;
    }
    return chatInputContent;
}

// Called after each Chat is created. Updates the status message, next step, "currentStage", and "upcomingStage"
function concludeStep(message, nextSteps, showCorrection, showRegeneration, showRevert, upcoming_stage, chatSection, showAddForm) {

    if (message) {
        typeWriter($(chatSection).find(".ai-status .text"), message, false);
        // Get the current computed transform and opacity values
        const $logo = $(chatSection).find(".ai-status .logo");
        const computedStyle = window.getComputedStyle($logo[0]);
        const transform = computedStyle.transform;
        const opacity = computedStyle.opacity;
        // Apply these values as inline styles
        $logo.css({
            transform: transform,
            opacity: opacity,
        });
        $(chatSection).find(".ai-status .logo").removeClass("loading").addClass("stop-loading");
    }

    // If need to add Correction and Regenerate button for the current step
    if (showRevert) {
        // Clones the template suggestion button for correction
        var suggestionButtonRevert = $(".template.suggestion-button.revert").clone();
        $(suggestionButtonRevert).removeClass("template hide");
        // Adds and shows the suggestion button
        $(".gen-ai-section:not(.template) .suggestion-section").append(suggestionButtonRevert);
        setTimeout(() => {
            $(suggestionButtonRevert).addClass("fade-in");
        }, 100);
    }
    if (showAddForm) {
        if (passedFormDesign) {
            // Clones the template suggestion button for adding a Form
            var suggestionButtonAddForm = $(".template.suggestion-button.add-form-design").clone();
            $(suggestionButtonAddForm).removeClass("template hide");
            // Adds and shows the suggestion button
            $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.add-form-design").remove();
            $(".gen-ai-section:not(.template) .suggestion-section").append(suggestionButtonAddForm);
            setTimeout(() => {
                $(suggestionButtonAddForm).addClass("fade-in");
            }, 100);
        }
    }
    // If need to add Correction and Regenerate button for the current step
    if (showCorrection) {
        // Clones the template suggestion button for correction
        var suggestionButtonCorrection = $(".template.suggestion-button.correction").clone();
        $(suggestionButtonCorrection).removeClass("template hide");
        // Adds and shows the suggestion button
        $(".gen-ai-section:not(.template) .suggestion-section").append(suggestionButtonCorrection);
        setTimeout(() => {
            $(suggestionButtonCorrection).addClass("fade-in");
        }, 100);
    }

    if (showRegeneration) {
        // Clones the template suggestion button for regeneration
        var suggestionButtonRegeneration = $(".template.suggestion-button.regeneration").clone();
        $(suggestionButtonRegeneration).removeClass("template hide");
        // Adds and shows the suggestion button
        $(".gen-ai-section:not(.template) .suggestion-section .suggestion-button.regeneration").remove();
        $(".gen-ai-section:not(.template) .suggestion-section").append(suggestionButtonRegeneration);
        setTimeout(() => {
            $(suggestionButtonRegeneration).addClass("fade-in");
        }, 100);
    }

    if (nextSteps) {
        // Loops through the included next steps
        for (var i in nextSteps) {
            // Clones the template suggestion button
            var suggestionButtonNextStep = $(".template.suggestion-button.next-step").clone();
            $(suggestionButtonNextStep).removeClass("next-step hide");
            // Sets attributes for the suggestion button
            $(suggestionButtonNextStep).addClass(nextSteps[i].cssClass);
            $(suggestionButtonNextStep).find(".suggestion-button-text").text(nextSteps[i].label)
            $(suggestionButtonNextStep).removeClass("template");
            // Adds and shows the suggestion button
            $(".gen-ai-section:not(.template) .suggestion-section").append(suggestionButtonNextStep);
            setTimeout(() => {
                $(suggestionButtonNextStep).addClass("fade-in");
            }, 100);
        }
    }

    previousStage = currentStage;
    upcomingStage = upcoming_stage;
}

// Appends Chat Output for Process Design
function putProcessDesign(chatSection, xpdl, isFailed) {
    xmlString = xpdl;
    if (isFailed) {
        appendChatOutput(chatSection, { type: 'xpdl', content: xpdl, action: "" }, `@@aiag.failed.processDesign@@ - ${xpdl}`, "#dc4438", "fas fa-project-diagram", true);
    } else {
        appendChatOutput(chatSection, { type: 'xpdl', content: prettifyXml(xpdl), action: 'previewXpdl' }, getXpdlTitle(xpdl), "#dc4438", "fas fa-project-diagram", false);
    }
}

// Appends Chat Output for Form Design
function putFormDesign(chatSection, json, isFailed) {
    if (isFailed) {
        var error;
        if(currentStage == "add_forms_design"){
            error = "@@aiag.failed.error.addFormDesign@@";
        }else if(currentStage == "replace_form_design"){
            error = "@@aiag.failed.error.replaceFormDesign@@";
        }else if(currentStage == "remove_form_design"){
            error = "@@aiag.failed.error.removeFormDesign@@";
        }else{
            error = "@@aiag.failed.formDesign@@";
        }
        appendChatOutput(chatSection, { type: 'json', content: json, action: "" }, `${error} - ${json}`, "#3f84f4", "fas fa-file-alt", true);
    } else {
        jsonString = JSON.stringify(json);
        Object.keys(json).forEach((formKey) => {
            const formData = json[formKey];
            const formName = formData["form"]["properties"]["name"];
            const formId = formData["form"]["properties"]["id"];

            const label = `${formName} - ${formId}`;

            appendChatOutput(chatSection, { type: 'json', content: getForm(formData), action: 'previewForm', form_meta: {key: formKey, name: formName, id: formId} }, label, "#3f84f4", "fas fa-file-alt", false);
        });
    }
}

// Utility: Convert name to slug-style ID
function slugify(str) {
    return str
        .toLowerCase()
        .trim()
        .replace(/[^a-z0-9]+/g, '_')
        .replace(/^_+|_+$/g, '');
}


function getXpdlTitle(xpdl_string){
    var xml = $.parseXML(xpdl_string);
    var $xml = $(xml);
    var workflowProcessName = $xml.find("WorkflowProcess").attr("Name");
    return workflowProcessName;
}

// Returns one of the Form from the Form JSON in a string format with indentations
function getForm(obj) {
    return JSON.stringify(obj.form, null, 4);
}

function isLastStageFile(current_stage, stage, formData, textInputParamName) {
    return (
        (current_stage === stage) &&
        !formData.get(textInputParamName) &&
        formData.get("image_base_64_list") !== "[]"
    );
}

// Calls /workflow_design API
async function workflowDesign(current_stage) {
    if ((current_stage == "process_proposal" && lastProcessProposalIsFile) || (current_stage == "process_correction" && lastProcessCorrectionIsFile)) {
        isFileUploaded = true;
    }

    var imageBase64ListRaw = imageBase64List.map(imageBase64 => imageBase64.split("base64,")[1]);

    const formData = new FormData();
    formData.append('_a', 'workflowDesign');
    formData.append('user_id', userId);
    formData.append('session_id', sessionId);
    formData.append('stage_name', current_stage);
    formData.append('query', isFileUploaded ? "" : unescapePiiTags(processProposalQuery));
    formData.append('requested_changes', isFileUploaded ? "" : processCorrectionQuery);
    formData.append('image_base_64_list', isFileUploaded ? JSON.stringify(imageBase64ListRaw) : JSON.stringify([]));
    formData.append('check_transitions', true);
    formData.append('_awsModels', JSON.stringify(awsModels));

    try {
        lastProcessProposalIsFile = isLastStageFile(current_stage, "process_proposal", formData, "query");
        lastProcessCorrectionIsFile = isLastStageFile(current_stage, "process_correction", formData, "requested_changes");

        const request = $.ajax({
            type: "POST",
            data: formData,
            processData: false, // Prevent jQuery from converting FormData to string
            contentType: false, // Let browser set appropriate headers for FormData
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            dataType: "json"
        });

        ajaxRequestObjectList.push(request);
        const response = await request;

        if (discontinueApiCalls) {
            return;
        }

        // If API call involved file upload, reset the flag
        if (isFileUploaded) {
            isFileUploaded = false;
        }

        if (response.status) {
            const generateOrderedList = (items) => items.map((item, index) => `<li>${index + 1}. ${item}</li>`).join('');
            const generateUnorderedList = (items) => items.map(item => `<li>&#8226; ${item}</li>`).join('');
            const isEmptyResponse = (condition) => condition ? true : false;

            let formattedResult;
            switch (current_stage) {
                case "process_proposal":
                    formattedResult = isEmptyResponse(!response.proposed_process?.length) ? "" : `<b>@@aiag.processProposal@@</b><ol style="padding-left:16px;margin-top:8px;margin-bottom:0px;padding-inline-start:0px!important;display:flex;flex-direction:column;gap:8px">${generateOrderedList(response.proposed_process)}</ol>`;
                    break;
                case "forms_and_participants":
                    formattedResult = isEmptyResponse(!response.forms?.length && !response.participants?.length) ? "" : `<b>@@aiag.forms@@</b><ul style="padding-inline-start:initial;margin-top:8px;margin-bottom:16px">${generateUnorderedList(response.forms)}</ul><b>@@aiag.participants@@</b><ul style="padding-inline-start:initial;margin-top:8px;margin-bottom:0px">${generateUnorderedList(response.participants)}</ul>`;
                    break;
                case "transitions_and_business_activities":
                    formattedResult = isEmptyResponse(!response.process_xpdl?.length) ? "" : response.process_xpdl;
                    break;
                case "forms_design":
                    formattedResult = isEmptyResponse(Object.keys(response.joget_designed_forms).length == 0) ? "" : response.joget_designed_forms;
                    break;
                case "process_correction":
                    var processProposalResult;
                    var formsAndParticipantsResult;
                    if (isEmptyResponse(!response.proposed_process?.length)) {
                        processProposalResult = "";
                    } else {
                        processProposalResult = `<b>@@aiag.processProposal@@</b><ol style="padding-left:16px;margin-top:8px;margin-bottom:0px;padding-inline-start:0px!important;display:flex;flex-direction:column;gap:8px">${generateOrderedList(response.proposed_process)}</ol>`;
                    }
                    if (isEmptyResponse(!response.forms?.length) || isEmptyResponse(!response.participants?.length)) {
                        formsAndParticipantsResult = "";
                    } else {
                        formsAndParticipantsResult = `
                            <b>@@aiag.forms@@</b>
                            <ul style="padding-inline-start:initial;margin-top:8px;margin-bottom:16px">${generateUnorderedList(response.forms)}</ul>
                            <b>@@aiag.participants@@</b>
                            <ul style="padding-inline-start:initial;margin-top:8px;margin-bottom:0px">${generateUnorderedList(response.participants)}</ul>
                        `;
                    }
                    formattedResult = new Map().set("processCorrection", {
                        processProposalResult,
                        formsAndParticipantsResult
                    });
                    break;
            }

            return new Map([
                ['result', formattedResult],
                ['status', true]
            ]);
        } else {
            return new Map([
                ['result', response.message],
                ['status', false]
            ]);
        }
    } catch (error) {
        console.error("AJAX request failed:", error);
        if (discontinueApiCalls) {
            return;
        }
        return new Map([
            ['result', error.responseJSON?.message || "@@aiag.error@@"],
            ['status', false]
        ]);
    }
}

// Decreases the height of Input Section as the suggestion buttons does not occupies too much height
function setInputBoxHalfHeight(ignoreSuggestionSection) {
    $(".gen-ai-section:not(.template) .input-section").css("gap", "");
    $(".gen-ai-section:not(.template) .input-section").css("flex-direction", "column");
    $(".gen-ai-section:not(.template) .input-section").css("padding", "0px");
    $(".gen-ai-section:not(.template) .input-section").css("transition", "height 0.1s ease");
    $(".gen-ai-section:not(.template) .input-section").css("height", "6%");
    $(".gen-ai-section:not(.template) .input-section").css("box-shadow", "none");
    $(".gen-ai-section:not(.template) .chat-scroll-view").css("height", "94%");
    $(".gen-ai-section:not(.template) .input-section .input-box").addClass("hide");
    $(".gen-ai-section:not(.template) .input-section .drop-zone").addClass("hide");
    $(".gen-ai-section:not(.template) .input-section .action-buttons-container").addClass("hide");
    $(".gen-ai-section:not(.template) .action-button.input.cancel").addClass("hide"); // Hides the cancel button
    if (!ignoreSuggestionSection) {
        setTimeout(() => {
            $(".gen-ai-section:not(.template) .input-section .suggestion-section").removeClass("hide");
        }, 100);
        setTimeout(() => {
            $(".gen-ai-section:not(.template) .input-section .suggestion-section").css("opacity", "1");
        }, 150);
    }
}

// Increases the height of Input Section as the <textarea> needs a fair amount of height for better typing experience 
function setInputBoxFullHeight() {
    $(".gen-ai-section:not(.template) .input-section").css("gap", "1em");
    $(".gen-ai-section:not(.template) .input-section").css("flex-direction", "row");
    $(".gen-ai-section:not(.template) .input-section .suggestion-section").addClass("hide");
    $(".gen-ai-section:not(.template) .input-section .suggestion-section").css("opacity", "0");
    $(".gen-ai-section:not(.template) .suggestion-section-for-remove-form-design").addClass("hide");
    $(".gen-ai-section:not(.template) .input-section").css("padding", "16px");
    $(".gen-ai-section:not(.template) .input-section").css("transition", "height 0.1s ease");
    $(".gen-ai-section:not(.template) .input-section").css("height", "21%");
    $(".gen-ai-section:not(.template) .input-section").css("box-shadow", "0px 0px 4px 2px var(--theme-border-color-1)");
    $(".gen-ai-section:not(.template) .chat-scroll-view").css("height", "79%");
    $(".gen-ai-section:not(.template) .input-section .input-box").removeClass("hide");
    $(".gen-ai-section:not(.template) .input-section .action-buttons-container").removeClass("hide");
    $(".gen-ai-section:not(.template) .action-button.input.cancel").removeClass("hide");
}

function scrollChatScrollViewDown() {
    var scrollHeight = $('.gen-ai-section:not(.template) .chat-scroll-view')[0].scrollHeight;
    $('.gen-ai-section:not(.template) .chat-scroll-view').animate({ scrollTop: scrollHeight }, 100);
}

function scrollPreviewBoxCodeTop() {
    $('.gen-ai-section:not(.template) .preview-box .code').scrollTop(0);
}

// Initializes the user_id and session_id
function initUserAndSessionId() {
    var uuid = generateUUID();
    userId = uuid;
    sessionId = uuid;

    // Saving the userId and sessionId in the form data also to use it later on while saving document in DB
    $("#createApp").data("userId", userId);
    $("#createApp").data("sessionId", sessionId);
}

// Click event for the "Correction" button
$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.correction', function () {

    $(".gen-ai-section:not(.template) .conversation-section .help-section").css("opacity", "0");
    scrollChatScrollViewDown();
    $(".gen-ai-section:not(.template) .action-button.input.file-upload").removeClass("hide"); // Shows the file upload action button while correction
    $(".gen-ai-section:not(.template) .input-section .uploaded-file-box").removeClass("hide");
    $(".gen-ai-section:not(.template) .action-button.input").removeClass("query add-form-design replace-form-design").addClass("correction"); // Changes the send button background color to purple
    $(".gen-ai-section:not(.template) .input-box").attr("placeholder", "@@aiag.processCorrectionPlaceholder@@").removeClass("query add-form-design replace-form-design").addClass("correction"); // Changes the placeholder message and text color to purple
    setInputBoxFullHeight();
    $(".gen-ai-section:not(.template) .input-section .action-buttons-container .dropdown-enhancement").addClass("hide");
    $(".gen-ai-section:not(.template) .input-section .action-buttons-container .action-button.input.send").addClass("correction").removeClass("add-form-design query");
});

// Click event for the "Regenerate" button
$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.regeneration', function () {
    hidePreviewSection();
    scrollChatScrollViewDown();
    $('.chat-output').find(".box").removeClass("selected"); // Removes grey background color from a Chat Output that is currently selected to avoid confusion since the user is regenerating the step
    discontinueApiCalls = false;
    createChat(true);
});

// Click event for the cancel button that appears beside the <textarea> during Correction Mode
$(document).on('click', '.gen-ai-section:not(.template) .action-button.input.cancel', function () {
    if (isFileUploaded) {
        hideUploadedFileContainer();
        $(".gen-ai-section:not(.template) .input-box").removeClass("hide");
        isFileUploaded = false;
    }
    $(".chat-output.file-box .indicator").addClass("hide").removeClass("replace-form-design");

    $(".gen-ai-section:not(.template) .input-section .input-box").val("");

    $(".gen-ai-section:not(.template) .conversation-section .help-section").removeClass("hide");
    setTimeout(() => {
        $(".gen-ai-section:not(.template) .conversation-section .help-section").css("opacity", "1");
    }, 150);


    setInputBoxHalfHeight();
});

// Click event for the resize button in the Preview section
$(document).on('click', '.gen-ai-section:not(.template) .action-button.preview-size', function () {
    hidePreviewContainer();
});

function hidePreviewContainer() {
    $('.preview-section').addClass("hide");
    $('.preview-section-container').css("width", "0%");
    $(".chat-output").find(".box").removeClass("selected");
}

// Click event for selectable Chat Output (e.g. Process Design, Form Design)
$(document).on('click', '.chat-output .box.selectable', function () {
    if (!$(this).hasClass("failed")) {
        scrollPreviewBoxCodeTop();
        previewData($(this));
    }
});

// Click event for Visualize button to visualize the Process Design or Form Design
$(document).on('click', '.gen-ai-section:not(.template) .action-button.preview-option.visualize', function () {
    // Show the Visualize view instead of Code view
    $('.gen-ai-section:not(.template) .preview-box').find('.visualize').removeClass("hide");
    $('.gen-ai-section:not(.template) .preview-box').find('.code').addClass("hide");
    // Makes Visualize button as the currently selected one
    $(".gen-ai-section:not(.template) .action-button.preview-option.visualize").addClass("selected");
    $(".gen-ai-section:not(.template) .action-button.preview-option.code").removeClass("selected");
});

// Click event for Code button to view the code of Process Design or Form Design
$(document).on('click', '.gen-ai-section:not(.template) .action-button.preview-option.code', function () {
    if (getCookie("isVisualizationLoaded")) {
        clearInterval(isVisualizationLoadedInterval);
        // Show the Code view instead of Visualize view
        $('.gen-ai-section:not(.template) .preview-box').find('.code').removeClass("hide");
        $('.gen-ai-section:not(.template) .preview-box').find('.visualize').addClass("hide");
        // Makes Code button as the currently selected one
        $(".gen-ai-section:not(.template) .action-button.preview-option.code").addClass("selected");
        $(".gen-ai-section:not(.template) .action-button.preview-option.visualize").removeClass("selected");
    }
});

$(document).on('click', '.attempts-controller .left', function () {
    var chatSection = $(this).closest(".chat-section");
    var attemptsCounter = $(this).next();
    var currentAttempt = $(attemptsCounter).find(".current-attempt").text();
    var farEnd = false;
    if (currentAttempt != 1) {
        currentAttempt--;
    }else{
        farEnd = true;
    }
    showChatOutputList(chatSection, currentAttempt, farEnd);
});

$(document).on('click', '.attempts-controller .right', function () {
    var chatSection = $(this).closest(".chat-section");
    var attemptsCounter = $(this).prev();
    var currentAttempt = $(attemptsCounter).find(".current-attempt").text();
    var farEnd = false;
    if (currentAttempt != $(chatSection).find(".chat-output-list").length) {
        currentAttempt++;
    }else{
        farEnd = true
    }
    showChatOutputList(chatSection, currentAttempt, farEnd);
});

// Click event for the button that creates the app
$(document).on('click', '.action-button.close-joget-ai-designer, .suggestion-button.create-app', function () {
    $(mainBodyHeader).find(".close-section").remove();
    // $(mainBodyHeader).find(".genai-ui-header-title").contents().unwrap();
    $(mainBodyHeader).find(".genai-ui-header-title").remove();
    $(mainBodyHeader).text("@@console.app.create.label@@");
    $(mainBodyHeader).css({
        "display": "",
        "padding-top": "",
        "padding-bottom": "",
        "justify-content": "",
        "align-items": ""
    });
    resetWindow();
    // Closes the Joget AI Designer interface
    newMainBodyContent.addClass("hide");
    mainBodyContent.removeClass("hide");
    popupBody.removeClass("genai-ui");
    $(".refresh-data").trigger("change"); // Saves the generated Process XPDL and Form JSON
    if ($(this).hasClass("create-app")) {
        // Update the message after the app is created
        $(".launch-joget-ai-designer-message .title").text("@@aiag.ready@@");
        $(".launch-joget-ai-designer-message .description").text('@@aiag.saveMsg@@');
    }
    // Hides the error
    $(aiGeneratorContainerParent).find(".property-input-error").addClass("hide");
});

// Click event for the button that lets user to proceed to the next step of app generation
$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.next-step', function () {
    if (currentStage != "process_proposal" && currentStage != "forms_and_participants") {
        hidePreviewSection();
    }
    scrollChatScrollViewDown();
    $(".chat-output").find(".box").removeClass("selected"); // Removes grey background color from a Chat Output that is currently selected to avoid confusion since the user is proceeding with the next step
    currentStage = upcomingStage;
    discontinueApiCalls = false;
    createChat(false);
});

$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.revert', function () {
    $(".chat-section").eq(-1).remove();
    previousStage = $(".chat-section").eq(-1).find(".chat-input").attr("previous-stage");
    currentStage = $(".chat-section").eq(-1).find(".chat-input").attr("current-stage");
    $(".chat-section").eq(-1).remove();
    createChat(false);
});

// Click event for the button that lets user to proceed to the next step of app generation
$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.skip-query-preprocess', function () {
    scrollChatScrollViewDown();
    discontinueApiCalls = false;
    currentStage = "process_proposal";
    createChat(false);
});

$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.continue-query-preprocess', function () {
    scrollChatScrollViewDown();
    discontinueApiCalls = false;
    if (previousStage == "enhance_query") {
        processProposalQuery = processProposalQueryEnhanced;
    } else if (previousStage == "pii_masking") {
        processProposalQuery = processProposalQueryMasked;
    }
    currentStage = upcomingStage;
    createChat(false);
});

function showInputTooltip(message, isError = true) {
    const tooltip = $('.gen-ai-section:not(.template) #inputTooltip');
    const inputBox = $('.gen-ai-section:not(.template) .input-box');
    const inputSection = $('.gen-ai-section:not(.template) .input-section'); // ADD THIS LINE
    const sendButton = $('.gen-ai-section:not(.template) .action-button.input.query.send');
    
    // Set tooltip message
    tooltip.text(message);
    
    // Add error styling if needed
    if (isError) {
        tooltip.addClass('error');
        inputBox.addClass('error');
        inputSection.addClass('error'); // ADD THIS LINE - Makes input-section border red
        sendButton.addClass('pulse');
    } else {
        tooltip.removeClass('error');
        inputBox.removeClass('error');
        inputSection.removeClass('error'); // ADD THIS LINE
        sendButton.removeClass('pulse');
    }
    
    // Show tooltip
    tooltip.addClass('show');
    
    // Focus on input box
    inputBox.focus();
    
    // Auto-hide after 3 seconds
    setTimeout(() => {
        hideInputTooltip();
    }, 3000);
}

function hideInputTooltip() {
    const tooltip = $('.gen-ai-section:not(.template) #inputTooltip');
    const inputBox = $('.gen-ai-section:not(.template) .input-box');
    const inputSection = $('.gen-ai-section:not(.template) .input-section');
    const sendButton = $('.gen-ai-section:not(.template) .action-button.input.query.send');
    
    tooltip.removeClass('show error');
    inputBox.removeClass('error');
    inputSection.removeClass('error');
    sendButton.removeClass('pulse');
}

// Hide tooltip when user starts typing
$(document).on('input', '.gen-ai-section:not(.template) .input-box', function() {
    if ($(this).val().trim() !== "") {
        hideInputTooltip();
    }
});

// Hide tooltip when user clicks elsewhere
$(document).on('click', function(e) {
    if (!$(e.target).closest('.gen-ai-section:not(.template) .input-section').length) {
        hideInputTooltip();
    }
});

$(document).on('click', '.gen-ai-section:not(.template) .action-button.input.query.send', function () {
    const inputValue = $(".gen-ai-section:not(.template) .input-box").val().trim();
    const wordCount = inputValue.trim().split(/\s+/).length;

    // CHECK FOR EMPTY INPUT - THIS IS THE NEW PART
    if (inputValue === "" && !isFileUploaded) {
        // Show tooltip for empty input
        showInputTooltip("@@aiag.pleaseEnterMessage@@", true);
        return; // Stop execution here
    }

    if(wordCount < 5){
        // Store the short query flag for later use
        window.isQueryTooShort = true;
        window.shortQueryMessage = "@@aiag.tooltip.enhanceQuery@@";
    } else {
        // Reset the flag if query is long enough
        window.isQueryTooShort = false;
    }

    if (inputValue !== "" || isFileUploaded) {
        lastProcessProposalIsFile = false;
        if (isFileUploaded) {
            currentStage = "before_process_proposal";
            processProposalQueryImageBase64 = imageBase64List[0];
        }
        if(isProcessProposalPromptOnEdit){
            initUserAndSessionId();
            // Only some things are needed but im not really sure.. better to relook
            $(".edit-prompt-button").find(".fa-pencil").removeClass("hide");
            $(".edit-prompt-button").find(".fa-times").addClass("hide");
            chatOutputMap = new Map();
            upcomingStage = "";
            processProposalQuery = "";
            previousStage = "";
            currentStage = "process_proposal";
            currentChatSectionId = "";
            passedFormDesign = false;
            $(".gen-ai-section:not(.template) .input-section .suggestion-section").addClass("hide");
            $(".gen-ai-section:not(.template) .input-section .action-buttons-container").removeClass("hide");
            $(".gen-ai-section:not(.template) .input-section .action-buttons-container .action-button.input.send").addClass("query").removeClass("correction add-form-design");
            $(".gen-ai-section:not(.template) .input-section .action-buttons-container .dropdown-enhancement").removeClass("hide");
            setInputBoxFullHeight();
            $(".gen-ai-section:not(.template) .action-button.input.cancel").addClass("hide");
            $(".gen-ai-section:not(.template) .preview-options-section").addClass("not-visible");
            $(".gen-ai-section:not(.template) .preview-box").addClass("hide");
            $(".gen-ai-section:not(.template) .preview-resize-section").addClass("hide");
            $(".gen-ai-section:not(.template) .action-button.input.file-upload").removeClass("hide").addClass("query").removeClass("correction add-form-design");
            $(".gen-ai-section:not(.template) .action-button.input").addClass("query").removeClass("correction add-form-design");
            $(".gen-ai-section:not(.template) .action-button.input").addClass("query").removeClass("correction add-form-design");
            $(".gen-ai-section:not(.template) .input-box").addClass("query").removeClass("correction add-form-design");
            $(".gen-ai-section:not(.template) .input-box").attr("placeholder", "@@aiag.processProposalPlaceholder@@").addClass("query").removeClass("correction add-form-design");
            $(".gen-ai-section:not(.template) .chat-sections-container").html("");
            isProcessProposalPromptOnEdit = false;
        }
        discontinueApiCalls = false;
        setInputBoxHalfHeight();
        processProposalQuery = escapePiiTags($(".gen-ai-section:not(.template) .input-box").val());
        $(".gen-ai-section:not(.template) .input-box").val("");
        
        // Hide tooltip if it was showing
        hideInputTooltip();
        
        discontinueApiCalls = false;
        createChat(false);
    }
});

// Click event for the send button after the user makes corrections for any step
$(document).on('click', '.gen-ai-section:not(.template) .action-button.input.correction.send', function () {
    // If not an empty value
    if ($(".gen-ai-section:not(.template) .input-box").val().trim() != "" || isFileUploaded) {
        lastProcessCorrectionIsFile = false;
        if (isFileUploaded) {
            processProposalCorrectionImageBase64 = imageBase64List[0];
        }
        hidePreviewSection();
        $(".chat-output").find(".box").removeClass("selected");
        scrollChatScrollViewDown()
        setInputBoxHalfHeight();
        currentStage = "process_correction";
        processCorrectionQuery = $(".gen-ai-section:not(.template) .input-box").val();
        $(".gen-ai-section:not(.template) .input-box").val("");
        discontinueApiCalls = false;
        createChat(false);
    }
});

// Click event for the close button for the file in Input Section
$(document).on('click', '.gen-ai-section:not(.template) .uploaded-file-container .close-button', function () {
    hideUploadedFileContainer();
    if (passedFormDesign) {
        $(".gen-ai-section:not(.template) .input-box").removeClass("hide");
        $(".gen-ai-section:not(.template) .uploaded-file-box").html("").addClass("hide");
    }
    imageBase64List = [];
    isFileUploaded = false;
    var inputSection = $(".gen-ai-section:not(.template)").find(".input-section");
    if ($(inputSection).find(".input-box").hasClass("add-form-design") || $(inputSection).find(".input-box").hasClass("replace-form-design")) {
        $(inputSection).find(".drop-zone").addClass("hide");
    }
});

// Click event for the button to upload an file
$(document).on('click', '.gen-ai-section:not(.template) .drop-zone, .gen-ai-section:not(.template) .action-button.input.file-upload', function () {
    $("#file-upload").click(); // Trigger click for #file-upload
});

// Listens to changes in the <input type="file">
$(document).on('change', '#file-upload', function () {
    // Check if an file is uploaded
    var fileInput = $("#file-upload")[0]; // Get the file input element
    if (fileInput.files && fileInput.files[0]) {
        var file = fileInput.files[0];

        // Size limit check: 2MB
        if (file.size > 2 * 1024 * 1024) {
            showInputTooltip("@@aiag.pleaseUploadFile@@", true);
            fileInput.value = "";
            return;
        }

        fileName = file.name;
        if(file.type == "application/pdf"){
            var reader = new FileReader();
            reader.onload = function () {
                var typedarray = new Uint8Array(this.result);
                pdfjsLib.getDocument({ data: typedarray }).promise.then(async function (pdf) {
                    imageBase64List = [];
        
                    for (let i = 1; i <= pdf.numPages; i++) {
                        let page = await pdf.getPage(i);
                        let canvas = document.createElement("canvas");
                        let context = canvas.getContext("2d");
                        let viewport = page.getViewport({ scale: 2 });
        
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;
        
                        await page.render({ canvasContext: context, viewport: viewport }).promise;
                        let base64String = canvas.toDataURL("image/png");
                        imageBase64List.push(base64String);
                    }
        
                    if (imageBase64List.length > 0) {
                        // Clone the file container template
                        var uploadedFileContainer = $(".template.uploaded-file-container").clone();
                        uploadedFileContainer.removeClass("template hide");
                        $(uploadedFileContainer).find(".uploaded-file").attr("src", imageBase64List[0]);
                        $(".gen-ai-section:not(.template) .drop-zone").addClass("hide");
                        $(".gen-ai-section:not(.template) .uploaded-file-box").html(uploadedFileContainer).removeClass("hide");
                        $(".gen-ai-section:not(.template) .input-box").val("").addClass("hide");
                    }
                });
            };
            reader.readAsArrayBuffer(file);

        }else if(file.type.startsWith("image/")){
            var reader = new FileReader();
            reader.onload = function (e) {
                var img = new Image();
                img.src = e.target.result;
                img.onload = function () {
                    var canvas = document.createElement("canvas");
                    var ctx = canvas.getContext("2d");
        
                    canvas.width = img.width;
                    canvas.height = img.height;
                    ctx.drawImage(img, 0, 0);
        
                    // Convert to PNG
                    var pngBase64 = canvas.toDataURL("image/png");
        
                    imageBase64List = [pngBase64];
        
                    // Clone the file container template
                    var uploadedFileContainer = $(".template.uploaded-file-container").clone();
                    uploadedFileContainer.removeClass("template hide");
                    $(uploadedFileContainer).find(".uploaded-file").attr("src", imageBase64List[0]);
        
                    $(".gen-ai-section:not(.template) .drop-zone").addClass("hide");
                    $(".gen-ai-section:not(.template) .uploaded-file-box").html(uploadedFileContainer).removeClass("hide");
                    $(".gen-ai-section:not(.template) .input-box").val("").addClass("hide");
                };
            };
            reader.readAsDataURL(file);
        }
        // Reset the file input element so the change event will trigger even if the same file is selected
        fileInput.value = "";
        isFileUploaded = true;
    }
});

$(document).on('dragover', '.gen-ai-section:not(.template) #drop-zone', function (e) {
    e.preventDefault();
    $(".gen-ai-section:not(.template) .drop-zone").addClass('dragover');
});

$(document).on('dragleave', '.gen-ai-section:not(.template) #drop-zone', function () {
    $(".gen-ai-section:not(.template) .drop-zone").removeClass('dragover');
});

$(document).on('drop', '.gen-ai-section:not(.template) #drop-zone', function (e) {
    e.preventDefault();
    $(".gen-ai-section:not(.template) .drop-zone").removeClass('dragover');
    // Check if an file is uploaded
    var fileInput = e.originalEvent.dataTransfer; // Get the file input element
    if (fileInput.files && fileInput.files[0]) {
        var file = fileInput.files[0];
        fileName = file.name;
        if(file.type == "application/pdf"){
            var reader = new FileReader();
            reader.onload = function () {
                var typedarray = new Uint8Array(this.result);
                pdfjsLib.getDocument({ data: typedarray }).promise.then(async function (pdf) {
                    imageBase64List = [];
        
                    for (let i = 1; i <= pdf.numPages; i++) {
                        let page = await pdf.getPage(i);
                        let canvas = document.createElement("canvas");
                        let context = canvas.getContext("2d");
                        let viewport = page.getViewport({ scale: 2 });
        
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;
        
                        await page.render({ canvasContext: context, viewport: viewport }).promise;
                        let base64String = canvas.toDataURL("image/png");
                        imageBase64List.push(base64String);
                    }
        
                    if (imageBase64List.length > 0) {
                        // Clone the file container template
                        var uploadedFileContainer = $(".template.uploaded-file-container").clone();
                        uploadedFileContainer.removeClass("template hide");
                        $(uploadedFileContainer).find(".uploaded-file").attr("src", imageBase64List[0]);
                        $(".gen-ai-section:not(.template) .drop-zone").addClass("hide");
                        $(".gen-ai-section:not(.template) .uploaded-file-box").html(uploadedFileContainer).removeClass("hide");
                        $(".gen-ai-section:not(.template) .input-box").val("").addClass("hide");
                    }
                });
            };
            reader.readAsArrayBuffer(file);
        }else if(file.type.startsWith("image/")){
            var reader = new FileReader();
            reader.onload = function (e) {
                imageBase64List = [e.target.result];
                // Clone the file container template 
                var uploadedFileContainer = $(".template.uploaded-file-container").clone();
                uploadedFileContainer.removeClass("template hide");
                $(uploadedFileContainer).find(".uploaded-file").attr("src", imageBase64List[0])
                $(".gen-ai-section:not(.template) .drop-zone").addClass("hide");
                $(".gen-ai-section:not(.template) .uploaded-file-box").html(uploadedFileContainer).removeClass("hide");
                $(".gen-ai-section:not(.template) .input-box").val("");
                $(".gen-ai-section:not(.template) .input-box").addClass("hide");
            };
            reader.readAsDataURL(file);
        }
        // Reset the file input element so the change event will trigger even if the same file is selected
        fileInput.value = "";
        isFileUploaded = true;
    }
});

// Click event for the button that leads to the GenAI view 
$(document).on('click', '.action-button.gen-ai', function () {
    // If the button is not made to be unclickable
    if (!$(this).hasClass("disable")) {
        showGenAiView();
    }
});

// Basically hides everything inside the Preview section
function hidePreviewSection() {
    $(".gen-ai-section:not(.template) .preview-options-section").addClass("not-visible");
    $(".gen-ai-section:not(.template) .preview-box").addClass("hide");
    $(".gen-ai-section:not(.template) .preview-resize-section").addClass("hide");
}

function hideUploadedFileContainer() {
    $(".gen-ai-section:not(.template) .drop-zone").removeClass("hide");
    $(".gen-ai-section:not(.template) .uploaded-file-box").html("").addClass("hide");
}

// Switches to GenAI view
function showGenAiView() {
    $(".genaiview-ai-service").val(currentAiServiceString.properties.aiService).trigger("change");
    $(".action-button.reset:not(.template)").removeClass("hide");
    $(".service-selector-container:not(.template)").removeClass("hide");
    // Switches the button so it will lead to Configuration view again
    $(".action-button.config").removeClass("hide");
    $(".action-button.gen-ai").addClass("hide").closest(".parent").addClass("hide");
    $(".gen-ai-section:not(.template)").removeClass("hide"); // Shows the GenAI view
    $(".config-section:not(.template)").addClass("hide"); // Hides the Configuration view
    // If the user haven't started the conversation
    if ($(".gen-ai-section:not(.template) .chat-section").length == 0) {
        currentStage = "app_creation_mode";
        createChat(false);
    }
}

function escapePiiTags(text) {
    // Escape HTML-like tags to prevent them from being interpreted as actual HTML
    var escapedText = text
        .replace(/</g, "&lt;")
        .replace(/>/g, "&gt;");
    return escapedText;
}

function unescapePiiTags(text) {
    var unescapedText = text
        .replace(/&lt;/g, "<")
        .replace(/&gt;/g, ">");
    return unescapedText;
}

// Generates UUID. Used for user_id and session_id
function generateUUID() {
    function S4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    }
    return (
        S4() + S4() + "-" +
        S4() + "-" +
        S4() + "-" +
        S4() + "-" +
        S4() + S4() + S4()
    );
}

// Formats the XPDL string so it looks presentable when the user previews it
function prettifyXml(sourceXml) {
    var xmlDoc = new DOMParser().parseFromString(sourceXml, 'application/xml');
    var xsltDoc = new DOMParser().parseFromString([
        '<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform">',
        '  <xsl:strip-space elements="*"/>',
        '  <xsl:template match="para[content-style][not(text())]">',
        '    <xsl:value-of select="normalize-space(.)"/>',
        '  </xsl:template>',
        '  <xsl:template match="node()|@*">',
        '    <xsl:copy><xsl:apply-templates select="node()|@*"/></xsl:copy>',
        '  </xsl:template>',
        '  <xsl:output indent="yes"/>',
        '</xsl:stylesheet>',
    ].join('\n'), 'application/xml');
    var xsltProcessor = new XSLTProcessor();
    xsltProcessor.importStylesheet(xsltDoc);
    var resultDoc = xsltProcessor.transformToDocument(xmlDoc);
    var resultXml = new XMLSerializer().serializeToString(resultDoc);
    return resultXml;
}

// Generates a unique ID for Chat Output. When Chat Output for Process Design or Form Design is generated, the XPDL string or Form jSON is stored in a map and the ID is used to retrieve it
function generateUniqueId() {
    const randomPart = Math.random().toString(36).substr(2, 9);
    const timestampPart = Date.now().toString(36);
    return `${timestampPart}${randomPart}`;
}

// << TYPING EFFECT FUNCTION >>

function typeWriter(element, text, isBlink, interval = 0) {
    const elementId = element[0];
    if (!typeWriterQueue[elementId]) {
        typeWriterQueue[elementId] = Promise.resolve();
    }
    typeWriterQueue[elementId] = typeWriterQueue[elementId]
        .then(() => {
            return new Promise((resolve) => {
                $(element).removeClass("blink");
                $(element).removeClass("fade-in");
                $(element).text("");
                let currentIndex = 0;
                const typeNextChar = () => {
                    if (currentIndex < text.length) {
                        $(element).append(text.charAt(currentIndex));
                        currentIndex++;
                        setTimeout(typeNextChar, 20);
                    } else {
                        setTimeout(() => {
                            if (isBlink) {
                                $(element).addClass("blink");
                            }
                            $(element).addClass("fade-in");
                            resolve();
                        }, 100);
                    }
                };

                typeNextChar();
            });
        })
        .then(() => {
            return new Promise((resolve) => {
                setTimeout(resolve, interval);
            });
        });
    return typeWriterQueue[elementId]; // Return the promise chain
}
// << TYPING EFFECT FUNCTION >>

$(document).on('click', '.card-button', function () {
    var chatOutput = $(this).closest(".box");
    previousStage = currentStage;
    currentStage = $(chatOutput).attr("button-id");
    createChat(false);
});

// Set cookie. Used to track which tooltip is closed
function setCookie(name, value) {
    const date = new Date();
    date.setTime(date.getTime() + (100 * 365 * 24 * 60 * 60 * 1000)); // Set expiration to 100 years
    const expires = "; expires=" + date.toUTCString();
    document.cookie = name + "=" + (value || "") + expires + "; path=/";
}

// Get stored cookie. Used to track which tooltip is closed
function getCookie(name) {
    const nameEQ = name + "=";
    const ca = document.cookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) === ' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
}

$(document).on('click', '.gen-ai-section:not(.template) .suggestion-section .suggestion-button.fetch-app', function () {
    modifyAppId = $('.gen-ai-section:not(.template) .app-id-selector').val();
    modifyAppVersion = $('.gen-ai-section:not(.template) .app-version-selector').val();
    previousStage = "modify_app";
    currentStage = "fetch_app";
    createChat(false);
});

//
//
//

$(document).on('change', '.gen-ai-section:not(.template) .app-id-selector', function () {
    $(".gen-ai-section:not(.template) .app-version-selector").empty();
    var selectedAppId = $(this).val();
    appData[selectedAppId].forEach(value => {
        var option = $("<option></option>").text(value).val(value);
        $(".gen-ai-section:not(.template) .app-version-selector").append(option);
    });
});

async function jogetFormToForms(json_string){
    const params = {
        '_a': 'jogetFormToForms',
        'user_id': userId,
        'session_id': sessionId,
        'json_string': JSON.stringify(json_string),
        'stage_name': "jogetFormToForms"
    };
    try {
        const request = $.ajax({
            type: "POST",
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            data: params,
            dataType: "json"
        });
        const response = await request;
        return response;
    } catch (error) {
        console.error("AJAX request failed:", error);
    }
}

async function xpdlToYaml(xpdl_string){
    const params = {
        '_a': 'xpdlToYaml',
        'user_id': userId,
        'session_id': sessionId,
        'xpdl_string': xpdl_string,
    };
    try {
        const request = $.ajax({
            type: "POST",
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            data: params,
            dataType: "json"
        });
        const response = await request;
        return response;
    } catch (error) {
        console.error("AJAX request failed:", error);
    }
}

async function getAppData(appId, appVersion){
    const params = {
        '_a': 'getAppData',
        '_appId': appId,
        '_appVersion': appVersion,
        'user_id': userId,
        'session_id': sessionId,
        'stage_name': "getAppData",
    };
    try {
        const request = $.ajax({
            type: "POST",
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            data: params,
            dataType: "json"
        });
        const response = await request;
        return response;
    } catch (error) {
        console.error("AJAX request failed:", error);
    }
}

async function getAppIds(){
    const params = {
        '_a': 'getAppIds'
    };
    try {
        const request = $.ajax({
            type: "POST",
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            data: params,
            dataType: "json"
        });
        const response = await request;
        return response;
    } catch (error) {
        console.error("AJAX request failed:", error);
    }
}

async function getAppVersions(appId){
    const params = {
        '_a': 'getAppVersions',
        '_appId': appId
    };
    try {
        const request = $.ajax({
            type: "POST",
            url: `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`,
            data: params,
            dataType: "json"
        });
        const response = await request;
        return response;
    } catch (error) {
        console.error("AJAX request failed:", error);
    }
}

// Sets up Joget AI Designer
initUserAndSessionId();

var generationSection = $(".template.gen-ai-section").clone();
$(generationSection).removeClass("template hide");

$(generationSection).find(".visualize").attr("name", "visualize-iframe");

$(".template.joget-ai-designer").append(generationSection);