function showAlert(message, type = "info") {
  alert(`[${type.toUpperCase()}] ${message}`);
}

$("#createApp").on("submit", async function (event) {
  event.preventDefault();

  const backendUrl = `${UI.base}/web/json/plugin/org.joget.ai.designer.AiDesigner/service`;
  const $form = $(this);

  // Value optional so that we can show error
  const appId = $("#id").val()?.trim();
  const appName = $("#name").val()?.trim();

  const userId = $form.data("userId");
  const sessionId = $form.data("sessionId");

  if (!appId || !appName) {
    showAlert(`@@aiag.createApp.detailsMissing@@`, "error");
    $.unblockUI();
    return;
  }

  // Validate appId uniqueness BEFORE creation
  try {
    const validationFormData = new FormData();
    validationFormData.append("appId", appId);
    validationFormData.append("_a", "validateUniqueAppId");

    const validateResponse = await fetch(backendUrl, {
      method: "POST",
      body: validationFormData,
    });

    if (!validateResponse.ok) {
      showAlert(`@@aiag.createApp.validateAppIdFailed@@`, "error");
      $.unblockUI();
      return;
    }

    const validationResult = await validateResponse.json();
    const isAppIdUnique = validationResult.isUnique;

    if (!isAppIdUnique) {
      showAlert(`@@aiag.createApp.appIdExists@@`, "warning");
      $.unblockUI();
      return;
    }

    // Proceed to create the app
    const creationFormData = new FormData();
    creationFormData.append("appId", appId);
    creationFormData.append("appName", appName);
    creationFormData.append("user_id", userId);
    creationFormData.append("session_id", sessionId);
    creationFormData.append("_a", "createApp");

    const creationResponse = await fetch(backendUrl, {
      method: "POST",
      body: creationFormData,
    });

    if (!creationResponse.ok) {
      showAlert(`@@aiag.createApp.appCreationFailed@@`, "error");
      $.unblockUI();
      return;
    }
    $form.off("submit").submit(); // Unbind event to prevent recursion
  } catch (err) {
    console.error(`@@aiag.createApp.unexpectedError@@`, ": ", err);
    showAlert(`@@aiag.createApp.unexpectedError@@`, "error");
    $.unblockUI();
    return;
  }
});
