var aiGeneratorContainerParent;
var newMainBodyContent;
var popupBody;
var mainBodyHeader;
var mainBodyContent;

// Click event for the button to launch Joget AI Designer
$(document).on('click', '.launch-joget-ai-designer-button', function () {  
    $(".gen-ai-section:not(.template) .input-box.query").attr("placeholder", `@@aiag.processProposalPlaceholder@@`);
    var closeSection = $(".template.close-section").clone();
    closeSection.removeClass("template hide");
    $(mainBodyHeader).append(closeSection);
    // Wrapping "Design New App" text with <span>
    $(mainBodyHeader).contents().filter(function() {
        return this.nodeType === 3; // Node type 3 is for text nodes
    }).wrap(`<span class="genai-ui-header-title"></span>`);

    var jogetLogo = $(".template.joget.logo").clone();
    jogetLogo.removeClass("template hide");
    $(mainBodyHeader).find(".genai-ui-header-title").text("@@aiag.jogetAIDesigner@@")
    $(mainBodyHeader).find(".genai-ui-header-title").prepend(jogetLogo);

    maxWindow();
    // Opens the Joget AI Designer interface
    mainBodyContent.addClass("hide");
    newMainBodyContent.removeClass("hide");
    popupBody.addClass("genai-ui");
    // If API Server is not configured yet
    if(apiServerConfigString.properties.apiServerUrl == ""){
        $(".config-section:not(.template) #api-server-url").val("@@aiag.defaultApiServerUrl@@");
        $(".config-section:not(.template) .tab-button.ai-service-config").addClass("disable"); // Makes the AI Service configuration tab button to be unclickable since API Server is not configured yet
        $(".config-section:not(.template) .tab-button.api-server-config").trigger("click"); // Programmatically clicks on the API Server configuration tab button to show the tab
        $(".action-button.gen-ai").addClass("disable"); // Makes the button that shows the GenAI view to become unclickable because app generation is not possible without doing configurations
        showConfigurationView();
    }else{
        // If no AI Service is selected yet
        if(currentAiServiceString.properties.aiService == ""){
            $(".config-section:not(.template) .tab-button.ai-service-config").trigger("click"); // Programmatically clicks on the AI Service configuration tab button to show the tab
            $(".action-button.gen-ai").addClass("disable"); // Makes the button that shows the GenAI view to become unclickable because app generation is not possible without doing configurations
            showConfigurationView();
        }
        // When API Server and AI Service is configured
        else{
            showGenAiView();
        }
    }
});


// Click event for the button to download Process Enhancement Plugin
$(document).on('click', '.download-process-enhancement-button', function () {
    // Open the plugin download page or marketplace
    var downloadUrl = "https://marketplace.joget.org/jw/web/userview/mp/mpp/_/vad?id=process_enhancement-7.0-PREVIEW";
    
    // Open in new tab/window
    window.open(downloadUrl, '_blank');
});

function maxWindow() {
    $(mainBodyHeader).addClass("ai-designer-main-body-header");
    var iframe = $(parent.document).find('iframe#jqueryDialogFrame');
    maxIframe(iframe);
    $(parent.document).find('.ui-dialog-titlebar').hide();
    
    var topIframe = $(top.document).find('iframe#quickOverlayFrame');
    if ($(topIframe).length > 0) {
        maxIframe(topIframe);
        $(top.document).find("#quickOverlayButton").hide();
    }
}

function resetWindow() {
    $(mainBodyHeader).removeClass("ai-designer-main-body-header");
    var iframe = $(parent.document).find('iframe#jqueryDialogFrame');
    resetIframe(iframe);
    $(parent.document).find('.ui-dialog-titlebar').show();
    
    var topIframe = $(top.document).find('iframe#quickOverlayFrame');
    if ($(topIframe).length > 0) {
        resetIframe(topIframe);
        $(top.document).find("#quickOverlayButton").show();
    }
}

function maxIframe(iframe) {
    // Store original styles
    var originalStyles = {
        width: iframe.css('width'),
        height: iframe.css('height'),
        position: iframe.css('position'),
        top: iframe.css('top'),
        left: iframe.css('left'),
        border: iframe.css('border'),
        zIndex: iframe.css('z-index'),
        "background-color" : iframe.css('background-color')
    };
    iframe.data("originalStyles", originalStyles);
    
    // Set the iframe size to match the parent's window size
    iframe.css({
        width: '100vw',
        height: '100vh',
        position: 'fixed',
        top: 0,
        left: 0,
        border: 'none', // remove border for seamless integration
        zIndex: 9999, // ensure it appears above other elements
        "background-color" : '#ffffff'
    });
}

function resetIframe(iframe) {
    var originalStyles = iframe.data("originalStyles");
    
    // reset the iframe style
    iframe.css(originalStyles);
}