{
    "resources" : %s,
    "currentAiServiceString" : %s,
    "myAiServicesString" : %s,
    "apiServerConfigString" : %s,
    "myPiiMaskingRulesConfigString" : %s,
    // getData is a default function, you can check inside jw-community to see other JS file that are using this too
    "getData" : function() {
        var data = new Object();
        data[this.properties.name] = "data";
        data["xml"] = xmlString;
        data["json"] = jsonString;
        data["modifyAppMode"] = isModifyAppMode;
        data["modifyAppId"] = modifyAppId;
        data["modifyAppVersion"] = modifyAppVersion;
        return data;
    },
    // renderField is a default function, you can check inside jw-community to see other JS file that are using this too
    "renderField": function() {
        // Setting the "id" of the "id-holder" <div> with the this.id, this is important for some reason 
        let parser = new DOMParser();
        let doc = parser.parseFromString(this.resources.LauncherPage.ftl.LauncherButton, "text/html");
        let idHolder = doc.querySelector(".id-holder");
        if (idHolder) {
            idHolder.id = this.id;
        }
        this.resources.LauncherPage.ftl.LauncherButton = doc.body.innerHTML;
        // Setting the resources
        var css = this.getCssResources();
        var ftl = this.getFtlResources();
        var javascript = this.getJsResources();
        // Return the resources
        return css + ftl + javascript;
    },
    // Gets FTL templates of all features
    "getFtlResources": function(){
        var ftl = `
        ${this.resources.LauncherPage.ftl.LauncherButton}\n
        ${this.resources.LauncherPage.ftl.LauncherPage}\n
        ${this.resources.GenerationPage.ftl}\n
        ${this.resources.ConfigurationPage.ftl}\n
        ${this.resources.AddFormDesign.ftl}\n
        ${this.resources.ReplaceRemoveFormDesign.ftl}\n
        ${this.resources.AiServiceQuickSwitch.ftl}\n
        ${this.resources.RestartProgress.ftl}\n
        ${this.resources.QueryPreprocess.ftl}\n
        ${this.resources.EditQuery.ftl}
        `;
        return ftl;
    },
    // Gets CSS styling of all features
    "getCssResources": function(){
        var css = `
        <style>
        ${this.resources.Global.css}\n
        ${this.resources.LauncherPage.css}\n
        ${this.resources.GenerationPage.css}\n
        ${this.resources.ConfigurationPage.css}\n
        ${this.resources.AddFormDesign.css}\n
        ${this.resources.ReplaceRemoveFormDesign.css}\n
        ${this.resources.AiServiceQuickSwitch.css}\n
        ${this.resources.RestartProgress.css}\n
        ${this.resources.QueryPreprocess.css}\n
        ${this.resources.EditQuery.css}
        </style>
        `;
        return css;
    },
    // Gets JavaScript of all features
    "getJsResources": function(){
        var js = `
        ${this.resources.Global.js}\n
        <script>
        ${this.getCustomVariables()}\n
        ${this.resources.LauncherPage.js}\n
        ${this.resources.LauncherPage.Capturejs}\n
        ${this.resources.GenerationPage.js}\n
        ${this.resources.ConfigurationPage.js}\n
        ${this.resources.AddFormDesign.js}\n
        ${this.resources.ReplaceRemoveFormDesign.js}\n
        ${this.resources.AiServiceQuickSwitch.js}\n
        ${this.resources.RestartProgress.js}\n
        ${this.resources.QueryPreprocess.js}\n
        ${this.resources.EditQuery.js}
        </script>
        `;
        return js;
    },
    // Getting the variables defined in this file to be sent and used at the plugin side
    "getCustomVariables" : function(){
        var variables = "";
        variables += `var currentAiServiceString = ${JSON.stringify(this.currentAiServiceString)};\n`;
        variables += `var myAiServicesString = ${JSON.stringify(this.myAiServicesString)};\n`;
        variables += `var apiServerConfigString = ${JSON.stringify(this.apiServerConfigString)};\n`;
        variables += `var myPiiMaskingRulesConfigString = ${JSON.stringify(this.myPiiMaskingRulesConfigString)};\n`;
        return variables;
    },
    // initScripting is a default function, you can check inside jw-community to see other JS file that are using this too
    "initScripting": function(){
        var thisObj = this;
        // Basically appends the Joget AI Designer interface inside "Design New App" window
        var aiGeneratorContainer = $("#" + thisObj.id).closest('.ai_generator_container');
        // Removes the gray frame around the launch button
        var pluginConfigEditorContainer = aiGeneratorContainer.closest('.pluginConfigEditor');
        $(pluginConfigEditorContainer).css("border", "none");
        $(pluginConfigEditorContainer).css("padding", "15px 0px");
        // Removes the gray underline from the launch button
        var propertyContainer = aiGeneratorContainer.closest('.property-editor-property-container');
        $(propertyContainer).css("border-bottom","0px");
        mainBodyContent = aiGeneratorContainer.closest("#main-body-content");
        mainBodyHeader = mainBodyContent.prev();
        popupBody = mainBodyContent.closest(".popupBody");
        var mainBodyContentParent = mainBodyContent.parent();
        newMainBodyContent = $("<div></div>");
        newMainBodyContent.attr("id", "main-body-content").addClass("ai-designer-main-body-content");
        newMainBodyContent.addClass("hide scrollbar-width-none");
        var jogetAiDesigner = $(".template.joget-ai-designer").clone();
        $(".template.joget-ai-designer").remove();
        jogetAiDesigner.removeClass("template hide");
        newMainBodyContent.append(jogetAiDesigner);
        mainBodyContentParent.append(newMainBodyContent);
        aiGeneratorContainerParent = $(aiGeneratorContainer).closest('.property-input');
        // Changes layout
        $(aiGeneratorContainerParent).css("width", "100%%");
        $(aiGeneratorContainerParent).css("margin-left", "0px");
        // Removes label
        $(aiGeneratorContainerParent).prev().remove();
    }

}
