<div id="config-container">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>${css}</style>

    <div class="config-wrapper">
        <!-- Header -->
        <header class="config-header">
            <div class="config-header-title">
                <i class="fas fa-cog"></i>
                AI Designer Central Configuration
            </div>
            <div class="config-header-subtitle">
                Configure your AI services and preferences for the AI Designer
            </div>
        </header>

        <!-- Main Content -->
        <div class="config-content">
            <!-- Tab Navigation -->
            <div class="tab-navigation">
                <button type="button" class="tab-button active" data-tab="api-server">
                    <i class="fas fa-plug"></i> API Server
                </button>
                <button type="button" class="tab-button disabled" data-tab="ai-services">
                    <i class="fas fa-robot"></i> AI Services
                </button>
                <button type="button" class="tab-button" data-tab="pii-masking">
                    <i class="fas fa-user-secret"></i> PII Masking
                </button>
            </div>

            <div class="main-content">
                <!-- Tab 1: API Server Configuration -->
                <div class="tab-content active" id="api-server-tab">
                    <div class="tab-description">
                        <p>Configure your AI Designer API server connection. This is required before you can manage AI services.</p>
                    </div>
                    <div class="config-section">
                        <h3 class="section-title">
                            <i class="fas fa-plug"></i> 
                            API Server Configuration
                        </h3>
                        <div class="form-group">
                            <label for="api-server-url">API Server URL</label>
                            <input type="text" id="api-server-url" class="form-input" 
                                placeholder="@@aiag.defaultApiServerUrl@@" 
                                value="">
                            <small class="form-help">The base URL for your AI service API server</small>
                        </div>
                        <div class="form-group">
                            <label for="api-server-key">API Server Key</label>
                            <div class="password-field">
                                <input type="password" id="api-server-key" class="form-input" 
                                    placeholder="Enter your API key">
                                <button type="button" class="password-toggle" id="toggle-server-key">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            <div class="key-actions">
                                <button type="button" class="btn btn-link" id="request-joget-key">
                                    <i class="fas fa-key"></i> Request for Joget Intelligence key
                                </button>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="api-config-actions">
                                <button type="button" class="btn btn-outline" id="test-connection">
                                    <i class="fas fa-plug"></i> Test Connection
                                </button>
                                <button type="button" class="btn btn-primary" id="save-config">
                                    <i class="fas fa-save"></i> Save Configuration
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab 2: AI Services Management -->
                <div class="tab-content" id="ai-services-tab">
                    <div class="tab-description">
                        <p>Manage your AI services and select which one to use for AI Designer operations.</p>
                    </div>
                    <!-- Current Service Selection -->
                    <div class="config-section">
                        <h3 class="section-title">
                            <i class="fas fa-robot"></i> 
                            Current AI Service
                        </h3>
                        <div class="form-group">
                            <label for="current-service">Active Service</label>
                            <select id="current-service" class="form-select">
                                <option value="">Select a service...</option>
                            </select>
                            <small class="form-help">Choose which AI service to use for AI Designer operations</small>
                        </div>
                    </div>

                    <!-- AI Services Management -->
                    <div class="config-section">
                        <div class="section-header">
                            <h3 class="section-title">
                                <i class="fas fa-list"></i> 
                                Manage AI Services
                            </h3>
                            <div class="section-actions">
                                <button type="button" class="btn btn-primary btn-sm" id="add-service">
                                    <i class="fas fa-plus"></i> Add Service
                                </button>
                            </div>
                        </div>

                        <div class="services-list" id="services-list">
                            <!-- Services will be populated dynamically -->
                            <div class="empty-state" id="services-empty-state">
                                <i class="fas fa-robot"></i>
                                <h3>No AI Services Configured</h3>
                                <p>Configure your API server first, then add AI services to get started.</p>
                                <p>Click "Add Service" to create your first AI service configuration.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tab 3: PII Masking -->
                <div class="tab-content" id="pii-masking-tab">
                    <div class="tab-description">
                        <p>Configure PII (Personally Identifiable Information) masking rules to protect sensitive data in your queries.</p>
                    </div>
                    
                    <!-- Add PII Rule Section -->
                    <div class="config-section">
                        <h3 class="section-title">
                            <i class="fas fa-plus"></i> 
                            Add PII Masking Rule
                        </h3>
                        <div class="form-group">
                            <label for="pii-rule-input">PII Masking Rule</label>
                            <div class="form-input-group">
                                <input type="text" id="pii-rule-input" class="form-input" 
                                    placeholder="Enter a PII masking rule (e.g., email addresses, phone numbers)">
                                <button type="button" class="btn btn-primary btn-sm" id="add-pii-rule">
                                    <i class="fas fa-plus"></i> Add Rule
                                </button>
                            </div>
                            <small class="form-help">Define patterns or types of data that should be masked in queries</small>
                        </div>
                    </div>

                    <!-- PII Rules List Section -->
                    <div class="config-section">
                        <div class="section-header">
                            <h3 class="section-title">
                                <i class="fas fa-list"></i> 
                                Current PII Masking Rules
                            </h3>
                        </div>

                        <div class="pii-rules-list" id="pii-rules-list">
                            <!-- PII rules will be populated dynamically -->
                            <div class="empty-state" id="pii-rules-empty-state">
                                <i class="fas fa-user-secret"></i>
                                <h3>No PII Masking Rules Configured</h3>
                                <p>Add PII masking rules to protect sensitive information in your queries.</p>
                                <p>Rules help identify and mask personal data like names, emails, and addresses.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Status messages will appear here (your latest change) -->
                <div class="config-status" id="config-status">
                    <!-- Status messages will appear here -->
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Add Service Modal with better error handling -->
    <div class="modal" id="add-service-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h4><i class="fas fa-plus"></i> Add New AI Service</h4>
                <button type="button" class="modal-close" id="close-modal">&times;</button>
            </div>
            <div class="modal-body">
                <div class="loading-state" id="modal-loading">
                    <i class="fas fa-spinner fa-spin"></i>
                    <p>Loading available AI services...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="cancel-service">Cancel</button>
                <button type="button" class="btn btn-primary" id="create-service">
                    <i class="fas fa-plus"></i> Create Service
                </button>
            </div>
        </div>
    </div>

    <!-- Edit Service Modal (NEW) -->
    <div class="modal" id="edit-service-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h4>
                    <i class="fas fa-edit"></i> 
                    Edit AI Service: <span id="edit-service-name">Service Name</span>
                </h4>
                <button type="button" class="modal-close" id="close-edit-modal">&times;</button>
            </div>
            <div class="modal-body">
                <!-- Error messages and dynamic form will be inserted here -->
                <div class="loading-state" id="edit-modal-loading">
                    <i class="fas fa-spinner fa-spin"></i>
                    <p>Loading service details...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="cancel-edit-service">Cancel</button>
                <button type="button" class="btn btn-primary" id="save-edit-service">
                    <i class="fas fa-save"></i> Save Changes
                </button>
            </div>
        </div>
    </div>
    <script>${js}</script>
</div>