/*
 * Decompiled with CFR 0.152.
 */
package org.joget.connector;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.dao.EnvironmentVariableDao;
import org.joget.apps.app.model.AbstractAppVersionedObject;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.model.CustomBuilder;
import org.joget.apps.app.model.CustomBuilderAbstract;
import org.joget.apps.app.model.EnvironmentVariable;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.apps.app.service.JsonApiUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.StringUtil;
import org.joget.connector.ApiConnectorExecutionException;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiConnectorBuilder
extends CustomBuilderAbstract
implements PluginWebSupport {
    Map<String, String> params = null;
    public static final String OUTPUT = "Output";
    public static final String OUTPUT_PROPRETY_OPTIONS = "Property Options";
    public static final String OUTPUT_EXECUTION = "Execute";
    public static final String OUTPUT_RESPONSE_OPTIONS = "Response Options";
    public static final String OUTPUT_SAMPLE_RESPONSE = "Sample Response";
    public static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";

    public String getName() {
        return "apiConnectorBuilder";
    }

    public String getObjectName() {
        return "api_connector";
    }

    public String getVersion() {
        return "8.0-BETA2";
    }

    public String getIcon() {
        return "fas fa-link";
    }

    public String getColor() {
        return "#ff5f00";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ApiConnectorBuilder");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ApiConnectorBuilder");
    }

    public String getObjectLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".code"), (String)this.getClassName(), (String)"messages/ApiConnectorBuilder");
    }

    public String getIdPrefix() {
        return "ac-";
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/apiConnectorBuilder/setting.json", null, (boolean)true, (String)"messages/ApiConnectorBuilder");
    }

    public String getBuilderConfig() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/apiConnectorBuilder/api_connector_builder.json", null, (boolean)false, (String)"messages/ApiConnectorBuilder");
    }

    public String getResourceBundlePath() {
        return "messages/ApiConnectorBuilder";
    }

    public String getBuilderJS(String contextPath, String buildNumber) {
        String html = "<script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.connector.ApiConnectorBuilder/static/js-yaml.min.js?build=" + this.getVersion() + buildNumber + "\"></script>";
        html = html + "<script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.connector.ApiConnectorBuilder/static/api_connector_builder.js?build=" + this.getVersion() + buildNumber + "\"></script>";
        return html;
    }

    public String getBuilderCSS(String contextPath, String buildNumber) {
        String css = "<link href=\"" + contextPath + "/plugin/org.joget.connector.ApiConnectorBuilder/static/api_connector_builder.css?build=" + this.getVersion() + buildNumber + "\" rel=\"stylesheet\" type=\"text/css\" />";
        return css;
    }

    public String getBuilderHTML(BuilderDefinition def, String json, HttpServletRequest request, HttpServletResponse response) {
        return "";
    }

    public void builderPreview(String json, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html; charset=utf-8");
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put(OUTPUT, OUTPUT_PROPRETY_OPTIONS);
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("propertyOptions", (String)this.getBuilderResult(json, config));
            String theme = WorkflowUtil.getSystemSetupValue((String)"systemTheme");
            model.put("theme", theme);
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            String html = CustomBuilderUtil.generateHtml((CustomBuilder)this, (String)"templates/preview.ftl", model, (HttpServletRequest)request);
            response.getWriter().write(html);
        }
        catch (Exception ex) {
            LogUtil.error((String)this.getClassName(), (Throwable)ex, (String)"");
        }
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
        if (!isAdmin) {
            response.sendError(401);
            return;
        }
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        String action = SecurityUtil.validateStringInput((String)request.getParameter("action"));
        if ("config".equals(action) || "outputOptions".equals(action)) {
            String id = SecurityUtil.validateStringInput((String)request.getParameter("value"));
            BuilderDefinition builderDefinition = builderDefinitionDao.loadById(id, appDef);
            if (builderDefinition != null) {
                String json = builderDefinition.getJson();
                HashMap<String, Object> config = new HashMap<String, Object>();
                if ("config".equals(action)) {
                    config.put(OUTPUT, OUTPUT_PROPRETY_OPTIONS);
                    String propertyOptions = (String)this.getBuilderResult(json, config);
                    response.getWriter().write(propertyOptions);
                } else if ("outputOptions".equals(action)) {
                    config.put(OUTPUT, OUTPUT_RESPONSE_OPTIONS);
                    String pluginConfig = request.getParameter("config");
                    config.put("pluginConfig", pluginConfig);
                    String responseOptions = (String)this.getBuilderResult(json, config);
                    response.getWriter().write(responseOptions);
                }
            }
        } else if ("selector".equals(action)) {
            response.addDateHeader("Expires", Long.MAX_VALUE);
            response.addHeader("Cache-Control", "private, max-age=9223372036854775807");
            response.getWriter().write(AppUtil.readPluginResource((String)this.getClassName(), (String)"/resources/static/apiSelector.js", null, (boolean)false, null));
        } else if ("options".equals(action)) {
            Collection builderDefinitionList = builderDefinitionDao.getBuilderDefinitionList(this.getObjectName(), null, appDef, "name", Boolean.valueOf(false), null, null);
            JSONArray jsonArray = new JSONArray();
            HashMap<String, String> blank = new HashMap<String, String>();
            blank.put("value", "");
            blank.put("label", "");
            jsonArray.put(blank);
            for (BuilderDefinition def : builderDefinitionList) {
                String name = def.getName();
                String description = this.getAttributeValue("description", def.getJson());
                String logo = this.getAttributeValue("logo", def.getJson());
                String html = "<block class=\"api_option\">";
                if (!logo.isEmpty()) {
                    logo = "background-image:url('" + logo + "');";
                    html = html + "<block class=\"logo\"><block style=\"" + logo + "\"></block></block>";
                } else {
                    html = html + "<block class=\"logo no_logo\"><i class=\"far fa-image fa-fw\"></i></block>";
                }
                html = html + "<block class=\"meta\"><span class=\"name\">" + StringUtil.escapeString((String)name, (String)"html") + "</span>";
                html = html + "<span class=\"desc\">" + StringUtil.escapeString((String)description, (String)"html") + "</span>";
                html = html + "</block></block>";
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("value", def.getId());
                data.put("label", html);
                jsonArray.put(data);
            }
            AppUtil.writeJson((Writer)response.getWriter(), (JSONArray)jsonArray, null);
        }
    }

    public Object getBuilderResult(String json, Map<String, Object> config) {
        String output = config.get(OUTPUT).toString();
        if (output != null && json != null && !json.isEmpty()) {
            try {
                JSONObject definition = new JSONObject(json);
                switch (output) {
                    case "Property Options": {
                        return this.generatePropertyOptions(definition);
                    }
                    case "Execute": {
                        return this.callApi(definition, config);
                    }
                    case "Response Options": {
                        return this.retrieveResponseOptions(definition, config);
                    }
                    case "Sample Response": {
                        return this.retrieveSampleResponse(definition, config);
                    }
                }
            }
            catch (Exception e) {
                if (e instanceof ApiConnectorExecutionException) {
                    throw (ApiConnectorExecutionException)e;
                }
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
        }
        return null;
    }

    public String retrieveResponseOptions(JSONObject definition, Map<String, Object> config) {
        try {
            JSONObject pathData;
            JSONObject pluginConfig;
            String pathId;
            JSONObject element;
            JSONArray options = new JSONArray();
            String pluginConfigString = (String)config.get("pluginConfig");
            if (definition != null && definition.has("elements") && (element = this.findApiPath(pathId = (pluginConfig = new JSONObject(pluginConfigString)).has("apiOperatorId") ? pluginConfig.getString("apiOperatorId") : "", definition)) != null && (pathData = element.getJSONObject("pathData")).has("responses")) {
                JSONObject responses = pathData.getJSONObject("responses");
                JSONObject schema = null;
                if (responses.has("200")) {
                    JSONObject code200 = responses.getJSONObject("200");
                    if (code200.has("content")) {
                        JSONObject responseContent = code200.getJSONObject("content");
                        schema = this.findContentSchema(responseContent, definition, null);
                    }
                    if (code200.has("headers")) {
                        JSONObject headers = code200.getJSONObject("headers");
                        Iterator keys = headers.keys();
                        while (keys.hasNext()) {
                            String k = keys.next().toString();
                            JSONObject option = new JSONObject();
                            option.put("value", (Object)k);
                            option.put("label", (Object)k);
                            options.put((Object)option);
                        }
                    }
                }
                if (schema != null) {
                    String prefix = "";
                    String ptype = schema.getString("type");
                    if ("array".equals(ptype) || !"object".equals(ptype)) {
                        prefix = "response";
                        JSONObject option = new JSONObject();
                        option.put("value", (Object)prefix);
                        option.put("label", (Object)prefix);
                        options.put((Object)option);
                    }
                    this.retrieveOptionsBySchema(options, schema, definition, prefix);
                }
            }
            return options.toString();
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return "[]";
        }
    }

    public String retrieveSampleResponse(JSONObject definition, Map<String, Object> config) {
        try {
            JSONObject pathData;
            String pathId;
            JSONObject apiPath;
            Map pluginConfig = (Map)config.get("properties");
            if (definition != null && definition.has("elements") && (apiPath = this.findApiPath(pathId = pluginConfig.containsKey("apiOperatorId") ? pluginConfig.get("apiOperatorId").toString() : "", definition)) != null && (pathData = apiPath.getJSONObject("pathData")).has("responses")) {
                JSONObject code200;
                JSONObject responses = pathData.getJSONObject("responses");
                JSONObject schema = null;
                if (responses.has("200") && (code200 = responses.getJSONObject("200")).has("content")) {
                    JSONObject responseContent = code200.getJSONObject("content");
                    schema = this.findContentSchema(responseContent, definition, null);
                }
                if (schema != null) {
                    Object example = this.getExampleBySchema(definition, schema, null);
                    if (!(example instanceof JSONObject)) {
                        JSONObject responseObject = new JSONObject();
                        responseObject.put("response", example);
                        return responseObject.toString();
                    }
                    return example.toString();
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return "{}";
    }

    public Object getExampleBySchema(JSONObject oas, JSONObject schema, String key) {
        String ptype;
        if (schema.has("$ref")) {
            schema = this.getSchemaByRef(oas, schema.getString("$ref"));
        }
        if ("object".equals(ptype = schema.getString("type")) && schema.has("properties")) {
            JSONObject example = new JSONObject();
            JSONObject objectProperties = schema.getJSONObject("properties");
            Iterator keys = objectProperties.keys();
            while (keys.hasNext()) {
                String k = keys.next().toString();
                example.put(k, this.getExampleBySchema(oas, objectProperties.getJSONObject(k), k));
            }
            return example;
        }
        if ("array".equals(ptype) && schema.has("items")) {
            JSONArray example = new JSONArray();
            example.put(this.getExampleBySchema(oas, schema.getJSONObject("items"), null));
            return example;
        }
        if ("string".equals(ptype)) {
            if (schema.has("description")) {
                return schema.getString("description");
            }
            if (key != null && !key.isEmpty()) {
                return key;
            }
            return "string";
        }
        if ("number".equals(ptype)) {
            return 1.0;
        }
        if ("integer".equals(ptype)) {
            return 1;
        }
        if ("boolean".equals(ptype)) {
            return true;
        }
        return new JSONObject();
    }

    public JSONObject findContentSchema(JSONObject content, JSONObject oas, Map<String, String> headers) {
        JSONObject schema = null;
        if (content != null) {
            JSONObject responseContent = null;
            if (content.has("application/json")) {
                if (headers != null) {
                    headers.put("Content-type", "application/json");
                }
                responseContent = content.getJSONObject("application/json");
            } else {
                Iterator keys = content.keys();
                if (keys.hasNext()) {
                    String type = (String)keys.next();
                    if (headers != null) {
                        headers.put("Content-type", type);
                    }
                    responseContent = content.getJSONObject(type);
                }
            }
            if (responseContent != null && responseContent.has("schema") && (schema = responseContent.getJSONObject("schema")).has("$ref")) {
                schema = this.getSchemaByRef(oas, schema.getString("$ref"));
            }
        }
        return schema;
    }

    public void retrieveOptionsBySchema(JSONArray options, JSONObject schema, JSONObject oas, String key) {
        String ptype;
        if (schema.has("$ref")) {
            schema = this.getSchemaByRef(oas, schema.getString("$ref"));
        }
        if ("object".equals(ptype = schema.getString("type")) && schema.has("properties")) {
            JSONObject objectProperties = schema.getJSONObject("properties");
            Iterator keys = objectProperties.keys();
            while (keys.hasNext()) {
                String name = (String)keys.next();
                JSONObject prop = objectProperties.getJSONObject(name);
                if (name.contains(".")) {
                    name = "{" + name + "}";
                }
                if (!key.isEmpty()) {
                    name = key + "." + name;
                }
                this.retrieveOptionsBySchema(options, prop, oas, name);
            }
        } else if ("array".equals(ptype) && schema.has("items")) {
            this.retrieveOptionsBySchema(options, schema.getJSONObject("items"), oas, key);
        } else {
            JSONObject option = new JSONObject();
            option.put("value", (Object)key);
            option.put("label", (Object)key);
            options.put((Object)option);
        }
    }

    public String generatePropertyOptions(JSONObject definition) {
        String result = null;
        if (definition != null && definition.has("elements")) {
            try {
                JSONArray propertyOptions = new JSONArray();
                JSONObject apiConectorProperties = definition.getJSONObject("properties");
                JSONObject page = new JSONObject();
                propertyOptions.put((Object)page);
                page.put("title", (Object)apiConectorProperties.getString("name"));
                JSONArray pageProperties = new JSONArray();
                page.put("properties", (Object)pageProperties);
                JSONObject selectOperation = this.createField("apiOperatorId", this.getMsg("apiConnectorBuilder.selectOperation"), "selectbox", null, null, true, null, null);
                JSONArray selectOperationOptions = new JSONArray();
                selectOperation.put("options", (Object)selectOperationOptions);
                pageProperties.put((Object)selectOperation);
                JSONArray elements = definition.getJSONArray("elements");
                for (int i = 0; i < elements.length(); ++i) {
                    String name;
                    JSONObject element = elements.getJSONObject(i);
                    JSONObject pathProperties = element.optJSONObject("properties");
                    JSONObject pathDetail = element.optJSONObject("pathData");
                    JSONArray sharedParameters = element.optJSONArray("sharedParameters");
                    String apiId = pathProperties.getString("id");
                    String string = name = pathProperties.has("name") ? pathProperties.getString("name") : "";
                    if (name.isEmpty() && pathDetail.has("summary")) {
                        name = pathDetail.getString("summary");
                    }
                    if (name.isEmpty()) {
                        name = "[" + element.getString("method").toUpperCase() + "] " + element.getString("path");
                    }
                    selectOperationOptions.put((Object)this.createOption(apiId, name));
                    this.renderPathFields(apiId, pageProperties, pathDetail, pathProperties, sharedParameters, definition);
                }
                result = propertyOptions.toString(4);
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
        }
        return result;
    }

    public void renderPathFields(String pathId, JSONArray pageProperties, JSONObject pathDetail, JSONObject pathSettings, JSONArray sharedParameters, JSONObject oas) {
        if (pathSettings.has("description")) {
            JSONObject field = this.createField(pathId + "_pathDescription", this.getMsg("apiConnectorBuilder.description"), "header", pathSettings.getString("description"), "", false, "apiOperatorId", pathId);
            pageProperties.put((Object)field);
        }
        if (pathDetail.has("parameters") && pathSettings.has("parameters")) {
            int i;
            JSONArray parameters = pathDetail.getJSONArray("parameters");
            JSONArray parametersSetting = pathSettings.getJSONArray("parameters");
            HashMap<String, JSONObject> parametersSettingMap = new HashMap<String, JSONObject>();
            for (i = 0; i < parametersSetting.length(); ++i) {
                JSONObject parameterSetting = parametersSetting.getJSONObject(i);
                parametersSettingMap.put(parameterSetting.getString("name"), parameterSetting);
            }
            for (i = 0; i < parameters.length(); ++i) {
                JSONObject parameter = parameters.getJSONObject(i);
                this.renderParameter(pathId, pageProperties, parameter, parametersSettingMap, oas, pathId + "_param_", null);
            }
        }
        if (sharedParameters != null && sharedParameters.length() > 0) {
            int i;
            JSONArray parametersSetting = pathSettings.getJSONArray("parameters");
            HashMap<String, JSONObject> parametersSettingMap = new HashMap<String, JSONObject>();
            for (i = 0; i < parametersSetting.length(); ++i) {
                JSONObject parameterSetting = parametersSetting.getJSONObject(i);
                parametersSettingMap.put(parameterSetting.getString("name"), parameterSetting);
            }
            for (i = 0; i < sharedParameters.length(); ++i) {
                JSONObject parameter = sharedParameters.getJSONObject(i);
                this.renderParameter(pathId, pageProperties, parameter, parametersSettingMap, oas, pathId + "_param_", null);
            }
        }
        if (pathDetail.has("requestBody")) {
            JSONObject requestBody = pathDetail.getJSONObject("requestBody");
            if (pathSettings.has("requestBodyType") && "fields".equals(pathSettings.getString("requestBodyType")) && pathSettings.has("requestBodyInputs")) {
                JSONObject schema = null;
                if (requestBody.has("content")) {
                    JSONObject requestBodyContent = requestBody.getJSONObject("content");
                    schema = this.findContentSchema(requestBodyContent, oas, null);
                }
                if (schema != null) {
                    JSONObject field = this.createField(pathId + "_header", this.getMsg("apiConnectorBuilder.requestBodyInputs"), "header", null, null, false, "apiOperatorId", pathId);
                    pageProperties.put((Object)field);
                    JSONArray parametersSetting = pathSettings.getJSONArray("requestBodyInputs");
                    HashMap<String, JSONObject> parametersSettingMap = new HashMap<String, JSONObject>();
                    for (int i = 0; i < parametersSetting.length(); ++i) {
                        JSONObject parameterSetting = parametersSetting.getJSONObject(i);
                        parametersSettingMap.put(parameterSetting.getString("name"), parameterSetting);
                    }
                    JSONObject objProperties = schema.getJSONObject("properties");
                    this.renderObjectParameter(pathId, pageProperties, objProperties, parametersSettingMap, oas, pathId + "_requestbody_", null);
                }
            } else {
                String description = requestBody.has("description") ? requestBody.getString("description") : "";
                String value = pathSettings.has("requestBody") ? pathSettings.getString("requestBody") : "";
                JSONObject field = this.createField(pathId + "_requestBody", this.getMsg("apiConnectorBuilder.requestBodyInputType.payload"), "codeeditor", description, value, true, "apiOperatorId", pathId);
                field.put("mode", (Object)"json");
                pageProperties.put((Object)field);
            }
        }
    }

    public void renderParameter(String pathId, JSONArray pageProperties, JSONObject parameter, Map<String, JSONObject> parameterSettingMap, JSONObject oas, String fieldPrefix, String prefix) {
        String description;
        if (prefix == null) {
            prefix = "";
        }
        if (parameter.has("$ref")) {
            parameter = this.mergeJSONObject(parameter, this.getSchemaByRef(oas, parameter.getString("$ref")));
        }
        String name = parameter.has("name") ? parameter.getString("name") : "";
        JSONObject parameterSetting = parameterSettingMap.get(prefix + name);
        if (parameterSetting == null) {
            parameterSetting = new JSONObject();
        }
        String mode = parameterSetting.has("mode") ? parameterSetting.getString("mode") : "";
        boolean required = "mandatory".equals(mode) || parameter.has("required") && parameter.getBoolean("required");
        String label = parameterSetting.has("customLabel") ? parameterSetting.getString("customLabel") : "";
        String string = description = parameter.has("description") ? parameter.getString("description") : "";
        if (label.isEmpty() && description.length() < 30) {
            label = description;
            description = null;
        }
        if (label.isEmpty()) {
            label = name;
        }
        String type = "textfield";
        JSONObject schema = null;
        if (parameter.has("type")) {
            schema = parameter;
        } else if (parameter.has("schema") && (schema = parameter.getJSONObject("schema")).has("$ref")) {
            schema = this.getSchemaByRef(oas, schema.getString("$ref"));
        }
        if (schema != null) {
            String value;
            String ptype = schema.getString("type");
            if ("boolean".equals(ptype)) {
                type = "checkbox";
            } else if ("string".equals(ptype) && schema.has("enum")) {
                type = "selectbox";
            } else {
                if ("object".equals(ptype)) {
                    if (schema.has("properties")) {
                        JSONObject objProperties = schema.getJSONObject("properties");
                        this.renderObjectParameter(pathId, pageProperties, objProperties, parameterSettingMap, oas, fieldPrefix, prefix + name + "_");
                    }
                    return;
                }
                if ("array".equals(ptype)) {
                    this.renderArrayParameter(pathId, pageProperties, schema, parameterSettingMap, oas, fieldPrefix, prefix, name, label, description, required);
                    return;
                }
            }
            if ("hide".equals(mode)) {
                type = "hidden";
            }
            String string2 = value = parameterSetting.has("defaultValue") ? parameterSetting.getString("defaultValue") : "";
            if (value.isEmpty()) {
                value = schema.has("default") ? schema.get("default").toString() : "";
            }
            JSONObject field = this.createField(fieldPrefix + prefix + name, label, type, description, value, required, "apiOperatorId", pathId);
            if ("boolean".equals(ptype)) {
                JSONArray options = new JSONArray();
                options.put((Object)this.createOption("true", ""));
                field.put("options", (Object)options);
            } else if ("string".equals(ptype) && schema.has("enum")) {
                JSONArray options = new JSONArray();
                JSONArray enumValues = schema.getJSONArray("enum");
                options.put((Object)this.createOption("", ""));
                for (int i = 0; i < enumValues.length(); ++i) {
                    String enumValue = enumValues.getString(i);
                    options.put((Object)this.createOption(enumValue, enumValue));
                }
                field.put("options", (Object)options);
            }
            pageProperties.put((Object)field);
        }
    }

    public void renderObjectParameter(String pathId, JSONArray pageProperties, JSONObject objectProperties, Map<String, JSONObject> parameterSettingMap, JSONObject oas, String fieldPrefix, String prefix) {
        Iterator keys = objectProperties.keys();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            JSONObject prop = objectProperties.getJSONObject(name);
            prop.put("name", (Object)name);
            this.renderParameter(pathId, pageProperties, prop, parameterSettingMap, oas, fieldPrefix, prefix);
        }
    }

    public void renderArrayParameter(String pathId, JSONArray pageProperties, JSONObject arrayProperties, Map<String, JSONObject> parameterSettingMap, JSONObject oas, String fieldPrefix, String prefix, String name, String label, String description, boolean required) {
        if (arrayProperties.has("items")) {
            JSONObject items;
            JSONObject schema = items = arrayProperties.getJSONObject("items");
            if (items.has("$ref")) {
                schema = this.getSchemaByRef(oas, items.getString("$ref"));
            }
            String ptype = schema.getString("type");
            String type = "grid";
            if ("object".equals(ptype)) {
                type = "repeater";
            }
            JSONObject field = this.createField(fieldPrefix + prefix + name, label, type, description, null, required, "apiOperatorId", pathId);
            if ("object".equals(ptype)) {
                JSONArray repeaterFields = new JSONArray();
                JSONObject objProperties = schema.getJSONObject("properties");
                this.renderObjectParameter(null, repeaterFields, objProperties, parameterSettingMap, oas, "", prefix + name + "_");
                field.put("fields", (Object)repeaterFields);
            } else {
                JSONObject column = new JSONObject();
                column.put("key", (Object)"value");
                column.put("label", (Object)this.getMsg("apiConnectorBuilder.value"));
                if ("number".equals(ptype) || "integer".equals(ptype)) {
                    column.put("type", (Object)"number");
                } else if ("boolean".equals(ptype)) {
                    column.put("type", (Object)"truefalse");
                } else if ("string".equals(ptype) && schema.has("enum")) {
                    JSONArray options = new JSONArray();
                    JSONArray enumValues = schema.getJSONArray("enum");
                    for (int i = 0; i < enumValues.length(); ++i) {
                        String enumValue = enumValues.getString(i);
                        options.put((Object)this.createOption(enumValue, enumValue));
                    }
                    column.put("options", (Object)options);
                }
                JSONArray columns = new JSONArray();
                columns.put((Object)column);
                field.put("columns", (Object)columns);
            }
            pageProperties.put((Object)field);
        }
    }

    public JSONObject getSchemaByRef(JSONObject data, String ref) {
        int index;
        if (ref.indexOf("#/") == 0) {
            ref = ref.substring(2);
        }
        if ((index = ref.indexOf("/")) != -1) {
            String name = ref.substring(0, index);
            ref = ref.substring(index + 1);
            return this.getSchemaByRef(data.getJSONObject(name), ref);
        }
        return data.getJSONObject(ref);
    }

    public JSONObject createField(String name, String label, String type, String description, String value, boolean required, String controlField, String controlValue) {
        JSONObject field = new JSONObject();
        field.put("name", (Object)this.removeSpecialChar(name));
        field.put("label", (Object)label);
        field.put("type", (Object)type);
        field.put("supportHash", (Object)"true");
        if (description != null && !description.isEmpty()) {
            field.put("description", (Object)description);
        }
        if (value != null && !value.isEmpty()) {
            field.put("value", (Object)value);
        }
        if (required) {
            field.put("required", (Object)"true");
        }
        if (controlField != null && controlValue != null) {
            field.put("control_field", (Object)controlField);
            field.put("control_value", (Object)controlValue);
            field.put("control_use_regex", (Object)"false");
        }
        return field;
    }

    public JSONObject createOption(String value, String label) {
        JSONObject option = new JSONObject();
        option.put("value", (Object)value);
        option.put("label", (Object)label);
        return option;
    }

    public String getPathId(String method, String path) {
        String id = method + "_" + path.replaceAll(StringUtil.escapeRegex((String)"/"), "_slash_");
        id = id.replaceAll(StringUtil.escapeRegex((String)"{"), "_ob_");
        id = id.replaceAll(StringUtil.escapeRegex((String)"}"), "_cb_");
        return id;
    }

    public String removeSpecialChar(String in) {
        return in.replaceAll("[^0-9a-zA-Z-_]", "");
    }

    public String callApi(JSONObject definition, Map<String, Object> config) throws Exception {
        try {
            this.params = (Map)config.get("params");
            HttpServletRequest httpRequest = WorkflowUtil.getHttpServletRequest();
            JSONObject apiConnectorProperties = definition.has("properties") ? definition.getJSONObject("properties") : new JSONObject();
            this.setProperty("debugMode", Boolean.toString(apiConnectorProperties.has("debugMode") && "true".equalsIgnoreCase(apiConnectorProperties.getString("debugMode"))));
            String serverUrl = this.getServerUrl(apiConnectorProperties);
            this.debug("Server URL :" + serverUrl);
            Map pluginProperties = (Map)config.get("properties");
            String pathId = pluginProperties.get("apiOperatorId").toString();
            this.debug("API PATH ID: " + pathId);
            JSONObject element = this.findApiPath(pathId, definition);
            if (element != null) {
                JSONObject pathSetting = element.has("properties") ? element.getJSONObject("properties") : new JSONObject();
                JSONObject pathData = element.getJSONObject("pathData");
                String path = element.getString("path");
                path = path.replaceAll("[\\{\\}]", "__");
                String method = element.getString("method");
                URIBuilder uriBuilder = new URIBuilder(serverUrl + path);
                HashMap<String, String> headers = new HashMap<String, String>();
                if (pathData.has("parameters")) {
                    this.populateParameters(pathId, pathData.getJSONArray("parameters"), pluginProperties, definition, uriBuilder, headers);
                }
                if (element.has("sharedParameters")) {
                    this.populateParameters(pathId, element.getJSONArray("sharedParameters"), pluginProperties, definition, uriBuilder, headers);
                }
                URI uri = uriBuilder.build();
                this.debug(uri.toString());
                this.handleSecurity(pathData, pluginProperties, apiConnectorProperties, definition, uriBuilder, headers);
                JSONObject payload = null;
                if (pathData.has("requestBody")) {
                    payload = this.getPayload(pathId, pathData, pathSetting, pluginProperties, definition, headers);
                }
                if (httpRequest != null) {
                    String referer = httpRequest.getRequestURL().toString();
                    headers.put("referer", referer);
                }
                HashSet<String> retrieveHeaders = new HashSet<String>();
                this.findResponseHeaderData(pathData, retrieveHeaders);
                return this.callApi(uri, method, payload, headers, retrieveHeaders);
            }
        }
        catch (Exception e) {
            if (e instanceof ApiConnectorExecutionException) {
                throw e;
            }
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return "";
    }

    public void findResponseHeaderData(JSONObject apiPath, Set<String> retrieveHeaders) {
        JSONObject code200;
        JSONObject responses;
        if (apiPath.has("responses") && (responses = apiPath.getJSONObject("responses")).has("200") && (code200 = responses.getJSONObject("200")).has("headers")) {
            JSONObject headers = code200.getJSONObject("headers");
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String k = keys.next().toString();
                retrieveHeaders.add(k);
            }
        }
    }

    public String callApi(URI uri, String method, JSONObject payload, Map<String, String> headers, Set<String> retrieveHeaders) throws Exception {
        CloseableHttpClient client = null;
        HttpPut request = null;
        try {
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            client = httpClientBuilder.build();
            HttpServletRequest httpRequest = WorkflowUtil.getHttpServletRequest();
            switch (method) {
                case "put": {
                    request = new HttpPut(uri);
                    break;
                }
                case "post": {
                    request = new HttpPost(uri);
                    break;
                }
                case "get": {
                    request = new HttpGet(uri);
                    break;
                }
                case "delete": {
                    request = new HttpDelete(uri);
                    break;
                }
                case "patch": {
                    request = new HttpPatch(uri);
                    break;
                }
                case "head": {
                    request = new HttpHead(uri);
                    break;
                }
                case "options": {
                    request = new HttpOptions(uri);
                    break;
                }
                case "trace": {
                    request = new HttpTrace(uri);
                }
            }
            if (!headers.isEmpty()) {
                for (String name : headers.keySet()) {
                    this.debug(name + " : " + headers.get(name));
                    request.setHeader(name, headers.get(name));
                }
            }
            if (payload != null) {
                this.debug(payload.toString());
                String contentType = headers.get("Content-type");
                if (contentType != null) {
                    if (contentType.toLowerCase().contains("json")) {
                        StringEntity requestEntity = new StringEntity(payload.toString(), "UTF-8");
                        ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)requestEntity);
                    } else if (contentType.toLowerCase().contains("x-www-form-urlencoded")) {
                        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                        Iterator keys = payload.keys();
                        while (keys.hasNext()) {
                            String name = (String)keys.next();
                            String value = payload.get(name).toString();
                            urlParameters.add(new BasicNameValuePair(name, value));
                        }
                        ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters, "UTF-8"));
                    }
                    this.debug(((HttpEntityEnclosingRequestBase)request).getEntity().toString());
                }
            }
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            this.debug(uri.toString() + " returned with status : " + response.getStatusLine().getStatusCode());
            String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() <= 299) {
                jsonResponse = this.wrapResponse(jsonResponse);
                if (!retrieveHeaders.isEmpty()) {
                    Header[] responseHeaders;
                    JSONObject result = new JSONObject(jsonResponse);
                    for (Header h : responseHeaders = response.getAllHeaders()) {
                        if (!retrieveHeaders.contains(h.getName())) continue;
                        result.put(h.getName(), (Object)h.getValue());
                    }
                    jsonResponse = result.toString();
                }
                this.debug(jsonResponse);
                String string = jsonResponse;
                return string;
            }
            throw new ApiConnectorExecutionException(jsonResponse);
        }
        finally {
            try {
                if (request != null) {
                    request.releaseConnection();
                }
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException ex) {
                LogUtil.error((String)JsonApiUtil.class.getName(), (Throwable)ex, (String)"");
            }
        }
    }

    public String wrapResponse(String jsonResponse) {
        if (jsonResponse != null && !jsonResponse.isEmpty()) {
            if ((jsonResponse = jsonResponse.trim()).startsWith("[") && jsonResponse.endsWith("]")) {
                jsonResponse = "{ \"response\" : " + jsonResponse + " }";
            } else if (!jsonResponse.startsWith("{") && !jsonResponse.endsWith("}")) {
                jsonResponse = "{ \"response\" : \"" + jsonResponse + "\" }";
            }
        }
        return jsonResponse;
    }

    public String getServerUrl(JSONObject properties) {
        String serverUrl;
        String string = serverUrl = properties.has("server") ? properties.getString("server") : "";
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        return this.fillVariables(serverUrl, this.jsonObjectToMap(properties), "variable_");
    }

    public JSONObject findApiPath(String pathId, JSONObject definition) {
        if (definition.has("elements")) {
            JSONArray elements = definition.optJSONArray("elements");
            for (int i = 0; i < elements.length(); ++i) {
                JSONObject element = elements.getJSONObject(i);
                if (!element.has("properties") || !pathId.equals(element.getJSONObject("properties").getString("id"))) continue;
                return element;
            }
        }
        return null;
    }

    public void handleSecurity(JSONObject apiPath, Map<String, Object> pluginProperties, JSONObject apiConnectorProperties, JSONObject oas, URIBuilder uriBuilder, Map<String, String> headers) {
        String authentication;
        String string = authentication = apiConnectorProperties.has("security_authentication") ? apiConnectorProperties.getString("security_authentication") : "";
        if (!authentication.isEmpty()) {
            String[] authTypes;
            JSONObject schemas = this.getSchemaByRef(oas, "#/components/securitySchemes");
            for (String authType : authTypes = authentication.split(";")) {
                if (schemas.has(authType)) {
                    try {
                        String type;
                        JSONObject schema = schemas.optJSONObject(authType);
                        String string2 = type = schema.has("type") ? schema.getString("type") : "";
                        if ("apiKey".equals(type)) {
                            String in;
                            String value = SecurityUtil.decrypt((String)(apiConnectorProperties.has("security_schema_" + authType) ? apiConnectorProperties.getString("security_schema_" + authType) : ""));
                            String name = schema.has("name") ? schema.getString("name") : "";
                            String string3 = in = schema.has("in") ? schema.getString("in") : "";
                            if ("query".equals(in)) {
                                uriBuilder.addParameter(name, value);
                                continue;
                            }
                            headers.put(name, value);
                            continue;
                        }
                        if ("http".equals(type)) {
                            String httpScheme;
                            String string4 = httpScheme = schema.has("scheme") ? schema.getString("scheme") : "";
                            if ("basic".equals(httpScheme)) {
                                String username = apiConnectorProperties.has("security_schema_" + authType + "_username") ? apiConnectorProperties.getString("security_schema_" + authType + "_username") : "";
                                String password = SecurityUtil.decrypt((String)(apiConnectorProperties.has("security_schema_" + authType + "_password") ? apiConnectorProperties.getString("security_schema_" + authType + "_password") : ""));
                                headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes("UTF-8")));
                                continue;
                            }
                            if (!"bearer".equals(httpScheme)) continue;
                            String token = SecurityUtil.decrypt((String)(apiConnectorProperties.has("security_schema_" + authType) ? apiConnectorProperties.getString("security_schema_" + authType) : ""));
                            headers.put("Authorization", "Bearer " + token);
                            continue;
                        }
                        if ("oauth2".equals(type)) {
                            String flow = apiConnectorProperties.has("security_schema_" + authType + "_flow") ? apiConnectorProperties.getString("security_schema_" + authType + "_flow") : "";
                            JSONObject flowAttrs = schema.getJSONObject("flows").optJSONObject(flow);
                            this.populateOauth2Token(authType, flow, flowAttrs, apiConnectorProperties, headers);
                            continue;
                        }
                        if (!"openIdConnect".equals(type)) continue;
                        this.populateOauth2Token(authType, "authorizationCode", schema, apiConnectorProperties, headers);
                    }
                    catch (Exception e) {
                        LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
                    }
                    continue;
                }
                LogUtil.info((String)this.getClassName(), (String)("Configured authentication " + authType + " not found!"));
            }
        }
        if (apiConnectorProperties.has("headers")) {
            JSONArray headersSetting = apiConnectorProperties.getJSONArray("headers");
            for (int i = 0; i < headersSetting.length(); ++i) {
                String value;
                JSONObject header = headersSetting.getJSONObject(i);
                String name = header.has("name") ? header.getString("name") : "";
                String string5 = value = header.has("value") ? header.getString("value") : "";
                if (name.isEmpty()) continue;
                headers.put(name, value);
            }
        }
        if (headers.containsKey("token") && headers.containsKey("api_id") && headers.containsKey("api_key")) {
            this.processJogetApiBuilderToken(headers);
        }
    }

    public void populateOauth2Token(String authType, String type, JSONObject flowAttrs, JSONObject apiConnectorProperties, Map<String, String> headers) {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            if (appDef != null) {
                String tokenUrl;
                String clientId = apiConnectorProperties.has("security_schema_" + authType + "_clientId") ? apiConnectorProperties.getString("security_schema_" + authType + "_clientId") : "";
                boolean isOpenIdConnect = flowAttrs.has("openIdConnectUrl");
                String string = tokenUrl = flowAttrs.has("tokenUrl") ? flowAttrs.getString("tokenUrl") : "";
                if (isOpenIdConnect) {
                    apiConnectorProperties.put("is_openId_connect", true);
                    tokenUrl = apiConnectorProperties.has("security_schema_" + authType + "_tokenEnpoint") ? apiConnectorProperties.getString("security_schema_" + authType + "_tokenEnpoint") : "";
                }
                JSONObject token = null;
                String tokenKey = authType + "_" + type + "_" + clientId;
                EnvironmentVariableDao environmentVariableDao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
                EnvironmentVariable env = (EnvironmentVariable)environmentVariableDao.loadById(tokenKey, appDef);
                if (env != null) {
                    token = new JSONObject(env.getValue());
                }
                if (token != null) {
                    SimpleDateFormat sdf;
                    boolean isExpired;
                    String expiresDate = token.has("expires_date") ? token.getString("expires_date") : "";
                    Date expirationDate = null;
                    if (!expiresDate.isEmpty() && (isExpired = (expirationDate = (sdf = new SimpleDateFormat(DATEFORMAT)).parse(expiresDate)).before(new Date()))) {
                        if (token.has("refresh_token")) {
                            String refreshUrl;
                            String string2 = refreshUrl = flowAttrs.has("refreshUrl") ? flowAttrs.getString("refreshUrl") : tokenUrl;
                            if (!refreshUrl.isEmpty()) {
                                apiConnectorProperties.put("refresh_token", (Object)token.getString("refresh_token"));
                                token = this.getToken(refreshUrl, type, clientId, authType, tokenKey, apiConnectorProperties, environmentVariableDao, env);
                            }
                        } else {
                            token = null;
                        }
                    }
                }
                if (!(token != null && token.has("access_token") || tokenUrl.isEmpty())) {
                    token = this.getToken(tokenUrl, type, clientId, authType, tokenKey, apiConnectorProperties, environmentVariableDao, env);
                }
                if (token != null) {
                    String tokenType = token.has("token_type") && "basic".equalsIgnoreCase(token.getString("token_type")) ? "Basic" : "Bearer";
                    String accessToken = token.has("access_token") ? token.getString("access_token") : "";
                    headers.put("Authorization", tokenType + " " + accessToken);
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Fail to populate OAuth2 token");
        }
    }

    public JSONObject getToken(String url, String type, String clientId, String authType, String tokenKey, JSONObject apiConnectorProperties, EnvironmentVariableDao environmentVariableDao, EnvironmentVariable env) throws Exception {
        if (!type.equals("clientCredentials") && !type.equals("authorizationCode")) {
            return null;
        }
        boolean isOpenIdConnect = apiConnectorProperties.has("is_openId_connect");
        if (url.startsWith("/")) {
            url = this.getServerUrl(apiConnectorProperties) + url;
        }
        Map<String, Object> prop = this.jsonObjectToMap(apiConnectorProperties);
        URIBuilder uriBuilder = new URIBuilder(this.fillVariables(url, prop, "variable_"));
        URI tokenEndpoint = uriBuilder.build();
        String clientSecret = SecurityUtil.decrypt((String)(apiConnectorProperties.has("security_schema_" + authType + "_clientSecret") ? apiConnectorProperties.getString("security_schema_" + authType + "_clientSecret") : ""));
        String clientAuthentication = apiConnectorProperties.has("security_schema_" + authType + "_clientAuthentication") ? apiConnectorProperties.getString("security_schema_" + authType + "_clientAuthentication") : "";
        Object clientAuth = null;
        clientAuth = clientAuthentication.isEmpty() ? new ClientSecretBasic(new ClientID(clientId), new Secret(clientSecret)) : new ClientSecretPost(new ClientID(clientId), new Secret(clientSecret));
        Scope scope = null;
        String scopeValues = apiConnectorProperties.has("security_schema_" + authType + "_scopes") ? apiConnectorProperties.getString("security_schema_" + authType + "_scopes") : "";
        scopeValues = this.fillVariables(scopeValues, prop, "variable_");
        scopeValues = scopeValues.replaceAll(";", " ");
        scope = Scope.parse((String)scopeValues);
        ClientCredentialsGrant grant = null;
        if (apiConnectorProperties.has("refresh_token")) {
            grant = new RefreshTokenGrant(new RefreshToken(apiConnectorProperties.getString("refresh_token")));
        } else if (type.equals("clientCredentials")) {
            grant = new ClientCredentialsGrant();
        } else if (type.equals("authorizationCode")) {
            String codeChallenge;
            String code = SecurityUtil.decrypt((String)(apiConnectorProperties.has("security_schema_" + authType + "_authorizationCode") ? apiConnectorProperties.getString("security_schema_" + authType + "_authorizationCode") : ""));
            AuthorizationCode authcode = new AuthorizationCode(code);
            String redirectUri = apiConnectorProperties.has("security_schema_" + authType + "_redirectUrl") ? apiConnectorProperties.getString("security_schema_" + authType + "_redirectUrl") : "";
            URI callback = new URI(redirectUri);
            String string = codeChallenge = apiConnectorProperties.has("security_schema_" + authType + "_codeChallenge") ? apiConnectorProperties.getString("security_schema_" + authType + "_codeChallenge") : "";
            if ("S256".equals(codeChallenge)) {
                String codeVerifier = apiConnectorProperties.has("security_schema_" + authType + "_codeVerifier") ? apiConnectorProperties.getString("security_schema_" + authType + "_codeVerifier") : "";
                grant = new AuthorizationCodeGrant(authcode, callback, new CodeVerifier(codeVerifier));
            } else {
                grant = new AuthorizationCodeGrant(authcode, callback);
            }
        }
        Date date = new Date();
        TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)grant, scope);
        TokenResponse tokenResponse = null;
        try {
            HTTPResponse tokenHttpResponse = request.toHTTPRequest().send();
            tokenResponse = isOpenIdConnect ? OIDCTokenResponseParser.parse((HTTPResponse)tokenHttpResponse) : TokenResponse.parse((HTTPResponse)tokenHttpResponse);
        }
        catch (Exception ex) {
            LogUtil.error((String)this.getClassName(), (Throwable)ex, (String)"Error Parsing Token Response");
            return null;
        }
        if (!tokenResponse.indicatesSuccess()) {
            TokenErrorResponse errorResponse = tokenResponse.toErrorResponse();
            LogUtil.error((String)this.getClassName(), null, (String)("Error response:" + errorResponse.getErrorObject().toString() + " : " + errorResponse.getErrorObject().getDescription()));
            return null;
        }
        AccessToken token = null;
        if (isOpenIdConnect) {
            OIDCTokenResponse successResponse = (OIDCTokenResponse)tokenResponse.toSuccessResponse();
            JWT idToken = successResponse.getOIDCTokens().getIDToken();
            token = successResponse.getOIDCTokens().getAccessToken();
            String issuer = apiConnectorProperties.has("security_schema_" + authType + "_issuer") ? apiConnectorProperties.getString("security_schema_" + authType + "_issuer") : "";
            String jwksUrl = apiConnectorProperties.has("security_schema_" + authType + "_jwksUrl") ? apiConnectorProperties.getString("security_schema_" + authType + "_jwksUrl") : "";
            String nonce = apiConnectorProperties.has("security_schema_" + authType + "_nonce") ? apiConnectorProperties.getString("security_schema_" + authType + "_nonce") : "";
            Issuer iss = new Issuer(issuer);
            JWSAlgorithm jwsAlg = JWSAlgorithm.RS256;
            URL jwkSetURL = new URL(jwksUrl);
            IDTokenValidator validator = new IDTokenValidator(iss, new ClientID(clientId), jwsAlg, jwkSetURL);
            Nonce expectedNonce = new Nonce(nonce);
            try {
                IDTokenClaimsSet iDTokenClaimsSet = validator.validate(idToken, expectedNonce);
            }
            catch (JOSEException | BadJOSEException e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"Invalid Claims");
                return null;
            }
        } else {
            token = tokenResponse.toSuccessResponse().getTokens().getAccessToken();
        }
        if (token == null) {
            return null;
        }
        JSONObject tokenJson = new JSONObject(tokenResponse.toSuccessResponse().getTokens().toString());
        int expire = Long.valueOf(token.getLifetime()).intValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, expire - 300);
        SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT);
        tokenJson.put("expires_date", (Object)sdf.format(calendar.getTime()));
        boolean add = false;
        if (env == null) {
            env = new EnvironmentVariable();
            env.setAppDefinition(AppUtil.getCurrentAppDefinition());
            env.setId(tokenKey);
            add = true;
        }
        env.setValue(tokenJson.toString());
        if (add) {
            environmentVariableDao.add((AbstractAppVersionedObject)env);
        } else {
            environmentVariableDao.update((AbstractAppVersionedObject)env);
        }
        return tokenJson;
    }

    public void processJogetApiBuilderToken(Map<String, String> headers) {
        String token = headers.get("token");
        try {
            if (token.contains("(")) {
                MessageDigest md;
                String tokenPattern = token;
                String method = tokenPattern.substring(0, tokenPattern.indexOf("("));
                tokenPattern = tokenPattern.substring(tokenPattern.indexOf("(") + 1, tokenPattern.length() - 1);
                if ((tokenPattern = tokenPattern.replaceAll(StringUtil.escapeRegex((String)"{api_key}"), StringUtil.escapeRegex((String)headers.get("api_key")))).contains("{")) {
                    Pattern pattern = Pattern.compile("\\{(.+)\\}");
                    Matcher matcher = pattern.matcher(tokenPattern);
                    while (matcher.find()) {
                        String key = matcher.group(1);
                        SimpleDateFormat sdf = new SimpleDateFormat(key);
                        tokenPattern = tokenPattern.replaceAll(StringUtil.escapeRegex((String)matcher.group(0)), StringUtil.escapeRegex((String)sdf.format(new Date())));
                    }
                }
                if ((md = MessageDigest.getInstance(method)) != null) {
                    byte[] bytes = md.digest(tokenPattern.getBytes("UTF-8"));
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < bytes.length; ++i) {
                        sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
                    }
                    tokenPattern = sb.toString();
                }
                headers.put("token", tokenPattern);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
    }

    public void populateParameters(String pathId, JSONArray parameters, Map<String, Object> pluginProperties, JSONObject oas, URIBuilder uriBuilder, Map<String, String> headers) {
        for (int i = 0; i < parameters.length(); ++i) {
            JSONObject parameter = parameters.getJSONObject(i);
            this.populateParameter(pathId, parameter, pluginProperties, oas, uriBuilder, headers);
        }
    }

    public void populateParameter(String pathId, JSONObject parameter, Map<String, Object> pluginProperties, JSONObject oas, URIBuilder uriBuilder, Map<String, String> headers) {
        JSONObject schema = null;
        if (parameter.has("$ref")) {
            parameter = this.getSchemaByRef(oas, parameter.getString("$ref"));
        }
        if (parameter.has("type")) {
            schema = parameter;
        } else if (parameter.has("schema") && (schema = parameter.getJSONObject("schema")).has("$ref")) {
            schema = this.getSchemaByRef(oas, schema.getString("$ref"));
        }
        if (schema != null) {
            String name = this.removeSpecialChar(parameter.has("name") ? parameter.getString("name") : "");
            Object data = this.getParameterData(name, schema, pluginProperties, oas, pathId + "_param_");
            String in = parameter.has("in") ? parameter.getString("in") : "";
            String style = parameter.has("style") ? parameter.getString("style") : "";
            Boolean explode = parameter.has("explode") ? parameter.getBoolean("explode") : false;
            if ((data instanceof JSONObject || data instanceof JSONArray) && ("form".equals(style) && explode.booleanValue() || "deepObject".equals(style))) {
                this.populateObjectOrArrayQueryParameterValue(name, data, style, uriBuilder);
            } else {
                boolean required;
                String value = this.getStringValue(name, data, style, explode);
                boolean bl = required = parameter.has("required") ? parameter.getBoolean("required") : false;
                if (!value.isEmpty() || required) {
                    if ("header".equals(in)) {
                        headers.put(name, value);
                    } else if ("query".equals(in)) {
                        uriBuilder.addParameter(name, value);
                    } else if ("path".equals(in)) {
                        String path = uriBuilder.getPath();
                        path = path.replaceAll(StringUtil.escapeRegex((String)("__" + name + "__")), StringUtil.escapeRegex((String)value));
                        uriBuilder.setPath(path);
                    }
                }
            }
        }
    }

    public String getStringValue(String name, Object data, String style, Boolean explode) {
        String result = "";
        try {
            if (data instanceof JSONObject) {
                String propDelimeter = ",";
                String valueDelimeter = "=";
                if ("matrix".equals(style) && explode.booleanValue()) {
                    propDelimeter = ";";
                } else if ("matrix".equals(style) && explode == false || "simple".equals(style) && explode == false || "form".equals(style)) {
                    valueDelimeter = ",";
                } else if ("label".equals(style)) {
                    propDelimeter = ".";
                    if (!explode.booleanValue()) {
                        valueDelimeter = ".";
                    }
                } else if ("spaceDelimited".equals(style)) {
                    propDelimeter = " ";
                    valueDelimeter = " ";
                } else if ("pipeDelimited".equals(style)) {
                    propDelimeter = " ";
                    valueDelimeter = " ";
                }
                result = this.appendObjectProperties((JSONObject)data, propDelimeter, valueDelimeter);
                if ("matrix".equals(style)) {
                    result = !explode.booleanValue() ? ";" + URLEncoder.encode(name, "UTF-8") + "=" + result : ";" + result;
                } else if ("label".equals(style)) {
                    result = "." + result;
                }
            } else {
                if (data instanceof JSONArray) {
                    String delimeter = ",";
                    if ("matrix".equals(style) && explode.booleanValue()) {
                        delimeter = ";" + URLEncoder.encode(name, "UTF-8") + "=";
                    } else if ("label".equals(style)) {
                        delimeter = ".";
                    } else if ("spaceDelimited".equals(style)) {
                        delimeter = " ";
                    } else if ("pipeDelimited".equals(style)) {
                        delimeter = "|";
                    }
                    JSONArray dataArray = (JSONArray)data;
                    for (int i = 0; i < dataArray.length(); ++i) {
                        if (!result.isEmpty()) {
                            result = result + delimeter;
                        }
                        result = result + dataArray.get(i).toString();
                    }
                } else {
                    String value = JsonApiUtil.replaceParam((String)data.toString(), this.params);
                    if (!value.isEmpty()) {
                        result = result + URLEncoder.encode(value, "UTF-8");
                    }
                }
                if ("matrix".equals(style)) {
                    result = ";" + URLEncoder.encode(name, "UTF-8") + (!result.isEmpty() ? "=" : "") + result;
                } else if ("label".equals(style)) {
                    result = "." + result;
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)name);
        }
        return result;
    }

    public String appendObjectProperties(JSONObject data, String propDelimeter, String valueDelimeter) throws UnsupportedEncodingException {
        String result = "";
        Iterator keys = data.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = data.get(key).toString();
            if (!result.isEmpty()) {
                result = result + propDelimeter;
            }
            result = result + URLEncoder.encode(key, "UTF-8") + valueDelimeter + URLEncoder.encode(value, "UTF-8");
        }
        return result;
    }

    public void populateObjectOrArrayQueryParameterValue(String name, Object data, String style, URIBuilder uriBuilder) {
        if (data instanceof JSONObject) {
            this.populateObjectQueryParameterValue((JSONObject)data, uriBuilder, "deepObject".equals(style) ? name : "");
        } else if (data instanceof JSONArray) {
            JSONArray dataArray = (JSONArray)data;
            for (int i = 0; i < dataArray.length(); ++i) {
                uriBuilder.addParameter(name, dataArray.get(i).toString());
            }
        }
    }

    public void populateObjectQueryParameterValue(JSONObject data, URIBuilder uriBuilder, String prefix) {
        Iterator keys = data.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = data.get(key);
            if (!prefix.isEmpty()) {
                key = prefix + "[" + key + "]";
            }
            if (value instanceof JSONObject) {
                this.populateObjectQueryParameterValue((JSONObject)value, uriBuilder, key);
                continue;
            }
            uriBuilder.addParameter(key, value.toString());
        }
    }

    public Object getParameterData(String name, JSONObject schema, Map<String, Object> pluginProperties, JSONObject oas, String prefix) {
        String ptype = schema.getString("type");
        if ("object".equals(ptype)) {
            return this.getJsonObjectBasedOnSchema(schema, pluginProperties, oas, prefix + name + "_");
        }
        if ("array".equals(ptype)) {
            return this.getJsonArrayBasedOnSchema(schema, pluginProperties, oas, prefix + name);
        }
        return pluginProperties.get(prefix + name);
    }

    public JSONObject getPayload(String pathId, JSONObject apiPath, JSONObject pathSetting, Map<String, Object> pluginProperties, JSONObject oas, Map<String, String> headers) {
        JSONObject requestBody = apiPath.getJSONObject("requestBody");
        JSONObject schema = null;
        if (requestBody.has("content")) {
            JSONObject requestBodyContent = requestBody.getJSONObject("content");
            schema = this.findContentSchema(requestBodyContent, oas, headers);
        }
        if (pathSetting.has("requestBodyType") && "fields".equals(pathSetting.getString("requestBodyType"))) {
            if (schema != null) {
                return this.getJsonObjectBasedOnSchema(schema, pluginProperties, oas, pathId + "_requestbody_");
            }
        } else {
            return new JSONObject(pluginProperties.get(pathId + "_requestBody").toString());
        }
        return null;
    }

    public JSONObject getJsonObjectBasedOnSchema(JSONObject schema, Map<String, Object> pluginProperties, JSONObject oas, String prefix) {
        JSONObject result = new JSONObject();
        if (schema.has("$ref")) {
            schema = this.getSchemaByRef(oas, schema.getString("$ref"));
        }
        if (schema.has("properties")) {
            JSONObject objectProperties = schema.getJSONObject("properties");
            Iterator keys = objectProperties.keys();
            while (keys.hasNext()) {
                Object value;
                String name = (String)keys.next();
                JSONObject prop = objectProperties.getJSONObject(name);
                String ptype = prop.getString("type");
                if ("object".equals(ptype)) {
                    value = this.getJsonObjectBasedOnSchema(prop, pluginProperties, oas, prefix + name + "_");
                    result.put(name, value);
                    continue;
                }
                if ("array".equals(ptype)) {
                    value = this.getJsonArrayBasedOnSchema(prop, pluginProperties, oas, prefix + name);
                    result.put(name, value);
                    continue;
                }
                value = pluginProperties.get(prefix + name);
                if (value == null) continue;
                result.put(name, this.parseValueByType(value, ptype));
            }
        }
        return result;
    }

    public JSONArray getJsonArrayBasedOnSchema(JSONObject schema, Map<String, Object> pluginProperties, JSONObject oas, String prefix) {
        JSONArray result = new JSONArray();
        if (schema.has("items")) {
            JSONObject itemSchema = schema.getJSONObject("items");
            if (itemSchema.has("$ref")) {
                itemSchema = this.getSchemaByRef(oas, itemSchema.getString("$ref"));
            }
            String ptype = itemSchema.getString("type");
            Object[] rowValues = (Object[])pluginProperties.get(prefix);
            if (rowValues != null && rowValues.length > 0) {
                for (Object o : rowValues) {
                    Object value;
                    HashMap row = (HashMap)o;
                    if ("object".equals(ptype)) {
                        value = this.getJsonObjectBasedOnSchema(itemSchema, row, oas, prefix + "_");
                        result.put(value);
                        continue;
                    }
                    value = pluginProperties.get("value");
                    if (value == null) continue;
                    result.put(this.parseValueByType(value, ptype));
                }
            }
        }
        return result;
    }

    public Object parseValueByType(Object value, String type) {
        if (value != null) {
            if ("number".equals(type)) {
                value = Double.parseDouble(value.toString());
            } else if ("integer".equals(type)) {
                value = Integer.parseInt(value.toString());
            } else if ("boolean".equals(type)) {
                value = Boolean.getBoolean(value.toString());
            }
        }
        return value;
    }

    public String fillVariables(String input, Map<String, Object> properties, String prefix) {
        if (input.contains("{") && input.contains("}")) {
            Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9_]+)\\}");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                String key = matcher.group(1);
                if (!properties.containsKey(prefix + key)) continue;
                input = input.replaceAll(StringUtil.escapeRegex((String)("{" + key + "}")), StringUtil.escapeRegex((String)properties.get(prefix + key).toString()));
            }
        }
        return input;
    }

    public Map<String, Object> jsonObjectToMap(JSONObject jsonObj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, jsonObj.get(key));
        }
        return map;
    }

    public String getMsg(String key) {
        return AppPluginUtil.getMessage((String)key, (String)this.getClassName(), (String)"messages/ApiConnectorBuilder");
    }

    public String getAttributeValue(String attribute, String json) {
        int index = json.indexOf("\"" + attribute + "\"");
        if (index != -1) {
            index = index + attribute.length() + 2;
            int firstQuoteIndex = json.indexOf("\"", index);
            String value = json.substring(firstQuoteIndex + 1, json.indexOf("\"", firstQuoteIndex + 1));
            return AppUtil.processHashVariable((String)value, null, null, null);
        }
        return "";
    }

    public static Map getApiConnectorResult(Object apiConnector, Map<String, String> params) {
        Map connectorMap;
        if (apiConnector != null && apiConnector instanceof Map && (connectorMap = (Map)apiConnector).containsKey("className") && !connectorMap.get("className").toString().isEmpty()) {
            String apiConnectorId = connectorMap.get("className").toString();
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
            BuilderDefinition builderDefinition = builderDefinitionDao.loadById(apiConnectorId, appDef);
            if (builderDefinition != null) {
                String jsonResponse;
                String json = builderDefinition.getJson();
                ApiConnectorBuilder builder = new ApiConnectorBuilder();
                HashMap<String, Object> config = new HashMap<String, Object>();
                config.put(OUTPUT, OUTPUT_EXECUTION);
                config.put("properties", connectorMap.get("properties"));
                if (params != null) {
                    config.put("params", params);
                }
                if ((jsonResponse = (String)builder.getBuilderResult(json, config)) != null && !jsonResponse.isEmpty()) {
                    return PropertyUtil.getProperties((JSONObject)new JSONObject(jsonResponse));
                }
            }
        }
        return null;
    }

    public static String getApiConnectorSampleResult(Object apiConnector) {
        Map connectorMap;
        if (apiConnector != null && apiConnector instanceof Map && (connectorMap = (Map)apiConnector).containsKey("className") && !connectorMap.get("className").toString().isEmpty()) {
            String apiConnectorId = connectorMap.get("className").toString();
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
            BuilderDefinition builderDefinition = builderDefinitionDao.loadById(apiConnectorId, appDef);
            if (builderDefinition != null) {
                String json = builderDefinition.getJson();
                ApiConnectorBuilder builder = new ApiConnectorBuilder();
                HashMap<String, Object> config = new HashMap<String, Object>();
                config.put(OUTPUT, OUTPUT_SAMPLE_RESPONSE);
                config.put("properties", connectorMap.get("properties"));
                return (String)builder.getBuilderResult(json, config);
            }
        }
        return null;
    }

    public void debug(String msg) {
        if ("true".equalsIgnoreCase(this.getPropertyString("debugMode"))) {
            LogUtil.info((String)this.getClassName(), (String)msg);
        }
    }

    protected JSONObject mergeJSONObject(JSONObject o1, JSONObject o2) {
        Iterator keys = o2.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            o1.put(key, o2.get(key));
        }
        return o1;
    }
}

