/*
 * Decompiled with CFR 0.152.
 */
package org.joget.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.apps.app.model.CustomBuilder;
import org.joget.apps.app.model.PluginWebFilterAbstract;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.connector.ApiConnectorBuilder;

public class ApiConnectorWebFilter
extends PluginWebFilterAbstract {
    public String getName() {
        return "ApiConnectorWebFilter";
    }

    public String getVersion() {
        return "8.0-BETA2";
    }

    public String getDescription() {
        return "";
    }

    public String[] getUrlPatterns() {
        return new String[]{"/apiconnector/**"};
    }

    public boolean isPositionAfterSecurityFilter() {
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURL = httpRequest.getRequestURL().toString();
        if (requestURL.contains("/apiconnector/callback")) {
            String code = SecurityUtil.validateStringInput((String)httpRequest.getParameter("code"));
            String state = SecurityUtil.validateStringInput((String)httpRequest.getParameter("state"));
            String error = SecurityUtil.validateStringInput((String)httpRequest.getParameter("error"));
            response.setContentType("text/html; charset=utf-8");
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("code", code != null ? code : "");
            model.put("state", state != null ? state : "");
            model.put("error", error != null ? error : "");
            String html = CustomBuilderUtil.generateHtml((CustomBuilder)new ApiConnectorBuilder(), (String)"templates/oauth2callback.ftl", model, (HttpServletRequest)httpRequest);
            httpResponse.getWriter().write(html);
        } else if (requestURL.contains("/apiconnector/openIdDiscovery")) {
            String url = httpRequest.getParameter("url");
            URL providerConfigurationURL = new URL(url);
            try (InputStream stream = providerConfigurationURL.openStream();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = stream.read(buffer)) != -1) {
                    httpResponse.getOutputStream().write(buffer, 0, length);
                }
            }
        }
    }
}

