/*
 * Decompiled with CFR 0.152.
 */
package org.joget.connector.lib;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.JsonApiUtil;
import org.joget.apps.datalist.model.DataList;
import org.joget.apps.datalist.model.DataListActionDefault;
import org.joget.apps.datalist.model.DataListActionResult;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.commons.util.ResourceBundleUtil;
import org.joget.commons.util.UuidGenerator;
import org.joget.connector.ApiConnectorBuilder;
import org.joget.workflow.util.WorkflowUtil;

public class ApiConnectorDatalistAction
extends DataListActionDefault {
    public String getName() {
        return "apiConnectorDatalistAction";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ApiConnectorPlugins");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ApiConnectorPlugins");
    }

    public String getVersion() {
        return "8.0-BETA2";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/properties/app/apiConnectorDatalistAction.json", null, (boolean)true, (String)"messages/ApiConnectorPlugins");
    }

    public String getLinkLabel() {
        String label = this.getPropertyString("label");
        if (label == null || label.isEmpty()) {
            label = this.getLabel();
        }
        return label;
    }

    public String getHref() {
        return this.getPropertyString("href");
    }

    public String getTarget() {
        return "post";
    }

    public String getHrefParam() {
        return this.getPropertyString("hrefParam");
    }

    public String getHrefColumn() {
        return this.getPropertyString("hrefColumn");
    }

    public String getConfirmation() {
        String confirm = this.getPropertyString("confirmation");
        if (confirm == null || confirm.isEmpty()) {
            confirm = ResourceBundleUtil.getMessage((String)"datalist.formrowdeletedatalistaction.pleaseConfirm");
        }
        return confirm;
    }

    public DataListActionResult executeAction(DataList dataList, String[] rowKeys) {
        DataListActionResult result = new DataListActionResult();
        result.setType("REDIRECT");
        result.setUrl("REFERER");
        HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
        if (request != null && !"POST".equalsIgnoreCase(request.getMethod())) {
            return null;
        }
        if (rowKeys != null && rowKeys.length > 0) {
            for (String id : rowKeys) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("primaryKey", id);
                Object apiConnector = this.getProperty("apiConnector");
                Map data = ApiConnectorBuilder.getApiConnectorResult(apiConnector, params);
                if (data == null) continue;
                this.storeToForm(this.properties, data, id);
            }
        }
        return result;
    }

    protected void storeToForm(Map properties, Map object, String id) {
        String formDefId = (String)properties.get("formDefId");
        if (formDefId != null && formDefId.trim().length() > 0) {
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            Object[] fieldMapping = (Object[])properties.get("fieldMapping");
            String multirowBaseObjectName = (String)properties.get("multirowBaseObject");
            FormRowSet rowSet = new FormRowSet();
            Object multirowBaseObject = null;
            if (multirowBaseObjectName != null && !multirowBaseObjectName.isEmpty()) {
                multirowBaseObject = JsonApiUtil.getObjectFromMap((String)multirowBaseObjectName, (Map)object);
            }
            if (multirowBaseObject != null && multirowBaseObject.getClass().isArray()) {
                Object[] baseObjectArray = (Object[])multirowBaseObject;
                if (baseObjectArray != null && baseObjectArray.length > 0) {
                    rowSet.setMultiRow(true);
                    for (int i = 0; i < baseObjectArray.length; ++i) {
                        rowSet.add((Object)this.getRow(multirowBaseObjectName, i, fieldMapping, object, id));
                    }
                }
            } else {
                rowSet.add((Object)this.getRow(null, null, fieldMapping, object, id));
            }
            if (rowSet.size() > 0) {
                appService.storeFormData(appDef.getId(), appDef.getVersion().toString(), formDefId, rowSet, null);
            }
        }
    }

    protected FormRow getRow(String multirowBaseObjectName, Integer rowNumber, Object[] fieldMapping, Map object, String id) {
        FormRow row = new FormRow();
        for (Object o : fieldMapping) {
            String value;
            HashMap mapping = (HashMap)o;
            String fieldName = mapping.get("field").toString();
            String jsonObjectName = mapping.get("jsonObjectName").toString();
            if (multirowBaseObjectName != null) {
                jsonObjectName = jsonObjectName.replace(multirowBaseObjectName, multirowBaseObjectName + "[" + rowNumber + "]");
            }
            if ((value = (String)JsonApiUtil.getObjectFromMap((String)jsonObjectName, (Map)object)) == null && jsonObjectName.equalsIgnoreCase("{primaryKey}")) {
                value = id;
            }
            if (value == null) {
                value = jsonObjectName;
            }
            if ("id".equals(fieldName)) {
                row.setId(value);
                continue;
            }
            row.put((Object)fieldName, (Object)value);
        }
        if (row.getId() == null || row.getId() != null && row.getId().trim().length() == 0) {
            row.setId(UuidGenerator.getInstance().getUuid());
        }
        Date currentDate = new Date();
        row.setDateModified(currentDate);
        row.setDateCreated(currentDate);
        return row;
    }
}

