/*
 * Decompiled with CFR 0.152.
 */
package org.joget.connector.lib;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.JsonApiUtil;
import org.joget.apps.datalist.service.DataListService;
import org.joget.apps.form.lib.JsonApiFormStoreBinder;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.apps.form.service.FormUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.UuidGenerator;
import org.joget.connector.ApiConnectorBuilder;
import org.joget.connector.ApiConnectorExecutionException;
import org.joget.directory.model.User;
import org.joget.directory.model.service.DirectoryUtil;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiConnectorFormStoreBinder
extends JsonApiFormStoreBinder {
    public String getName() {
        return "apiConnectorFormStoreBinder";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ApiConnectorPlugins");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ApiConnectorPlugins");
    }

    public String getVersion() {
        return "8.0-BETA2";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/properties/app/apiConnectorFormStoreBinder.json", null, (boolean)true, (String)"messages/ApiConnectorPlugins");
    }

    public FormRowSet store(Element element, FormRowSet rows, FormData formData) {
        Form form = FormUtil.findRootForm((Element)element);
        String primaryKey = form.getPrimaryKeyValue(formData);
        HashMap<String, String> params = null;
        Date currentDate = new Date();
        WorkflowUserManager workflowUserManager = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User user = workflowUserManager.getCurrentUser();
        String name = null;
        String username = workflowUserManager.getCurrentUsername();
        if (user != null) {
            name = DirectoryUtil.getUserFullName((User)user);
        }
        for (FormRow r : rows) {
            params = new HashMap<String, String>();
            if (primaryKey != null && !primaryKey.isEmpty()) {
                if (rows.isMultiRow()) {
                    params.put("primaryKey", primaryKey);
                } else if (r.getId() == null || r.getId().isEmpty()) {
                    r.setId(primaryKey);
                }
            }
            boolean isUpdate = true;
            if (r.getId() == null || r.getId().isEmpty() || !rows.isMultiRow() && !r.getId().equals(formData.getRequestParameter("_FORM_META_ORIGINAL_ID"))) {
                r.setId(UuidGenerator.getInstance().getUuid());
                r.setCreatedBy(username);
                r.setCreatedByName(name);
                r.setDateCreated(currentDate);
                isUpdate = false;
            } else {
                params.put("primaryKey", r.getId());
            }
            Object apiConnector = this.getProperty("apiConnector");
            if (isUpdate && "true".equalsIgnoreCase(this.getPropertyString("useDifferentApiForUpdate"))) {
                apiConnector = this.getProperty("updateApiConnector");
            }
            r.setModifiedBy(username);
            r.setModifiedByName(name);
            r.setDateModified(currentDate);
            for (Object key : r.keySet()) {
                params.put(key.toString(), r.getProperty(key.toString()));
            }
            if ("true".equalsIgnoreCase(this.getPropertyString("autoPopulateRequestBody"))) {
                this.autoPopulateRequestBody(apiConnector, r, params);
            }
            try {
                ApiConnectorBuilder.getApiConnectorResult(apiConnector, params);
            }
            catch (ApiConnectorExecutionException e) {
                return null;
            }
        }
        return rows;
    }

    public void autoPopulateRequestBody(Object apiConnector, FormRow r, Map<String, String> params) {
        Map connectorMap;
        Map pluginProperties;
        String pathId;
        if (apiConnector != null && apiConnector instanceof Map && (pathId = (String)(pluginProperties = (Map)((connectorMap = (Map)apiConnector).containsKey("properties") ? connectorMap.get("properties") : new HashMap())).get("apiOperatorId")) != null && !pathId.isEmpty()) {
            String requestBody = (String)pluginProperties.get(pathId + "_orgRequestBody");
            if (requestBody == null && (requestBody = (String)pluginProperties.get(pathId + "_requestBody")) != null) {
                pluginProperties.put(pathId + "_orgRequestBody", requestBody);
            }
            if (requestBody != null && !requestBody.isEmpty()) {
                JSONObject o = new JSONObject(requestBody);
                JSONObject newRequestBody = new JSONObject();
                this.populateData(o, newRequestBody, r, "", params);
                pluginProperties.put(pathId + "_requestBody", newRequestBody.toString());
            }
        }
    }

    public void populateData(JSONObject sample, JSONObject result, Object data, String prefix, Map<String, String> params) {
        Iterator keys = sample.keys();
        while (keys.hasNext()) {
            String paramValue;
            String key = keys.next().toString();
            Object sampleValue = sample.get(key);
            Object value = null;
            if (sampleValue != null && sampleValue.toString().startsWith("{") && sampleValue.toString().endsWith("}") && !(paramValue = JsonApiUtil.replaceParam((String)sampleValue.toString(), params)).equals(sampleValue)) {
                value = paramValue;
            }
            if (value == null) {
                value = DataListService.evaluateColumnValueFromRow((Object)data, (String)(prefix + key));
            }
            if (value != null) {
                try {
                    if (sampleValue instanceof JSONArray) {
                        JSONArray sampleValues = (JSONArray)sampleValue;
                        Object sampleArrayValue = null;
                        if (!sampleValues.isEmpty()) {
                            sampleArrayValue = sampleValues.get(0);
                        }
                        JSONArray resultValues = new JSONArray();
                        if (value instanceof String && !value.toString().isEmpty()) {
                            if (value.toString().startsWith("[") && value.toString().endsWith("]")) {
                                FormRowSet rows = FormUtil.jsonToFormRowSet((String)value.toString());
                                for (int i = 0; i < rows.size(); ++i) {
                                    Object v = rows.get(i);
                                    if (sampleArrayValue instanceof JSONObject) {
                                        JSONObject newData = new JSONObject();
                                        this.populateData((JSONObject)sampleArrayValue, newData, v, "", params);
                                        resultValues.put((Object)newData);
                                        continue;
                                    }
                                    resultValues.put(this.getValue(sampleArrayValue, v.toString()));
                                }
                            } else {
                                String[] arrayValues;
                                for (String v : arrayValues = value.toString().split(";")) {
                                    resultValues.put(this.getValue(sampleArrayValue, v));
                                }
                            }
                        }
                        result.put(key, (Object)resultValues);
                        continue;
                    }
                    result.put(key, this.getValue(sampleValue, value.toString()));
                }
                catch (Exception e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)key);
                }
                continue;
            }
            if (!(sampleValue instanceof JSONObject)) continue;
            JSONObject newData = new JSONObject();
            this.populateData((JSONObject)sampleValue, newData, data, key + ".", params);
            result.put(key, (Object)newData);
        }
    }

    public Object getValue(Object sample, String value) {
        if (sample instanceof Double) {
            return Double.valueOf(value);
        }
        if (sample instanceof Integer) {
            return Integer.valueOf(value);
        }
        if (sample instanceof Boolean) {
            return Boolean.getBoolean(value);
        }
        return value;
    }
}

