/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.joget.api.dao.ApiCredentialDaoImpl;
import org.joget.api.dao.ApiLogDao;
import org.joget.api.model.ApiLog;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.spring.model.AbstractSpringDao;
import org.joget.commons.util.LogUtil;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class ApiLogDaoImpl
extends AbstractSpringDao
implements ApiLogDao {
    @Override
    public Collection<ApiLog> find(final String condition, final Object[] params, final String sort, final Boolean desc, final Integer start, final Integer rows) {
        try {
            TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
            Collection logs = (Collection)transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus ts) {
                    return ApiLogDaoImpl.this.find("ApiLog", condition, params, sort, desc, start, rows);
                }
            });
            return logs;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiLogDaoImpl.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }

    @Override
    public Collection<ApiLog> findByApiKey(final String apiKey, final String condition, final Object[] params, final String sort, final Boolean desc, final Integer start, final Integer rows) {
        try {
            TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
            Collection logs = (Collection)transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus ts) {
                    String conds = condition;
                    conds = conds == null || conds.isEmpty() ? "where e.apiKey = ?" : conds + " and e.apiKey = ?";
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (params != null) {
                        list.addAll(Arrays.asList(params));
                    }
                    list.add(apiKey);
                    return ApiLogDaoImpl.this.find("ApiLog", conds, list.toArray(), sort, desc, start, rows);
                }
            });
            return logs;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiLogDaoImpl.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }

    @Override
    public Long count(final String condition, final Object[] params) {
        try {
            TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
            Long count = (Long)transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus ts) {
                    return ApiLogDaoImpl.this.count("ApiLog", condition, params);
                }
            });
            return count;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiLogDaoImpl.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }

    @Override
    public Long countByApiKey(final String apiKey, final String condition, final Object[] params) {
        try {
            TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
            Long count = (Long)transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus ts) {
                    String conds = condition;
                    conds = conds == null || conds.isEmpty() ? "where e.apiKey = ?" : conds + " and e.apiKey = ?";
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (params != null) {
                        list.addAll(Arrays.asList(params));
                    }
                    list.add(apiKey);
                    return ApiLogDaoImpl.this.count("ApiLog", conds, list.toArray());
                }
            });
            return count;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiLogDaoImpl.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }

    @Override
    public void save(final ApiLog log) {
        try {
            TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
            transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus ts) {
                    ApiLogDaoImpl.this.saveOrUpdate("ApiLog", log);
                    return true;
                }
            });
        }
        catch (Exception e) {
            LogUtil.error((String)ApiLogDaoImpl.class.getName(), (Throwable)e, (String)"");
        }
    }

    @Override
    public void deleteByApiKey(String apiKey) {
        try {
            final Collection<ApiLog> logs = this.findByApiKey(apiKey, null, null, null, null, null, null);
            if (logs != null && !logs.isEmpty()) {
                TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
                transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                    public Object doInTransaction(TransactionStatus ts) {
                        for (ApiLog l : logs) {
                            ApiLogDaoImpl.this.delete("ApiLog", l);
                        }
                        return true;
                    }
                });
            }
        }
        catch (Exception e) {
            LogUtil.error((String)ApiLog.class.getName(), (Throwable)e, (String)"");
        }
    }

    @Override
    public ApiLog get(final String id) {
        try {
            TransactionTemplate transactionTemplate = (TransactionTemplate)AppUtil.getApplicationContext().getBean("transactionTemplate");
            ApiLog jobDefinition = (ApiLog)transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus ts) {
                    return (ApiLog)ApiLogDaoImpl.this.find("ApiLog", id);
                }
            });
            return jobDefinition;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiCredentialDaoImpl.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }
}

