/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.joget.api.model.JSONOrderedObject;
import org.joget.api.service.ApiService;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.lib.FileUpload;
import org.joget.apps.form.lib.Grid;
import org.joget.apps.form.model.AbstractSubForm;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormContainer;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.GridInnerDataRetriever;
import org.joget.apps.form.service.FormService;
import org.joget.apps.form.service.FormUtil;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class APIFormUtil {
    protected static void setGridData(Element el, FormData formData, JSONArray data) {
        try {
            Field cachedRowSetField = APIFormUtil.getField(el.getClass(), "cachedRowSet");
            cachedRowSetField.setAccessible(true);
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            FormDefinitionDao formDefinitionDao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
            FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
            Map cachedRowSet = (Map)cachedRowSetField.get(el);
            if (cachedRowSet != null && !cachedRowSet.containsKey(formData)) {
                for (int i = 0; i < data.length(); ++i) {
                    String formDefId;
                    JSONObject obj = data.getJSONObject(i);
                    if (obj.has("id") && !obj.get("id").toString().isEmpty() || (formDefId = el.getPropertyString("formDefId")) == null || formDefId.isEmpty()) continue;
                    FormData newformData = new FormData();
                    FormDefinition formDef = formDefinitionDao.loadById(formDefId, appDef);
                    Form form = (Form)formService.createElementFromJson(formDef.getJson());
                    Element primaryElement = FormUtil.findElement((String)"id", (Element)form, (FormData)newformData);
                    if (primaryElement == null) continue;
                    newformData = FormUtil.executeElementFormatData((Element)primaryElement, (FormData)newformData);
                    String primaryKeyValue = form.getPrimaryKeyValue(newformData);
                    obj.put("id", (Object)primaryKeyValue);
                    data.put(i, (Object)obj);
                }
                cachedRowSet.put(formData, FormUtil.jsonToFormRowSet((String)data.toString()));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)APIFormUtil.class.getName(), (Throwable)e, (String)el.getClassName());
        }
    }

    protected static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return APIFormUtil.getField(superClass, fieldName);
        }
    }

    protected static void addRequestParam(FormData formData, String name, Object value) throws JSONException {
        if (value instanceof JSONArray) {
            JSONArray ja = (JSONArray)value;
            ArrayList<String> arr = new ArrayList<String>();
            for (int i = 0; i < ja.length(); ++i) {
                arr.add(ja.getString(i));
            }
            formData.addRequestParameterValues(name, arr.toArray(new String[0]));
        } else {
            formData.addRequestParameterValues(name, new String[]{value.toString()});
        }
    }

    protected static void jsonToFormData(Element el, FormData formData, JSONObject obj, String ignorePermission) throws JSONException {
        block8: {
            block10: {
                String name;
                block9: {
                    block7: {
                        if (!"true".equalsIgnoreCase(ignorePermission) && (!el.isAuthorize(formData).booleanValue() || FormUtil.isHidden((Element)el, (FormData)formData) || FormUtil.isReadonly((Element)el, (FormData)formData))) {
                            return;
                        }
                        name = el.getPropertyString("id");
                        Collection dynamic = el.getDynamicFieldNames();
                        if (dynamic != null && dynamic.isEmpty()) {
                            for (String s : dynamic) {
                                if (!obj.has(s)) continue;
                                APIFormUtil.addRequestParam(formData, s, obj.get(s));
                            }
                        }
                        if (!(el instanceof Grid) && !(el instanceof GridInnerDataRetriever)) break block7;
                        if (!obj.has(name)) break block8;
                        APIFormUtil.setGridData(el, formData, obj.getJSONArray(name));
                        break block8;
                    }
                    if (el instanceof FormContainer) break block9;
                    if (!obj.has(name)) break block8;
                    APIFormUtil.addRequestParam(formData, FormUtil.getElementParameterName((Element)el), obj.get(name));
                    break block8;
                }
                if (!(el instanceof AbstractSubForm)) break block10;
                if (!obj.has(name)) break block8;
                JSONObject sobj = obj.getJSONObject(name);
                Collection children = el.getChildren(formData);
                if (children != null && !children.isEmpty()) {
                    for (Element c : children) {
                        APIFormUtil.jsonToFormData(c, formData, sobj, ignorePermission);
                    }
                }
                break block8;
            }
            Collection children = el.getChildren(formData);
            if (children != null && !children.isEmpty()) {
                for (Element c : children) {
                    APIFormUtil.jsonToFormData(c, formData, obj, ignorePermission);
                }
            }
        }
    }

    protected static void recursiveGenerateDefinition(FormData formData, JSONObject properties, Element el, boolean handleFile) throws JSONException {
        Collection dynamic = el.getDynamicFieldNames();
        String fieldId = el.getPropertyString("id");
        if (handleFile && el.getCustomParameterName() != null) {
            fieldId = el.getCustomParameterName();
        }
        String fieldLabel = el.getPropertyString("label");
        if (dynamic != null && dynamic.isEmpty()) {
            for (String s : dynamic) {
                properties.put(s, (Object)ApiService.getSchema(String.class, null, false));
            }
        }
        if (el instanceof Grid || el instanceof GridInnerDataRetriever) {
            JSONObject grid = new JSONObject();
            grid.put("type", (Object)"array");
            JSONObject obj = new JSONObject();
            grid.put("items", (Object)obj);
            obj.put("type", (Object)"object");
            JSONOrderedObject gProperties = new JSONOrderedObject();
            gProperties.put("id", ApiService.getSchema(String.class, null, false));
            Object optionProperty = el.getProperty("options");
            if (optionProperty != null && optionProperty instanceof Collection) {
                for (Object opt : (ArrayList)optionProperty) {
                    Map optMap = (Map)opt;
                    Object value = optMap.get("value");
                    gProperties.put(value.toString(), ApiService.getSchema(String.class, null, false));
                }
            }
            obj.put("properties", (Object)gProperties);
            if (handleFile) {
                grid.put("description", (Object)fieldLabel);
            }
            properties.put(fieldId, (Object)grid);
        } else if (!(el instanceof FormContainer)) {
            if (handleFile && el instanceof FileUpload) {
                properties.put(fieldId, (Object)ApiService.getSchema(File.class, null, false, fieldLabel));
            } else {
                properties.put(fieldId, (Object)ApiService.getSchema(String.class, null, false, fieldLabel));
            }
        } else if (el instanceof AbstractSubForm) {
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)"object");
            JSONOrderedObject gProperties = new JSONOrderedObject();
            Collection children = el.getChildren(formData);
            if (children != null && !children.isEmpty()) {
                for (Element c : children) {
                    if (handleFile) {
                        APIFormUtil.recursiveGenerateDefinition(formData, properties, c, handleFile);
                        continue;
                    }
                    APIFormUtil.recursiveGenerateDefinition(formData, gProperties, c, handleFile);
                }
            }
            if (!handleFile) {
                obj.put("properties", (Object)gProperties);
                properties.put(fieldId, (Object)obj);
            }
        } else {
            Collection children = el.getChildren(formData);
            if (children != null && !children.isEmpty()) {
                for (Element c : children) {
                    APIFormUtil.recursiveGenerateDefinition(formData, properties, c, handleFile);
                }
            }
        }
    }
}

