/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Date;
import java.util.UUID;
import org.joget.api.dao.ApiCredentialDao;
import org.joget.api.dao.ApiLogDao;
import org.joget.api.model.ApiCredential;
import org.joget.api.model.ApiLog;
import org.joget.api.service.ApiAppContext;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.FormBinder;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.FormLoadBinder;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.apps.form.model.FormStoreBinder;
import org.joget.workflow.model.service.WorkflowUserManager;

public class ApiKeyFormBinder
extends FormBinder
implements FormLoadBinder,
FormStoreBinder {
    private String Id = null;

    ApiKeyFormBinder(String id) {
        this.Id = id;
    }

    public String getName() {
        return "ApiKeyFormBinder";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return "";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLabel() {
        return "ApiKeyFormBinder";
    }

    public String getPropertyOptions() {
        return "";
    }

    public FormRowSet load(Element element, String primaryKey, FormData formData) {
        FormRowSet results = new FormRowSet();
        if (primaryKey != null && primaryKey.trim().length() > 0) {
            if (this.Id == null) {
                ApiCredentialDao dao = (ApiCredentialDao)ApiAppContext.getInstance().getAppContext().getBean("apiCredentialDao");
                ApiCredential obj = dao.get(primaryKey);
                if (obj != null) {
                    FormRow row = new FormRow();
                    row.setId(obj.getApiKey());
                    row.setProperty("apiName", obj.getApiName());
                    row.setProperty("apiKey", obj.getApiKey());
                    row.setProperty("apiId", obj.getApiId());
                    if (obj.getType().equals("basic")) {
                        row.setProperty("permissionPlugin", obj.getApiSecret() != null ? obj.getApiSecret() : "");
                        row.setProperty("permissionPluginConfig", obj.getSetting() != null ? obj.getSetting() : "");
                        row.setProperty("apiSecret", UUID.randomUUID().toString().replaceAll("-", ""));
                    } else {
                        row.setProperty("apiSecret", obj.getApiSecret() != null ? obj.getApiSecret() : UUID.randomUUID().toString().replaceAll("-", ""));
                        if (obj.getSetting() != null) {
                            row.setProperty("setting", obj.getSetting());
                        }
                    }
                    row.setProperty("domainWhitelist", obj.getDomainWhitelist());
                    row.setProperty("ipWhitelist", obj.getIpWhitelist());
                    row.setProperty("type", obj.getType());
                    row.setProperty("remark", obj.getRemark());
                    row.setProperty("apiCustom", obj.getApiCustom());
                    row.setProperty("settingCustom", obj.getSettingCustom() != null ? obj.getSettingCustom() : "");
                    row.setProperty("customAuthMethod", obj.getCustomAuthMethod() != null ? obj.getCustomAuthMethod() : "");
                    row.setProperty("log", obj.getLog() != null ? obj.getLog() : "");
                    row.setProperty("logDetails", obj.getLogDetails() != null ? obj.getLogDetails() : "");
                    results.add((Object)row);
                }
            } else {
                ApiLogDao dao = (ApiLogDao)ApiAppContext.getInstance().getAppContext().getBean("apiLogDao");
                ApiLog logObj = dao.get(primaryKey);
                FormRow row = new FormRow();
                if (logObj.getLogDetails() == null) {
                    row.setProperty("logDetails", "Record not found");
                } else {
                    row.setProperty("logDetails", "<pre>" + logObj.getLogDetails() + "</pre>");
                }
                results.add((Object)row);
            }
        } else {
            FormRow row = new FormRow();
            row.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            row.setProperty("apiKey", row.getId());
            row.setProperty("apiId", this.getPropertyString("apiId"));
            row.setProperty("apiSecret", UUID.randomUUID().toString().replaceAll("-", ""));
            results.add((Object)row);
        }
        return results;
    }

    public FormRowSet store(Element element, FormRowSet rows, FormData formData) {
        if (rows != null && !rows.isEmpty()) {
            ApiCredential objt;
            FormRow row;
            WorkflowUserManager workflowUserManager = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
            ApiCredentialDao dao = (ApiCredentialDao)ApiAppContext.getInstance().getAppContext().getBean("apiCredentialDao");
            ApiCredential obj = dao.get((row = (FormRow)rows.get(0)).getProperty("apiKey"));
            if (obj == null) {
                obj = new ApiCredential();
                obj.setApiKey(row.getProperty("apiKey"));
            }
            Date currentDate = new Date();
            Date dateCreated = null;
            String createdBy = null;
            if (row.getProperty("apiKey") != null && row.getProperty("apiKey").trim().length() > 0 && (objt = dao.get(row.getProperty("apiKey"))) != null) {
                dateCreated = obj.getDateCreated();
                createdBy = obj.getCreatedBy();
            }
            if (dateCreated == null) {
                dateCreated = currentDate;
                createdBy = workflowUserManager.getCurrentUsername();
            }
            obj.setApiName(row.getProperty("apiName"));
            obj.setApiId(this.getPropertyString("apiId"));
            obj.setDomainWhitelist(row.getProperty("domainWhitelist"));
            obj.setIpWhitelist(row.getProperty("ipWhitelist"));
            obj.setRemark(row.getProperty("remark"));
            obj.setType(row.getProperty("type"));
            if (obj.getType().equals("basic")) {
                obj.setApiSecret(row.getProperty("permissionPlugin"));
                obj.setSetting(row.getProperty("permissionPluginConfig"));
            } else {
                obj.setApiSecret(row.getProperty("apiSecret"));
                obj.setSetting(row.getProperty("setting"));
            }
            obj.setApiCustom(row.getProperty("apiCustom"));
            obj.setSettingCustom(row.getProperty("settingCustom"));
            obj.setCustomAuthMethod(row.getProperty("customAuthMethod"));
            obj.setDateCreated(dateCreated);
            obj.setCreatedBy(createdBy);
            obj.setDateModified(currentDate);
            obj.setModifiedBy(workflowUserManager.getCurrentUsername());
            obj.setLogDetails(row.getProperty("logDetails"));
            obj.setLog(row.getProperty("log"));
            dao.save(obj);
        }
        return rows;
    }
}

