/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.api.dao.ApiCredentialDao;
import org.joget.api.dao.ApiLogDao;
import org.joget.api.lib.ApiKeyDatalistBinder;
import org.joget.api.lib.ApiKeyDeleteAction;
import org.joget.api.lib.ApiKeyFormBinder;
import org.joget.api.model.ApiCredential;
import org.joget.api.service.ApiAppContext;
import org.joget.apps.app.dao.PluginDefaultPropertiesDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.PluginDefaultProperties;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.datalist.model.DataList;
import org.joget.apps.datalist.model.DataListAction;
import org.joget.apps.datalist.model.DataListActionResult;
import org.joget.apps.datalist.model.DataListBinder;
import org.joget.apps.datalist.service.DataListService;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.FormLoadBinder;
import org.joget.apps.form.model.FormStoreBinder;
import org.joget.apps.form.service.FormService;
import org.joget.apps.form.service.FormUtil;
import org.joget.apps.userview.model.UserviewMenu;
import org.joget.apps.userview.service.UserviewUtil;
import org.joget.commons.util.CsvUtil;
import org.joget.commons.util.ResourceBundleUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.Plugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.util.WorkflowUtil;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ApiKeyMenu
extends UserviewMenu
implements PluginWebSupport {
    private DataList cacheDataList = null;

    public String getCategory() {
        return "Enterprise";
    }

    public String getIcon() {
        return "";
    }

    public String getRenderPage() {
        return null;
    }

    public boolean isHomePageSupported() {
        return true;
    }

    public String getDecoratedMenu() {
        return null;
    }

    public String getName() {
        return "APIKeyMenu";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/apiPlugin");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/apiPlugin");
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/userview/apiMenu.json", null, (boolean)true, (String)"messages/apiPlugin");
    }

    public String getJspPage() {
        String mode = this.getRequestParameterString("_mode");
        if ("add".equals(mode) || "edit".equals(mode)) {
            this.setProperty("customHeader", this.getPropertyString(mode + "-customHeader"));
            this.setProperty("customFooter", this.getPropertyString(mode + "-customFooter"));
            this.setProperty("messageShowAfterComplete", this.getPropertyString(mode + "-messageShowAfterComplete"));
            return this.handleForm();
        }
        if ("log".equals(mode)) {
            this.setProperty("customHeader", this.getPropertyString("list-customHeader"));
            this.setProperty("customFooter", this.getPropertyString("list-customFooter"));
            return this.handleList("log");
        }
        if ("details".equals(mode)) {
            this.setProperty("customHeader", this.getPropertyString("list-customHeader"));
            this.setProperty("customFooter", this.getPropertyString("list-customFooter"));
            return this.handleForm();
        }
        this.setProperty("customHeader", this.getPropertyString("list-customHeader"));
        this.setProperty("customFooter", this.getPropertyString("list-customFooter"));
        return this.handleList(null);
    }

    protected String addParamToUrl(String url, String name, String value) {
        return StringUtil.addParamsToUrl((String)url, (String)name, (String)value);
    }

    protected String handleList(String type) {
        this.viewList(type);
        return "userview/plugin/datalist.jsp";
    }

    protected void viewList(String type) {
        try {
            DataList dataList = this.getDataList(type);
            if (dataList != null) {
                DataListActionResult ac = dataList.getActionResult();
                if (ac != null) {
                    if (ac.getMessage() != null && !ac.getMessage().isEmpty()) {
                        this.setAlertMessage(ac.getMessage());
                    }
                    if (ac.getType() != null && "REDIRECT".equals(ac.getType()) && ac.getUrl() != null && !ac.getUrl().isEmpty()) {
                        if ("REFERER".equals(ac.getUrl())) {
                            HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
                            if (request != null && request.getHeader("Referer") != null) {
                                this.setRedirectUrl(request.getHeader("Referer"));
                            } else {
                                this.setRedirectUrl("REFERER");
                            }
                        } else {
                            if (ac.getUrl().startsWith("?")) {
                                ac.setUrl(this.getUrl() + ac.getUrl());
                            }
                            this.setRedirectUrl(ac.getUrl());
                        }
                    }
                }
                this.setProperty("dataList", dataList);
            }
        }
        catch (Exception ex) {
            StringWriter out = new StringWriter();
            ex.printStackTrace(new PrintWriter(out));
            String message = ex.toString();
            message = message + "\r\n<pre class=\"stacktrace\">" + out.getBuffer() + "</pre>";
            this.setProperty("error", message);
        }
    }

    protected DataList getDataList(String type) throws BeansException {
        if (this.cacheDataList == null) {
            DataListService dataListService = (DataListService)AppUtil.getApplicationContext().getBean("dataListService");
            String json = null;
            if ("log".equals(type)) {
                json = AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/userview/apiLogDatalist.json", null, (boolean)true, (String)"messages/apiPlugin");
            } else {
                String newLabel = this.getPropertyString("list-newButtonLabel") != null && this.getPropertyString("list-newButtonLabel").trim().length() > 0 ? this.getPropertyString("list-newButtonLabel") : ResourceBundleUtil.getMessage((String)"userview.crudmenu.button.new");
                json = AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/userview/apiCredentialDatalist.json", (Object[])new String[]{newLabel}, (boolean)true, (String)"messages/apiPlugin");
            }
            this.cacheDataList = dataListService.fromJson(json);
            this.cacheDataList.setDisableQuickEdit(true);
            if ("log".equals(type)) {
                String id = this.getRequestParameterString("apiKey");
                this.cacheDataList.setBinder((DataListBinder)new ApiKeyDatalistBinder(id));
                this.cacheDataList.setCheckboxPosition("no");
                this.cacheDataList.setDefaultSortColumn("timestamp");
                this.cacheDataList.setDefaultOrder("1");
                ApiCredentialDao credentialDao = (ApiCredentialDao)ApiAppContext.getInstance().getAppContext().getBean("apiCredentialDao");
                ApiCredential credential = credentialDao.get(id);
                if (credential.getLogDetails() != null && credential.getLogDetails().equalsIgnoreCase("true")) {
                    this.cacheDataList = this.addDatalistButtons(this.cacheDataList, type);
                }
            } else {
                ApiKeyDatalistBinder binder = new ApiKeyDatalistBinder();
                binder.setProperty("apiId", this.getPropertyString("apiId"));
                this.cacheDataList.setBinder((DataListBinder)binder);
                this.cacheDataList.setActionPosition(this.getPropertyString("buttonPosition"));
                this.cacheDataList.setSelectionType(this.getPropertyString("selectionType"));
                this.cacheDataList.setCheckboxPosition(this.getPropertyString("checkboxPosition"));
                this.cacheDataList = this.addDatalistButtons(this.cacheDataList, type);
                ArrayList<Object> actionList = new ArrayList<Object>();
                actionList.addAll(Arrays.asList(this.cacheDataList.getActions()));
                ApiKeyDeleteAction action = new ApiKeyDeleteAction();
                String deleteLabel = this.getPropertyString("list-deleteButtonLabel") != null && this.getPropertyString("list-deleteButtonLabel").trim().length() > 0 ? this.getPropertyString("list-deleteButtonLabel") : ResourceBundleUtil.getMessage((String)"general.method.label.delete");
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("id", "delete_apiKey");
                properties.put("label", deleteLabel);
                properties.put("confirmation", AppPluginUtil.getMessage((String)"userview.api.delete", (String)this.getClassName(), (String)"messages/apiPlugin"));
                action.setProperties(properties);
                actionList.add((Object)action);
                this.cacheDataList.setActions(actionList.toArray(new DataListAction[actionList.size()]));
            }
        }
        return this.cacheDataList;
    }

    protected DataList addDatalistButtons(DataList dataList, String type) {
        if (type != null && type.equalsIgnoreCase("log")) {
            DataListBinder binder = dataList.getBinder();
            String primaryKeyColumn = "apiKey";
            if (binder != null) {
                primaryKeyColumn = binder.getPrimaryKeyColumnName();
            }
            if (primaryKeyColumn == null) {
                primaryKeyColumn = "apiKey";
            }
            HashMap<String, String> logProperties = new HashMap<String, String>();
            logProperties.put("id", "details_log");
            logProperties.put("label", "Details");
            logProperties.put("href", this.addParamToUrl(this.addParamToUrl(this.getUrl(), "_mode", "details"), "embed", "true"));
            logProperties.put("hrefParam", "id");
            logProperties.put("hrefColumn", primaryKeyColumn);
            logProperties.put("target", "popup");
            dataList.addDataListAction("org.joget.apps.datalist.lib.HyperlinkDataListAction", "rowAction", logProperties);
        } else if (type == null) {
            HashMap<String, String> editProperties = new HashMap<String, String>();
            editProperties.put("id", "edit_apiKey");
            editProperties.put("label", this.getPropertyString("list-editLinkLabel") != null && this.getPropertyString("list-editLinkLabel").trim().length() > 0 ? this.getPropertyString("list-editLinkLabel") : ResourceBundleUtil.getMessage((String)"general.method.label.edit"));
            editProperties.put("href", this.addParamToUrl(this.getUrl(), "_mode", "edit"));
            editProperties.put("hrefParam", "id");
            String primaryKeyColumn = "apiKey";
            DataListBinder binder = dataList.getBinder();
            if (binder != null) {
                primaryKeyColumn = binder.getPrimaryKeyColumnName();
            }
            if (primaryKeyColumn == null) {
                primaryKeyColumn = "apiKey";
            }
            editProperties.put("hrefColumn", primaryKeyColumn);
            dataList.addDataListAction("org.joget.apps.datalist.lib.HyperlinkDataListAction", "rowAction", editProperties);
            HashMap<String, String> logProperties = new HashMap<String, String>();
            logProperties.put("id", "apiKey_log");
            logProperties.put("label", AppPluginUtil.getMessage((String)"userview.api.logs", (String)this.getClassName(), (String)"messages/apiPlugin"));
            logProperties.put("href", this.addParamToUrl(this.addParamToUrl(this.getUrl(), "_mode", "log"), "embed", "true"));
            logProperties.put("hrefParam", "apiKey");
            logProperties.put("hrefColumn", primaryKeyColumn);
            logProperties.put("target", "popup");
            dataList.addDataListAction("org.joget.apps.datalist.lib.HyperlinkDataListAction", "rowAction", logProperties);
        }
        return dataList;
    }

    protected String handleForm() {
        if ("submit".equals(this.getRequestParameterString("_action"))) {
            HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
            if (request != null && !"POST".equalsIgnoreCase(request.getMethod())) {
                return "userview/plugin/unauthorized.jsp";
            }
            this.submitForm();
        } else {
            this.displayForm();
        }
        return "userview/plugin/form.jsp";
    }

    protected void displayForm() {
        String id = this.getRequestParameterString("id");
        ApplicationContext ac = AppUtil.getApplicationContext();
        FormService formService = (FormService)ac.getBean("formService");
        Form form = null;
        FormData formData = new FormData();
        form = this.retrieveDataForm(formData, id);
        if (form != null) {
            String formHtml = formService.retrieveFormHtml(form, formData);
            this.setProperty("view", "formView");
            this.setProperty("formHtml", formHtml);
        }
    }

    protected void submitForm() {
        String id = this.getRequestParameterString("id");
        ApplicationContext ac = AppUtil.getApplicationContext();
        FormService formService = (FormService)ac.getBean("formService");
        Form form = null;
        FormData formData = new FormData();
        form = this.retrieveDataForm(formData, id);
        if ((form = this.submitDataForm(formData, form)) != null) {
            String formHtml = null;
            Map errors = formData.getFormErrors();
            int errorCount = 0;
            if (!formData.getStay().booleanValue() && (errors == null || errors.isEmpty())) {
                String mode = this.getRequestParameterString("_mode");
                String redirectUrl = this.getPropertyString("redirectUrlAfterComplete");
                this.setRedirectUrl(redirectUrl);
                this.setAlertMessage(this.getPropertyString(mode + "-messageShowAfterComplete"));
                formHtml = formService.generateElementHtml((Element)form, formData);
            } else {
                formHtml = formService.generateElementErrorHtml((Element)form, formData);
                errorCount = errors.size();
            }
            if (formData.getStay().booleanValue()) {
                this.setAlertMessage("");
                this.setRedirectUrl("");
            }
            this.setProperty("view", "formView");
            this.setProperty("stay", formData.getStay());
            this.setProperty("submitted", Boolean.TRUE);
            this.setProperty("errorCount", errorCount);
            this.setProperty("formHtml", formHtml);
        }
    }

    protected Form retrieveDataForm(FormData formData, String primaryKeyValue) {
        Form form = null;
        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
        FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
        String mode = this.getRequestParameterString("_mode");
        Map requestParams = this.getRequestParameters();
        requestParams.put("_mode", this.getPropertyString("mode"));
        formData.setPrimaryKeyValue(primaryKeyValue);
        formData = formService.retrieveFormDataFromRequestMap(formData, requestParams);
        String formUrl = this.addParamToUrl(this.getUrl(), "_mode", mode) + "&_action=submit";
        if (primaryKeyValue != null) {
            try {
                formUrl = formUrl + "&id=" + URLEncoder.encode(primaryKeyValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        String submitLabel = ResourceBundleUtil.getMessage((String)"general.method.label.save");
        String cancelLabel = null;
        if ("add".equals(mode)) {
            if (this.getPropertyString("add-saveButtonLabel") != null && this.getPropertyString("add-saveButtonLabel").trim().length() > 0) {
                submitLabel = this.getPropertyString("add-saveButtonLabel");
            }
            cancelLabel = ResourceBundleUtil.getMessage((String)"general.method.label.cancel");
            if (this.getPropertyString("add-cancelButtonLabel") != null && this.getPropertyString("add-cancelButtonLabel").trim().length() > 0) {
                cancelLabel = this.getPropertyString("add-cancelButtonLabel");
            }
        } else if ("edit".equals(mode)) {
            if (this.getPropertyString("edit-saveButtonLabel") != null && this.getPropertyString("edit-saveButtonLabel").trim().length() > 0) {
                submitLabel = this.getPropertyString("edit-saveButtonLabel");
            }
            cancelLabel = ResourceBundleUtil.getMessage((String)"general.method.label.back");
            if (this.getPropertyString("edit-backButtonLabel") != null && this.getPropertyString("edit-backButtonLabel").trim().length() > 0) {
                cancelLabel = this.getPropertyString("edit-backButtonLabel");
            }
        }
        if (mode.equalsIgnoreCase("details")) {
            String formJson = AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/userview/apiDetailsForm.json", null, (boolean)true, (String)"messages/apiPlugin");
            formJson = AppUtil.processHashVariable((String)formJson, null, (String)"json", null);
            form = formService.loadFormFromJson(formJson, formData);
        } else {
            String formJson = AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/userview/apiForm.json", (Object[])new Object[]{this.getServiceUrl(), this.getServiceUrl()}, (boolean)true, (String)"messages/apiPlugin");
            formJson = AppUtil.processHashVariable((String)formJson, null, (String)"json", null);
            form = formService.loadFormFromJson(formJson, formData);
        }
        if (form != null) {
            String idValue;
            ApiKeyFormBinder binder;
            if (mode.equalsIgnoreCase("details")) {
                binder = new ApiKeyFormBinder(primaryKeyValue);
                binder.setProperty("apiId", this.getPropertyString("apiId"));
            } else {
                binder = new ApiKeyFormBinder(null);
                binder.setProperty("apiId", this.getPropertyString("apiId"));
            }
            form.setLoadBinder((FormLoadBinder)binder);
            form.setStoreBinder((FormStoreBinder)binder);
            form = formService.loadFormData(form, formData);
            form.setProperty("removeQuickEdit", (Object)"true");
            form = appService.viewDataForm(form, null, submitLabel, cancelLabel, "window", formData, formUrl, this.getUrl());
            Element el = FormUtil.findElement((String)"id", (Element)form, (FormData)formData);
            if (el != null && (idValue = FormUtil.getElementPropertyValue((Element)el, (FormData)formData)) != null && !idValue.trim().isEmpty() && !"".equals(formData.getRequestParameter("_FORM_META_ORIGINAL_ID"))) {
                el.setProperty("readonly", (Object)"true");
            }
        }
        if ("edit".equals(mode)) {
            Boolean readonly = "yes".equalsIgnoreCase(this.getPropertyString("edit-readonly"));
            Boolean readonlyLabel = "true".equalsIgnoreCase(this.getPropertyString("edit-readonlyLabel"));
            if (readonly.booleanValue() || readonlyLabel.booleanValue()) {
                FormUtil.setReadOnlyProperty((Element)form, (Boolean)readonly, (Boolean)readonlyLabel);
            }
        }
        return form;
    }

    protected Form submitDataForm(FormData formData, Form form) {
        ApplicationContext ac = AppUtil.getApplicationContext();
        FormService formService = (FormService)ac.getBean("formService");
        formData = formService.retrieveFormDataFromRequestMap(formData, this.getRequestParameters());
        formData = formService.executeFormActions(form, formData);
        this.setProperty("submitted", Boolean.TRUE);
        String redirectUrl = this.getUrl();
        this.setProperty("redirectUrlAfterComplete", redirectUrl);
        return form;
    }

    protected Map getHyperlinkDataListActionProperties(String label, String href, String hrefParam, String hrefColumn, String confirmation, boolean visible) {
        HashMap<String, String> actionProperties = new HashMap<String, String>();
        actionProperties.put("id", "LR_" + label.replace(" ", "_"));
        actionProperties.put("label", label);
        actionProperties.put("href", href);
        actionProperties.put("hrefParam", hrefParam);
        actionProperties.put("hrefColumn", hrefColumn);
        actionProperties.put("confirmation", confirmation);
        actionProperties.put("visible", Boolean.toString(visible));
        return actionProperties;
    }

    protected String getServiceUrl() {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        String userviewId = this.getUserview().getPropertyString("id");
        String key = this.getKey() != null ? this.getKey() : "";
        String menuId = this.getPropertyString("customId");
        if (menuId == null || menuId.trim().isEmpty()) {
            menuId = this.getPropertyString("id");
        }
        String nonce = SecurityUtil.generateNonce((String[])new String[]{"ApiKeyMenu", appDef.getId(), appDef.getVersion().toString(), userviewId, key, menuId}, (int)3);
        try {
            nonce = URLEncoder.encode(nonce, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String url = WorkflowUtil.getHttpServletRequest().getContextPath() + "/web/json/app/" + appDef.getId() + "/" + appDef.getVersion() + "/plugin/org.joget.api.lib.ApiKeyMenu/service?userviewId=" + userviewId + "&menuId=" + menuId + "&key=" + key + "&_nonce=" + nonce;
        return url;
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        try {
            String userviewId = request.getParameter("userviewId");
            String key = request.getParameter("key");
            String menuId = request.getParameter("menuId");
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            String nonce = request.getParameter("_nonce");
            if (!SecurityUtil.verifyNonce((String)nonce, (String[])new String[]{"ApiKeyMenu", appDef.getAppId(), appDef.getVersion().toString(), userviewId, key, menuId})) {
                response.setStatus(403);
                return;
            }
            if ("config".equals(action)) {
                String submit = request.getParameter("submit");
                String pluginClass = request.getParameter("pluginClass");
                String pluginProperties = request.getParameter("pluginProp");
                if ("post".equalsIgnoreCase(request.getMethod()) && "true".equals(submit)) {
                    pluginProperties = request.getParameter("pluginProperties");
                    this.write("<script>window.parent.updatePluginProps(\"" + StringUtil.escapeString((String)pluginProperties, (String)"json", null) + "\");</script>", response);
                } else {
                    AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                    PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                    PluginDefaultPropertiesDao pluginDefaultPropertiesDao = (PluginDefaultPropertiesDao)AppUtil.getApplicationContext().getBean("pluginDefaultPropertiesDao");
                    Plugin plugin = pluginManager.getPlugin(pluginClass);
                    HashMap<String, Object> modelMap = new HashMap<String, Object>();
                    modelMap.put("properties", pluginProperties);
                    if (plugin != null) {
                        modelMap.put("propertyEditable", (PropertyEditable)plugin);
                        modelMap.put("plugin", plugin);
                        PluginDefaultProperties pluginDefaultProperties = (PluginDefaultProperties)pluginDefaultPropertiesDao.loadById(pluginClass, appDef);
                        if (pluginDefaultProperties != null) {
                            if (!(plugin instanceof PropertyEditable)) {
                                Map defaultPropertyMap = new HashMap();
                                String properties = pluginDefaultProperties.getPluginProperties();
                                if (properties != null && properties.trim().length() > 0) {
                                    defaultPropertyMap = CsvUtil.getPluginPropertyMap((String)properties);
                                }
                                modelMap.put("defaultPropertyMap", defaultPropertyMap);
                            } else {
                                modelMap.put("defaultProperties", PropertyUtil.propertiesJsonLoadProcessing((String)pluginDefaultProperties.getPluginProperties()));
                            }
                        }
                    }
                    String url = "?" + request.getQueryString() + "&submit=true&action=config";
                    url = StringUtil.addParamsToUrl((String)url, (String)"_nonce", (String)nonce);
                    modelMap.put("actionUrl", url);
                    String content = UserviewUtil.renderJspAsString((String)"console/plugin/pluginConfig.jsp", modelMap);
                    content = this.fixI18nForNoneAdminUser(content);
                    this.write(this.fixMissingLabel(content), response);
                }
            } else {
                response.setStatus(204);
            }
        }
        catch (Exception e) {
            response.setStatus(204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String fixI18nForNoneAdminUser(String content) {
        if (!WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN")) {
            Pattern pattern = Pattern.compile("<script type=\\\"text/javascript\\\" src=\\\".+/web/console/i18n/peditor.+\\\"></script>");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String script = matcher.group();
                Properties keys = new Properties();
                InputStream inputStream = null;
                try {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("peditor.properties");
                    if (inputStream == null) continue;
                    keys.load(inputStream);
                    String replace = "<script>var peditor_lang = {";
                    for (Object k : keys.keySet()) {
                        replace = replace + "'" + k.toString() + "' : '" + StringUtil.escapeString((String)keys.getProperty(k.toString()), (String)"json", null) + "',";
                    }
                    replace = replace + " lang_file_name : 'peditor.properties'}\n";
                    replace = replace + "function get_peditor_msg(key){\n    return (peditor_lang[key] !== undefined) ? peditor_lang[key] : '??'+key+'??';\n}\n</script>";
                    content = content.replaceAll(StringUtil.escapeRegex((String)script), StringUtil.escapeRegex((String)replace));
                }
                catch (Exception exception) {}
                continue;
                finally {
                    if (inputStream == null) continue;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return content;
    }

    protected void write(String content, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        writer.write(content);
    }

    protected String fixMissingLabel(String content) {
        content = content.replaceAll(StringUtil.escapeRegex((String)"???"), StringUtil.escapeRegex((String)"@@"));
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        content = pluginManager.processPluginTranslation(content, this.getClassName(), null);
        content = content.replaceAll(StringUtil.escapeRegex((String)"@@"), StringUtil.escapeRegex((String)"???"));
        return content;
    }

    public static void deleteApiKey(String apiKey) {
        ApiCredentialDao apiCredentialDao = (ApiCredentialDao)ApiAppContext.getInstance().getAppContext().getBean("apiCredentialDao");
        ApiCredential apiCredential = apiCredentialDao.get(apiKey);
        if (apiCredential != null) {
            ApiLogDao apiLogDao = (ApiLogDao)ApiAppContext.getInstance().getAppContext().getBean("apiLogDao");
            apiCredentialDao.delete(apiKey);
            apiLogDao.deleteByApiKey(apiKey);
        }
    }
}

