/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.model.FieldsSerializer;
import org.joget.api.service.ApiService;
import org.joget.apps.app.dao.AppDefinitionDao;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.dao.DatalistDefinitionDao;
import org.joget.apps.app.dao.EnvironmentVariableDao;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.dao.UserviewDefinitionDao;
import org.joget.apps.app.model.AbstractAppVersionedObject;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.model.DatalistDefinition;
import org.joget.apps.app.model.EnvironmentVariable;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.model.PackageDefinition;
import org.joget.apps.app.model.UserviewDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.workflow.model.WorkflowProcess;
import org.joget.workflow.model.service.WorkflowManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppAPI
extends ApiPluginAbstract {
    public String getName() {
        return "AppAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-edit\"></i>";
    }

    @Override
    public String getTag() {
        return "app";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/versions", type=Operation.MethodType.GET, summary="@@AppAPI.versions.summary@@", description="@@AppAPI.versions.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="AppDefinition", array=true)})
    public ApiResponse versions(@Param(value="sort", required=false, description="@@AppAPI.versions.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.versions.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.versions.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.versions.pageSize.desc@@") Integer pageSize) {
        AppDefinitionDao dao = (AppDefinitionDao)AppUtil.getApplicationContext().getBean("appDefinitionDao");
        Collection objs = dao.findVersions(AppUtil.getCurrentAppDefinition().getId(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, objs, this.getAppDefinitionFields());
    }

    @Operation(path="/published", type=Operation.MethodType.GET, summary="@@AppAPI.published.summary@@", description="@@AppAPI.published.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="AppDefinition"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse published() {
        return new ApiResponse(200, AppUtil.getCurrentAppDefinition(), this.getAppDefinitionFields());
    }

    @Operation(path="/new/{version}", summary="@@AppAPI.newVersion.summary@@", description="@@AppAPI.newVersion.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="AppDefinition"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse newVersion(@Param(value="version", description="@@AppAPI.newVersion.version.desc@@") Long version) {
        AppService service = (AppService)AppUtil.getApplicationContext().getBean("appService");
        AppDefinition appDef = null;
        appDef = new Long(0L).equals(version) ? service.createNewAppDefinitionVersion(AppUtil.getCurrentAppDefinition().getId()) : service.createNewAppDefinitionVersion(AppUtil.getCurrentAppDefinition().getId(), version);
        if (appDef != null) {
            return new ApiResponse(200, AppUtil.getCurrentAppDefinition(), this.getAppDefinitionFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/delete/{version}", type=Operation.MethodType.DELETE, summary="@@AppAPI.deleteVersion.summary@@", description="@@AppAPI.deleteVersion.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteVersion(@Param(value="version", description="@@AppAPI.deleteVersion.version.desc@@") Long version) {
        AppService service = (AppService)AppUtil.getApplicationContext().getBean("appService");
        try {
            service.deleteAppDefinitionVersion(AppUtil.getCurrentAppDefinition().getId(), version);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/list/form", type=Operation.MethodType.GET, summary="@@AppAPI.listForm.summary@@", description="@@AppAPI.listForm.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDefinition", array=true)})
    public ApiResponse listForm(@Param(value="nameFilter", required=false, description="@@AppAPI.listForm.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.listForm.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.listForm.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.listForm.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.listForm.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        FormDefinitionDao dao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
        Collection list = dao.getFormDefinitionList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, list, this.getFormDefinitionFields(), false, this.getCustomSerializers((Type)((Object)FormDefinition.class), this.getFormDefinitionFields()));
    }

    @Operation(path="/list/datalist", type=Operation.MethodType.GET, summary="@@AppAPI.listDatalist.summary@@", description="@@AppAPI.listDatalist.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="DatalistDefinition", array=true)})
    public ApiResponse listDatalist(@Param(value="nameFilter", required=false, description="@@AppAPI.listDatalist.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.listDatalist.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.listDatalist.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.listDatalist.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.listDatalist.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        DatalistDefinitionDao dao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
        Collection list = dao.getDatalistDefinitionList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, list, this.getDatalistDefinitionFields(), false, this.getCustomSerializers((Type)((Object)DatalistDefinition.class), this.getDatalistDefinitionFields()));
    }

    @Operation(path="/list/userview", type=Operation.MethodType.GET, summary="@@AppAPI.listUserview.summary@@", description="@@AppAPI.listUserview.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="UserviewDefinition", array=true)})
    public ApiResponse listUserview(@Param(value="nameFilter", required=false, description="@@AppAPI.listUserview.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.listUserview.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.listUserview.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.listUserview.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.listUserview.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        UserviewDefinitionDao dao = (UserviewDefinitionDao)AppUtil.getApplicationContext().getBean("userviewDefinitionDao");
        Collection list = dao.getUserviewDefinitionList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, list, this.getUserviewDefinitionFields(), false, this.getCustomSerializers((Type)((Object)UserviewDefinition.class), this.getUserviewDefinitionFields()));
    }

    @Operation(path="/list/{builder}", type=Operation.MethodType.GET, summary="@@AppAPI.listCustomBuilder.summary@@", description="@@AppAPI.listCustomBuilder.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="BuilderDefinition", array=true)})
    public ApiResponse listCustomBuilder(@Param(value="builder", description="@@AppAPI.listCustomBuilder.builder.desc@@") String builder, @Param(value="nameFilter", required=false, description="@@AppAPI.listCustomBuilder.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.listCustomBuilder.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.listCustomBuilder.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.listCustomBuilder.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.listCustomBuilder.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        BuilderDefinitionDao dao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        Collection list = dao.getBuilderDefinitionList(builder, nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, list, this.getBuilderDefinitionFields(), false, this.getCustomSerializers((Type)((Object)BuilderDefinition.class), this.getBuilderDefinitionFields()));
    }

    @Operation(path="/form/definition/{id}", type=Operation.MethodType.GET, summary="@@AppAPI.getFormJsonDefinition.summary@@", description="@@AppAPI.getFormJsonDefinition.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getFormJsonDefinition(@Param(value="id", description="@@AppAPI.getFormJsonDefinition.id.desc@@") String id) {
        FormDefinitionDao dao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
        FormDefinition def = dao.loadById(id, AppUtil.getCurrentAppDefinition());
        if (def != null) {
            return new ApiResponse(200, def.getJson(), "");
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/datalist/definition/{id}", type=Operation.MethodType.GET, summary="@@AppAPI.getDatalistJsonDefinition.summary@@", description="@@AppAPI.getDatalistJsonDefinition.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getDatalistJsonDefinition(@Param(value="id", description="@@AppAPI.getDatalistJsonDefinition.id.desc@@") String id) {
        DatalistDefinitionDao dao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
        DatalistDefinition def = (DatalistDefinition)dao.loadById(id, AppUtil.getCurrentAppDefinition());
        if (def != null) {
            return new ApiResponse(200, def.getJson(), "");
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/userview/definition/{id}", type=Operation.MethodType.GET, summary="@@AppAPI.getUserviewJsonDefinition.summary@@", description="@@AppAPI.getUserviewJsonDefinition.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getUserviewJsonDefinition(@Param(value="id", description="@@AppAPI.getUserviewJsonDefinition.id.desc@@") String id) {
        UserviewDefinitionDao dao = (UserviewDefinitionDao)AppUtil.getApplicationContext().getBean("userviewDefinitionDao");
        UserviewDefinition def = (UserviewDefinition)dao.loadById(id, AppUtil.getCurrentAppDefinition());
        if (def != null) {
            return new ApiResponse(200, def.getJson(), "");
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/{builder}/definition/{id}", type=Operation.MethodType.GET, summary="@@AppAPI.getCustomBuilderJsonDefinition.summary@@", description="@@AppAPI.getCustomBuilderJsonDefinition.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getCustomBuilderJsonDefinition(@Param(value="builder", description="@@AppAPI.getCustomBuilderJsonDefinition.builder.desc@@") String builder, @Param(value="id", description="@@AppAPI.getCustomBuilderJsonDefinition.id.desc@@") String id) {
        BuilderDefinitionDao dao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition def = dao.loadById(id, AppUtil.getCurrentAppDefinition());
        if (def != null) {
            return new ApiResponse(200, def.getJson(), "");
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/form/options", type=Operation.MethodType.GET, summary="@@AppAPI.formOptions.summary@@", description="@@AppAPI.formOptions.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Option", array=true)})
    public ApiResponse formOptions(@Param(value="nameFilter", required=false, description="@@AppAPI.formOptions.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.formOptions.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.formOptions.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.formOptions.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.formOptions.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        FormDefinitionDao dao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
        Collection list = dao.getFormDefinitionList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        JSONArray jsonArray = new JSONArray();
        HashMap<String, String> blank = new HashMap<String, String>();
        blank.put("value", "");
        blank.put("label", "");
        jsonArray.put(blank);
        for (FormDefinition def : list) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("value", def.getId());
            data.put("label", def.getName());
            jsonArray.put(data);
        }
        return new ApiResponse(200, jsonArray);
    }

    @Operation(path="/datalist/options", type=Operation.MethodType.GET, summary="@@AppAPI.datalistOptions.summary@@", description="@@AppAPI.datalistOptions.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Option", array=true)})
    public ApiResponse datalistOptions(@Param(value="nameFilter", required=false, description="@@AppAPI.datalistOptions.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.datalistOptions.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.datalistOptions.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.datalistOptions.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.datalistOptions.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        DatalistDefinitionDao dao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
        Collection list = dao.getDatalistDefinitionList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        JSONArray jsonArray = new JSONArray();
        HashMap<String, String> blank = new HashMap<String, String>();
        blank.put("value", "");
        blank.put("label", "");
        jsonArray.put(blank);
        for (DatalistDefinition def : list) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("value", def.getId());
            data.put("label", def.getName());
            jsonArray.put(data);
        }
        return new ApiResponse(200, jsonArray);
    }

    @Operation(path="/userview/options", type=Operation.MethodType.GET, summary="@@AppAPI.userviewOptions.summary@@", description="@@AppAPI.userviewOptions.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Option", array=true)})
    public ApiResponse userviewOptions(@Param(value="nameFilter", required=false, description="@@AppAPI.userviewOptions.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.userviewOptions.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.userviewOptions.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.userviewOptions.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.userviewOptions.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        UserviewDefinitionDao dao = (UserviewDefinitionDao)AppUtil.getApplicationContext().getBean("userviewDefinitionDao");
        Collection list = dao.getUserviewDefinitionList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        JSONArray jsonArray = new JSONArray();
        HashMap<String, String> blank = new HashMap<String, String>();
        blank.put("value", "");
        blank.put("label", "");
        jsonArray.put(blank);
        for (UserviewDefinition def : list) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("value", def.getId());
            data.put("label", def.getName());
            jsonArray.put(data);
        }
        return new ApiResponse(200, jsonArray);
    }

    @Operation(path="/{builder}/options", type=Operation.MethodType.GET, summary="@@AppAPI.customBuilderOptions.summary@@", description="@@AppAPI.customBuilderOptions.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Option", array=true)})
    public ApiResponse customBuilderOptions(@Param(value="builder", description="@@AppAPI.customBuilderOptions.builder.desc@@") String builder, @Param(value="nameFilter", required=false, description="@@AppAPI.customBuilderOptions.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.customBuilderOptions.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.customBuilderOptions.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.customBuilderOptions.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.customBuilderOptions.pageSize.desc@@") Integer pageSize) {
        if (sort == null) {
            sort = "name";
            desc = false;
        }
        BuilderDefinitionDao dao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        Collection list = dao.getBuilderDefinitionList(builder, nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        JSONArray jsonArray = new JSONArray();
        HashMap<String, String> blank = new HashMap<String, String>();
        blank.put("value", "");
        blank.put("label", "");
        jsonArray.put(blank);
        for (BuilderDefinition def : list) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("value", def.getId());
            data.put("label", def.getName());
            jsonArray.put(data);
        }
        return new ApiResponse(200, jsonArray);
    }

    @Operation(path="/process/options", type=Operation.MethodType.GET, summary="@@AppAPI.processOptions.summary@@", description="@@AppAPI.processOptions.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Option", array=true)})
    public ApiResponse processOptions() {
        JSONArray jsonArray = new JSONArray();
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        PackageDefinition packageDefinition = appDef.getPackageDefinition();
        if (packageDefinition != null) {
            Long packageVersion = packageDefinition != null ? packageDefinition.getVersion() : new Long(1L);
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            Collection processList = workflowManager.getProcessList(appDef.getAppId(), packageVersion.toString());
            HashMap<String, String> empty = new HashMap<String, String>();
            empty.put("value", "");
            empty.put("label", "");
            jsonArray.put(empty);
            for (WorkflowProcess p : processList) {
                HashMap<String, String> option = new HashMap<String, String>();
                option.put("value", p.getIdWithoutVersion());
                option.put("label", p.getName() + " (" + p.getIdWithoutVersion() + ")");
                jsonArray.put(option);
            }
        }
        return new ApiResponse(200, jsonArray);
    }

    @Operation(path="/xpdl", type=Operation.MethodType.GET, summary="@@AppAPI.xpdl.summary@@", description="@@AppAPI.xpdl.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", contentType="application/xml"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse xpdl() {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            PackageDefinition packageDef = appDef.getPackageDefinition();
            if (packageDef != null) {
                WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
                byte[] content = workflowManager.getPackageContent(packageDef.getId(), packageDef.getVersion().toString());
                String xpdl = new String(content, "UTF-8");
                return new ApiResponse(200, xpdl, "application/xml; charset=utf-8");
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/deploy/xpdl", summary="@@AppAPI.deployXpdl.summary@@", description="@@AppAPI.deployXpdl.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse deployXpdl(@Param(value="xpdl", description="@@AppAPI.xpdl.body@@") byte[] xpdl) {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            appService.deployWorkflowPackage(appDef.getAppId(), appDef.getVersion().toString(), xpdl, false);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/environment", summary="@@AppAPI.addEnvironmentVariable.summary@@", description="@@AppAPI.addEnvironmentVariable.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="EnvironmentVariable"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse addEnvironmentVariable(@Param(value="body", description="@@AppAPI.addEnvironmentVariable.body.desc@@", definition="EnvironmentVariable") JSONObject body) {
        EnvironmentVariableDao dao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        EnvironmentVariable envNew = this.buildEnvironmentVariable("add", body, null);
        if (dao.add((AbstractAppVersionedObject)envNew)) {
            return new ApiResponse(200, envNew, this.getEnvironmentFields());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/environment", type=Operation.MethodType.PUT, summary="@@AppAPI.updateEnvironmentVariable.summary@@", description="@@AppAPI.updateEnvironmentVariable.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="EnvironmentVariable"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateEnvironmentVariable(@Param(value="body", description="@@AppAPI.updateEnvironmentVariable.body.desc@@", definition="EnvironmentVariable") JSONObject body) {
        EnvironmentVariableDao dao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
        EnvironmentVariable envExisting = (EnvironmentVariable)dao.loadById(body.getString("id"), AppUtil.getCurrentAppDefinition());
        EnvironmentVariable envNew = this.buildEnvironmentVariable("update", body, envExisting);
        if (envExisting != null) {
            ApiService.mergeObject(envExisting, envNew);
            if (dao.update((AbstractAppVersionedObject)envExisting)) {
                return new ApiResponse(200, envExisting, this.getEnvironmentFields());
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    public EnvironmentVariable buildEnvironmentVariable(String operation, JSONObject body, EnvironmentVariable envExisting) {
        EnvironmentVariable envNew = new EnvironmentVariable();
        AppDefinition appDef = null;
        if (operation.equals("add")) {
            appDef = AppUtil.getCurrentAppDefinition();
            envNew.setAppDefinition(appDef);
        }
        if (operation.equals("add") && appDef != null) {
            envNew.setAppId(appDef.getAppId());
            envNew.setAppVersion(appDef.getVersion());
        } else if (operation.equals("update") && envExisting != null) {
            envNew.setAppId(envExisting.getAppId());
            envNew.setAppVersion(envExisting.getAppVersion());
        }
        envNew.setId(body.getString("id"));
        envNew.setValue(body.getString("value"));
        envNew.setRemarks(body.getString("remarks"));
        if (operation.equals("update") && envExisting != null) {
            envNew.setDateCreated(envExisting.getDateCreated());
            envNew.setDateModified(envExisting.getDateModified());
        }
        return envNew;
    }

    @Operation(path="/environment/find", type=Operation.MethodType.GET, summary="@@AppAPI.findEnvironmentVariable.summary@@", description="@@AppAPI.findEnvironmentVariable.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="EnvironmentVariable", array=true), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse findEnvironmentVariable(@Param(value="nameFilter", required=false, description="@@AppAPI.findEnvironmentVariable.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@AppAPI.findEnvironmentVariable.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AppAPI.findEnvironmentVariable.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AppAPI.findEnvironmentVariable.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppAPI.findEnvironmentVariable.pageSize.desc@@") Integer pageSize) {
        EnvironmentVariableDao dao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
        Collection envs = dao.getEnvironmentVariableList(nameFilter, AppUtil.getCurrentAppDefinition(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, envs, this.getEnvironmentFields());
    }

    @Operation(path="/environment/increaseCounter", type=Operation.MethodType.PUT, summary="@@AppAPI.increaseEnvironmentVariable.summary@@", description="@@AppAPI.increaseEnvironmentVariable.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="EnvironmentVariable"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse increaseEnvironmentVariable(@Param(value="id", description="@@AppAPI.increaseEnvironmentVariable.id.desc@@") String id, @Param(value="amount", required=false, description="@@AppAPI.increaseEnvironmentVariable.amount.desc@@") Integer amount) {
        EnvironmentVariableDao dao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
        Integer v = null;
        if (amount == null || amount < 1) {
            amount = 1;
        }
        for (int i = 1; i <= amount; ++i) {
            v = dao.getIncreasedCounter(id, "", AppUtil.getCurrentAppDefinition());
        }
        if (v != null) {
            return new ApiResponse(200, dao.loadById(id, AppUtil.getCurrentAppDefinition()), this.getEnvironmentFields());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/environment/{id}", type=Operation.MethodType.GET, summary="@@AppAPI.getEnvironmentVariable.summary@@", description="@@AppAPI.getEnvironmentVariable.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="EnvironmentVariable"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getEnvironmentVariable(@Param(value="id", description="@@AppAPI.getEnvironmentVariable.id.desc@@") String id) {
        EnvironmentVariableDao dao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
        EnvironmentVariable env = (EnvironmentVariable)dao.loadById(id, AppUtil.getCurrentAppDefinition());
        if (env != null) {
            return new ApiResponse(200, env, this.getEnvironmentFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/environment/{id}", type=Operation.MethodType.DELETE, summary="@@AppAPI.deleteEnvironmentVariable.summary@@", description="@@AppAPI.deleteEnvironmentVariable.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteEnvironmentVariable(@Param(value="id", description="@@AppAPI.deleteEnvironmentVariable.id.desc@@") String id) {
        EnvironmentVariableDao dao = (EnvironmentVariableDao)AppUtil.getApplicationContext().getBean("environmentVariableDao");
        EnvironmentVariable env = (EnvironmentVariable)dao.loadById(id, AppUtil.getCurrentAppDefinition());
        if (env != null) {
            dao.delete(id, AppUtil.getCurrentAppDefinition());
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    protected String[] getEnvironmentFields() {
        return new String[]{"id", "value", "remarks"};
    }

    protected String[] getAppDefinitionFields() {
        return new String[]{"id", "name", "version", "dateCreated", "dateModified", "description", "meta", "published"};
    }

    protected String[] getFormDefinitionFields() {
        return new String[]{"id", "name", "dateCreated", "dateModified", "description", "tableName"};
    }

    protected String[] getDatalistDefinitionFields() {
        return new String[]{"id", "name", "dateCreated", "dateModified", "description"};
    }

    protected String[] getUserviewDefinitionFields() {
        return new String[]{"id", "name", "dateCreated", "dateModified", "description", "thumbnail"};
    }

    protected String[] getBuilderDefinitionFields() {
        return new String[]{"id", "name", "dateCreated", "dateModified", "description", "type"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("AppDefinition", new ApiDefinition(new AppDefinition(), this.getAppDefinitionFields()));
        defs.put("FormDefinition", new ApiDefinition(new FormDefinition(), this.getFormDefinitionFields()));
        defs.put("DatalistDefinition", new ApiDefinition(new DatalistDefinition(), this.getDatalistDefinitionFields()));
        defs.put("UserviewDefinition", new ApiDefinition(new UserviewDefinition(), this.getUserviewDefinitionFields()));
        defs.put("BuilderDefinition", new ApiDefinition(new BuilderDefinition(), this.getBuilderDefinitionFields()));
        defs.put("EnvironmentVariable", new ApiDefinition(new EnvironmentVariable(), this.getEnvironmentFields()));
        LinkedHashMap<String, Class> apiResponseDef = new LinkedHashMap<String, Class>();
        apiResponseDef.put("value", String.class);
        apiResponseDef.put("label", String.class);
        defs.put("Option", new ApiDefinition(apiResponseDef));
        return defs;
    }

    protected Map<Type, JsonSerializer> getCustomSerializers(Type type, String[] fields) {
        HashMap<Type, JsonSerializer> serializers = new HashMap<Type, JsonSerializer>();
        serializers.put(type, new FieldsSerializer(fields));
        return serializers;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

