/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.lib.APIFormUtil;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.model.JSONOrderedObject;
import org.joget.api.service.ApiService;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.lib.FileUpload;
import org.joget.apps.form.lib.Grid;
import org.joget.apps.form.model.AbstractSubForm;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.FileDownloadSecurity;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormContainer;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.apps.form.model.GridInnerDataRetriever;
import org.joget.apps.form.service.FileUtil;
import org.joget.apps.form.service.FormService;
import org.joget.apps.form.service.FormUtil;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppFormAPI
extends ApiPluginAbstract {
    public String getName() {
        return "AppFormAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)("/properties/api/" + this.getName() + ".json"), null, (boolean)true, (String)this.getResourceBundlePath());
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-file-alt\"></i>";
    }

    @Override
    public String getTag() {
        return "form/{formDefId}";
    }

    @Operation(path="/", summary="@@FormAPI.addFormData.summary@@", description="@@FormAPI.addFormData.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDataResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@")})
    public ApiResponse addFormData(@Param(value="body", description="@@FormAPI.addFormData.body.desc@@", definition="{formDefId}-FormData") JSONObject body) {
        try {
            Form form = this.getForm();
            FormData formData = new FormData();
            if ("true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                formData.addFormResult("_PREVIEW_MODE", "true");
            }
            if (body.has("id") && !body.getString("id").isEmpty()) {
                formData.setPrimaryKeyValue(body.getString("id"));
                FormUtil.executeLoadBinders((Element)form, (FormData)formData);
                FormRowSet rows = formData.getLoadBinderData((Element)form);
                if (!rows.isEmpty()) {
                    return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405.InvalidID", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                }
            }
            APIFormUtil.jsonToFormData((Element)form, formData, body, this.getPropertyString("ignorePermission"));
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            FormData submitted = appService.submitForm(form, formData, false);
            JSONObject resp = new JSONObject();
            if (submitted.getFormErrors().isEmpty()) {
                resp.put("id", (Object)form.getPrimaryKeyValue(submitted));
                resp.put("errors", new HashMap());
            } else {
                resp.put("id", (Object)"");
                resp.put("errors", submitted.getFormErrors());
            }
            return new ApiResponse(200, resp);
        }
        catch (JSONException e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(500, AppPluginUtil.getMessage((String)"FormAPI.resp.500", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/saveOrUpdate", summary="@@FormAPI.addOrUpdateFormData.summary@@", description="@@FormAPI.addOrUpdateFormData.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDataResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@")})
    public ApiResponse saveOrUpdateFormData(@Param(value="body", description="@@FormAPI.addFormData.body.desc@@", definition="{formDefId}-FormData") JSONObject body) {
        try {
            Form form = this.getForm();
            FormData formData = new FormData();
            if ("true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                formData.addFormResult("_PREVIEW_MODE", "true");
            }
            if (body.has("id") && !body.getString("id").isEmpty()) {
                String idValue;
                Element el;
                formData.setPrimaryKeyValue(body.getString("id"));
                FormUtil.executeLoadBinders((Element)form, (FormData)formData);
                FormRowSet rows = formData.getLoadBinderData((Element)form);
                if (!(rows.isEmpty() || (el = FormUtil.findElement((String)"id", (Element)form, (FormData)formData)) == null || (idValue = FormUtil.getElementPropertyValue((Element)el, (FormData)formData)) == null || idValue.trim().isEmpty() || "".equals(formData.getRequestParameter("_FORM_META_ORIGINAL_ID")))) {
                    el.setProperty("readonly", (Object)"true");
                }
            }
            APIFormUtil.jsonToFormData((Element)form, formData, body, this.getPropertyString("ignorePermission"));
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            FormData submitted = appService.submitForm(form, formData, false);
            JSONObject resp = new JSONObject();
            if (submitted.getFormErrors().isEmpty()) {
                resp.put("id", (Object)form.getPrimaryKeyValue(submitted));
                resp.put("errors", new HashMap());
            } else {
                resp.put("id", (Object)"");
                resp.put("errors", submitted.getFormErrors());
            }
            return new ApiResponse(200, resp);
        }
        catch (JSONException e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(500, AppPluginUtil.getMessage((String)"FormAPI.resp.500", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/addWithFiles", summary="@@FormAPI.addFormDataWithFiles.summary@@", description="@@FormAPI.addFormData.desc@@", bodyContentType="multipart/form-data")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDataResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@")})
    public ApiResponse addFormDataWithFiles(@Param(value="body", description="@@FormAPI.addFormData.body.desc@@", definition="{formDefId}-FormDataWithFiles") Map body) {
        try {
            String id;
            FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
            Form form = this.getForm();
            FormData formData = new FormData();
            formData = formService.retrieveFormDataFromRequestMap(formData, body);
            this.handleGridData((Element)form, formData);
            if ("true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                formData.addFormResult("_PREVIEW_MODE", "true");
            }
            if ((id = formData.getRequestParameter("id")) != null && !id.isEmpty()) {
                formData.setPrimaryKeyValue(id);
                FormUtil.executeLoadBinders((Element)form, (FormData)formData);
                FormRowSet rows = formData.getLoadBinderData((Element)form);
                if (!rows.isEmpty()) {
                    return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405.InvalidID", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                }
            }
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            FormData submitted = appService.submitForm(form, formData, false);
            JSONObject resp = new JSONObject();
            if (submitted.getFormErrors().isEmpty()) {
                resp.put("id", (Object)form.getPrimaryKeyValue(submitted));
                resp.put("errors", new HashMap());
            } else {
                resp.put("id", (Object)"");
                resp.put("errors", submitted.getFormErrors());
            }
            return new ApiResponse(200, resp);
        }
        catch (JSONException e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(500, AppPluginUtil.getMessage((String)"FormAPI.resp.500", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@FormAPI.updateFormData.summary@@", description="@@FormAPI.updateFormData.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDataResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@"), @Response(responseCode=405, description="@@FormAPI.resp.405@@")})
    public ApiResponse updateFormData(@Param(value="body", description="@@FormAPI.updateFormData.body.desc@@", definition="{formDefId}-FormData") JSONObject body) {
        try {
            String idValue;
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            Form form = this.getForm();
            FormData formData = new FormData();
            if ("true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                formData.addFormResult("_PREVIEW_MODE", "true");
            }
            if (!body.has("id")) {
                return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            formData.setPrimaryKeyValue(body.getString("id"));
            formData.addRequestParameterValues("_FORM_META_ORIGINAL_ID", new String[]{body.getString("id")});
            FormUtil.executeLoadBinders((Element)form, (FormData)formData);
            FormRowSet rows = formData.getLoadBinderData((Element)form);
            if (rows == null || rows.isEmpty()) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            Element el = FormUtil.findElement((String)"id", (Element)form, (FormData)formData);
            if (el != null && (idValue = FormUtil.getElementPropertyValue((Element)el, (FormData)formData)) != null && !idValue.trim().isEmpty() && !"".equals(formData.getRequestParameter("_FORM_META_ORIGINAL_ID"))) {
                el.setProperty("readonly", (Object)"true");
            }
            APIFormUtil.jsonToFormData((Element)form, formData, body, this.getPropertyString("ignorePermission"));
            FormData submitted = appService.submitForm(form, formData, false);
            JSONObject resp = new JSONObject();
            if (submitted.getFormErrors().isEmpty()) {
                resp.put("id", (Object)form.getPrimaryKeyValue(submitted));
                resp.put("errors", new HashMap());
            } else {
                resp.put("id", (Object)submitted.getPrimaryKeyValue());
                resp.put("errors", submitted.getFormErrors());
            }
            return new ApiResponse(200, resp);
        }
        catch (JSONException e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(500, AppPluginUtil.getMessage((String)"FormAPI.resp.500", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/updateWithFiles", type=Operation.MethodType.POST, summary="@@FormAPI.updateFormDataWithFiles.summary@@", description="@@FormAPI.updateFormData.desc@@", bodyContentType="multipart/form-data")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDataResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@"), @Response(responseCode=405, description="@@FormAPI.resp.405@@")})
    public ApiResponse updateFormDataWithFiles(@Param(value="body", description="@@FormAPI.updateFormData.body.desc@@", definition="{formDefId}-FormDataWithFiles") Map body, @Param(value="appendFile", required=false, description="@@FormAPI.getFormData.appendFile.desc@@") String appendFile) {
        try {
            String idValue;
            String id;
            FormRowSet loadRows;
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
            Form form = this.getForm();
            FormData formData = new FormData();
            formData = formService.retrieveFormDataFromRequestMap(formData, body);
            if (appendFile != null && appendFile.equalsIgnoreCase("true") && (loadRows = form.getLoadBinder().load((Element)form, formData.getRequestParameter("id"), formData)) != null && !loadRows.isEmpty()) {
                FormRow row = (FormRow)loadRows.get(0);
                for (Object fieldId : row.keySet()) {
                    Element field = FormUtil.findElement((String)fieldId.toString(), (Element)form, (FormData)formData);
                    if (!(field instanceof FileUpload) || formData.getRequestParameterValues(fieldId.toString()) == null) continue;
                    ArrayList<String> appendFiles = new ArrayList<String>(Arrays.asList(formData.getRequestParameterValues(fieldId.toString())));
                    if (row.getProperty(fieldId.toString()).contains(";")) {
                        String[] existingFile = row.getProperty(fieldId.toString()).split(";");
                        for (int i = 0; i <= existingFile.length - 1; ++i) {
                            appendFiles.add(existingFile[i]);
                        }
                    } else {
                        appendFiles.add(row.getProperty(fieldId.toString()));
                    }
                    String[] UploadedFile = appendFiles.toArray(new String[0]);
                    formData.addRequestParameterValues(fieldId.toString(), UploadedFile);
                }
            }
            this.handleGridData((Element)form, formData);
            if ("true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                formData.addFormResult("_PREVIEW_MODE", "true");
            }
            if ((id = formData.getRequestParameter("id")) == null || id.isEmpty()) {
                return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            formData.setPrimaryKeyValue(id);
            formData.addRequestParameterValues("_FORM_META_ORIGINAL_ID", new String[]{id});
            FormUtil.executeLoadBinders((Element)form, (FormData)formData);
            FormRowSet rows = formData.getLoadBinderData((Element)form);
            if (rows == null || rows.isEmpty()) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            Element el = FormUtil.findElement((String)"id", (Element)form, (FormData)formData);
            if (el != null && (idValue = FormUtil.getElementPropertyValue((Element)el, (FormData)formData)) != null && !idValue.trim().isEmpty() && !"".equals(formData.getRequestParameter("_FORM_META_ORIGINAL_ID"))) {
                el.setProperty("readonly", (Object)"true");
            }
            FormData submitted = appService.submitForm(form, formData, false);
            JSONObject resp = new JSONObject();
            if (submitted.getFormErrors().isEmpty()) {
                resp.put("id", (Object)form.getPrimaryKeyValue(submitted));
                resp.put("errors", new HashMap());
            } else {
                resp.put("id", (Object)submitted.getPrimaryKeyValue());
                resp.put("errors", submitted.getFormErrors());
            }
            return new ApiResponse(200, resp);
        }
        catch (JSONException e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(500, AppPluginUtil.getMessage((String)"FormAPI.resp.500", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/{recordId}", type=Operation.MethodType.GET, summary="@@FormAPI.getFormData.summary@@", description="@@FormAPI.getFormData.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@"), @Response(responseCode=405, description="@@FormAPI.resp.405@@")})
    public ApiResponse getFormData(@Param(value="recordId", description="@@FormAPI.getFormData.recordId.desc@@") String recordId, @Param(value="includeSubformData", required=false, description="@@FormAPI.getFormData.includeSubformData.desc@@") Boolean includeSubformData, @Param(value="includeReferenceElements", required=false, description="@@FormAPI.getFormData.includeReferenceElements.desc@@") Boolean includeReferenceElements, @Param(value="flattenData", required=false, description="@@FormAPI.getFormData.flattenData.desc@@") Boolean flatten) {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            Map result = FormUtil.loadFormData((String)appDef.getId(), (String)appDef.getVersion().toString(), (String)this.getPropertyString("formDefId"), (String)recordId, (boolean)(includeSubformData == null ? false : includeSubformData), (boolean)(includeReferenceElements == null ? false : includeSubformData), (boolean)(flatten == null ? false : flatten), null);
            if (!"true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                FormData formData = new FormData();
                formData.setPrimaryKeyValue(recordId);
                Form form = this.getForm();
                HashSet<String> existFields = new HashSet<String>();
                this.checkElementPermission((Element)form, result, formData, existFields, includeSubformData, flatten);
            }
            return new ApiResponse(200, new JSONObject(result));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)recordId);
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/{recordId}", type=Operation.MethodType.DELETE, summary="@@FormAPI.deleteFormData.summary@@", description="@@FormAPI.deleteFormData.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@"), @Response(responseCode=404, description="@@FormAPI.resp.404@@")})
    public ApiResponse deleteFormData(@Param(value="recordId", description="@@FormAPI.deleteFormData.id.desc@@") String recordId) {
        try {
            Form form = this.getForm();
            FormData formData = new FormData();
            formData.setPrimaryKeyValue(recordId);
            formData.addFormResult("FORM_RESULT_LOAD_ALL_DATA", "FORM_RESULT_LOAD_ALL_DATA");
            formData = FormUtil.executeLoadBinders((Element)form, (FormData)formData);
            FormUtil.recursiveExecuteFormDeleteBinders((Element)form, (FormData)formData, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)recordId);
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(path="/{recordId}/download/{fileName}", type=Operation.MethodType.GET, summary="@@FormAPI.downloadFile.summary@@", description="@@FormAPI.downloadFile.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", contentType="*", definition="{\"type\" : \"file\"}"), @Response(responseCode=404, description="@@FormAPI.resp.404@@")})
    public ApiResponse downloadFile(@Param(value="recordId", description="@@FormAPI.getFormData.recordId.desc@@") String recordId, @Param(value="fileName", description="@@FormAPI.downloadFile.fileName.desc@@") String fileName, @Param(value="attachment", required=false, description="@@FormAPI.downloadFile.attachment.desc@@") Boolean attachment, HttpServletRequest request, HttpServletResponse response) {
        try {
            String tableName;
            boolean isAuthorize;
            block19: {
                isAuthorize = false;
                AppDefinition appDef = AppUtil.getCurrentAppDefinition();
                tableName = null;
                if (!"true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                    Form form = this.getForm();
                    try {
                        if (form == null || form.getLoadBinder() == null) break block19;
                        tableName = form.getPropertyString("tableName");
                        FormData formData = new FormData();
                        FormRowSet rows = form.getLoadBinder().load((Element)form, recordId, formData);
                        if (rows != null && !rows.isEmpty()) {
                            FormRow row = (FormRow)rows.get(0);
                            for (Object fieldId : row.keySet()) {
                                Element field;
                                String value;
                                String compareValue = fileName;
                                if (compareValue.endsWith(".thumb.jpg")) {
                                    compareValue = compareValue.replace(".thumb.jpg", "");
                                }
                                if (!(value = row.getProperty(fieldId.toString())).equals(compareValue) && (!value.contains(";") || !value.startsWith(compareValue + ";") && !value.contains(";" + compareValue + ";") && !value.endsWith(";" + compareValue)) && !value.contains(this.getPropertyString("formDefId") + "/" + recordId + "/" + compareValue) && !value.contains("{tempFilePath}" + compareValue) || !((field = FormUtil.findElement((String)fieldId.toString(), (Element)form, (FormData)formData)) instanceof FileDownloadSecurity)) continue;
                                FileDownloadSecurity security = (FileDownloadSecurity)field;
                                isAuthorize = security.isDownloadAllowed(request.getParameterMap());
                            }
                        }
                    }
                    catch (Exception formData) {}
                } else {
                    isAuthorize = true;
                    AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                    tableName = appService.getFormTableName(appDef, this.getPropertyString("formDefId"));
                }
            }
            if (!isAuthorize) {
                response.setDateHeader("Expires", System.currentTimeMillis() + 0L);
                response.setHeader("Cache-Control", "no-cache, no-store");
                return new ApiResponse(404, true);
            }
            ServletOutputStream stream = response.getOutputStream();
            String decodedFileName = fileName;
            try {
                decodedFileName = URLDecoder.decode(fileName, "UTF8");
            }
            catch (UnsupportedEncodingException rows) {
                // empty catch block
            }
            File file = FileUtil.getFile((String)decodedFileName, (String)tableName, (String)recordId);
            if (file.isDirectory() || !file.exists()) {
                response.setDateHeader("Expires", System.currentTimeMillis() + 0L);
                response.setHeader("Cache-Control", "no-cache, no-store");
                return new ApiResponse(404, true);
            }
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            byte[] bbuf = new byte[65536];
            try {
                String contentType = request.getSession().getServletContext().getMimeType(decodedFileName);
                if (contentType != null) {
                    response.setContentType(contentType);
                }
                if (attachment != null && Boolean.valueOf(attachment).booleanValue()) {
                    String name = URLEncoder.encode(decodedFileName, "UTF8").replaceAll("\\+", "%20");
                    response.setHeader("Content-Disposition", "attachment; filename=" + name + "; filename*=UTF-8''" + name);
                }
                int length = 0;
                while (in != null && (length = in.read(bbuf)) != -1) {
                    stream.write(bbuf, 0, length);
                }
            }
            finally {
                in.close();
                stream.flush();
                stream.close();
            }
            return new ApiResponse(200, true);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)recordId);
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Operation(path="/{recordId}/{fieldId}/files", type=Operation.MethodType.GET, summary="@@FormAPI.downloadFiles.summary@@", description="@@FormAPI.downloadFiles.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", contentType="application/zip", definition="{\"type\" : \"file\"}"), @Response(responseCode=404, description="@@FormAPI.resp.404@@")})
    public ApiResponse downloadFiles(@Param(value="recordId", description="@@FormAPI.getFormData.recordId.desc@@") String recordId, @Param(value="fieldId", description="@@FormAPI.downloadFiles.fieldId.desc@@") String fieldId, HttpServletRequest request, HttpServletResponse response) {
        try {
            FormData formData;
            Form form;
            String tableName;
            boolean isAuthorize;
            block22: {
                isAuthorize = false;
                AppDefinition appDef = AppUtil.getCurrentAppDefinition();
                tableName = null;
                form = this.getForm();
                formData = new FormData();
                if (!"true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                    try {
                        if (form == null || form.getLoadBinder() == null) break block22;
                        tableName = form.getPropertyString("tableName");
                        Element field = FormUtil.findElement((String)fieldId, (Element)form, (FormData)formData);
                        if (field instanceof FileDownloadSecurity) {
                            FileDownloadSecurity security = (FileDownloadSecurity)field;
                            isAuthorize = security.isDownloadAllowed(request.getParameterMap());
                        }
                    }
                    catch (Exception field) {}
                } else {
                    isAuthorize = true;
                    AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                    tableName = appService.getFormTableName(appDef, this.getPropertyString("formDefId"));
                }
            }
            if (!isAuthorize) {
                response.setDateHeader("Expires", System.currentTimeMillis() + 0L);
                response.setHeader("Cache-Control", "no-cache, no-store");
                return new ApiResponse(404, true);
            }
            FormRowSet rows = form.getLoadBinder().load((Element)form, recordId, formData);
            FormRow row = null;
            if (rows != null && !rows.isEmpty()) {
                row = (FormRow)rows.get(0);
            }
            if (row == null || !row.containsKey((Object)fieldId) || row.getProperty(fieldId).isEmpty()) {
                response.setDateHeader("Expires", System.currentTimeMillis() + 0L);
                response.setHeader("Cache-Control", "no-cache, no-store");
                return new ApiResponse(404, true);
            }
            ServletOutputStream stream = response.getOutputStream();
            DeflaterOutputStream zip = null;
            try {
                Object object;
                String[] values = row.getProperty(fieldId).split(";");
                ArrayList<File> files = new ArrayList<File>();
                for (String v : values) {
                    File file = FileUtil.getFile((String)v, (String)tableName, (String)recordId);
                    if (!file.exists() || file.isDirectory()) continue;
                    files.add(file);
                }
                if (!files.isEmpty()) {
                    response.setContentType("application/zip");
                    response.setHeader("Content-Disposition", "attachment; filename=" + fieldId + ".zip");
                    zip = new ZipOutputStream((OutputStream)stream);
                    for (File file : files) {
                        if (!file.canRead()) continue;
                        FileInputStream fis = null;
                        try {
                            ((ZipOutputStream)zip).putNextEntry(new ZipEntry(file.getName()));
                            fis = new FileInputStream(file);
                            byte[] buffer = new byte[4092];
                            int byteCount = 0;
                            while ((byteCount = fis.read(buffer)) != -1) {
                                ((ZipOutputStream)zip).write(buffer, 0, byteCount);
                            }
                            ((ZipOutputStream)zip).closeEntry();
                        }
                        finally {
                            if (fis == null) continue;
                            fis.close();
                        }
                    }
                    object = new ApiResponse(200, true);
                    return object;
                }
                response.setDateHeader("Expires", System.currentTimeMillis() + 0L);
                response.setHeader("Cache-Control", "no-cache, no-store");
                object = new ApiResponse(404, true);
                return object;
            }
            finally {
                if (zip != null) {
                    zip.flush();
                    ((ZipOutputStream)zip).close();
                }
                stream.flush();
                stream.close();
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)recordId);
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    protected Form getForm() {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
        FormDefinitionDao formDefinitionDao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
        Form form = null;
        FormDefinition formDef = formDefinitionDao.loadById(this.getPropertyString("formDefId"), appDef);
        if (formDef != null && formDef.getJson() != null) {
            String formJson = formDef.getJson();
            formJson = AppUtil.processHashVariable((String)formJson, null, (String)"json", null);
            form = (Form)formService.createElementFromJson(formJson);
        }
        return form;
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        LinkedHashMap<String, Class> fields = new LinkedHashMap<String, Class>();
        fields.put("id", String.class);
        fields.put("errors", Map.class);
        defs.put("FormDataResponse", new ApiDefinition(fields));
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)"object");
            JSONOrderedObject properties = new JSONOrderedObject();
            properties.put("id", ApiService.getSchema(String.class, null, false));
            Form form = this.getForm();
            FormData formData = new FormData();
            this.recursiveGenerateDefinition(formData, properties, (Element)form, false);
            properties.put("dateCreated", ApiService.getSchema(Date.class, null, false));
            properties.put("dateModified", ApiService.getSchema(Date.class, null, false));
            properties.put("createdBy", ApiService.getSchema(String.class, null, false));
            properties.put("createdByName", ApiService.getSchema(String.class, null, false));
            properties.put("modifiedBy", ApiService.getSchema(String.class, null, false));
            properties.put("modifiedByName", ApiService.getSchema(String.class, null, false));
            obj.put("properties", (Object)properties);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        defs.put(this.getPropertyString("formDefId") + "-FormData", new ApiDefinition(obj));
        JSONObject obj2 = new JSONObject();
        try {
            obj2.put("type", (Object)"object");
            JSONOrderedObject properties = new JSONOrderedObject();
            properties.put("id", ApiService.getSchema(String.class, null, false));
            Form form = this.getForm();
            FormData formData = new FormData();
            this.recursiveGenerateDefinition(formData, properties, (Element)form, true);
            properties.put("dateCreated", ApiService.getSchema(Date.class, null, false));
            properties.put("dateModified", ApiService.getSchema(Date.class, null, false));
            properties.put("createdBy", ApiService.getSchema(String.class, null, false));
            properties.put("createdByName", ApiService.getSchema(String.class, null, false));
            properties.put("modifiedBy", ApiService.getSchema(String.class, null, false));
            properties.put("modifiedByName", ApiService.getSchema(String.class, null, false));
            obj2.put("properties", (Object)properties);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        defs.put(this.getPropertyString("formDefId") + "-FormDataWithFiles", new ApiDefinition(obj2));
        return defs;
    }

    protected void handleGridData(Element el, FormData formData) throws JSONException {
        if (!"true".equalsIgnoreCase(this.getPropertyString("ignorePermission")) && (!el.isAuthorize(formData).booleanValue() || FormUtil.isHidden((Element)el, (FormData)formData) || FormUtil.isReadonly((Element)el, (FormData)formData))) {
            return;
        }
        if (el instanceof Grid || el instanceof GridInnerDataRetriever) {
            String data;
            String fieldId = el.getPropertyString("id");
            if (el.getCustomParameterName() != null) {
                fieldId = el.getCustomParameterName();
            }
            if ((data = formData.getRequestParameter(fieldId)) != null && !data.isEmpty()) {
                if (!data.startsWith("[") || !data.endsWith("]")) {
                    data = "[" + data + "]";
                }
                APIFormUtil.setGridData(el, formData, new JSONArray(data));
            }
        } else {
            Collection children = el.getChildren(formData);
            if (children != null && !children.isEmpty()) {
                for (Element c : children) {
                    this.handleGridData(c, formData);
                }
            }
        }
    }

    protected void checkElementPermission(Element el, Map<String, Object> result, FormData formData, Set<String> existFields, Boolean includeSubformData, Boolean flatten) {
        if (el instanceof Form && (el.getParent() == null || el.getParent() != null && flatten != null && !flatten.booleanValue())) {
            existFields.addAll(result.keySet());
            existFields.remove("id");
            existFields.remove("dateCreated");
            existFields.remove("createdByName");
            existFields.remove("createdBy");
            existFields.remove("dateModified");
            existFields.remove("modifiedByName");
            existFields.remove("modifiedBy");
        }
        boolean isAuthorize = el.isAuthorize(formData);
        String name = el.getPropertyString("id");
        if (isAuthorize && !FormUtil.isHidden((Element)el, (FormData)formData)) {
            Collection dynamic = el.getDynamicFieldNames();
            if (dynamic != null && dynamic.isEmpty()) {
                for (String s : dynamic) {
                    existFields.remove(s);
                }
            }
            if (el instanceof Grid || el instanceof GridInnerDataRetriever) {
                existFields.remove(name);
                if (result.containsKey(name) && result.get(name) instanceof Collection) {
                    HashSet<String> gFields = new HashSet<String>();
                    HashSet<String> gRemoveFields = null;
                    Object optionProperty = el.getProperty("options");
                    if (optionProperty != null && optionProperty instanceof Collection) {
                        for (Object opt : (FormRowSet)optionProperty) {
                            Object value = opt.get("value");
                            if (value == null) continue;
                            gFields.add(value.toString());
                        }
                    }
                    gFields.add("id");
                    gFields.add("dateCreated");
                    gFields.add("createdByName");
                    gFields.add("createdBy");
                    gFields.add("dateModified");
                    gFields.add("modifiedByName");
                    gFields.add("modifiedBy");
                    Collection gdata = (Collection)result.get(name);
                    for (Map r : gdata) {
                        gRemoveFields = new HashSet<String>();
                        for (String field : r.keySet()) {
                            if (gFields.contains(field)) continue;
                            gRemoveFields.add(field);
                        }
                        for (String rfield : gRemoveFields) {
                            r.remove(rfield);
                        }
                    }
                }
            } else if (!(el instanceof FormContainer)) {
                existFields.remove(name);
            } else if (el instanceof AbstractSubForm && includeSubformData != null && includeSubformData.booleanValue()) {
                Map data = null;
                Set<String> newExistingFields = null;
                if (flatten != null && flatten.booleanValue()) {
                    data = result;
                    newExistingFields = existFields;
                } else if (result.containsKey(name)) {
                    Collection children;
                    newExistingFields = new HashSet<String>();
                    try {
                        data = (Map)result.get(name);
                    }
                    catch (Exception e) {
                        LogUtil.debug((String)AppFormAPI.class.getName(), (String)(name + " can't cast to map"));
                    }
                    if (data != null && (children = el.getChildren(formData)) != null && !children.isEmpty()) {
                        for (Element c : children) {
                            this.checkElementPermission(c, data, formData, newExistingFields, includeSubformData, flatten);
                        }
                    }
                }
            } else {
                Collection children = el.getChildren(formData);
                if (children != null && !children.isEmpty()) {
                    for (Element c : children) {
                        this.checkElementPermission(c, result, formData, existFields, includeSubformData, flatten);
                    }
                }
            }
        }
        if (el instanceof Form && (el.getParent() == null || el.getParent() != null && flatten != null && !flatten.booleanValue())) {
            for (String r : existFields) {
                result.remove(r);
            }
        }
    }

    protected void recursiveGenerateDefinition(FormData formData, JSONObject properties, Element el, boolean handleFile) throws JSONException {
        Collection dynamic = el.getDynamicFieldNames();
        String fieldId = el.getPropertyString("id");
        if (handleFile && el.getCustomParameterName() != null) {
            fieldId = el.getCustomParameterName();
        }
        String fieldLabel = el.getPropertyString("label");
        if (dynamic != null && dynamic.isEmpty()) {
            for (String s : dynamic) {
                properties.put(s, (Object)ApiService.getSchema(String.class, null, false));
            }
        }
        if (el instanceof Grid || el instanceof GridInnerDataRetriever) {
            JSONObject grid = new JSONObject();
            grid.put("type", (Object)"array");
            JSONObject obj = new JSONObject();
            grid.put("items", (Object)obj);
            obj.put("type", (Object)"object");
            JSONOrderedObject gProperties = new JSONOrderedObject();
            gProperties.put("id", ApiService.getSchema(String.class, null, false));
            Object optionProperty = el.getProperty("options");
            if (optionProperty != null && optionProperty instanceof Collection) {
                for (Object opt : (ArrayList)optionProperty) {
                    Map optMap = (Map)opt;
                    Object value = optMap.get("value");
                    gProperties.put(value.toString(), ApiService.getSchema(String.class, null, false));
                }
            }
            obj.put("properties", (Object)gProperties);
            if (handleFile) {
                grid.put("description", (Object)fieldLabel);
            }
            properties.put(fieldId, (Object)grid);
        } else if (!(el instanceof FormContainer)) {
            if (handleFile && el instanceof FileUpload) {
                properties.put(fieldId, (Object)ApiService.getSchema(File.class, null, false, fieldLabel));
            } else {
                properties.put(fieldId, (Object)ApiService.getSchema(String.class, null, false, fieldLabel));
            }
        } else if (el instanceof AbstractSubForm) {
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)"object");
            JSONOrderedObject gProperties = new JSONOrderedObject();
            Collection children = el.getChildren(formData);
            if (children != null && !children.isEmpty()) {
                for (Element c : children) {
                    if (handleFile) {
                        this.recursiveGenerateDefinition(formData, properties, c, handleFile);
                        continue;
                    }
                    this.recursiveGenerateDefinition(formData, gProperties, c, handleFile);
                }
            }
            if (!handleFile) {
                obj.put("properties", (Object)gProperties);
                properties.put(fieldId, (Object)obj);
            }
        } else {
            Collection children = el.getChildren(formData);
            if (children != null && !children.isEmpty()) {
                for (Element c : children) {
                    this.recursiveGenerateDefinition(formData, properties, c, handleFile);
                }
            }
        }
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

