/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.model.JSONOrderedObject;
import org.joget.api.service.ApiService;
import org.joget.apps.app.dao.DatalistDefinitionDao;
import org.joget.apps.app.model.DatalistDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.datalist.model.DataList;
import org.joget.apps.datalist.model.DataListCollection;
import org.joget.apps.datalist.model.DataListColumn;
import org.joget.apps.datalist.model.DataListColumnFormat;
import org.joget.apps.datalist.service.DataListDecorator;
import org.joget.apps.datalist.service.DataListService;
import org.joget.commons.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppListAPI
extends ApiPluginAbstract {
    public String getName() {
        return "AppListAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)("/properties/api/" + this.getName() + ".json"), null, (boolean)true, (String)this.getResourceBundlePath());
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-table\"></i>";
    }

    @Override
    public String getTag() {
        return "list/{listDefId}";
    }

    @Operation(path="/", type=Operation.MethodType.GET, summary="@@AppListAPI.list.summary@@", description="@@AppListAPI.list.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="{listDefId}-ListObject"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse list(@Param(value="filters", required=false, description="@@AppListAPI.list.filters.desc@@") Map filters, @Param(value="startOffset", required=false, description="@@AppListAPI.list.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AppListAPI.list.pageSize.desc@@") Integer pageSize) {
        DatalistDefinitionDao datalistDefinitionDao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
        DatalistDefinition datalistDefinition = (DatalistDefinition)datalistDefinitionDao.loadById(this.getPropertyString("listDefId"), AppUtil.getCurrentAppDefinition());
        if (datalistDefinition != null) {
            String json = datalistDefinition.getJson();
            DataListService dataListService = (DataListService)AppUtil.getApplicationContext().getBean("dataListService");
            DataList dataList = dataListService.fromJson(json);
            DataListDecorator decorator = new DataListDecorator(dataList);
            DataListColumn[] columns = dataList.getColumns();
            if (filters != null && !filters.isEmpty()) {
                HashMap<String, String[]> requestParamMap = new HashMap<String, String[]>();
                for (String key : filters.keySet()) {
                    String[] rangeValue;
                    if (key.contains("fn_")) {
                        if (filters.get(key).toString().contains("|")) {
                            rangeValue = filters.get(key).toString().split("\\|", -1);
                            requestParamMap.put(key, rangeValue);
                            continue;
                        }
                        requestParamMap.put(key, new String[]{filters.get(key).toString()});
                        continue;
                    }
                    if (filters.get(key).toString().contains("|")) {
                        rangeValue = filters.get(key).toString().split("\\|", -1);
                        requestParamMap.put(dataList.getDataListEncodedParamName("fn_" + key), rangeValue);
                        continue;
                    }
                    requestParamMap.put(dataList.getDataListEncodedParamName("fn_" + key), new String[]{filters.get(key).toString()});
                }
                dataList.setRequestParamMap(requestParamMap);
            }
            DataListCollection results = dataList.getRows(pageSize, startOffset);
            int total = dataList.getSize();
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("size", results.size());
                jsonObject.put("total", total);
                jsonObject.put("data", (Object)this.getData(results, columns, decorator));
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
            return new ApiResponse(200, jsonObject);
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    protected JSONArray getData(DataListCollection results, DataListColumn[] columns, DataListDecorator decorator) throws JSONException {
        JSONArray data = new JSONArray();
        for (Object row : results) {
            JSONObject rowObject = new JSONObject();
            for (DataListColumn column : columns) {
                if (column.isHidden()) continue;
                String columnName = column.getName();
                Object value = DataListService.evaluateColumnValueFromRow(row, (String)columnName);
                Collection formats = column.getFormats();
                DataListColumnFormat nestedDataListFormatter = null;
                if (formats != null) {
                    for (DataListColumnFormat f : formats) {
                        if (f == null || !f.getClassName().equals("org.joget.plugin.enterprise.NestedDatalistFormatter")) continue;
                        nestedDataListFormatter = f;
                        break;
                    }
                }
                if (nestedDataListFormatter != null) {
                    JSONArray nestedData = new JSONArray();
                    try {
                        DataList nestedDataList = (DataList)MethodUtils.invokeExactMethod(nestedDataListFormatter, (String)"getNestedDatalist", (Object[])new Object[0]);
                        DataListDecorator nestedDecorator = new DataListDecorator(nestedDataList);
                        DataListCollection nestedRows = (DataListCollection)MethodUtils.invokeExactMethod((Object)nestedDataListFormatter, (String)"getRowData", (Object[])new Object[]{row, value}, (Class[])new Class[]{Object.class, Object.class});
                        nestedData = this.getData(nestedRows, nestedDataList.getColumns(), nestedDecorator);
                    }
                    catch (Exception nestedDataList) {
                        // empty catch block
                    }
                    String label = column.getLabel();
                    rowObject.put(label, (Object)nestedData);
                    continue;
                }
                String formattedValue = decorator.formatColumn(column, row, value);
                rowObject.put(columnName, (Object)formattedValue);
            }
            data.put((Object)rowObject);
        }
        return data;
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        try {
            JSONOrderedObject jsonObj = new JSONOrderedObject();
            jsonObj.put("type", "object");
            JSONOrderedObject properties = new JSONOrderedObject();
            jsonObj.put("properties", (Object)properties);
            properties.put("total", ApiService.getSchema(Integer.class, null, false));
            properties.put("size", ApiService.getSchema(Integer.class, null, false));
            DatalistDefinitionDao datalistDefinitionDao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
            DatalistDefinition datalistDefinition = (DatalistDefinition)datalistDefinitionDao.loadById(this.getPropertyString("listDefId"), AppUtil.getCurrentAppDefinition());
            if (datalistDefinition != null) {
                String json = datalistDefinition.getJson();
                DataListService dataListService = (DataListService)AppUtil.getApplicationContext().getBean("dataListService");
                DataList dataList = dataListService.fromJson(json);
                DataListColumn[] columns = dataList.getColumns();
                properties.put("data", this.getDataDefinition(columns));
            } else {
                properties.put("data", this.getDataDefinition(null));
            }
            defs.put(this.getPropertyString("listDefId") + "-ListObject", new ApiDefinition(jsonObj));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return defs;
    }

    protected JSONObject getDataDefinition(DataListColumn[] columns) throws JSONException {
        JSONOrderedObject dataObj = new JSONOrderedObject();
        dataObj.put("type", "array");
        JSONOrderedObject itemsObj = new JSONOrderedObject();
        dataObj.put("items", (Object)itemsObj);
        itemsObj.put("type", "object");
        JSONOrderedObject itemsPropsObj = new JSONOrderedObject();
        itemsObj.put("properties", (Object)itemsPropsObj);
        if (columns != null && columns.length > 0) {
            for (DataListColumn c : columns) {
                if (c.isHidden()) continue;
                Collection formats = c.getFormats();
                DataListColumnFormat nestedDataListFormatter = null;
                if (formats != null) {
                    for (DataListColumnFormat f : formats) {
                        if (f == null || !f.getClassName().equals("org.joget.plugin.enterprise.NestedDatalistFormatter")) continue;
                        nestedDataListFormatter = f;
                        break;
                    }
                }
                if (nestedDataListFormatter != null) {
                    try {
                        DataList nestedDataList = (DataList)MethodUtils.invokeExactMethod(nestedDataListFormatter, (String)"getNestedDatalist", (Object[])new Object[0]);
                        itemsPropsObj.put(c.getLabel(), this.getDataDefinition(nestedDataList.getColumns()));
                    }
                    catch (Exception nestedDataList) {}
                    continue;
                }
                JSONOrderedObject cObj = new JSONOrderedObject();
                cObj.put("type", "string");
                cObj.put("description", c.getLabel());
                itemsPropsObj.put(c.getName(), (Object)cObj);
            }
        }
        return dataObj;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

