/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.TimeZoneUtil;
import org.joget.directory.model.User;
import org.joget.workflow.model.WorkflowAssignment;
import org.joget.workflow.model.WorkflowVariable;
import org.joget.workflow.model.service.WorkflowManager;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssignmentAPI
extends ApiPluginAbstract {
    public String getName() {
        return "AssignmentAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-tasks\"></i>";
    }

    @Override
    public String getTag() {
        return "assignment";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/list", type=Operation.MethodType.GET, summary="@@AssignmentAPI.list.summary@@", description="@@AssignmentAPI.list.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Assignment", array=true)})
    public ApiResponse list(@Param(value="appId", required=false, description="@@AssignmentAPI.list.appId.desc@@") String appId, @Param(value="processDefId", required=false, description="@@AssignmentAPI.list.processDefId.desc@@") String processDefId, @Param(value="processInstanceId", required=false, description="@@AssignmentAPI.list.processInstanceId.desc@@") String processInstanceId, @Param(value="activityDefId", required=false, description="@@AssignmentAPI.list.activityDefId.desc@@") String activityDefId, @Param(value="sort", required=false, description="@@AssignmentAPI.list.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AssignmentAPI.list.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AssignmentAPI.list.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AssignmentAPI.list.pageSize.desc@@") Integer pageSize) {
        return this.listByUsername(null, appId, processDefId, processInstanceId, activityDefId, sort, desc, startOffset, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(path="/listByUser/{username}", type=Operation.MethodType.GET, summary="@@AssignmentAPI.listByUsername.summary@@", description="@@AssignmentAPI.listByUsername.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Assignment", array=true)})
    public ApiResponse listByUsername(@Param(value="username", description="@@AssignmentAPI.listByUsername.username.desc@@") String username, @Param(value="appId", required=false, description="@@AssignmentAPI.listByUsername.appId.desc@@") String appId, @Param(value="processDefId", required=false, description="@@AssignmentAPI.listByUsername.processDefId.desc@@") String processDefId, @Param(value="processInstanceId", required=false, description="@@AssignmentAPI.listByUsername.processInstanceId.desc@@") String processInstanceId, @Param(value="activityDefId", required=false, description="@@AssignmentAPI.listByUsername.activityDefId.desc@@") String activityDefId, @Param(value="sort", required=false, description="@@AssignmentAPI.listByUsername.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AssignmentAPI.listByUsername.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AssignmentAPI.listByUsername.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AssignmentAPI.listByUsername.pageSize.desc@@") Integer pageSize) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User currentUser = wum.getCurrentUser();
        try {
            if (username != null) {
                wum.setCurrentThreadUser(username);
            }
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            Collection assignmentList = workflowManager.getAssignmentListLite(appId, processDefId, processInstanceId, activityDefId, sort, desc, startOffset, pageSize);
            JSONArray datas = new JSONArray();
            String format = AppUtil.getAppDateFormat();
            for (WorkflowAssignment assignment : assignmentList) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("processId", assignment.getProcessId());
                data.put("activityId", assignment.getActivityId());
                data.put("processName", assignment.getProcessName());
                data.put("activityName", assignment.getActivityName());
                data.put("processVersion", assignment.getProcessVersion());
                data.put("dateCreated", TimeZoneUtil.convertToTimeZone((Date)assignment.getDateCreated(), null, (String)format));
                data.put("due", assignment.getDueDate() != null ? TimeZoneUtil.convertToTimeZone((Date)assignment.getDueDate(), null, (String)format) : "-");
                double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningActivity(assignment.getActivityId());
                data.put("serviceLevelMonitor", WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
                data.put("id", assignment.getActivityId());
                data.put("label", assignment.getActivityName());
                data.put("description", assignment.getDescription());
                datas.put(data);
            }
            ApiResponse apiResponse = new ApiResponse(200, datas);
            return apiResponse;
        }
        finally {
            wum.setCurrentThreadUser(currentUser);
        }
    }

    @Operation(path="/count", type=Operation.MethodType.GET, summary="@@AssignmentAPI.count.summary@@", description="@@AssignmentAPI.count.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Total")})
    public ApiResponse count(@Param(value="appId", required=false, description="@@AssignmentAPI.count.appId.desc@@") String appId, @Param(value="processDefId", required=false, description="@@AssignmentAPI.count.processDefId.desc@@") String processDefId, @Param(value="processInstanceId", required=false, description="@@AssignmentAPI.count.processInstanceId.desc@@") String processInstanceId, @Param(value="activityDefId", required=false, description="@@AssignmentAPI.count.activityDefId.desc@@") String activityDefId) {
        return this.countByUsername(null, appId, processDefId, processInstanceId, activityDefId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(path="/countByUser/{username}", type=Operation.MethodType.GET, summary="@@AssignmentAPI.countByUsername.summary@@", description="@@AssignmentAPI.countByUsername.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Total")})
    public ApiResponse countByUsername(@Param(value="username", description="@@AssignmentAPI.countByUsername.username.desc@@") String username, @Param(value="appId", required=false, description="@@AssignmentAPI.countByUsername.appId.desc@@") String appId, @Param(value="processDefId", required=false, description="@@AssignmentAPI.countByUsername.processDefId.desc@@") String processDefId, @Param(value="processInstanceId", required=false, description="@@AssignmentAPI.countByUsername.processInstanceId.desc@@") String processInstanceId, @Param(value="activityDefId", required=false, description="@@AssignmentAPI.countByUsername.activityDefId.desc@@") String activityDefId) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User currentUser = wum.getCurrentUser();
        try {
            if (username != null) {
                wum.setCurrentThreadUser(username);
            }
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            int size = workflowManager.getAssignmentSize(appId, processDefId, processDefId, activityDefId);
            JSONObject data = new JSONObject();
            try {
                data.put("size", size);
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
            ApiResponse apiResponse = new ApiResponse(200, data);
            return apiResponse;
        }
        finally {
            wum.setCurrentThreadUser(currentUser);
        }
    }

    @Operation(path="/complete/{activityId}", summary="@@AssignmentAPI.complete.summary@@", description="@@AssignmentAPI.complete.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="CompleteAssignmentResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse complete(@Param(value="activityId", description="@@AssignmentAPI.complete.activityId.desc@@") String activityId, @Param(value="variables", required=false, description="@@AssignmentAPI.complete.variables.desc@@") Map<String, String> variables) {
        return this.completeByUser(null, activityId, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(path="/completeByUser/{username}/{activityId}", summary="@@AssignmentAPI.completeByUser.summary@@", description="@@AssignmentAPI.completeByUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="CompleteAssignmentResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse completeByUser(@Param(value="username", description="@@AssignmentAPI.completeByUser.username.desc@@") String username, @Param(value="activityId", description="@@AssignmentAPI.completeByUser.activityId.desc@@") String activityId, @Param(value="variables", required=false, description="@@AssignmentAPI.completeByUser.variables.desc@@") Map<String, String> variables) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User currentUser = wum.getCurrentUser();
        try {
            WorkflowAssignment nextAssignment;
            if (username != null) {
                wum.setCurrentThreadUser(username);
            }
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            appService.getAppDefinitionForWorkflowActivity(activityId);
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            WorkflowAssignment assignment = workflowManager.getAssignment(activityId);
            if (assignment == null) {
                ApiResponse apiResponse = new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                return apiResponse;
            }
            if (!assignment.isAccepted()) {
                workflowManager.assignmentAccept(activityId);
            }
            workflowManager.assignmentComplete(activityId, variables);
            LogUtil.info((String)this.getClass().getName(), (String)("Assignment " + activityId + " completed"));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("processId", (Object)assignment.getProcessId());
            jsonObject.put("activityId", (Object)activityId);
            jsonObject.put("nextActivityId", (Object)"");
            String processDefId = assignment.getProcessDefId();
            String activityDefId = assignment.getActivityDefId();
            String packageId = WorkflowUtil.getProcessDefPackageId((String)processDefId);
            String packageVersion = WorkflowUtil.getProcessDefVersion((String)processDefId);
            boolean continueNextAssignment = appService.isActivityAutoContinue(packageId, packageVersion, processDefId, activityDefId);
            if (continueNextAssignment && (nextAssignment = workflowManager.getAssignmentByProcess(assignment.getProcessId())) != null) {
                jsonObject.put("nextActivityId", (Object)nextAssignment.getActivityId());
            }
            ApiResponse apiResponse = new ApiResponse(200, jsonObject);
            return apiResponse;
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            ApiResponse apiResponse = new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            return apiResponse;
        }
        finally {
            wum.setCurrentThreadUser(currentUser);
        }
    }

    @Operation(path="/detail/{activityId}", type=Operation.MethodType.GET, summary="@@AssignmentAPI.getDetail.summary@@", description="@@AssignmentAPI.getDetail.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="AssignmentWithVariables"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getDetail(@Param(value="activityId", description="@@AssignmentAPI.getDetail.activityId.desc@@") String activityId) {
        return this.getDetailByUser(null, activityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(path="/detailByUser/{username}/{activityId}", type=Operation.MethodType.GET, summary="@@AssignmentAPI.getDetailByUser.summary@@", description="@@AssignmentAPI.getDetailByUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="AssignmentWithVariables"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse getDetailByUser(@Param(value="username", description="@@AssignmentAPI.getDetailByUser.username.desc@@") String username, @Param(value="activityId", description="@@AssignmentAPI.getDetailByUser.activityId.desc@@") String activityId) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User currentUser = wum.getCurrentUser();
        try {
            if (username != null) {
                wum.setCurrentThreadUser(username);
            }
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            appService.getAppDefinitionForWorkflowActivity(activityId);
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            WorkflowAssignment assignment = workflowManager.getAssignment(activityId);
            String format = AppUtil.getAppDateFormat();
            JSONObject data = new JSONObject();
            data.put("processId", (Object)assignment.getProcessId());
            data.put("activityId", (Object)assignment.getActivityId());
            data.put("processName", (Object)assignment.getProcessName());
            data.put("activityName", (Object)assignment.getActivityName());
            data.put("processVersion", (Object)assignment.getProcessVersion());
            data.put("dateCreated", (Object)TimeZoneUtil.convertToTimeZone((Date)assignment.getDateCreated(), null, (String)format));
            data.put("due", (Object)(assignment.getDueDate() != null ? TimeZoneUtil.convertToTimeZone((Date)assignment.getDueDate(), null, (String)format) : "-"));
            double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningActivity(assignment.getActivityId());
            data.put("serviceLevelMonitor", (Object)WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
            data.put("id", (Object)assignment.getActivityId());
            data.put("label", (Object)assignment.getActivityName());
            data.put("description", (Object)assignment.getDescription());
            JSONObject variables = new JSONObject();
            Collection variableList = workflowManager.getActivityVariableList(activityId);
            for (WorkflowVariable variable : variableList) {
                variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
            }
            data.put("variables", (Object)variables);
            ApiResponse apiResponse = new ApiResponse(200, data);
            return apiResponse;
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            ApiResponse apiResponse = new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            return apiResponse;
        }
        finally {
            wum.setCurrentThreadUser(currentUser);
        }
    }

    @Operation(path="/reevaluate", summary="@@AssignmentAPI.reevaluate.summary@@", description="@@AssignmentAPI.reevaluate.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse reevaluate() {
        return this.reevaluateByUsername(null);
    }

    @Operation(path="/reevaluateByUsername/{username}", summary="@@AssignmentAPI.reevaluateByUsername.summary@@", description="@@AssignmentAPI.reevaluateByUsername.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse reevaluateByUsername(@Param(value="username", description="@@AssignmentAPI.reevaluateByUsername.username.desc@@") String username) {
        try {
            if (username == null) {
                WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
                username = wum.getCurrentUsername();
            }
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.reevaluateAssignmentsForUser(username);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        LinkedHashMap<String, Class> totalResponseDef = new LinkedHashMap<String, Class>();
        totalResponseDef.put("size", Integer.class);
        defs.put("Total", new ApiDefinition(totalResponseDef));
        LinkedHashMap<String, Class> assignmentResponseDef = new LinkedHashMap<String, Class>();
        assignmentResponseDef.put("size", Integer.class);
        assignmentResponseDef.put("processId", String.class);
        assignmentResponseDef.put("activityId", String.class);
        assignmentResponseDef.put("processName", String.class);
        assignmentResponseDef.put("activityName", String.class);
        assignmentResponseDef.put("processVersion", String.class);
        assignmentResponseDef.put("dateCreated", String.class);
        assignmentResponseDef.put("due", String.class);
        assignmentResponseDef.put("serviceLevelMonitor", String.class);
        assignmentResponseDef.put("id", String.class);
        assignmentResponseDef.put("label", String.class);
        assignmentResponseDef.put("description", String.class);
        defs.put("Assignment", new ApiDefinition(assignmentResponseDef));
        LinkedHashMap<String, Class> assignmentVariableResponseDef = new LinkedHashMap<String, Class>();
        assignmentVariableResponseDef.put("size", Integer.class);
        assignmentVariableResponseDef.put("processId", String.class);
        assignmentVariableResponseDef.put("activityId", String.class);
        assignmentVariableResponseDef.put("processName", String.class);
        assignmentVariableResponseDef.put("activityName", String.class);
        assignmentVariableResponseDef.put("processVersion", String.class);
        assignmentVariableResponseDef.put("dateCreated", String.class);
        assignmentVariableResponseDef.put("due", String.class);
        assignmentVariableResponseDef.put("serviceLevelMonitor", String.class);
        assignmentVariableResponseDef.put("id", String.class);
        assignmentVariableResponseDef.put("label", String.class);
        assignmentVariableResponseDef.put("description", String.class);
        assignmentVariableResponseDef.put("variable", Map.class);
        defs.put("AssignmentWithVariables", new ApiDefinition(assignmentVariableResponseDef));
        LinkedHashMap<String, Class> completeAssignmentResponseDef = new LinkedHashMap<String, Class>();
        completeAssignmentResponseDef.put("processId", String.class);
        completeAssignmentResponseDef.put("activityId", String.class);
        completeAssignmentResponseDef.put("nextActivityId", String.class);
        defs.put("CompleteAssignmentResponse", new ApiDefinition(completeAssignmentResponseDef));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

