/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.apps.app.dao.AuditTrailDao;
import org.joget.apps.app.model.AuditTrail;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;

public class AuditTrailAPI
extends ApiPluginAbstract {
    public String getName() {
        return "AuditTrailAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-shoe-prints\"></i>";
    }

    @Override
    public String getTag() {
        return "auditTrails";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", type=Operation.MethodType.GET, summary="@@AuditTrailAPI.listAuditTrails.summary@@", description="@@AuditTrailAPI.listAuditTrails.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="AuditTrail", array=true)})
    public ApiResponse listAuditTrails(@Param(value="search", required=false, description="@@AuditTrailAPI.listAuditTrails.search.desc@@") String search, @Param(value="dateFrom", required=false, description="@@AuditTrailAPI.listAuditTrails.dateFrom.desc@@") Date from, @Param(value="dateTo", required=false, description="@@AuditTrailAPI.listAuditTrails.dateTo.desc@@") Date to, @Param(value="sort", required=false, description="@@AuditTrailAPI.listAuditTrails.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@AuditTrailAPI.listAuditTrails.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@AuditTrailAPI.listAuditTrails.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@AuditTrailAPI.listAuditTrails.pageSize.desc@@") Integer pageSize) {
        String condition = "";
        ArrayList<Object> args = new ArrayList<Object>();
        if (search != null && !search.isEmpty()) {
            condition = "(e.username like ? or e.clazz like ? or e.method like ? or e.message like ?)";
            args.add("%" + search + "%");
            args.add("%" + search + "%");
            args.add("%" + search + "%");
            args.add("%" + search + "%");
        }
        if (from != null) {
            if (!condition.isEmpty()) {
                condition = condition + " and ";
            }
            condition = condition + "e.timestamp >= ?";
            args.add(from);
        }
        if (to != null) {
            if (!condition.isEmpty()) {
                condition = condition + " and ";
            }
            condition = condition + "e.timestamp <= ?";
            args.add(to);
        }
        if (!condition.isEmpty()) {
            condition = "where " + condition;
        }
        AuditTrailDao auditTrailDao = (AuditTrailDao)AppUtil.getApplicationContext().getBean("AuditTrailDao");
        List auditTrailList = auditTrailDao.getAuditTrails(condition, args.toArray(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, auditTrailList, this.getFields());
    }

    protected String[] getFields() {
        return new String[]{"id", "username", "appId", "appVersion", "timestamp", "clazz", "method", "message"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("AuditTrail", new ApiDefinition(new AuditTrail(), this.getFields()));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

