/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiService;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.directory.dao.DepartmentDao;
import org.joget.directory.dao.EmploymentDao;
import org.joget.directory.dao.OrganizationDao;
import org.joget.directory.model.Department;
import org.joget.directory.model.Employment;
import org.joget.directory.model.Organization;
import org.joget.directory.model.User;
import org.joget.directory.model.service.DirectoryUtil;
import org.joget.directory.model.service.ExtDirectoryManager;

public class DirectoryDepartmentAPI
extends ApiPluginAbstract {
    public String getName() {
        return "DirectoryDepartmentAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-users\"></i>";
    }

    @Override
    public String getTag() {
        return "department";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", summary="@@DirectoryDepartmentAPI.addDepartment.summary@@", description="@@DirectoryDepartmentAPI.addDepartment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Department"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse addDepartment(@Param(value="body", description="@@DirectoryDepartmentAPI.addDepartment.body.desc@@", definition="Department") Department body) {
        String org;
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryDepartmentAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        DepartmentDao dao = (DepartmentDao)AppUtil.getApplicationContext().getBean("departmentDao");
        if (body.getId() == null || body.getId().isEmpty()) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        if (body.getOrganization() != null) {
            org = body.getOrganization().getId();
            if (org == null || org.isEmpty() || this.getOrganization(org) == null) {
                return new ApiResponse(405, AppPluginUtil.getMessage((String)"DirectoryDepartmentAPI.error.405.noOrg", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
        } else {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"DirectoryDepartmentAPI.error.405.noOrg", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        body.setOrganization(this.getOrganization(org));
        if (dao.addDepartment(body).booleanValue()) {
            return new ApiResponse(200, body, this.getFields());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@DirectoryDepartmentAPI.updateDepartment.summary@@", description="@@DirectoryDepartmentAPI.updateDepartment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Department"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateDepartment(@Param(value="body", description="@@DirectoryDepartmentAPI.updateDepartment.body.desc@@", definition="Department") Department body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryDepartmentAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        DepartmentDao dao = (DepartmentDao)AppUtil.getApplicationContext().getBean("departmentDao");
        Department dept = dao.getDepartment(body.getId());
        if (dept != null) {
            String org;
            if (body.getOrganization() != null && (org = body.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
                body.setOrganization(this.getOrganization(org));
            }
            ApiService.mergeObject(dept, body);
            if (dao.updateDepartment(dept).booleanValue()) {
                return new ApiResponse(200, dept, this.getFields());
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/find", type=Operation.MethodType.GET, summary="@@DirectoryDepartmentAPI.findDepartment.summary@@", description="@@DirectoryDepartmentAPI.findDepartment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Department", array=true)})
    public ApiResponse findDepartment(@Param(value="nameFilter", required=false, description="@@DirectoryDepartmentAPI.findDepartment.nameFilter.desc@@") String nameFilter, @Param(value="organizationId", required=false, description="@@DirectoryDepartmentAPI.findDepartment.organizationId.desc@@") String orgId, @Param(value="sort", required=false, description="@@DirectoryDepartmentAPI.findDepartment.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@DirectoryDepartmentAPI.findDepartment.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@DirectoryDepartmentAPI.findDepartment.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@DirectoryDepartmentAPI.findDepartment.pageSize.desc@@") Integer pageSize) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection depts = dm.getDepartmentsByOrganizationId(nameFilter, orgId, sort, desc, startOffset, pageSize);
        for (Department dept : depts) {
            String org;
            if (dept.getOrganization() == null || (org = dept.getOrganization().getId()) == null || org.isEmpty() || this.getOrganization(org) == null) continue;
            dept.setOrganization(this.getOrganization(org));
        }
        return new ApiResponse(200, depts, this.getFields());
    }

    @Operation(path="/{id}", type=Operation.MethodType.GET, summary="@@DirectoryDepartmentAPI.getDepartment.summary@@", description="@@DirectoryDepartmentAPI.getDepartment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Department"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getDepartment(@Param(value="id", description="@@DirectoryDepartmentAPI.getDepartment.id.desc@@") String id) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Department dept = dm.getDepartmentById(id);
        if (dept != null) {
            String org;
            if (dept.getOrganization() != null && (org = dept.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
                dept.setOrganization(this.getOrganization(org));
            }
            return new ApiResponse(200, dept, this.getFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/{id}", type=Operation.MethodType.DELETE, summary="@@DirectoryDepartmentAPI.deleteDepartment.summary@@", description="@@DirectoryDepartmentAPI.deleteDepartment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteDepartment(@Param(value="id", description="@@DirectoryDepartmentAPI.deleteDepartment.id.desc@@") String id) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryDepartmentAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        DepartmentDao dao = (DepartmentDao)AppUtil.getApplicationContext().getBean("departmentDao");
        if (dao.deleteDepartment(id).booleanValue()) {
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/assignUser/{department}/{username}", type=Operation.MethodType.POST, summary="@@DirectoryDepartmentAPI.assignUser.summary@@", description="@@DirectoryDepartmentAPI.assignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Employment"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse assignUser(@Param(value="department", description="@@DirectoryDepartmentAPI.assignUser.department.desc@@") String department, @Param(value="username", description="@@DirectoryDepartmentAPI.assignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
        User user = dm.getUserByUsername(username);
        Employment employment = null;
        if (user != null) {
            if (user.getEmployments() != null && !user.getEmployments().isEmpty()) {
                employment = (Employment)user.getEmployments().iterator().next();
            } else {
                employment = new Employment();
                employment.setUserId(user.getId());
                employment.setUser(user);
            }
            Department dept = dm.getDepartmentById(department);
            if (dept != null) {
                employment.setDepartmentId(department);
                employment.setOrganizationId(dept.getOrganization().getId());
                if (employment.getId() == null) {
                    employmentDao.addEmployment(employment);
                } else {
                    employmentDao.updateEmployment(employment);
                }
            } else {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"DirectoryDepartmentAPI.error.404.noDept", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            return new ApiResponse(200, employment, this.getEmploymentFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/unassignUser/{department}/{username}", type=Operation.MethodType.DELETE, summary="@@DirectoryDepartmentAPI.unassignUser.summary@@", description="@@DirectoryDepartmentAPI.unassignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse unassignUser(@Param(value="department", description="@@DirectoryDepartmentAPI.unassignUser.department.desc@@") String department, @Param(value="username", description="@@DirectoryDepartmentAPI.unassignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
        User user = dm.getUserByUsername(username);
        if (user != null && user.getEmployments() != null) {
            try {
                Employment employment = (Employment)user.getEmployments().iterator().next();
                if (employment.getDepartment() != null && department.equalsIgnoreCase(employment.getDepartmentId())) {
                    employment.setDepartmentId(null);
                    employmentDao.updateEmployment(employment);
                    return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                }
            }
            catch (Exception e) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Override
    public Map<String, String> getOperationOptions() {
        Map<String, String> options = super.getOperationOptions();
        if (DirectoryUtil.isCustomDirectoryManager()) {
            options.remove("post:/");
            options.remove("put:/");
            options.remove("delete:/{id}");
        }
        return options;
    }

    protected String[] getFields() {
        return new String[]{"id", "name", "description", "organization", "org.joget.directory.model.Organization", "org.joget.directory.model.Organization:id"};
    }

    protected String[] getEmploymentFields() {
        return new String[]{"userId", "startDate", "endDate", "employeeCode", "gradeId", "departmentId", "organizationId"};
    }

    protected Organization getOrganization(String organization) {
        OrganizationDao orgDao = (OrganizationDao)AppUtil.getApplicationContext().getBean("organizationDao");
        Organization orgById = orgDao.getOrganization(organization);
        Organization orgByName = orgDao.getOrganizationByName(organization);
        if (orgById != null) {
            return orgById;
        }
        if (orgByName != null) {
            return orgByName;
        }
        return null;
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        ApiDefinition deptFields = new ApiDefinition(new Department(), this.getFields());
        ApiDefinition empFields = new ApiDefinition(new Employment(), this.getEmploymentFields());
        defs.put("Department", deptFields);
        defs.put("Employment", empFields);
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

